/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.common;

import com.alibaba.dashscope.common.Result;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.protocol.HalfDuplexRequest;
import com.alibaba.dashscope.protocol.NetworkResponse;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.utils.EncryptionUtils;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;

public class DashScopeResult
extends Result {
    private Object output;
    private String event;

    public Boolean isBinaryOutput() {
        return this.output instanceof ByteBuffer;
    }

    @Override
    protected <T extends Result> T fromResponse(Protocol protocol, NetworkResponse response) throws ApiException {
        if (protocol == Protocol.WEBSOCKET) {
            if (response.getBinary() == null) {
                JsonObject headers;
                JsonObject jsonObject = JsonUtils.parse(response.getMessage());
                if (jsonObject.has("header") && (headers = jsonObject.get("header").getAsJsonObject()).has("task_id")) {
                    this.setRequestId(headers.get("task_id").getAsString());
                }
                if (jsonObject.has("payload")) {
                    JsonObject payload = jsonObject.getAsJsonObject("payload");
                    if (payload.has("output")) {
                        Object object = this.output = payload.get("output").isJsonNull() ? null : payload.get("output");
                    }
                    if (payload.has("usage")) {
                        this.setUsage(payload.get("usage").isJsonNull() ? null : payload.get("usage"));
                    }
                }
            } else {
                this.output = response.getBinary();
            }
        } else {
            JsonObject jsonObject = JsonUtils.parse(response.getMessage());
            if (jsonObject.has("output")) {
                Object object = this.output = jsonObject.get("output").isJsonNull() ? null : jsonObject.get("output").getAsJsonObject();
            }
            if (jsonObject.has("usage")) {
                this.setUsage((JsonElement)(jsonObject.get("usage").isJsonNull() ? null : jsonObject.get("usage").getAsJsonObject()));
            }
            if (jsonObject.has("request_id")) {
                this.setRequestId(jsonObject.get("request_id").getAsString());
            }
            if (jsonObject.has("data")) {
                if (jsonObject.has("request_id")) {
                    jsonObject.remove("request_id");
                }
                this.output = jsonObject;
            }
        }
        return (T)this;
    }

    @Override
    public <T extends Result> T fromResponse(Protocol protocol, NetworkResponse response, boolean isFlattenResult) throws ApiException {
        if (!isFlattenResult) {
            return this.fromResponse(protocol, response);
        }
        if (protocol == Protocol.WEBSOCKET) {
            if (response.getBinary() == null) {
                JsonObject jsonObject = JsonUtils.parse(response.getMessage());
                this.output = jsonObject;
            } else {
                this.output = response.getBinary();
            }
        } else {
            JsonObject jsonObject = JsonUtils.parse(response.getMessage());
            this.output = jsonObject;
            this.event = response.getEvent();
        }
        return (T)this;
    }

    @Override
    public <T extends Result> T fromResponse(Protocol protocol, NetworkResponse response, boolean isFlattenResult, HalfDuplexRequest req) throws ApiException {
        if ((response.getHeaders().containsKey("X-DashScope-OutputEncrypted".toLowerCase()) || req.isEncryptRequest().booleanValue()) && protocol == Protocol.HTTP) {
            String encryptedOutput;
            JsonObject jsonObject = JsonUtils.parse(response.getMessage());
            String string = encryptedOutput = jsonObject.get("output").isJsonNull() ? null : jsonObject.get("output").getAsString();
            if (encryptedOutput != null) {
                String plainOutput = EncryptionUtils.AESDecrypt(encryptedOutput, req.getEncryptionConfig().getAESEncryptKey(), req.getEncryptionConfig().getIv());
                this.output = JsonUtils.parse(plainOutput);
            } else {
                this.output = null;
            }
            if (jsonObject.has("usage")) {
                this.setUsage((JsonElement)(jsonObject.get("usage").isJsonNull() ? null : jsonObject.get("usage").getAsJsonObject()));
            }
            if (jsonObject.has("request_id")) {
                this.setRequestId(jsonObject.get("request_id").getAsString());
            }
            if (jsonObject.has("data") && jsonObject.has("request_id")) {
                jsonObject.remove("request_id");
            }
            return (T)this;
        }
        return this.fromResponse(protocol, response, isFlattenResult);
    }

    public Object getOutput() {
        return this.output;
    }

    public String getEvent() {
        return this.event;
    }

    public void setOutput(Object output) {
        this.output = output;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    @Override
    public String toString() {
        return "DashScopeResult(output=" + this.getOutput() + ", event=" + this.getEvent() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DashScopeResult)) {
            return false;
        }
        DashScopeResult other = (DashScopeResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Object this$output = this.getOutput();
        Object other$output = other.getOutput();
        if (this$output == null ? other$output != null : !this$output.equals(other$output)) {
            return false;
        }
        String this$event = this.getEvent();
        String other$event = other.getEvent();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DashScopeResult;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Object $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : $output.hashCode());
        String $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }
}

