/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.oracle.parser;

import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLKeep;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAggregateOption;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLSequenceExpr;
import com.alibaba.druid.sql.ast.expr.SQLTimestampExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLCharacterDataType;
import com.alibaba.druid.sql.ast.statement.SQLCheck;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyConstraint;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLUnique;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleDataTypeIntervalDay;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleDataTypeIntervalYear;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleDataTypeTimestamp;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleLobStorageClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleStorageClause;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleAnalytic;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleAnalyticWindowing;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleArgumentExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleBinaryDoubleExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleBinaryFloatExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleCursorExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleDateExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleDateTimeUnit;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleDatetimeExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleDbLinkExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleExtractExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleIntervalExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleIntervalType;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleIsSetExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleOuterExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleRangeExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleSizeExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleSysdateExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCheck;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleConstraint;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleForeignKey;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OraclePrimaryKey;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelect;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUnique;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUsingIndexClause;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleLexer;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;
import java.math.BigInteger;

public class OracleExprParser
extends SQLExprParser {
    public boolean allowStringAdditive = false;
    public static final String[] AGGREGATE_FUNCTIONS = new String[]{"AVG", "CORR", "COVAR_POP", "COVAR_SAMP", "COUNT", "CUME_DIST", "DENSE_RANK", "FIRST", "FIRST_VALUE", "LAG", "LAST", "LAST_VALUE", "LISTAGG", "LEAD", "MAX", "MIN", "NTILE", "PERCENT_RANK", "PERCENTILE_CONT", "PERCENTILE_DISC", "RANK", "RATIO_TO_REPORT", "REGR_SLOPE", "REGR_INTERCEPT", "REGR_COUNT", "REGR_R2", "REGR_AVGX", "REGR_AVGY", "REGR_SXX", "REGR_SYY", "REGR_SXY", "ROW_NUMBER", "STDDEV", "STDDEV_POP", "STDDEV_SAMP", "SUM", "VAR_POP", "VAR_SAMP", "VARIANCE", "WM_CONCAT"};

    public OracleExprParser(Lexer lexer) {
        super(lexer);
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
        this.dbType = "oracle";
    }

    public OracleExprParser(String text) {
        this(new OracleLexer(text));
        this.lexer.nextToken();
        this.dbType = "oracle";
    }

    @Override
    protected boolean isCharType(String dataTypeName) {
        return "varchar2".equalsIgnoreCase(dataTypeName) || "nvarchar2".equalsIgnoreCase(dataTypeName) || "char".equalsIgnoreCase(dataTypeName) || "varchar".equalsIgnoreCase(dataTypeName) || "nchar".equalsIgnoreCase(dataTypeName) || "nvarchar".equalsIgnoreCase(dataTypeName);
    }

    @Override
    public SQLDataType parseDataType() {
        String typeName;
        if (this.lexer.token() == Token.CONSTRAINT || this.lexer.token() == Token.COMMA) {
            return null;
        }
        if (this.lexer.token() == Token.DEFAULT || this.lexer.token() == Token.NOT || this.lexer.token() == Token.NULL) {
            return null;
        }
        if (this.lexer.token() == Token.INTERVAL) {
            this.lexer.nextToken();
            if (this.identifierEquals("YEAR")) {
                this.lexer.nextToken();
                OracleDataTypeIntervalYear interval = new OracleDataTypeIntervalYear();
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    interval.addArgument(this.expr());
                    this.accept(Token.RPAREN);
                }
                this.accept(Token.TO);
                this.acceptIdentifier("MONTH");
                return interval;
            }
            this.acceptIdentifier("DAY");
            OracleDataTypeIntervalDay interval = new OracleDataTypeIntervalDay();
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                interval.addArgument(this.expr());
                this.accept(Token.RPAREN);
            }
            this.accept(Token.TO);
            this.acceptIdentifier("SECOND");
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                interval.getFractionalSeconds().add(this.expr());
                this.accept(Token.RPAREN);
            }
            return interval;
        }
        if (this.identifierEquals("LONG")) {
            this.lexer.nextToken();
            this.acceptIdentifier("RAW");
            typeName = "LONG RAW";
        } else {
            SQLName typeExpr = this.name();
            typeName = typeExpr.toString();
        }
        if ("TIMESTAMP".equalsIgnoreCase(typeName)) {
            OracleDataTypeTimestamp timestamp = new OracleDataTypeTimestamp();
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                timestamp.addArgument(this.expr());
                this.accept(Token.RPAREN);
            }
            if (this.lexer.token() == Token.WITH) {
                this.lexer.nextToken();
                if (this.identifierEquals("LOCAL")) {
                    this.lexer.nextToken();
                    timestamp.setWithLocalTimeZone(true);
                } else {
                    timestamp.setWithTimeZone(true);
                }
                this.acceptIdentifier("TIME");
                this.acceptIdentifier("ZONE");
            }
            return timestamp;
        }
        if (this.isCharType(typeName)) {
            SQLCharacterDataType charType = new SQLCharacterDataType(typeName);
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                charType.addArgument(this.expr());
                if (this.identifierEquals("CHAR")) {
                    this.lexer.nextToken();
                    charType.setCharType("CHAR");
                } else if (this.identifierEquals("BYTE")) {
                    this.lexer.nextToken();
                    charType.setCharType("BYTE");
                }
                this.accept(Token.RPAREN);
            }
            return this.parseCharTypeRest(charType);
        }
        if (this.lexer.token() == Token.PERCENT) {
            this.lexer.nextToken();
            if (this.identifierEquals("TYPE")) {
                this.lexer.nextToken();
                typeName = typeName + "%TYPE";
            } else if (this.identifierEquals("ROWTYPE")) {
                this.lexer.nextToken();
                typeName = typeName + "%ROWTYPE";
            } else {
                throw new ParserException("syntax error : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
            }
        }
        SQLDataTypeImpl dataType = new SQLDataTypeImpl(typeName);
        return this.parseDataTypeRest(dataType);
    }

    @Override
    public SQLExpr primary() {
        Token tok = this.lexer.token();
        SQLExpr sqlExpr = null;
        switch (tok) {
            case SYSDATE: {
                this.lexer.nextToken();
                OracleSysdateExpr sysdate = new OracleSysdateExpr();
                if (this.lexer.token() == Token.MONKEYS_AT) {
                    this.lexer.nextToken();
                    this.accept(Token.BANG);
                    sysdate.setOption("!");
                }
                sqlExpr = sysdate;
                return this.primaryRest(sqlExpr);
            }
            case PRIOR: {
                this.lexer.nextToken();
                sqlExpr = this.expr();
                sqlExpr = new SQLUnaryExpr(SQLUnaryOperator.Prior, sqlExpr);
                return this.primaryRest(sqlExpr);
            }
            case COLON: {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.LITERAL_INT) {
                    String name = ":" + this.lexer.numberString();
                    this.lexer.nextToken();
                    return new SQLVariantRefExpr(name);
                }
                if (this.lexer.token() == Token.IDENTIFIER) {
                    String name = this.lexer.stringVal();
                    if (name.charAt(0) == 'B' || name.charAt(0) == 'b') {
                        this.lexer.nextToken();
                        return new SQLVariantRefExpr(":" + name);
                    }
                    throw new ParserException("syntax error : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                }
                throw new ParserException("syntax error : " + (Object)((Object)this.lexer.token()));
            }
            case LITERAL_ALIAS: {
                String alias = '\"' + this.lexer.stringVal() + '\"';
                this.lexer.nextToken();
                return this.primaryRest(new SQLIdentifierExpr(alias));
            }
            case EXTRACT: {
                this.lexer.nextToken();
                OracleExtractExpr extract = new OracleExtractExpr();
                this.accept(Token.LPAREN);
                extract.setUnit(OracleDateTimeUnit.valueOf(this.lexer.stringVal().toUpperCase()));
                this.lexer.nextToken();
                this.accept(Token.FROM);
                extract.setFrom(this.expr());
                this.accept(Token.RPAREN);
                return this.primaryRest(extract);
            }
            case BINARY_FLOAT: {
                OracleBinaryFloatExpr floatExpr = new OracleBinaryFloatExpr();
                floatExpr.setValue(Float.valueOf(Float.parseFloat(this.lexer.numberString())));
                this.lexer.nextToken();
                return this.primaryRest(floatExpr);
            }
            case BINARY_DOUBLE: {
                OracleBinaryDoubleExpr doubleExpr = new OracleBinaryDoubleExpr();
                doubleExpr.setValue(Double.parseDouble(this.lexer.numberString()));
                this.lexer.nextToken();
                return this.primaryRest(doubleExpr);
            }
            case TABLE: {
                this.lexer.nextToken();
                return this.primaryRest(new SQLIdentifierExpr("TABLE"));
            }
            case PLUS: {
                this.lexer.nextToken();
                switch (this.lexer.token()) {
                    case LITERAL_INT: {
                        sqlExpr = new SQLIntegerExpr(this.lexer.integerValue());
                        this.lexer.nextToken();
                        break;
                    }
                    case LITERAL_FLOAT: {
                        sqlExpr = new SQLNumberExpr(this.lexer.decimalValue());
                        this.lexer.nextToken();
                        break;
                    }
                    case BINARY_FLOAT: {
                        sqlExpr = new OracleBinaryFloatExpr(Float.valueOf(Float.parseFloat(this.lexer.numberString())));
                        this.lexer.nextToken();
                        break;
                    }
                    case BINARY_DOUBLE: {
                        sqlExpr = new OracleBinaryDoubleExpr(Double.parseDouble(this.lexer.numberString()));
                        this.lexer.nextToken();
                        break;
                    }
                    case LPAREN: {
                        this.lexer.nextToken();
                        sqlExpr = this.expr();
                        this.accept(Token.RPAREN);
                        sqlExpr = new SQLUnaryExpr(SQLUnaryOperator.Plus, sqlExpr);
                        break;
                    }
                    default: {
                        throw new ParserException("TODO");
                    }
                }
                return this.primaryRest(sqlExpr);
            }
            case SUB: {
                this.lexer.nextToken();
                switch (this.lexer.token()) {
                    case LITERAL_INT: {
                        long longVal;
                        int intVal;
                        Number integerValue = this.lexer.integerValue();
                        integerValue = integerValue instanceof Integer ? (Number)((intVal = ((Integer)integerValue).intValue()) == Integer.MIN_VALUE ? (Number)((long)intVal * -1L) : (Number)(intVal * -1)) : (Number)(integerValue instanceof Long ? ((longVal = ((Long)integerValue).longValue()) == 0x80000000L ? (Number)((int)(longVal * -1L)) : (Number)(longVal * -1L)) : ((BigInteger)integerValue).negate());
                        sqlExpr = new SQLIntegerExpr(integerValue);
                        this.lexer.nextToken();
                        break;
                    }
                    case LITERAL_FLOAT: {
                        sqlExpr = new SQLNumberExpr(this.lexer.decimalValue().negate());
                        this.lexer.nextToken();
                        break;
                    }
                    case BINARY_FLOAT: {
                        sqlExpr = new OracleBinaryFloatExpr(Float.valueOf(Float.parseFloat(this.lexer.numberString()) * -1.0f));
                        this.lexer.nextToken();
                        break;
                    }
                    case BINARY_DOUBLE: {
                        sqlExpr = new OracleBinaryDoubleExpr(Double.parseDouble(this.lexer.numberString()) * -1.0);
                        this.lexer.nextToken();
                        break;
                    }
                    case VARIANT: 
                    case IDENTIFIER: {
                        sqlExpr = this.expr();
                        sqlExpr = new SQLUnaryExpr(SQLUnaryOperator.Negative, sqlExpr);
                        break;
                    }
                    case LPAREN: {
                        this.lexer.nextToken();
                        sqlExpr = this.expr();
                        this.accept(Token.RPAREN);
                        sqlExpr = new SQLUnaryExpr(SQLUnaryOperator.Negative, sqlExpr);
                        break;
                    }
                    default: {
                        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()));
                    }
                }
                return this.primaryRest(sqlExpr);
            }
            case CURSOR: {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                OracleSelect select = this.createSelectParser().select();
                OracleCursorExpr cursorExpr = new OracleCursorExpr(select);
                this.accept(Token.RPAREN);
                sqlExpr = cursorExpr;
                return this.primaryRest(sqlExpr);
            }
            case MODEL: 
            case PCTFREE: 
            case INITRANS: 
            case MAXTRANS: 
            case SEGMENT: 
            case CREATION: 
            case IMMEDIATE: 
            case DEFERRED: 
            case STORAGE: 
            case NEXT: 
            case MINEXTENTS: 
            case MAXEXTENTS: 
            case MAXSIZE: 
            case PCTINCREASE: 
            case FLASH_CACHE: 
            case CELL_FLASH_CACHE: 
            case KEEP: 
            case NONE: 
            case LOB: 
            case STORE: 
            case ROW: 
            case CHUNK: 
            case CACHE: 
            case NOCACHE: 
            case LOGGING: 
            case NOCOMPRESS: 
            case KEEP_DUPLICATES: 
            case EXCEPTIONS: 
            case PURGE: {
                sqlExpr = new SQLIdentifierExpr(this.lexer.stringVal());
                this.lexer.nextToken();
                return this.primaryRest(sqlExpr);
            }
        }
        return super.primary();
    }

    @Override
    protected SQLExpr methodRest(SQLExpr expr, boolean acceptLPAREN) {
        if (acceptLPAREN) {
            this.accept(Token.LPAREN);
        }
        if (this.lexer.token() == Token.PLUS) {
            this.lexer.nextToken();
            this.accept(Token.RPAREN);
            return new OracleOuterExpr(expr);
        }
        if (expr instanceof SQLIdentifierExpr) {
            String methodName = ((SQLIdentifierExpr)expr).getName();
            SQLMethodInvokeExpr methodExpr = new SQLMethodInvokeExpr(methodName);
            if ("trim".equalsIgnoreCase(methodName)) {
                if (this.identifierEquals("LEADING") || this.identifierEquals("TRAILING") || this.identifierEquals("BOTH")) {
                    methodExpr.putAttribute("trim_option", this.lexer.stringVal());
                    this.lexer.nextToken();
                }
                if (this.lexer.token() != Token.FROM) {
                    SQLExpr trim_character = this.primary();
                    trim_character.setParent(methodExpr);
                    methodExpr.putAttribute("trim_character", trim_character);
                }
                if (this.lexer.token() == Token.FROM) {
                    this.lexer.nextToken();
                    SQLExpr trim_source = this.expr();
                    methodExpr.addParameter(trim_source);
                }
                this.accept(Token.RPAREN);
                return this.primaryRest(methodExpr);
            }
        }
        return super.methodRest(expr, false);
    }

    @Override
    public SQLExpr primaryRest(SQLExpr expr) {
        SQLExpr paramExpr;
        SQLMethodInvokeExpr methodInvoke;
        SQLExpr restExpr;
        String ident;
        if (expr.getClass() == SQLIdentifierExpr.class) {
            ident = ((SQLIdentifierExpr)expr).getName();
            if ("DATE".equalsIgnoreCase(ident)) {
                OracleDateExpr timestamp = new OracleDateExpr();
                String literal = this.lexer.stringVal();
                timestamp.setLiteral(literal);
                this.accept(Token.LITERAL_CHARS);
                return this.primaryRest(timestamp);
            }
            if ("TIMESTAMP".equalsIgnoreCase(ident)) {
                if (this.lexer.token() != Token.LITERAL_ALIAS && this.lexer.token() != Token.LITERAL_CHARS) {
                    return new SQLIdentifierExpr("TIMESTAMP");
                }
                SQLTimestampExpr timestamp = new SQLTimestampExpr();
                String literal = this.lexer.stringVal();
                timestamp.setLiteral(literal);
                this.accept(Token.LITERAL_CHARS);
                if (this.identifierEquals("AT")) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("TIME");
                    this.acceptIdentifier("ZONE");
                    String timezone = this.lexer.stringVal();
                    timestamp.setTimeZone(timezone);
                    this.accept(Token.LITERAL_CHARS);
                }
                return this.primaryRest(timestamp);
            }
        }
        if (this.lexer.token() == Token.IDENTIFIER && expr instanceof SQLNumericLiteralExpr && (ident = this.lexer.stringVal()).length() == 1) {
            char unit = ident.charAt(0);
            switch (unit) {
                case 'E': 
                case 'G': 
                case 'K': 
                case 'M': 
                case 'P': 
                case 'T': 
                case 'e': 
                case 'g': 
                case 'k': 
                case 'm': 
                case 'p': 
                case 't': {
                    expr = new OracleSizeExpr(expr, OracleSizeExpr.Unit.valueOf(ident.toUpperCase()));
                    this.lexer.nextToken();
                    break;
                }
            }
        }
        if (this.lexer.token() == Token.DOTDOT) {
            this.lexer.nextToken();
            SQLExpr upBound = this.expr();
            return new OracleRangeExpr(expr, upBound);
        }
        if (this.lexer.token() == Token.MONKEYS_AT) {
            this.lexer.nextToken();
            OracleDbLinkExpr dblink = new OracleDbLinkExpr();
            dblink.setExpr(expr);
            if (this.lexer.token() == Token.BANG) {
                dblink.setDbLink("!");
                this.lexer.nextToken();
            } else {
                String link = this.lexer.stringVal();
                this.accept(Token.IDENTIFIER);
                dblink.setDbLink(link);
            }
            expr = dblink;
        }
        if (this.identifierEquals("DAY") || this.identifierEquals("YEAR")) {
            this.lexer.mark();
            String name = this.lexer.stringVal();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.COMMA) {
                this.lexer.reset();
                return expr;
            }
            OracleIntervalExpr interval = new OracleIntervalExpr();
            interval.setValue(expr);
            OracleIntervalType type = OracleIntervalType.valueOf(name);
            interval.setType(type);
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                if (this.lexer.token() != Token.LITERAL_INT) {
                    throw new ParserException("syntax error");
                }
                interval.setPrecision(this.lexer.integerValue().intValue());
                this.lexer.nextToken();
                this.accept(Token.RPAREN);
            }
            this.accept(Token.TO);
            if (this.identifierEquals("SECOND")) {
                this.lexer.nextToken();
                interval.setToType(OracleIntervalType.SECOND);
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    if (this.lexer.token() != Token.LITERAL_INT) {
                        throw new ParserException("syntax error");
                    }
                    interval.setFactionalSecondsPrecision(this.lexer.integerValue().intValue());
                    this.lexer.nextToken();
                    this.accept(Token.RPAREN);
                }
            } else {
                interval.setToType(OracleIntervalType.MONTH);
                this.lexer.nextToken();
            }
            expr = interval;
        }
        if (this.identifierEquals("AT")) {
            char markChar = this.lexer.current();
            int markBp = this.lexer.bp();
            this.lexer.nextToken();
            if (this.identifierEquals("LOCAL")) {
                this.lexer.nextToken();
                expr = new OracleDatetimeExpr(expr, new SQLIdentifierExpr("LOCAL"));
            } else {
                if (!this.identifierEquals("TIME")) {
                    this.lexer.reset(markBp, markChar, Token.IDENTIFIER);
                    return expr;
                }
                this.lexer.nextToken();
                this.acceptIdentifier("ZONE");
                SQLExpr timeZone = this.primary();
                expr = new OracleDatetimeExpr(expr, timeZone);
            }
        }
        if ((restExpr = super.primaryRest(expr)) != expr && restExpr instanceof SQLMethodInvokeExpr && (methodInvoke = (SQLMethodInvokeExpr)restExpr).getParameters().size() == 1 && (paramExpr = methodInvoke.getParameters().get(0)) instanceof SQLIdentifierExpr && "+".equals(((SQLIdentifierExpr)paramExpr).getName())) {
            OracleOuterExpr outerExpr = new OracleOuterExpr();
            if (methodInvoke.getOwner() == null) {
                outerExpr.setExpr(new SQLIdentifierExpr(methodInvoke.getMethodName()));
            } else {
                outerExpr.setExpr(new SQLPropertyExpr(methodInvoke.getOwner(), methodInvoke.getMethodName()));
            }
            return outerExpr;
        }
        return restExpr;
    }

    @Override
    protected SQLExpr dotRest(SQLExpr expr) {
        if (this.lexer.token() == Token.LITERAL_ALIAS) {
            String name = '\"' + this.lexer.stringVal() + '\"';
            this.lexer.nextToken();
            expr = new SQLPropertyExpr(expr, name);
            if (this.lexer.token() == Token.DOT) {
                this.lexer.nextToken();
                expr = this.dotRest(expr);
            }
            return expr;
        }
        if (this.identifierEquals("NEXTVAL")) {
            if (expr instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr identExpr = (SQLIdentifierExpr)expr;
                SQLSequenceExpr seqExpr = new SQLSequenceExpr(identExpr, SQLSequenceExpr.Function.NextVal);
                this.lexer.nextToken();
                return seqExpr;
            }
        } else if (this.identifierEquals("CURRVAL") && expr instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr identExpr = (SQLIdentifierExpr)expr;
            SQLSequenceExpr seqExpr = new SQLSequenceExpr(identExpr, SQLSequenceExpr.Function.CurrVal);
            this.lexer.nextToken();
            return seqExpr;
        }
        return super.dotRest(expr);
    }

    @Override
    protected SQLAggregateExpr parseAggregateExpr(String methodName) {
        SQLAggregateExpr aggregateExpr;
        methodName = methodName.toUpperCase();
        if (this.lexer.token() == Token.UNIQUE) {
            aggregateExpr = new SQLAggregateExpr(methodName, SQLAggregateOption.UNIQUE);
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.ALL) {
            aggregateExpr = new SQLAggregateExpr(methodName, SQLAggregateOption.ALL);
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.DISTINCT) {
            aggregateExpr = new SQLAggregateExpr(methodName, SQLAggregateOption.DISTINCT);
            this.lexer.nextToken();
        } else {
            aggregateExpr = new SQLAggregateExpr(methodName);
        }
        this.exprList(aggregateExpr.getArguments(), aggregateExpr);
        if (this.lexer.stringVal().equalsIgnoreCase("IGNORE")) {
            this.lexer.nextToken();
            this.identifierEquals("NULLS");
            aggregateExpr.setIgnoreNulls(true);
        }
        this.accept(Token.RPAREN);
        if (this.identifierEquals("WITHIN")) {
            this.lexer.nextToken();
            this.accept(Token.GROUP);
            this.accept(Token.LPAREN);
            SQLOrderBy withinGroup = this.parseOrderBy();
            aggregateExpr.setWithinGroup(withinGroup);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.KEEP) {
            this.lexer.nextToken();
            SQLKeep keep = new SQLKeep();
            this.accept(Token.LPAREN);
            this.acceptIdentifier("DENSE_RANK");
            if (this.identifierEquals("FIRST")) {
                this.lexer.nextToken();
                keep.setDenseRank(SQLKeep.DenseRank.FIRST);
            } else {
                this.acceptIdentifier("LAST");
                keep.setDenseRank(SQLKeep.DenseRank.LAST);
            }
            SQLOrderBy orderBy = this.parseOrderBy();
            keep.setOrderBy(orderBy);
            aggregateExpr.setKeep(keep);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.OVER) {
            OracleAnalytic over = new OracleAnalytic();
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            if (this.identifierEquals("PARTITION")) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    this.exprList(over.getPartitionBy(), over);
                    this.accept(Token.RPAREN);
                } else {
                    this.exprList(over.getPartitionBy(), over);
                }
            }
            over.setOrderBy(this.parseOrderBy());
            if (over.getOrderBy() != null) {
                OracleAnalyticWindowing windowing = null;
                if (this.lexer.stringVal().equalsIgnoreCase("ROWS")) {
                    this.lexer.nextToken();
                    windowing = new OracleAnalyticWindowing();
                    windowing.setType(OracleAnalyticWindowing.Type.ROWS);
                } else if (this.lexer.stringVal().equalsIgnoreCase("RANGE")) {
                    this.lexer.nextToken();
                    windowing = new OracleAnalyticWindowing();
                    windowing.setType(OracleAnalyticWindowing.Type.RANGE);
                }
                if (windowing != null) {
                    if (this.lexer.stringVal().equalsIgnoreCase("CURRENT")) {
                        this.lexer.nextToken();
                        if (this.lexer.stringVal().equalsIgnoreCase("ROW")) {
                            this.lexer.nextToken();
                            windowing.setExpr(new SQLIdentifierExpr("CURRENT ROW"));
                            over.setWindowing(windowing);
                        }
                        throw new ParserException("syntax error");
                    }
                    if (this.lexer.stringVal().equalsIgnoreCase("UNBOUNDED")) {
                        this.lexer.nextToken();
                        if (this.lexer.stringVal().equalsIgnoreCase("PRECEDING")) {
                            this.lexer.nextToken();
                            windowing.setExpr(new SQLIdentifierExpr("UNBOUNDED PRECEDING"));
                        } else {
                            throw new ParserException("syntax error");
                        }
                    }
                    over.setWindowing(windowing);
                }
            }
            this.accept(Token.RPAREN);
            aggregateExpr.setOver(over);
        }
        return aggregateExpr;
    }

    private OracleIntervalType parseIntervalType() {
        String currentTokenUpperValue = this.lexer.stringVal();
        this.lexer.nextToken();
        if (currentTokenUpperValue.equals("YEAR")) {
            return OracleIntervalType.YEAR;
        }
        if (currentTokenUpperValue.equals("MONTH")) {
            return OracleIntervalType.MONTH;
        }
        if (currentTokenUpperValue.equals("HOUR")) {
            return OracleIntervalType.HOUR;
        }
        if (currentTokenUpperValue.equals("MINUTE")) {
            return OracleIntervalType.MINUTE;
        }
        if (currentTokenUpperValue.equals("SECOND")) {
            return OracleIntervalType.SECOND;
        }
        throw new ParserException("syntax error");
    }

    @Override
    public OracleSelectParser createSelectParser() {
        return new OracleSelectParser(this);
    }

    @Override
    public SQLSelectOrderByItem parseSelectOrderByItem() {
        SQLSelectOrderByItem item = new SQLSelectOrderByItem();
        item.setExpr(this.expr());
        if (this.lexer.token() == Token.ASC) {
            this.lexer.nextToken();
            item.setType(SQLOrderingSpecification.ASC);
        } else if (this.lexer.token() == Token.DESC) {
            this.lexer.nextToken();
            item.setType(SQLOrderingSpecification.DESC);
        }
        if (this.identifierEquals("NULLS")) {
            this.lexer.nextToken();
            if (this.identifierEquals("FIRST")) {
                this.lexer.nextToken();
                item.setNullsOrderType(SQLSelectOrderByItem.NullsOrderType.NullsFirst);
            } else if (this.identifierEquals("LAST")) {
                this.lexer.nextToken();
                item.setNullsOrderType(SQLSelectOrderByItem.NullsOrderType.NullsLast);
            } else {
                throw new ParserException("TODO " + (Object)((Object)this.lexer.token()));
            }
        }
        return item;
    }

    @Override
    protected SQLExpr parseInterval() {
        this.accept(Token.INTERVAL);
        OracleIntervalExpr interval = new OracleIntervalExpr();
        if (this.lexer.token() != Token.LITERAL_CHARS) {
            return new SQLIdentifierExpr("INTERVAL");
        }
        interval.setValue(new SQLCharExpr(this.lexer.stringVal()));
        this.lexer.nextToken();
        OracleIntervalType type = OracleIntervalType.valueOf(this.lexer.stringVal());
        interval.setType(type);
        this.lexer.nextToken();
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            if (this.lexer.token() != Token.LITERAL_INT) {
                throw new ParserException("syntax error");
            }
            interval.setPrecision(this.lexer.integerValue().intValue());
            this.lexer.nextToken();
            if (this.lexer.token() == Token.COMMA) {
                this.lexer.nextToken();
                if (this.lexer.token() != Token.LITERAL_INT) {
                    throw new ParserException("syntax error");
                }
                interval.setFactionalSecondsPrecision(this.lexer.integerValue().intValue());
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.TO) {
            this.lexer.nextToken();
            if (this.identifierEquals("SECOND")) {
                this.lexer.nextToken();
                interval.setToType(OracleIntervalType.SECOND);
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    if (this.lexer.token() != Token.LITERAL_INT) {
                        throw new ParserException("syntax error");
                    }
                    interval.setToFactionalSecondsPrecision(this.lexer.integerValue().intValue());
                    this.lexer.nextToken();
                    this.accept(Token.RPAREN);
                }
            } else {
                interval.setToType(OracleIntervalType.MONTH);
                this.lexer.nextToken();
            }
        }
        return interval;
    }

    @Override
    public SQLExpr relationalRest(SQLExpr expr) {
        if (this.lexer.token() == Token.IS) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.NOT) {
                this.lexer.nextToken();
                SQLExpr rightExpr = this.primary();
                expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.IsNot, rightExpr, this.getDbType());
            } else if (this.identifierEquals("A")) {
                this.lexer.nextToken();
                this.accept(Token.SET);
                expr = new OracleIsSetExpr(expr);
            } else {
                SQLExpr rightExpr = this.primary();
                expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Is, rightExpr, this.getDbType());
            }
            return expr;
        }
        return super.relationalRest(expr);
    }

    @Override
    public SQLName name() {
        SQLName name = super.name();
        if (this.lexer.token() == Token.MONKEYS_AT) {
            this.lexer.nextToken();
            if (this.lexer.token() != Token.IDENTIFIER) {
                throw new ParserException("syntax error, expect identifier, but " + (Object)((Object)this.lexer.token()));
            }
            OracleDbLinkExpr dbLink = new OracleDbLinkExpr();
            dbLink.setExpr(name);
            dbLink.setDbLink(this.lexer.stringVal());
            this.lexer.nextToken();
            return dbLink;
        }
        return name;
    }

    @Override
    public SQLExpr equalityRest(SQLExpr expr) {
        if (this.lexer.token() == Token.EQ) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.GT) {
                this.lexer.nextToken();
                SQLExpr rightExp = this.expr();
                String argumentName = ((SQLIdentifierExpr)expr).getName();
                return new OracleArgumentExpr(argumentName, rightExp);
            }
            SQLExpr rightExp = this.shift();
            rightExp = this.equalityRest(rightExp);
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Equality, rightExp, this.getDbType());
        } else if (this.lexer.token() == Token.BANGEQ) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.shift();
            rightExp = this.equalityRest(rightExp);
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.NotEqual, rightExp, this.getDbType());
        }
        return expr;
    }

    @Override
    public OraclePrimaryKey parsePrimaryKey() {
        this.lexer.nextToken();
        this.accept(Token.KEY);
        OraclePrimaryKey primaryKey = new OraclePrimaryKey();
        this.accept(Token.LPAREN);
        this.exprList(primaryKey.getColumns(), primaryKey);
        this.accept(Token.RPAREN);
        if (this.lexer.token() == Token.USING) {
            OracleUsingIndexClause using = this.parseUsingIndex();
            primaryKey.setUsing(using);
        }
        return primaryKey;
    }

    private OracleUsingIndexClause parseUsingIndex() {
        OracleUsingIndexClause using;
        block8: {
            this.accept(Token.USING);
            this.accept(Token.INDEX);
            using = new OracleUsingIndexClause();
            while (true) {
                if (this.lexer.token() == Token.TABLESPACE) {
                    this.lexer.nextToken();
                    using.setTablespace(this.name());
                    continue;
                }
                if (this.lexer.token() == Token.PCTFREE) {
                    this.lexer.nextToken();
                    using.setPtcfree(this.expr());
                    continue;
                }
                if (this.lexer.token() == Token.INITRANS) {
                    this.lexer.nextToken();
                    using.setInitrans(this.expr());
                    continue;
                }
                if (this.lexer.token() == Token.MAXTRANS) {
                    this.lexer.nextToken();
                    using.setMaxtrans(this.expr());
                    continue;
                }
                if (this.lexer.token() == Token.COMPUTE) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("STATISTICS");
                    using.setComputeStatistics(true);
                    continue;
                }
                if (this.lexer.token() == Token.ENABLE) {
                    this.lexer.nextToken();
                    using.setEnable(true);
                    continue;
                }
                if (this.lexer.token() == Token.DISABLE) {
                    this.lexer.nextToken();
                    using.setEnable(false);
                    continue;
                }
                if (this.lexer.token() != Token.STORAGE) break;
                OracleStorageClause storage = this.parseStorage();
                using.setStorage(storage);
            }
            if (this.lexer.token() != Token.IDENTIFIER) break block8;
            using.setTablespace(this.name());
        }
        return using;
    }

    @Override
    public SQLColumnDefinition parseColumnRest(SQLColumnDefinition column) {
        column = super.parseColumnRest(column);
        if (this.lexer.token() == Token.ENABLE) {
            this.lexer.nextToken();
            column.setEnable(Boolean.TRUE);
        }
        return column;
    }

    @Override
    public SQLExpr exprRest(SQLExpr expr) {
        expr = super.exprRest(expr);
        if (this.lexer.token() == Token.COLONEQ) {
            this.lexer.nextToken();
            SQLExpr right = this.expr();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Assignment, right, this.getDbType());
        }
        return expr;
    }

    public OracleLobStorageClause parseLobStorage() {
        OracleLobStorageClause clause;
        block8: {
            this.lexer.nextToken();
            clause = new OracleLobStorageClause();
            this.accept(Token.LPAREN);
            this.names(clause.getItems());
            this.accept(Token.RPAREN);
            this.accept(Token.STORE);
            this.accept(Token.AS);
            while (true) {
                if (this.identifierEquals("SECUREFILE")) {
                    this.lexer.nextToken();
                    clause.setSecureFile(true);
                    continue;
                }
                if (!this.identifierEquals("BASICFILE")) break;
                this.lexer.nextToken();
                clause.setBasicFile(true);
            }
            if (this.lexer.token() != Token.LPAREN) break block8;
            this.lexer.nextToken();
            while (true) {
                if (this.lexer.token() == Token.TABLESPACE) {
                    this.lexer.nextToken();
                    clause.setTableSpace(this.name());
                    continue;
                }
                if (this.lexer.token() == Token.ENABLE) {
                    this.lexer.nextToken();
                    this.accept(Token.STORAGE);
                    this.accept(Token.IN);
                    this.accept(Token.ROW);
                    clause.setEnable(true);
                    continue;
                }
                if (this.lexer.token() == Token.CHUNK) {
                    this.lexer.nextToken();
                    clause.setChunk(this.primary());
                    continue;
                }
                if (this.lexer.token() == Token.NOCACHE) {
                    this.lexer.nextToken();
                    clause.setCache(false);
                    if (this.lexer.token() != Token.LOGGING) continue;
                    this.lexer.nextToken();
                    clause.setLogging(true);
                    continue;
                }
                if (this.lexer.token() == Token.NOCOMPRESS) {
                    this.lexer.nextToken();
                    clause.setCompress(false);
                    continue;
                }
                if (this.lexer.token() != Token.KEEP_DUPLICATES) break;
                this.lexer.nextToken();
                clause.setKeepDuplicate(true);
            }
            this.accept(Token.RPAREN);
        }
        return clause;
    }

    public OracleStorageClause parseStorage() {
        this.lexer.nextToken();
        this.accept(Token.LPAREN);
        OracleStorageClause storage = new OracleStorageClause();
        while (true) {
            OracleStorageClause.FlashCacheType flashCacheType;
            if (this.identifierEquals("INITIAL")) {
                this.lexer.nextToken();
                storage.setInitial(this.expr());
                continue;
            }
            if (this.lexer.token() == Token.NEXT) {
                this.lexer.nextToken();
                storage.setNext(this.expr());
                continue;
            }
            if (this.lexer.token() == Token.MINEXTENTS) {
                this.lexer.nextToken();
                storage.setMinExtents(this.expr());
                continue;
            }
            if (this.lexer.token() == Token.MAXEXTENTS) {
                this.lexer.nextToken();
                storage.setMaxExtents(this.expr());
                continue;
            }
            if (this.lexer.token() == Token.MAXSIZE) {
                this.lexer.nextToken();
                storage.setMaxSize(this.expr());
                continue;
            }
            if (this.lexer.token() == Token.PCTINCREASE) {
                this.lexer.nextToken();
                storage.setPctIncrease(this.expr());
                continue;
            }
            if (this.identifierEquals("FREELISTS")) {
                this.lexer.nextToken();
                storage.setFreeLists(this.expr());
                continue;
            }
            if (this.identifierEquals("FREELIST")) {
                this.lexer.nextToken();
                this.acceptIdentifier("GROUPS");
                storage.setFreeListGroups(this.expr());
                continue;
            }
            if (this.identifierEquals("BUFFER_POOL")) {
                this.lexer.nextToken();
                storage.setBufferPool(this.expr());
                continue;
            }
            if (this.identifierEquals("OBJNO")) {
                this.lexer.nextToken();
                storage.setObjno(this.expr());
                continue;
            }
            if (this.lexer.token() == Token.FLASH_CACHE) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.KEEP) {
                    flashCacheType = OracleStorageClause.FlashCacheType.KEEP;
                    this.lexer.nextToken();
                } else if (this.lexer.token() == Token.NONE) {
                    flashCacheType = OracleStorageClause.FlashCacheType.NONE;
                    this.lexer.nextToken();
                } else {
                    this.accept(Token.DEFAULT);
                    flashCacheType = OracleStorageClause.FlashCacheType.DEFAULT;
                }
                storage.setFlashCache(flashCacheType);
                continue;
            }
            if (this.lexer.token() != Token.CELL_FLASH_CACHE) break;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.KEEP) {
                flashCacheType = OracleStorageClause.FlashCacheType.KEEP;
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.NONE) {
                flashCacheType = OracleStorageClause.FlashCacheType.NONE;
                this.lexer.nextToken();
            } else {
                this.accept(Token.DEFAULT);
                flashCacheType = OracleStorageClause.FlashCacheType.DEFAULT;
            }
            storage.setCellFlashCache(flashCacheType);
        }
        this.accept(Token.RPAREN);
        return storage;
    }

    @Override
    public SQLUnique parseUnique() {
        this.accept(Token.UNIQUE);
        OracleUnique unique = new OracleUnique();
        this.accept(Token.LPAREN);
        this.exprList(unique.getColumns(), unique);
        this.accept(Token.RPAREN);
        if (this.lexer.token() == Token.USING) {
            OracleUsingIndexClause using = this.parseUsingIndex();
            unique.setUsing(using);
        }
        return unique;
    }

    @Override
    public OracleConstraint parseConstaint() {
        OracleConstraint constraint = (OracleConstraint)super.parseConstaint();
        while (true) {
            if (this.lexer.token() == Token.EXCEPTIONS) {
                this.lexer.nextToken();
                this.accept(Token.INTO);
                SQLName exceptionsInto = this.name();
                constraint.setExceptionsInto(exceptionsInto);
                continue;
            }
            if (this.lexer.token() == Token.DISABLE) {
                this.lexer.nextToken();
                constraint.setEnable(false);
                continue;
            }
            if (this.lexer.token() == Token.ENABLE) {
                this.lexer.nextToken();
                constraint.setEnable(true);
                continue;
            }
            if (this.lexer.token() == Token.INITIALLY) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.IMMEDIATE) {
                    this.lexer.nextToken();
                    constraint.setInitially(OracleConstraint.Initially.IMMEDIATE);
                    continue;
                }
                this.accept(Token.DEFERRED);
                constraint.setInitially(OracleConstraint.Initially.DEFERRED);
                continue;
            }
            if (this.lexer.token() == Token.NOT) {
                this.lexer.nextToken();
                if (this.identifierEquals("DEFERRABLE")) {
                    this.lexer.nextToken();
                    constraint.setDeferrable(false);
                    continue;
                }
                throw new ParserException("TODO " + (Object)((Object)this.lexer.token()));
            }
            if (!this.identifierEquals("DEFERRABLE")) break;
            this.lexer.nextToken();
            constraint.setDeferrable(true);
        }
        return constraint;
    }

    @Override
    protected SQLForeignKeyConstraint createForeignKey() {
        return new OracleForeignKey();
    }

    @Override
    protected SQLCheck createCheck() {
        return new OracleCheck();
    }
}

