/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.util;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.Utils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.sql.XAConnection;

public class MySqlUtils {
    static Class<?> utilClass;
    static boolean utilClassError;
    static boolean utilClass_isJdbc4;
    static Class<?> class_5_connection;
    static Method method_5_getPinGlobalTxToPhysicalConnection;
    static Class<?> class_5_suspendableXAConnection;
    static Constructor<?> constructor_5_suspendableXAConnection;
    static Class<?> class_5_JDBC4SuspendableXAConnection;
    static Constructor<?> constructor_5_JDBC4SuspendableXAConnection;
    static Class<?> class_5_MysqlXAConnection;
    static Constructor<?> constructor_5_MysqlXAConnection;
    static Class<?> class_5_ConnectionImpl;
    static Method method_5_getId;
    static Class<?> class_6_ConnectionImpl;
    static Method method_6_getId;
    static volatile Class<?> class_6_connection;
    static volatile Method method_6_getPropertySet;
    static volatile Method method_6_getBooleanReadableProperty;
    static volatile Method method_6_getValue;
    static volatile boolean method_6_getValue_error;
    static volatile Class<?> class_6_suspendableXAConnection;
    static volatile Method method_6_getInstance;
    static volatile boolean method_6_getInstance_error;
    static volatile Method method_6_getInstanceXA;
    static volatile boolean method_6_getInstanceXA_error;
    static volatile Class<?> class_6_JDBC4SuspendableXAConnection;
    private static Set<String> keywords;
    private static Set<String> builtinDataTypes;
    private static Class class_connectionImpl;
    private static boolean class_connectionImpl_Error;
    private static Method method_getIO;
    private static boolean method_getIO_error;
    private static Class class_MysqlIO;
    private static boolean class_MysqlIO_Error;
    private static Method method_getLastPacketReceivedTimeMs;
    private static boolean method_getLastPacketReceivedTimeMs_error;
    static Class<?> class_5_CommunicationsException;
    static Class<?> class_6_CommunicationsException;

    public static XAConnection createXAConnection(Driver driver, Connection physicalConn) throws SQLException {
        int major = driver.getMajorVersion();
        if (major == 5) {
            if (utilClass == null && !utilClassError) {
                try {
                    utilClass = Class.forName("com.mysql.jdbc.Util");
                    Method method = utilClass.getMethod("isJdbc4", new Class[0]);
                    utilClass_isJdbc4 = (Boolean)method.invoke(null, new Object[0]);
                    class_5_connection = Class.forName("com.mysql.jdbc.Connection");
                    method_5_getPinGlobalTxToPhysicalConnection = class_5_connection.getMethod("getPinGlobalTxToPhysicalConnection", new Class[0]);
                    class_5_suspendableXAConnection = Class.forName("com.mysql.jdbc.jdbc2.optional.SuspendableXAConnection");
                    constructor_5_suspendableXAConnection = class_5_suspendableXAConnection.getConstructor(class_5_connection);
                    class_5_JDBC4SuspendableXAConnection = Class.forName("com.mysql.jdbc.jdbc2.optional.JDBC4SuspendableXAConnection");
                    constructor_5_JDBC4SuspendableXAConnection = class_5_JDBC4SuspendableXAConnection.getConstructor(class_5_connection);
                    class_5_MysqlXAConnection = Class.forName("com.mysql.jdbc.jdbc2.optional.MysqlXAConnection");
                    constructor_5_MysqlXAConnection = class_5_MysqlXAConnection.getConstructor(class_5_connection, Boolean.TYPE);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    utilClassError = true;
                }
            }
            try {
                boolean pinGlobTx = (Boolean)method_5_getPinGlobalTxToPhysicalConnection.invoke((Object)physicalConn, new Object[0]);
                if (pinGlobTx) {
                    if (!utilClass_isJdbc4) {
                        return (XAConnection)constructor_5_suspendableXAConnection.newInstance(physicalConn);
                    }
                    return (XAConnection)constructor_5_JDBC4SuspendableXAConnection.newInstance(physicalConn);
                }
                return (XAConnection)constructor_5_MysqlXAConnection.newInstance(physicalConn, Boolean.FALSE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (major == 6 || major == 8) {
            if (method_6_getValue == null && !method_6_getValue_error) {
                try {
                    class_6_connection = Class.forName("com.mysql.cj.api.jdbc.JdbcConnection");
                }
                catch (Throwable e) {
                    // empty catch block
                }
                try {
                    if (class_6_connection == null) {
                        class_6_connection = Class.forName("com.mysql.cj.jdbc.JdbcConnection");
                        method_6_getPropertySet = class_6_connection.getMethod("getPropertySet", new Class[0]);
                        method_6_getBooleanReadableProperty = Class.forName("com.mysql.cj.conf.PropertySet").getMethod("getBooleanReadableProperty", String.class);
                        method_6_getValue = Class.forName("com.mysql.cj.conf.ReadableProperty").getMethod("getValue", new Class[0]);
                    } else {
                        method_6_getPropertySet = class_6_connection.getMethod("getPropertySet", new Class[0]);
                        method_6_getBooleanReadableProperty = Class.forName("com.mysql.cj.api.conf.PropertySet").getMethod("getBooleanReadableProperty", String.class);
                        method_6_getValue = Class.forName("com.mysql.cj.api.conf.ReadableProperty").getMethod("getValue", new Class[0]);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    method_6_getValue_error = true;
                }
            }
            try {
                boolean pinGlobTx = (Boolean)method_6_getValue.invoke(method_6_getBooleanReadableProperty.invoke(method_6_getPropertySet.invoke((Object)physicalConn, new Object[0]), "pinGlobalTxToPhysicalConnection"), new Object[0]);
                if (pinGlobTx) {
                    try {
                        if (method_6_getInstance == null && !method_6_getInstance_error) {
                            class_6_suspendableXAConnection = Class.forName("com.mysql.cj.jdbc.SuspendableXAConnection");
                            method_6_getInstance = class_6_suspendableXAConnection.getDeclaredMethod("getInstance", class_6_connection);
                            method_6_getInstance.setAccessible(true);
                        }
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                        method_6_getInstance_error = true;
                    }
                    return (XAConnection)method_6_getInstance.invoke(null, physicalConn);
                }
                try {
                    if (method_6_getInstanceXA == null && !method_6_getInstanceXA_error) {
                        class_6_JDBC4SuspendableXAConnection = Class.forName("com.mysql.cj.jdbc.MysqlXAConnection");
                        method_6_getInstanceXA = class_6_JDBC4SuspendableXAConnection.getDeclaredMethod("getInstance", class_6_connection, Boolean.TYPE);
                        method_6_getInstanceXA.setAccessible(true);
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    method_6_getInstanceXA_error = true;
                }
                return (XAConnection)method_6_getInstanceXA.invoke(null, physicalConn, Boolean.FALSE);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                method_6_getInstance_error = true;
            }
        }
        throw new SQLFeatureNotSupportedException();
    }

    public static String buildKillQuerySql(Connection connection, SQLException error) throws SQLException {
        Long threadId = null;
        try {
            Class<?> clazz = connection.getClass();
            if (class_5_ConnectionImpl == null && clazz.getName().equals("com.mysql.jdbc.ConnectionImpl")) {
                class_5_ConnectionImpl = clazz;
            }
            if (class_5_ConnectionImpl == clazz) {
                if (method_5_getId == null) {
                    method_5_getId = class_5_ConnectionImpl.getMethod("getId", new Class[0]);
                }
                threadId = (Long)method_5_getId.invoke((Object)connection, new Object[0]);
            }
            if (class_6_ConnectionImpl == null && clazz.getName().equals("com.mysql.cj.jdbc.ConnectionImpl")) {
                class_6_ConnectionImpl = clazz;
            }
            if (class_6_ConnectionImpl == clazz) {
                if (method_6_getId == null) {
                    method_6_getId = class_6_ConnectionImpl.getMethod("getId", new Class[0]);
                }
                threadId = (Long)method_6_getId.invoke((Object)connection, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (threadId == null) {
            return null;
        }
        return "KILL QUERY " + threadId;
    }

    public static boolean isKeyword(String name) {
        if (name == null) {
            return false;
        }
        String name_lower = name.toLowerCase();
        Set<String> words = keywords;
        if (words == null) {
            words = new HashSet<String>();
            Utils.loadFromFile("META-INF/druid/parser/mysql/keywords", words);
            keywords = words;
        }
        return words.contains(name_lower);
    }

    public static boolean isBuiltinDataType(String dataType) {
        if (dataType == null) {
            return false;
        }
        String table_lower = dataType.toLowerCase();
        Set<String> dataTypes = builtinDataTypes;
        if (dataTypes == null) {
            dataTypes = new HashSet<String>();
            Utils.loadFromFile("META-INF/druid/parser/mysql/builtin_datatypes", dataTypes);
            builtinDataTypes = dataTypes;
        }
        return dataTypes.contains(table_lower);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> showTables(Connection conn) throws SQLException {
        ArrayList<String> tables = new ArrayList<String>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery("show tables");
            while (rs.next()) {
                String tableName = rs.getString(1);
                tables.add(tableName);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.close(rs);
            JdbcUtils.close(stmt);
            throw throwable;
        }
        JdbcUtils.close(rs);
        JdbcUtils.close(stmt);
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> getTableDDL(Connection conn, List<String> tables) throws SQLException {
        ArrayList<String> ddlList = new ArrayList<String>();
        Statement stmt = null;
        try {
            for (String table : tables) {
                ResultSet rs;
                block8: {
                    if (stmt == null) {
                        stmt = conn.createStatement();
                    }
                    if (MySqlUtils.isKeyword(table)) {
                        table = "`" + table + "`";
                    }
                    rs = null;
                    try {
                        rs = stmt.executeQuery("show create table " + table);
                        if (!rs.next()) break block8;
                        String ddl = rs.getString(2);
                        ddlList.add(ddl);
                    }
                    catch (Throwable throwable) {
                        JdbcUtils.close(rs);
                        throw throwable;
                        return ddlList;
                    }
                }
                JdbcUtils.close(rs);
            }
        }
        finally {
            JdbcUtils.close(stmt);
        }
    }

    public static String getCreateTableScript(Connection conn) throws SQLException {
        return MySqlUtils.getCreateTableScript(conn, true, true);
    }

    public static String getCreateTableScript(Connection conn, boolean sorted, boolean simplify) throws SQLException {
        List<String> tables = MySqlUtils.showTables(conn);
        List<String> ddlList = MySqlUtils.getTableDDL(conn, tables);
        StringBuilder buf = new StringBuilder();
        for (String ddl : ddlList) {
            buf.append(ddl);
            buf.append(';');
        }
        String ddlScript = buf.toString();
        if (!sorted && !simplify) {
            return ddlScript;
        }
        List<SQLStatement> stmtList = SQLUtils.parseStatements(ddlScript, "mysql");
        if (simplify) {
            for (SQLStatement o : stmtList) {
                if (!(o instanceof SQLCreateTableStatement)) continue;
                SQLCreateTableStatement createTableStmt = (SQLCreateTableStatement)o;
                createTableStmt.simplify();
            }
        }
        if (sorted) {
            SQLCreateTableStatement.sort(stmtList);
        }
        return SQLUtils.toSQLString(stmtList, "mysql");
    }

    public static long getLastPacketReceivedTimeMs(Connection conn) throws SQLException {
        if (class_connectionImpl == null && !class_connectionImpl_Error) {
            try {
                class_connectionImpl = Utils.loadClass("com.mysql.jdbc.MySQLConnection");
            }
            catch (Throwable error) {
                class_connectionImpl_Error = true;
            }
        }
        if (class_connectionImpl == null) {
            return -1L;
        }
        if (method_getIO == null && !method_getIO_error) {
            try {
                method_getIO = class_connectionImpl.getMethod("getIO", new Class[0]);
            }
            catch (Throwable error) {
                method_getIO_error = true;
            }
        }
        if (method_getIO == null) {
            return -1L;
        }
        if (class_MysqlIO == null && !class_MysqlIO_Error) {
            try {
                class_MysqlIO = Utils.loadClass("com.mysql.jdbc.MysqlIO");
            }
            catch (Throwable error) {
                class_MysqlIO_Error = true;
            }
        }
        if (class_MysqlIO == null) {
            return -1L;
        }
        if (method_getLastPacketReceivedTimeMs == null && !method_getLastPacketReceivedTimeMs_error) {
            try {
                Method method = class_MysqlIO.getDeclaredMethod("getLastPacketReceivedTimeMs", new Class[0]);
                method.setAccessible(true);
                method_getLastPacketReceivedTimeMs = method;
            }
            catch (Throwable error) {
                method_getLastPacketReceivedTimeMs_error = true;
            }
        }
        if (method_getLastPacketReceivedTimeMs == null) {
            return -1L;
        }
        try {
            Object connImpl = conn.unwrap(class_connectionImpl);
            if (connImpl == null) {
                return -1L;
            }
            Object mysqlio = method_getIO.invoke(connImpl, new Object[0]);
            Long ms = (Long)method_getLastPacketReceivedTimeMs.invoke(mysqlio, new Object[0]);
            return ms;
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("getLastPacketReceivedTimeMs error", e);
        }
        catch (IllegalAccessException e) {
            throw new SQLException("getLastPacketReceivedTimeMs error", e);
        }
        catch (InvocationTargetException e) {
            throw new SQLException("getLastPacketReceivedTimeMs error", e);
        }
    }

    public static Class getCommunicationsExceptionClass() {
        if (class_5_CommunicationsException != null) {
            return class_5_CommunicationsException;
        }
        if (class_6_CommunicationsException != null) {
            return class_6_CommunicationsException;
        }
        class_5_CommunicationsException = Utils.loadClass("com.mysql.jdbc.CommunicationsException");
        if (class_5_CommunicationsException != null) {
            return class_5_CommunicationsException;
        }
        class_6_CommunicationsException = Utils.loadClass("com.mysql.cj.jdbc.exceptions.CommunicationsException");
        if (class_6_CommunicationsException != null) {
            return class_6_CommunicationsException;
        }
        return null;
    }

    static {
        utilClassError = false;
        utilClass_isJdbc4 = false;
        class_5_connection = null;
        method_5_getPinGlobalTxToPhysicalConnection = null;
        class_5_suspendableXAConnection = null;
        constructor_5_suspendableXAConnection = null;
        class_5_JDBC4SuspendableXAConnection = null;
        constructor_5_JDBC4SuspendableXAConnection = null;
        class_5_MysqlXAConnection = null;
        constructor_5_MysqlXAConnection = null;
        class_5_ConnectionImpl = null;
        method_5_getId = null;
        class_6_ConnectionImpl = null;
        method_6_getId = null;
        class_6_connection = null;
        method_6_getPropertySet = null;
        method_6_getBooleanReadableProperty = null;
        method_6_getValue = null;
        method_6_getValue_error = false;
        class_6_suspendableXAConnection = null;
        method_6_getInstance = null;
        method_6_getInstance_error = false;
        method_6_getInstanceXA = null;
        method_6_getInstanceXA_error = false;
        class_6_JDBC4SuspendableXAConnection = null;
        class_connectionImpl = null;
        class_connectionImpl_Error = false;
        method_getIO = null;
        method_getIO_error = false;
        class_MysqlIO = null;
        class_MysqlIO_Error = false;
        method_getLastPacketReceivedTimeMs = null;
        method_getLastPacketReceivedTimeMs_error = false;
        class_5_CommunicationsException = null;
        class_6_CommunicationsException = null;
    }
}

