/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLObjectWithDataType;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnConstraint;
import com.alibaba.druid.sql.ast.statement.SQLNotNullConstraint;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLColumnDefinition
extends SQLObjectImpl
implements SQLTableElement,
SQLObjectWithDataType,
SQLReplaceable {
    protected String dbType;
    protected SQLName name;
    protected SQLDataType dataType;
    protected SQLExpr defaultExpr;
    protected final List<SQLColumnConstraint> constraints = new ArrayList<SQLColumnConstraint>(0);
    protected SQLExpr comment;
    protected Boolean enable;
    protected Boolean validate;
    protected Boolean rely;
    protected boolean autoIncrement = false;
    protected SQLExpr onUpdate;
    protected SQLExpr storage;
    protected SQLExpr charsetExpr;
    protected SQLExpr asExpr;
    protected boolean sorted = false;
    protected boolean virtual = false;
    protected Identity identity;

    public Identity getIdentity() {
        return this.identity;
    }

    public void setIdentity(Identity identity) {
        if (identity != null) {
            identity.setParent(this);
        }
        this.identity = identity;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public Boolean getValidate() {
        return this.validate;
    }

    public void setValidate(Boolean validate) {
        this.validate = validate;
    }

    public Boolean getRely() {
        return this.rely;
    }

    public void setRely(Boolean rely) {
        this.rely = rely;
    }

    public SQLName getName() {
        return this.name;
    }

    public long nameHashCode64() {
        if (this.name == null) {
            return 0L;
        }
        return this.name.hashCode64();
    }

    public String getNameAsString() {
        if (this.name == null) {
            return null;
        }
        return this.name.toString();
    }

    public void setName(SQLName name) {
        this.name = name;
    }

    public void setName(String name) {
        this.setName(new SQLIdentifierExpr(name));
    }

    @Override
    public SQLDataType getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(SQLDataType dataType) {
        if (dataType != null) {
            dataType.setParent(this);
        }
        this.dataType = dataType;
    }

    public SQLExpr getDefaultExpr() {
        return this.defaultExpr;
    }

    public void setDefaultExpr(SQLExpr defaultExpr) {
        if (defaultExpr != null) {
            defaultExpr.setParent(this);
        }
        this.defaultExpr = defaultExpr;
    }

    public List<SQLColumnConstraint> getConstraints() {
        return this.constraints;
    }

    public void addConstraint(SQLColumnConstraint constraint) {
        if (constraint != null) {
            constraint.setParent(this);
        }
        this.constraints.add(constraint);
    }

    @Override
    public void output(StringBuffer buf) {
        this.name.output(buf);
        buf.append(' ');
        this.dataType.output(buf);
        if (this.defaultExpr != null) {
            buf.append(" DEFAULT ");
            this.defaultExpr.output(buf);
        }
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.name);
            this.acceptChild(visitor, this.dataType);
            this.acceptChild(visitor, this.defaultExpr);
            this.acceptChild(visitor, this.constraints);
        }
        visitor.endVisit(this);
    }

    public SQLExpr getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.setComment(new SQLCharExpr(comment));
    }

    public void setComment(SQLExpr comment) {
        if (comment != null) {
            comment.setParent(this);
        }
        this.comment = comment;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
    }

    public SQLExpr getCharsetExpr() {
        return this.charsetExpr;
    }

    public void setCharsetExpr(SQLExpr charsetExpr) {
        if (charsetExpr != null) {
            charsetExpr.setParent(this);
        }
        this.charsetExpr = charsetExpr;
    }

    public SQLExpr getAsExpr() {
        return this.asExpr;
    }

    public void setAsExpr(SQLExpr asExpr) {
        if (this.charsetExpr != null) {
            this.charsetExpr.setParent(this);
        }
        this.asExpr = asExpr;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public SQLExpr getOnUpdate() {
        return this.onUpdate;
    }

    public void setOnUpdate(SQLExpr onUpdate) {
        this.onUpdate = onUpdate;
    }

    public SQLExpr getStorage() {
        return this.storage;
    }

    public void setStorage(SQLExpr storage) {
        this.storage = storage;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (this.defaultExpr == expr) {
            this.setDefaultExpr(target);
            return true;
        }
        if (this.name == expr) {
            this.setName((SQLName)target);
            return true;
        }
        return false;
    }

    public String computeAlias() {
        String alias = null;
        if (this.name instanceof SQLIdentifierExpr) {
            alias = ((SQLIdentifierExpr)this.name).getName();
        } else if (this.name instanceof SQLPropertyExpr) {
            alias = ((SQLPropertyExpr)this.name).getName();
        }
        return SQLUtils.normalize(alias);
    }

    @Override
    public SQLColumnDefinition clone() {
        SQLColumnDefinition x = new SQLColumnDefinition();
        x.setDbType(this.dbType);
        if (this.name != null) {
            x.setName(this.name.clone());
        }
        if (this.dataType != null) {
            x.setDataType(this.dataType.clone());
        }
        if (this.defaultExpr != null) {
            x.setDefaultExpr(this.defaultExpr.clone());
        }
        for (SQLColumnConstraint item : this.constraints) {
            SQLColumnConstraint itemCloned = item.clone();
            itemCloned.setParent(x);
            x.constraints.add(itemCloned);
        }
        if (this.comment != null) {
            x.setComment(this.comment.clone());
        }
        x.enable = this.enable;
        x.validate = this.validate;
        x.rely = this.rely;
        x.autoIncrement = this.autoIncrement;
        if (this.onUpdate != null) {
            x.setOnUpdate(this.onUpdate.clone());
        }
        if (this.storage != null) {
            x.setStorage(this.storage.clone());
        }
        if (this.charsetExpr != null) {
            x.setCharsetExpr(this.charsetExpr.clone());
        }
        if (this.asExpr != null) {
            x.setAsExpr(this.asExpr.clone());
        }
        x.sorted = this.sorted;
        x.virtual = this.virtual;
        if (this.identity != null) {
            x.setIdentity(this.identity.clone());
        }
        return x;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public void simplify() {
        SQLIdentifierExpr identExpr;
        String columnName;
        String normalized;
        this.enable = null;
        this.validate = null;
        this.rely = null;
        if (this.name instanceof SQLIdentifierExpr && (normalized = SQLUtils.normalize(columnName = (identExpr = (SQLIdentifierExpr)this.name).getName(), this.dbType)) != columnName) {
            this.setName(normalized);
        }
    }

    public boolean containsNotNullConstaint() {
        for (SQLColumnConstraint constraint : this.constraints) {
            if (!(constraint instanceof SQLNotNullConstraint)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return SQLUtils.toSQLString(this, this.dbType);
    }

    public static class Identity
    extends SQLObjectImpl {
        private Integer seed;
        private Integer increment;
        private boolean notForReplication;

        public Integer getSeed() {
            return this.seed;
        }

        public void setSeed(Integer seed) {
            this.seed = seed;
        }

        public Integer getIncrement() {
            return this.increment;
        }

        public void setIncrement(Integer increment) {
            this.increment = increment;
        }

        public boolean isNotForReplication() {
            return this.notForReplication;
        }

        public void setNotForReplication(boolean notForReplication) {
            this.notForReplication = notForReplication;
        }

        @Override
        public void accept0(SQLASTVisitor visitor) {
            visitor.visit(this);
            visitor.endVisit(this);
        }

        @Override
        public Identity clone() {
            Identity x = new Identity();
            x.seed = this.seed;
            x.increment = this.increment;
            x.notForReplication = this.notForReplication;
            return x;
        }
    }
}

