/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.odps.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.expr.SQLArrayExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLDateTimeExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.statement.SQLExternalRecordFormat;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsNewExpr;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsTransformExpr;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsUDTFSQLSelectItem;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsLexer;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.Arrays;

public class OdpsExprParser
extends SQLExprParser {
    public static final String[] AGGREGATE_FUNCTIONS;
    public static final long[] AGGREGATE_FUNCTIONS_CODES;
    static final long GSONBUILDER;

    public OdpsExprParser(Lexer lexer) {
        super(lexer, DbType.odps);
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
        this.aggregateFunctionHashCodes = AGGREGATE_FUNCTIONS_CODES;
    }

    public OdpsExprParser(String sql, SQLParserFeature ... features) {
        this(new OdpsLexer(sql, features));
        this.lexer.nextToken();
    }

    public OdpsExprParser(String sql, boolean skipComments, boolean keepComments) {
        this(new OdpsLexer(sql, skipComments, keepComments));
        this.lexer.nextToken();
    }

    @Override
    protected SQLExpr parseAliasExpr(String alias) {
        String chars = alias.substring(1, alias.length() - 1);
        return new SQLCharExpr(chars);
    }

    @Override
    public SQLSelectItem parseSelectItem() {
        SQLExpr expr;
        if (this.lexer.token() == Token.IDENTIFIER) {
            String stringVal = this.lexer.stringVal();
            long hash_lower = this.lexer.hash_lower();
            this.lexer.nextTokenComma();
            if (FnvHash.Constants.DATETIME == hash_lower && this.lexer.stringVal().charAt(0) != '`' && this.lexer.token() == Token.LITERAL_CHARS) {
                String literal = this.lexer.stringVal();
                this.lexer.nextToken();
                SQLDateTimeExpr ts = new SQLDateTimeExpr(literal);
                expr = ts;
            } else {
                expr = new SQLIdentifierExpr(stringVal);
                if (this.lexer.token() != Token.COMMA) {
                    expr = this.primaryRest(expr);
                    expr = this.exprRest(expr);
                }
            }
        } else {
            expr = this.expr();
        }
        String alias = null;
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                OdpsUDTFSQLSelectItem selectItem = new OdpsUDTFSQLSelectItem();
                selectItem.setExpr(expr);
                while (true) {
                    alias = this.lexer.stringVal();
                    this.lexer.nextToken();
                    selectItem.getAliasList().add(alias);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
                return selectItem;
            }
            alias = this.alias();
        } else {
            alias = this.as();
        }
        SQLSelectItem item = new SQLSelectItem(expr, alias);
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            item.addAfterComment(this.lexer.readAndResetComments());
        }
        return item;
    }

    @Override
    public SQLExpr primaryRest(SQLExpr expr) {
        if (this.lexer.token() == Token.COLON) {
            this.lexer.nextToken();
            expr = this.dotRest(expr);
            return expr;
        }
        if (this.lexer.token() == Token.LBRACKET) {
            SQLArrayExpr array = new SQLArrayExpr();
            array.setExpr(expr);
            this.lexer.nextToken();
            this.exprList(array.getValues(), array);
            this.accept(Token.RBRACKET);
            return this.primaryRest(array);
        }
        if ((this.lexer.token() == Token.LITERAL_CHARS || this.lexer.token() == Token.LITERAL_ALIAS) && expr instanceof SQLCharExpr) {
            SQLCharExpr charExpr = new SQLCharExpr(this.lexer.stringVal());
            this.lexer.nextTokenValue();
            SQLMethodInvokeExpr concat = new SQLMethodInvokeExpr("concat", null, expr, charExpr);
            while (this.lexer.token() == Token.LITERAL_CHARS || this.lexer.token() == Token.LITERAL_ALIAS) {
                charExpr = new SQLCharExpr(this.lexer.stringVal());
                this.lexer.nextToken();
                concat.addArgument(charExpr);
            }
            expr = concat;
        }
        if (this.lexer.token() == Token.LPAREN && expr instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)expr).nameHashCode64() == FnvHash.Constants.TRANSFORM) {
            SQLExternalRecordFormat recordFormat;
            OdpsTransformExpr transformExpr = new OdpsTransformExpr();
            this.lexer.nextToken();
            this.exprList(transformExpr.getInputColumns(), transformExpr);
            this.accept(Token.RPAREN);
            if (this.lexer.identifierEquals(FnvHash.Constants.ROW)) {
                recordFormat = this.parseRowFormat();
                transformExpr.setInputRowFormat(recordFormat);
            }
            if (this.lexer.token() == Token.USING || this.lexer.identifierEquals(FnvHash.Constants.USING)) {
                this.lexer.nextToken();
                transformExpr.setUsing(this.expr());
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.RESOURCES)) {
                this.lexer.nextToken();
                this.exprList(transformExpr.getResources(), transformExpr);
            }
            if (this.lexer.token() == Token.AS) {
                this.lexer.nextToken();
                this.exprList(transformExpr.getOutputColumns(), transformExpr);
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.ROW)) {
                recordFormat = this.parseRowFormat();
                transformExpr.setOutputRowFormat(recordFormat);
            }
            return transformExpr;
        }
        if (expr instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)expr).nameHashCode64() == FnvHash.Constants.NEW) {
            SQLIdentifierExpr ident = (SQLIdentifierExpr)expr;
            OdpsNewExpr newExpr = new OdpsNewExpr();
            if (this.lexer.identifierEquals(FnvHash.Constants.GSON) || this.lexer.identifierEquals(GSONBUILDER)) {
                this.lexer.nextToken();
                newExpr.setMethodName(this.lexer.stringVal());
                this.accept(Token.LPAREN);
                this.exprList(newExpr.getArguments(), newExpr);
                this.accept(Token.RPAREN);
                expr = newExpr;
            } else if (this.lexer.identifierEquals("java") || this.lexer.identifierEquals("com")) {
                SQLName name = this.name();
                String strName = ident.getName() + ' ' + name.toString();
                if (this.lexer.token() == Token.LT) {
                    this.lexer.nextToken();
                    int i = 0;
                    while (this.lexer.token() != Token.GT) {
                        if (i != 0) {
                            strName = strName + ", ";
                        }
                        SQLName arg = this.name();
                        strName = strName + arg.toString();
                        ++i;
                    }
                    this.lexer.nextToken();
                }
                ident.setName(strName);
            }
        }
        return super.primaryRest(expr);
    }

    @Override
    public SQLExpr relationalRest(SQLExpr expr) {
        if (this.lexer.identifierEquals("REGEXP")) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitOr();
            rightExp = this.relationalRest(rightExp);
            return new SQLBinaryOpExpr(expr, SQLBinaryOperator.RegExp, rightExp, this.dbType);
        }
        return super.relationalRest(expr);
    }

    @Override
    public OdpsSelectParser createSelectParser() {
        return new OdpsSelectParser(this);
    }

    static {
        String[] strings = new String[]{"AVG", "COUNT", "LAG", "LEAD", "MAX", "MIN", "STDDEV", "SUM", "ROW_NUMBER", "WM_CONCAT"};
        AGGREGATE_FUNCTIONS_CODES = FnvHash.fnv1a_64_lower(strings, true);
        AGGREGATE_FUNCTIONS = new String[AGGREGATE_FUNCTIONS_CODES.length];
        for (String str : strings) {
            long hash = FnvHash.fnv1a_64_lower(str);
            int index = Arrays.binarySearch(AGGREGATE_FUNCTIONS_CODES, hash);
            OdpsExprParser.AGGREGATE_FUNCTIONS[index] = str;
        }
        GSONBUILDER = FnvHash.fnv1a_64_lower("GSONBUILDER");
    }
}

