/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.protocol.thrift.io;

import java.io.IOException;
import java.io.InputStream;

public class InputStreamWrapper
extends InputStream {
    private InputStream is;

    public InputStreamWrapper(InputStream is) {
        if (is == null) {
            throw new NullPointerException("is == null");
        }
        this.is = is;
    }

    public int read(byte[] b) throws IOException {
        if (this.is.available() >= b.length) {
            return this.is.read(b);
        }
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.is.available() >= len) {
            return this.is.read(b, off, len);
        }
        return -1;
    }

    public long skip(long n) throws IOException {
        return this.is.skip(n);
    }

    public int available() throws IOException {
        return this.is.available();
    }

    public void close() throws IOException {
        this.is.close();
    }

    public void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    public void reset() throws IOException {
        this.is.reset();
    }

    public boolean markSupported() {
        return this.is.markSupported();
    }

    public int read() throws IOException {
        if (this.is.available() >= 1) {
            return this.is.read();
        }
        return -1;
    }
}

