/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.remote.client.grpc;

import com.alibaba.nacos.api.ability.constant.AbilityMode;
import com.alibaba.nacos.api.common.Constants;
import com.alibaba.nacos.common.remote.client.RpcClientTlsConfig;
import com.alibaba.nacos.common.remote.client.grpc.GrpcClient;
import com.alibaba.nacos.common.remote.client.grpc.GrpcClientConfig;
import com.alibaba.nacos.common.utils.VersionUtils;
import java.util.Map;

public class GrpcClusterClient
extends GrpcClient {
    private static final String CLUSTER_CLIENT_VERSION_PREFIX = "Nacos-Server:v";

    public GrpcClusterClient(String name) {
        super(name);
    }

    public GrpcClusterClient(GrpcClientConfig config) {
        super(config);
    }

    public GrpcClusterClient(String name, Integer threadPoolCoreSize, Integer threadPoolMaxSize, Map<String, String> labels) {
        this(name, threadPoolCoreSize, threadPoolMaxSize, labels, null);
    }

    public GrpcClusterClient(String name, Integer threadPoolCoreSize, Integer threadPoolMaxSize, Map<String, String> labels, RpcClientTlsConfig tlsConfig) {
        super(name, threadPoolCoreSize, threadPoolMaxSize, labels, tlsConfig);
    }

    @Override
    protected AbilityMode abilityMode() {
        return AbilityMode.CLUSTER_CLIENT;
    }

    @Override
    protected String getClientVersion() {
        return CLUSTER_CLIENT_VERSION_PREFIX + VersionUtils.version;
    }

    @Override
    public int rpcPortOffset() {
        return Integer.parseInt(System.getProperty("nacos.server.grpc.port.offset", String.valueOf(Constants.CLUSTER_GRPC_PORT_DEFAULT_OFFSET)));
    }
}

