/*
 * Decompiled with CFR 0.152.
 */
package com.alimuzaffar.lib.pin;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.animation.OvershootInterpolator;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import com.alimuzaffar.lib.pin.R;

public class PinEntryEditText
extends AppCompatEditText {
    private static final String XML_NAMESPACE_ANDROID = "http://schemas.android.com/apk/res/android";
    public static final String DEFAULT_MASK = "\u25cf";
    protected String mMask = null;
    protected StringBuilder mMaskChars = null;
    protected String mSingleCharHint = null;
    protected int mAnimatedType = 0;
    protected float mSpace = 24.0f;
    protected float mCharSize;
    protected float mNumChars = 4.0f;
    protected float mTextBottomPadding = 8.0f;
    protected int mMaxLength = 4;
    protected RectF[] mLineCoords;
    protected float[] mCharBottom;
    protected Paint mCharPaint;
    protected Paint mLastCharPaint;
    protected Paint mSingleCharPaint;
    protected Drawable mPinBackground;
    protected Rect mTextHeight = new Rect();
    protected boolean mIsDigitSquare = false;
    protected View.OnClickListener mClickListener;
    protected OnPinEnteredListener mOnPinEnteredListener = null;
    protected float mLineStroke = 1.0f;
    protected float mLineStrokeSelected = 2.0f;
    protected Paint mLinesPaint;
    protected boolean mAnimate = false;
    protected boolean mHasError = false;
    protected ColorStateList mOriginalTextColors;
    protected int[][] mStates = new int[][]{{0x10100A1}, {16842914}, {16842908}, {-16842908}};
    protected int[] mColors = new int[]{-16711936, -65536, -16777216, -7829368};
    protected ColorStateList mColorStates = new ColorStateList(this.mStates, this.mColors);

    public PinEntryEditText(Context context) {
        super(context);
    }

    public PinEntryEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public PinEntryEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    public void setMaxLength(int maxLength) {
        this.mMaxLength = maxLength;
        this.mNumChars = maxLength;
        this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxLength)});
        this.setText(null);
        this.invalidate();
    }

    public void setMask(String mask) {
        this.mMask = mask;
        this.mMaskChars = null;
        this.invalidate();
    }

    public void setSingleCharHint(String hint) {
        this.mSingleCharHint = hint;
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        int colorUnfocused;
        int colorFocused;
        int colorSelected;
        TypedValue outValue;
        float multi = context.getResources().getDisplayMetrics().density;
        this.mLineStroke = multi * this.mLineStroke;
        this.mLineStrokeSelected = multi * this.mLineStrokeSelected;
        this.mSpace = multi * this.mSpace;
        this.mTextBottomPadding = multi * this.mTextBottomPadding;
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.PinEntryEditText, 0, 0);
        try {
            outValue = new TypedValue();
            ta.getValue(R.styleable.PinEntryEditText_pinAnimationType, outValue);
            this.mAnimatedType = outValue.data;
            this.mMask = ta.getString(R.styleable.PinEntryEditText_pinCharacterMask);
            this.mSingleCharHint = ta.getString(R.styleable.PinEntryEditText_pinRepeatedHint);
            this.mLineStroke = ta.getDimension(R.styleable.PinEntryEditText_pinLineStroke, this.mLineStroke);
            this.mLineStrokeSelected = ta.getDimension(R.styleable.PinEntryEditText_pinLineStrokeSelected, this.mLineStrokeSelected);
            this.mSpace = ta.getDimension(R.styleable.PinEntryEditText_pinCharacterSpacing, this.mSpace);
            this.mTextBottomPadding = ta.getDimension(R.styleable.PinEntryEditText_pinTextBottomPadding, this.mTextBottomPadding);
            this.mIsDigitSquare = ta.getBoolean(R.styleable.PinEntryEditText_pinBackgroundIsSquare, this.mIsDigitSquare);
            this.mPinBackground = ta.getDrawable(R.styleable.PinEntryEditText_pinBackgroundDrawable);
            ColorStateList colors = ta.getColorStateList(R.styleable.PinEntryEditText_pinLineColors);
            if (colors != null) {
                this.mColorStates = colors;
            }
        }
        finally {
            ta.recycle();
        }
        this.mCharPaint = new Paint((Paint)this.getPaint());
        this.mLastCharPaint = new Paint((Paint)this.getPaint());
        this.mSingleCharPaint = new Paint((Paint)this.getPaint());
        this.mLinesPaint = new Paint((Paint)this.getPaint());
        this.mLinesPaint.setStrokeWidth(this.mLineStroke);
        outValue = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.colorControlActivated, outValue, true);
        this.mColors[0] = colorSelected = outValue.data;
        this.mColors[1] = colorFocused = this.isInEditMode() ? -7829368 : ContextCompat.getColor((Context)context, (int)R.color.pin_normal);
        this.mColors[2] = colorUnfocused = this.isInEditMode() ? -7829368 : ContextCompat.getColor((Context)context, (int)R.color.pin_normal);
        this.setBackgroundResource(0);
        this.mMaxLength = attrs.getAttributeIntValue(XML_NAMESPACE_ANDROID, "maxLength", 4);
        this.mNumChars = this.mMaxLength;
        super.setCustomSelectionActionModeCallback(new ActionMode.Callback(){

            public boolean onPrepareActionMode(ActionMode mode, Menu menu) {
                return false;
            }

            public void onDestroyActionMode(ActionMode mode) {
            }

            public boolean onCreateActionMode(ActionMode mode, Menu menu) {
                return false;
            }

            public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
                return false;
            }
        });
        super.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PinEntryEditText.this.setSelection(PinEntryEditText.this.getText().length());
                if (PinEntryEditText.this.mClickListener != null) {
                    PinEntryEditText.this.mClickListener.onClick(v);
                }
            }
        });
        super.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                PinEntryEditText.this.setSelection(PinEntryEditText.this.getText().length());
                return true;
            }
        });
        if ((this.getInputType() & 0x80) == 128 && TextUtils.isEmpty((CharSequence)this.mMask)) {
            this.mMask = DEFAULT_MASK;
        } else if ((this.getInputType() & 0x10) == 16 && TextUtils.isEmpty((CharSequence)this.mMask)) {
            this.mMask = DEFAULT_MASK;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mMask)) {
            this.mMaskChars = this.getMaskChars();
        }
        this.getPaint().getTextBounds("|", 0, 1, this.mTextHeight);
        this.mAnimate = this.mAnimatedType > -1;
    }

    public void setInputType(int type) {
        super.setInputType(type);
        if ((type & 0x80) == 128 || (type & 0x10) == 16) {
            if (TextUtils.isEmpty((CharSequence)this.mMask)) {
                this.setMask(DEFAULT_MASK);
            }
        } else {
            this.setMask(null);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        int startX;
        int rtlFlag;
        boolean isLayoutRtl;
        super.onSizeChanged(w, h, oldw, oldh);
        this.mOriginalTextColors = this.getTextColors();
        if (this.mOriginalTextColors != null) {
            this.mLastCharPaint.setColor(this.mOriginalTextColors.getDefaultColor());
            this.mCharPaint.setColor(this.mOriginalTextColors.getDefaultColor());
            this.mSingleCharPaint.setColor(this.getCurrentHintTextColor());
        }
        int availableWidth = this.getWidth() - ViewCompat.getPaddingEnd((View)this) - ViewCompat.getPaddingStart((View)this);
        this.mCharSize = this.mSpace < 0.0f ? (float)availableWidth / (this.mNumChars * 2.0f - 1.0f) : ((float)availableWidth - this.mSpace * (this.mNumChars - 1.0f)) / this.mNumChars;
        this.mLineCoords = new RectF[(int)this.mNumChars];
        this.mCharBottom = new float[(int)this.mNumChars];
        int bottom = this.getHeight() - this.getPaddingBottom();
        boolean bl = isLayoutRtl = ViewCompat.getLayoutDirection((View)this) == 1;
        if (isLayoutRtl) {
            rtlFlag = -1;
            startX = (int)((float)(this.getWidth() - ViewCompat.getPaddingStart((View)this)) - this.mCharSize);
        } else {
            rtlFlag = 1;
            startX = ViewCompat.getPaddingStart((View)this);
        }
        int i = 0;
        while ((float)i < this.mNumChars) {
            this.mLineCoords[i] = new RectF((float)startX, (float)bottom, (float)startX + this.mCharSize, (float)bottom);
            if (this.mPinBackground != null) {
                if (this.mIsDigitSquare) {
                    this.mLineCoords[i].top = this.getPaddingTop();
                    this.mLineCoords[i].right = (float)startX + this.mLineCoords[i].width();
                } else {
                    this.mLineCoords[i].top -= (float)this.mTextHeight.height() + this.mTextBottomPadding * 2.0f;
                }
            }
            startX = this.mSpace < 0.0f ? (int)((float)startX + (float)rtlFlag * this.mCharSize * 2.0f) : (int)((float)startX + (float)rtlFlag * (this.mCharSize + this.mSpace));
            this.mCharBottom[i] = this.mLineCoords[i].bottom - this.mTextBottomPadding;
            ++i;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mIsDigitSquare) {
            int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int measuredWidth = 0;
            int measuredHeight = 0;
            if (widthMode == 0x40000000) {
                measuredWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
                measuredHeight = (int)(((float)measuredWidth - (this.mNumChars - 1.0f * this.mSpace)) / this.mNumChars);
            } else if (heightMode == 0x40000000) {
                measuredHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
                measuredWidth = (int)((float)measuredHeight * this.mNumChars + (this.mSpace * this.mNumChars - 1.0f));
            } else if (widthMode == Integer.MIN_VALUE) {
                measuredWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
                measuredHeight = (int)(((float)measuredWidth - (this.mNumChars - 1.0f * this.mSpace)) / this.mNumChars);
            } else if (heightMode == Integer.MIN_VALUE) {
                measuredHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
                measuredWidth = (int)((float)measuredHeight * this.mNumChars + (this.mSpace * this.mNumChars - 1.0f));
            } else {
                measuredWidth = this.getPaddingLeft() + this.getPaddingRight() + this.getSuggestedMinimumWidth();
                measuredHeight = (int)(((float)measuredWidth - (this.mNumChars - 1.0f * this.mSpace)) / this.mNumChars);
            }
            this.setMeasuredDimension(PinEntryEditText.resolveSizeAndState((int)measuredWidth, (int)widthMeasureSpec, (int)1), PinEntryEditText.resolveSizeAndState((int)measuredHeight, (int)heightMeasureSpec, (int)0));
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public void setOnClickListener(View.OnClickListener l) {
        this.mClickListener = l;
    }

    public void setCustomSelectionActionModeCallback(ActionMode.Callback actionModeCallback) {
        throw new RuntimeException("setCustomSelectionActionModeCallback() not supported.");
    }

    protected void onDraw(Canvas canvas) {
        CharSequence text = this.getFullText();
        int textLength = text.length();
        float[] textWidths = new float[textLength];
        this.getPaint().getTextWidths(text, 0, textLength, textWidths);
        float hintWidth = 0.0f;
        if (this.mSingleCharHint != null) {
            float[] hintWidths = new float[this.mSingleCharHint.length()];
            this.getPaint().getTextWidths(this.mSingleCharHint, hintWidths);
            for (float i : hintWidths) {
                hintWidth += i;
            }
        }
        int i = 0;
        while ((float)i < this.mNumChars) {
            if (this.mPinBackground != null) {
                this.updateDrawableState(i < textLength, i == textLength);
                this.mPinBackground.setBounds((int)this.mLineCoords[i].left, (int)this.mLineCoords[i].top, (int)this.mLineCoords[i].right, (int)this.mLineCoords[i].bottom);
                this.mPinBackground.draw(canvas);
            }
            float middle = this.mLineCoords[i].left + this.mCharSize / 2.0f;
            if (textLength > i) {
                if (!this.mAnimate || i != textLength - 1) {
                    canvas.drawText(text, i, i + 1, middle - textWidths[i] / 2.0f, this.mCharBottom[i], this.mCharPaint);
                } else {
                    canvas.drawText(text, i, i + 1, middle - textWidths[i] / 2.0f, this.mCharBottom[i], this.mLastCharPaint);
                }
            } else if (this.mSingleCharHint != null) {
                canvas.drawText(this.mSingleCharHint, middle - hintWidth / 2.0f, this.mCharBottom[i], this.mSingleCharPaint);
            }
            if (this.mPinBackground == null) {
                this.updateColorForLines(i <= textLength);
                canvas.drawLine(this.mLineCoords[i].left, this.mLineCoords[i].top, this.mLineCoords[i].right, this.mLineCoords[i].bottom, this.mLinesPaint);
            }
            ++i;
        }
    }

    private CharSequence getFullText() {
        if (TextUtils.isEmpty((CharSequence)this.mMask)) {
            return this.getText();
        }
        return this.getMaskChars();
    }

    private StringBuilder getMaskChars() {
        if (this.mMaskChars == null) {
            this.mMaskChars = new StringBuilder();
        }
        int textLength = this.getText().length();
        while (this.mMaskChars.length() != textLength) {
            if (this.mMaskChars.length() < textLength) {
                this.mMaskChars.append(this.mMask);
                continue;
            }
            this.mMaskChars.deleteCharAt(this.mMaskChars.length() - 1);
        }
        return this.mMaskChars;
    }

    private int getColorForState(int ... states) {
        return this.mColorStates.getColorForState(states, -7829368);
    }

    protected void updateColorForLines(boolean hasTextOrIsNext) {
        if (this.mHasError) {
            this.mLinesPaint.setColor(this.getColorForState(16842914));
        } else if (this.isFocused()) {
            this.mLinesPaint.setStrokeWidth(this.mLineStrokeSelected);
            this.mLinesPaint.setColor(this.getColorForState(16842908));
            if (hasTextOrIsNext) {
                this.mLinesPaint.setColor(this.getColorForState(0x10100A1));
            }
        } else {
            this.mLinesPaint.setStrokeWidth(this.mLineStroke);
            this.mLinesPaint.setColor(this.getColorForState(-16842908));
        }
    }

    protected void updateDrawableState(boolean hasText, boolean isNext) {
        if (this.mHasError) {
            this.mPinBackground.setState(new int[]{16842914});
        } else if (this.isFocused()) {
            this.mPinBackground.setState(new int[]{16842908});
            if (isNext) {
                this.mPinBackground.setState(new int[]{16842908, 0x10100A1});
            } else if (hasText) {
                this.mPinBackground.setState(new int[]{16842908, 0x10100A0});
            }
        } else if (hasText) {
            this.mPinBackground.setState(new int[]{-16842908, 0x10100A0});
        } else {
            this.mPinBackground.setState(new int[]{-16842908});
        }
    }

    public void setError(boolean hasError) {
        this.mHasError = hasError;
        this.invalidate();
    }

    public boolean isError() {
        return this.mHasError;
    }

    public void focus() {
        this.requestFocus();
        InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        inputMethodManager.showSoftInput((View)this, 0);
    }

    public void setTypeface(@Nullable Typeface tf) {
        super.setTypeface(tf);
        this.setCustomTypeface(tf);
    }

    public void setTypeface(@Nullable Typeface tf, int style) {
        super.setTypeface(tf, style);
        this.setCustomTypeface(tf);
    }

    private void setCustomTypeface(@Nullable Typeface tf) {
        if (this.mCharPaint != null) {
            this.mCharPaint.setTypeface(tf);
            this.mLastCharPaint.setTypeface(tf);
            this.mSingleCharPaint.setTypeface(tf);
            this.mLinesPaint.setTypeface(tf);
        }
    }

    public void setPinLineColors(ColorStateList colors) {
        this.mColorStates = colors;
        this.invalidate();
    }

    public void setPinBackground(Drawable pinBackground) {
        this.mPinBackground = pinBackground;
        this.invalidate();
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        this.setError(false);
        if (this.mLineCoords == null || !this.mAnimate) {
            if (this.mOnPinEnteredListener != null && text.length() == this.mMaxLength) {
                this.mOnPinEnteredListener.onPinEntered(text);
            }
            return;
        }
        if (this.mAnimatedType == -1) {
            this.invalidate();
            return;
        }
        if (lengthAfter > lengthBefore) {
            if (this.mAnimatedType == 0) {
                this.animatePopIn();
            } else {
                this.animateBottomUp(text, start);
            }
        }
    }

    private void animatePopIn() {
        ValueAnimator va = ValueAnimator.ofFloat((float[])new float[]{1.0f, this.getPaint().getTextSize()});
        va.setDuration(200L);
        va.setInterpolator((TimeInterpolator)new OvershootInterpolator());
        va.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                PinEntryEditText.this.mLastCharPaint.setTextSize(((Float)animation.getAnimatedValue()).floatValue());
                PinEntryEditText.this.invalidate();
            }
        });
        if (this.getText().length() == this.mMaxLength && this.mOnPinEnteredListener != null) {
            va.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    PinEntryEditText.this.mOnPinEnteredListener.onPinEntered((CharSequence)PinEntryEditText.this.getText());
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        }
        va.start();
    }

    private void animateBottomUp(CharSequence text, final int start) {
        this.mCharBottom[start] = this.mLineCoords[start].bottom - this.mTextBottomPadding;
        ValueAnimator animUp = ValueAnimator.ofFloat((float[])new float[]{this.mCharBottom[start] + this.getPaint().getTextSize(), this.mCharBottom[start]});
        animUp.setDuration(300L);
        animUp.setInterpolator((TimeInterpolator)new OvershootInterpolator());
        animUp.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Float value = (Float)animation.getAnimatedValue();
                PinEntryEditText.this.mCharBottom[start] = value.floatValue();
                PinEntryEditText.this.invalidate();
            }
        });
        this.mLastCharPaint.setAlpha(255);
        ValueAnimator animAlpha = ValueAnimator.ofInt((int[])new int[]{0, 255});
        animAlpha.setDuration(300L);
        animAlpha.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Integer value = (Integer)animation.getAnimatedValue();
                PinEntryEditText.this.mLastCharPaint.setAlpha(value.intValue());
            }
        });
        AnimatorSet set = new AnimatorSet();
        if (text.length() == this.mMaxLength && this.mOnPinEnteredListener != null) {
            set.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    PinEntryEditText.this.mOnPinEnteredListener.onPinEntered((CharSequence)PinEntryEditText.this.getText());
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        }
        set.playTogether(new Animator[]{animUp, animAlpha});
        set.start();
    }

    public void setAnimateText(boolean animate) {
        this.mAnimate = animate;
    }

    public void setOnPinEnteredListener(OnPinEnteredListener l) {
        this.mOnPinEnteredListener = l;
    }

    public static interface OnPinEnteredListener {
        public void onPinEntered(CharSequence var1);
    }
}

