/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.ha3engine.async;

import com.aliyun.core.http.HttpMethod;
import com.aliyun.ha3engine.async.AsyncClient;
import com.aliyun.ha3engine.async.models.FetchRequest;
import com.aliyun.ha3engine.async.models.MultiQueryRequest;
import com.aliyun.ha3engine.async.models.PushDocumentsRequest;
import com.aliyun.ha3engine.async.models.PushDocumentsResponse;
import com.aliyun.ha3engine.async.models.QueryRequest;
import com.aliyun.ha3engine.async.models.SearchResponse;
import com.aliyun.ha3engine.async.models.StatsRequest;
import darabonba.core.RequestModel;
import darabonba.core.RequestStyle;
import darabonba.core.TeaAsyncHandler;
import darabonba.core.TeaModel;
import darabonba.core.TeaRequest;
import darabonba.core.client.ClientConfiguration;
import darabonba.core.client.ClientExecutionParams;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public final class DefaultAsyncClient
implements AsyncClient {
    protected final TeaRequest REQUEST;
    protected final TeaAsyncHandler handler;

    protected DefaultAsyncClient(ClientConfiguration configuration) {
        this.handler = new TeaAsyncHandler(configuration);
        this.REQUEST = TeaRequest.create();
    }

    @Override
    public CompletableFuture<SearchResponse> query(QueryRequest request) {
        try {
            TeaRequest teaRequest = this.REQUEST.copy().setStyle(RequestStyle.RESTFUL).setAction("Query").setMethod(HttpMethod.POST).setPathRegex("/vector-service/query").setBodyType("json").setBodyIsForm(Boolean.valueOf(false)).setReqBodyType("json").formModel((RequestModel)request);
            ClientExecutionParams params = new ClientExecutionParams().withInput((RequestModel)request).withRequest(teaRequest).withOutput((TeaModel)SearchResponse.create());
            return this.handler.execute(params);
        }
        catch (Exception e) {
            CompletableFuture<SearchResponse> future = new CompletableFuture<SearchResponse>();
            future.completeExceptionally(e);
            return future;
        }
    }

    @Override
    public CompletableFuture<SearchResponse> inferenceQuery(QueryRequest request) {
        try {
            TeaRequest teaRequest = this.REQUEST.copy().setStyle(RequestStyle.RESTFUL).setAction("InferenceQuery").setMethod(HttpMethod.POST).setPathRegex("/vector-service/inference-query").setBodyType("json").setBodyIsForm(Boolean.valueOf(false)).setReqBodyType("json").formModel((RequestModel)request);
            ClientExecutionParams params = new ClientExecutionParams().withInput((RequestModel)request).withRequest(teaRequest).withOutput((TeaModel)SearchResponse.create());
            return this.handler.execute(params);
        }
        catch (Exception e) {
            CompletableFuture<SearchResponse> future = new CompletableFuture<SearchResponse>();
            future.completeExceptionally(e);
            return future;
        }
    }

    @Override
    public CompletableFuture<SearchResponse> multiQuery(MultiQueryRequest request) {
        try {
            TeaRequest teaRequest = this.REQUEST.copy().setStyle(RequestStyle.RESTFUL).setAction("MultiQuery").setMethod(HttpMethod.POST).setPathRegex("/vector-service/multi-query").setBodyType("json").setBodyIsForm(Boolean.valueOf(false)).setReqBodyType("json").formModel((RequestModel)request);
            ClientExecutionParams params = new ClientExecutionParams().withInput((RequestModel)request).withRequest(teaRequest).withOutput((TeaModel)SearchResponse.create());
            return this.handler.execute(params);
        }
        catch (Exception e) {
            CompletableFuture<SearchResponse> future = new CompletableFuture<SearchResponse>();
            future.completeExceptionally(e);
            return future;
        }
    }

    @Override
    public CompletableFuture<SearchResponse> fetch(FetchRequest request) {
        try {
            TeaRequest teaRequest = this.REQUEST.copy().setStyle(RequestStyle.RESTFUL).setAction("Fetch").setMethod(HttpMethod.POST).setPathRegex("/vector-service/fetch").setBodyType("json").setBodyIsForm(Boolean.valueOf(false)).setReqBodyType("json").formModel((RequestModel)request);
            ClientExecutionParams params = new ClientExecutionParams().withInput((RequestModel)request).withRequest(teaRequest).withOutput((TeaModel)SearchResponse.create());
            return this.handler.execute(params);
        }
        catch (Exception e) {
            CompletableFuture<SearchResponse> future = new CompletableFuture<SearchResponse>();
            future.completeExceptionally(e);
            return future;
        }
    }

    @Override
    public CompletableFuture<SearchResponse> stats(StatsRequest request) {
        try {
            TeaRequest teaRequest = this.REQUEST.copy().setStyle(RequestStyle.RESTFUL).setAction("Stats").setMethod(HttpMethod.POST).setPathRegex("/vector-service/stats").setBodyType("json").setBodyIsForm(Boolean.valueOf(false)).setReqBodyType("json").formModel((RequestModel)request);
            ClientExecutionParams params = new ClientExecutionParams().withInput((RequestModel)request).withRequest(teaRequest).withOutput((TeaModel)SearchResponse.create());
            return this.handler.execute(params);
        }
        catch (Exception e) {
            CompletableFuture<SearchResponse> future = new CompletableFuture<SearchResponse>();
            future.completeExceptionally(e);
            return future;
        }
    }

    @Override
    public CompletableFuture<PushDocumentsResponse> pushDocuments(String dataSourceName, String keyField, PushDocumentsRequest request) {
        try {
            HashMap<String, String> headers = null == request.getHeaders() || request.getHeaders().isEmpty() ? new HashMap<String, String>() : request.getHeaders();
            headers.put("X-Opensearch-Swift-PK-Field", keyField);
            PushDocumentsRequest build = request.toBuilder().headers(headers).body(request.getBody()).build();
            TeaRequest teaRequest = this.REQUEST.copy().setStyle(RequestStyle.RESTFUL).setAction("PushDocuments").setMethod(HttpMethod.POST).setPathRegex("/update/" + dataSourceName + "/actions/bulk").setBodyType("json").setBodyIsForm(Boolean.valueOf(false)).setReqBodyType("json").formModel((RequestModel)build);
            ClientExecutionParams params = new ClientExecutionParams().withInput((RequestModel)request).withRequest(teaRequest).withOutput((TeaModel)PushDocumentsResponse.create());
            return this.handler.execute(params);
        }
        catch (Exception e) {
            CompletableFuture<PushDocumentsResponse> future = new CompletableFuture<PushDocumentsResponse>();
            future.completeExceptionally(e);
            return future;
        }
    }

    @Override
    public CompletableFuture<PushDocumentsResponse> pushDocumentsWithSwift(String dataSourceName, String keyField, String topic, String swift, PushDocumentsRequest request) {
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("X-Opensearch-Swift-PK-Field", keyField);
            headers.put("X-Opensearch-Swift-Topic", topic);
            headers.put("X-Opensearch-Swift-Swift", swift);
            PushDocumentsRequest build = request.toBuilder().headers(headers).body(request.getBody()).build();
            TeaRequest teaRequest = this.REQUEST.copy().setStyle(RequestStyle.RESTFUL).setAction("PushDocumentsWithSwift").setMethod(HttpMethod.POST).setPathRegex("/update/" + dataSourceName + "/actions/bulk").setBodyType("json").setBodyIsForm(Boolean.valueOf(false)).setReqBodyType("json").formModel((RequestModel)build);
            ClientExecutionParams params = new ClientExecutionParams().withInput((RequestModel)request).withRequest(teaRequest).withOutput((TeaModel)PushDocumentsResponse.create());
            return this.handler.execute(params);
        }
        catch (Exception e) {
            CompletableFuture<PushDocumentsResponse> future = new CompletableFuture<PushDocumentsResponse>();
            future.completeExceptionally(e);
            return future;
        }
    }
}

