/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.ha3engine;

import com.aliyun.darabonba.encode.Encoder;
import com.aliyun.ha3engine.models.Config;
import com.aliyun.ha3engine.models.HaQuery;
import com.aliyun.ha3engine.models.HaQueryAggregateClause;
import com.aliyun.ha3engine.models.HaQueryDistinctClause;
import com.aliyun.ha3engine.models.HaQuerySortClause;
import com.aliyun.ha3engine.models.HaQueryconfigClause;
import com.aliyun.ha3engine.models.PushDocumentsRequestModel;
import com.aliyun.ha3engine.models.PushDocumentsResponseModel;
import com.aliyun.ha3engine.models.SQLQuery;
import com.aliyun.ha3engine.models.SearchBytesResponseModel;
import com.aliyun.ha3engine.models.SearchRequestModel;
import com.aliyun.ha3engine.models.SearchResponseModel;
import com.aliyun.tea.Tea;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaException;
import com.aliyun.tea.TeaModel;
import com.aliyun.tea.TeaPair;
import com.aliyun.tea.TeaRequest;
import com.aliyun.tea.TeaResponse;
import com.aliyun.tea.TeaUnretryableException;
import com.aliyun.tea.interceptor.InterceptorChain;
import com.aliyun.tea.interceptor.RequestInterceptor;
import com.aliyun.tea.interceptor.ResponseInterceptor;
import com.aliyun.tea.interceptor.RuntimeOptionsInterceptor;
import com.aliyun.teautil.Common;
import com.aliyun.teautil.models.RuntimeOptions;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class Client {
    private static final InterceptorChain interceptorChain = InterceptorChain.create();
    public String _endpoint;
    public String _instanceId;
    public String _protocol;
    public String _userAgent;
    public String _credential;
    public String _domainsuffix;
    public String _httpProxy;

    public Client(Config config) throws Exception {
        if (Common.isUnset((Object)TeaModel.buildMap((TeaModel)config))) {
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("name", (Object)"ParameterMissing"), new TeaPair("message", (Object)"'config' can not be unset")}));
        }
        this._credential = this.getRealmSignStr(config.accessUserName, config.accessPassWord);
        this._endpoint = config.endpoint;
        this._instanceId = config.instanceId;
        this._protocol = config.protocol;
        this._userAgent = config.userAgent;
        this._domainsuffix = "ha.aliyuncs.com";
        this._httpProxy = config.httpProxy;
    }

    public Map<String, ?> _request(String method, String pathname, Map<String, ?> query, Map<String, String> headers, Object body, RuntimeOptions runtime) throws Exception {
        Map runtime_ = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("timeouted", (Object)"retry"), new TeaPair("readTimeout", (Object)runtime.readTimeout), new TeaPair("connectTimeout", (Object)runtime.connectTimeout), new TeaPair("httpProxy", (Object)runtime.httpProxy), new TeaPair("httpsProxy", (Object)runtime.httpsProxy), new TeaPair("noProxy", (Object)runtime.noProxy), new TeaPair("maxIdleConns", (Object)runtime.maxIdleConns), new TeaPair("retry", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("retryable", (Object)runtime.autoretry), new TeaPair("maxAttempts", (Object)Common.defaultNumber((Number)runtime.maxAttempts, (Number)5))})), new TeaPair("backoff", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("policy", (Object)Common.defaultString((String)runtime.backoffPolicy, (String)"no")), new TeaPair("period", (Object)Common.defaultNumber((Number)runtime.backoffPeriod, (Number)1))})), new TeaPair("ignoreSSL", (Object)runtime.ignoreSSL)});
        TeaRequest _lastRequest = null;
        Exception _lastException = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)((Map)runtime_.get("retry")), (int)_retryTimes, (long)_now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), (int)_retryTimes)) > 0) {
                Tea.sleep((int)backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                request_.protocol = Common.defaultString((String)this._protocol, (String)"HTTP");
                request_.method = method;
                request_.pathname = pathname;
                request_.headers = TeaConverter.merge(String.class, (Map[])new Map[]{TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("user-agent", (Object)this.getUserAgent()), new TeaPair("host", (Object)Common.defaultString((String)this._endpoint, (String)("" + this._instanceId + "." + this._domainsuffix + ""))), new TeaPair("authorization", (Object)("Basic " + this._credential + "")), new TeaPair("content-type", (Object)"application/json; charset=utf-8")}), headers});
                if (!Common.isUnset(query)) {
                    request_.query = Common.stringifyMapValue(query);
                    request_.headers.put("X-Opensearch-Request-ID", Common.getNonce());
                }
                if (!Common.isUnset((Object)body)) {
                    request_.headers.put("X-Opensearch-Swift-Request-ID", Common.getNonce());
                    request_.body = Tea.toReadable((String)Common.toJSONString((Object)body));
                }
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction((TeaRequest)request_, (Map)runtime_, (InterceptorChain)interceptorChain);
                String objStr = Common.readAsString((InputStream)response_.body);
                if (Common.is4xx((Number)response_.statusCode) || Common.is5xx((Number)response_.statusCode)) {
                    Object rawMsg = null;
                    try {
                        rawMsg = Common.parseJSON((String)objStr);
                    }
                    catch (TeaException err) {
                        rawMsg = objStr;
                    }
                    catch (Exception _err) {
                        TeaException err = new TeaException(_err.getMessage(), (Throwable)_err);
                        rawMsg = objStr;
                    }
                    Map rawMap = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("errors", rawMsg)});
                    throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("message", (Object)response_.statusMessage), new TeaPair("data", (Object)rawMap), new TeaPair("code", (Object)response_.statusCode)}));
                }
                if (Common.empty((String)objStr)) {
                    Map rawbodyMap = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("status", (Object)response_.statusMessage), new TeaPair("code", (Object)response_.statusCode)});
                    return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)Common.toJSONString((Object)rawbodyMap)), new TeaPair("headers", (Object)response_.headers)});
                }
                return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)objStr), new TeaPair("headers", (Object)response_.headers)});
            }
            catch (Exception e) {
                if (Tea.isRetryable((Exception)e)) {
                    _lastException = e;
                    continue;
                }
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest, _lastException);
    }

    public Map<String, ?> _request_search_bytes(String method, String pathname, Map<String, ?> query, Map<String, String> headers, Object body, RuntimeOptions runtime) throws Exception {
        Map runtime_ = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("timeouted", (Object)"retry"), new TeaPair("readTimeout", (Object)runtime.readTimeout), new TeaPair("connectTimeout", (Object)runtime.connectTimeout), new TeaPair("httpProxy", (Object)runtime.httpProxy), new TeaPair("httpsProxy", (Object)runtime.httpsProxy), new TeaPair("noProxy", (Object)runtime.noProxy), new TeaPair("maxIdleConns", (Object)runtime.maxIdleConns), new TeaPair("retry", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("retryable", (Object)runtime.autoretry), new TeaPair("maxAttempts", (Object)Common.defaultNumber((Number)runtime.maxAttempts, (Number)5))})), new TeaPair("backoff", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("policy", (Object)Common.defaultString((String)runtime.backoffPolicy, (String)"no")), new TeaPair("period", (Object)Common.defaultNumber((Number)runtime.backoffPeriod, (Number)1))})), new TeaPair("ignoreSSL", (Object)runtime.ignoreSSL)});
        TeaRequest _lastRequest = null;
        Exception _lastException = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)((Map)runtime_.get("retry")), (int)_retryTimes, (long)_now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), (int)_retryTimes)) > 0) {
                Tea.sleep((int)backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                request_.protocol = Common.defaultString((String)this._protocol, (String)"HTTP");
                request_.method = method;
                request_.pathname = pathname;
                request_.headers = TeaConverter.merge(String.class, (Map[])new Map[]{TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("user-agent", (Object)this.getUserAgent()), new TeaPair("host", (Object)Common.defaultString((String)this._endpoint, (String)("" + this._instanceId + "." + this._domainsuffix + ""))), new TeaPair("authorization", (Object)("Basic " + this._credential + "")), new TeaPair("content-type", (Object)"application/json; charset=utf-8")}), headers});
                if (!Common.isUnset(query)) {
                    request_.query = Common.stringifyMapValue(query);
                    request_.headers.put("X-Opensearch-Request-ID", Common.getNonce());
                }
                if (!Common.isUnset((Object)body)) {
                    request_.headers.put("X-Opensearch-Swift-Request-ID", Common.getNonce());
                    request_.body = Tea.toReadable((String)Common.toJSONString((Object)body));
                }
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction((TeaRequest)request_, (Map)runtime_, (InterceptorChain)interceptorChain);
                byte[] objStr = Common.readAsBytes((InputStream)response_.body);
                if (Common.is4xx((Number)response_.statusCode) || Common.is5xx((Number)response_.statusCode)) {
                    String errorMsg = Common.toString((byte[])objStr);
                    Object rawMsg = null;
                    try {
                        rawMsg = Common.parseJSON((String)errorMsg);
                    }
                    catch (TeaException err) {
                        rawMsg = errorMsg;
                    }
                    catch (Exception _err) {
                        TeaException err = new TeaException(_err.getMessage(), (Throwable)_err);
                        rawMsg = errorMsg;
                    }
                    Map rawMap = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("errors", rawMsg)});
                    throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("message", (Object)response_.statusMessage), new TeaPair("data", (Object)rawMap), new TeaPair("code", (Object)response_.statusCode)}));
                }
                if (Common.isUnset((Object)objStr)) {
                    Map rawbodyMap = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("status", (Object)response_.statusMessage), new TeaPair("code", (Object)response_.statusCode)});
                    return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)rawbodyMap), new TeaPair("headers", (Object)response_.headers)});
                }
                return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)objStr), new TeaPair("headers", (Object)response_.headers)});
            }
            catch (Exception e) {
                if (Tea.isRetryable((Exception)e)) {
                    _lastException = e;
                    continue;
                }
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest, _lastException);
    }

    public void addRuntimeOptionsInterceptor(RuntimeOptionsInterceptor interceptor) {
        interceptorChain.addRuntimeOptionsInterceptor(interceptor);
    }

    public void addRequestInterceptor(RequestInterceptor interceptor) {
        interceptorChain.addRequestInterceptor(interceptor);
    }

    public void addResponseInterceptor(ResponseInterceptor interceptor) {
        interceptorChain.addResponseInterceptor(interceptor);
    }

    public void setUserAgent(String userAgent) throws Exception {
        this._userAgent = userAgent;
    }

    public void appendUserAgent(String userAgent) throws Exception {
        this._userAgent = "" + this._userAgent + " " + userAgent + "";
    }

    public String getUserAgent() throws Exception {
        String userAgent = Common.getUserAgent((String)this._userAgent);
        return userAgent;
    }

    public String getRealmSignStr(String accessUserName, String accessPassWord) throws Exception {
        String accessUserNameStr = com.aliyun.darabonbastring.Client.trim((String)accessUserName);
        String accessPassWordStr = com.aliyun.darabonbastring.Client.trim((String)accessPassWord);
        String realmStr = "" + accessUserNameStr + ":" + accessPassWordStr + "";
        return Encoder.base64EncodeToString((byte[])com.aliyun.darabonbastring.Client.toBytes((String)realmStr, (String)"UTF-8"));
    }

    public String buildHaSearchQuery(HaQuery haquery) throws Exception {
        String kvpairs;
        String distinctClauseStr;
        String aggregateClauseStr;
        String sortStr;
        Object filterStr;
        if (Common.isUnset((Object)haquery.query)) {
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("name", (Object)"ParameterMissing"), new TeaPair("message", (Object)"'HaQuery.query' can not be unset")}));
        }
        String tempString = "query=" + haquery.query + "";
        String configStr = this.buildHaQueryconfigClauseStr(haquery.config);
        tempString = "" + tempString + "&&cluster=" + Common.defaultString((String)haquery.cluster, (String)"general") + "";
        tempString = "" + tempString + "&&config=" + configStr + "";
        if (!Common.isUnset((Object)haquery.filter) && !Common.empty((String)(filterStr = haquery.filter))) {
            String fieldValueTrimed = com.aliyun.darabonbastring.Client.trim((String)filterStr);
            tempString = "" + tempString + "&&filter=" + fieldValueTrimed + "";
        }
        if (!Common.isUnset(haquery.customQuery)) {
            for (String keyField : com.aliyun.darabonba.map.Client.keySet(haquery.customQuery)) {
                String fieldValue = haquery.customQuery.get(keyField);
                if (Common.empty((String)fieldValue)) continue;
                String fieldValueTrimed = com.aliyun.darabonbastring.Client.trim((String)fieldValue);
                String keyFieldTrimed = com.aliyun.darabonbastring.Client.trim((String)keyField);
                tempString = "" + tempString + "&&" + keyFieldTrimed + "=" + fieldValueTrimed + "";
            }
        }
        if (!Common.isUnset(haquery.sort) && !Common.empty((String)(sortStr = this.buildHaQuerySortClauseStr(haquery.sort)))) {
            tempString = "" + tempString + "&&sort=" + sortStr + "";
        }
        if (!Common.isUnset(haquery.aggregate) && !Common.empty((String)(aggregateClauseStr = this.buildHaQueryAggregateClauseStr(haquery.aggregate)))) {
            tempString = "" + tempString + "&&aggregate=" + aggregateClauseStr + "";
        }
        if (!Common.isUnset(haquery.distinct) && !Common.empty((String)(distinctClauseStr = this.buildHaQueryDistinctClauseStr(haquery.distinct)))) {
            tempString = "" + tempString + "&&distinct=" + distinctClauseStr + "";
        }
        if (!Common.empty((String)(kvpairs = this.buildSearcKvPairClauseStr(haquery.kvpairs)))) {
            tempString = "" + tempString + "&&kvpairs=" + kvpairs + "";
        }
        return tempString;
    }

    public String buildHaQueryAggregateClauseStr(List<HaQueryAggregateClause> Clause) throws Exception {
        String tempClauseString = "";
        for (HaQueryAggregateClause AggregateClause : Clause) {
            String tempAggregateClauseString = "";
            if (Common.isUnset((Object)AggregateClause.groupKey) || Common.isUnset((Object)AggregateClause.aggFun)) {
                throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("name", (Object)"ParameterMissing"), new TeaPair("message", (Object)"'HaQueryAggregateClause.groupKey/aggFun' can not be unset")}));
            }
            if (!Common.empty((String)AggregateClause.groupKey) && !Common.empty((String)AggregateClause.aggFun)) {
                String groupKeyTrimed = com.aliyun.darabonbastring.Client.trim((String)AggregateClause.groupKey);
                String aggFunTrimed = com.aliyun.darabonbastring.Client.trim((String)AggregateClause.aggFun);
                tempAggregateClauseString = "group_key:" + groupKeyTrimed + ",agg_fun:" + aggFunTrimed + "";
            }
            if (!Common.empty((String)AggregateClause.range)) {
                String rangeTrimed = com.aliyun.darabonbastring.Client.trim((String)AggregateClause.range);
                tempAggregateClauseString = "" + tempAggregateClauseString + ",range:" + rangeTrimed + "";
            }
            if (!Common.empty((String)AggregateClause.maxGroup)) {
                String maxGroupTrimed = com.aliyun.darabonbastring.Client.trim((String)AggregateClause.maxGroup);
                tempAggregateClauseString = "" + tempAggregateClauseString + ",max_group:" + maxGroupTrimed + "";
            }
            if (!Common.empty((String)AggregateClause.aggFilter)) {
                String aggFilterTrimed = com.aliyun.darabonbastring.Client.trim((String)AggregateClause.aggFilter);
                tempAggregateClauseString = "" + tempAggregateClauseString + ",agg_filter:" + aggFilterTrimed + "";
            }
            if (!Common.empty((String)AggregateClause.aggSamplerThresHold)) {
                String aggSamplerThresHoldTrimed = com.aliyun.darabonbastring.Client.trim((String)AggregateClause.aggSamplerThresHold);
                tempAggregateClauseString = "" + tempAggregateClauseString + ",agg_sampler_threshold:" + aggSamplerThresHoldTrimed + "";
            }
            if (!Common.empty((String)AggregateClause.aggSamplerStep)) {
                String aggSamplerStepTrimed = com.aliyun.darabonbastring.Client.trim((String)AggregateClause.aggSamplerStep);
                tempAggregateClauseString = "" + tempAggregateClauseString + ",agg_sampler_step:" + aggSamplerStepTrimed + "";
            }
            if (!Common.empty((String)tempClauseString)) {
                tempClauseString = "" + tempClauseString + ";" + tempAggregateClauseString + "";
                continue;
            }
            tempClauseString = "" + tempAggregateClauseString + "";
        }
        return tempClauseString;
    }

    public String buildHaQueryDistinctClauseStr(List<HaQueryDistinctClause> Clause) throws Exception {
        String tempClauseString = "";
        for (HaQueryDistinctClause DistinctClause : Clause) {
            String tempDistinctClauseString = "";
            if (Common.isUnset((Object)DistinctClause.distKey)) {
                throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("name", (Object)"ParameterMissing"), new TeaPair("message", (Object)"'HaQueryDistinctClause.distKey' can not be unset")}));
            }
            if (!Common.empty((String)DistinctClause.distKey)) {
                String distKeyTrimed = com.aliyun.darabonbastring.Client.trim((String)DistinctClause.distKey);
                tempDistinctClauseString = "dist_key:" + distKeyTrimed + "";
            }
            if (!Common.empty((String)DistinctClause.distCount)) {
                String distCountTrimed = com.aliyun.darabonbastring.Client.trim((String)DistinctClause.distCount);
                tempDistinctClauseString = "" + tempDistinctClauseString + ",dist_count:" + distCountTrimed + "";
            }
            if (!Common.empty((String)DistinctClause.distTimes)) {
                String distTimesTrimed = com.aliyun.darabonbastring.Client.trim((String)DistinctClause.distTimes);
                tempDistinctClauseString = "" + tempDistinctClauseString + ",dist_times:" + distTimesTrimed + "";
            }
            if (!Common.empty((String)DistinctClause.reserved)) {
                String reservedTrimed = com.aliyun.darabonbastring.Client.trim((String)DistinctClause.reserved);
                tempDistinctClauseString = "" + tempDistinctClauseString + ",reserved:" + reservedTrimed + "";
            }
            if (!Common.empty((String)DistinctClause.distFilter)) {
                String distFilterTrimed = com.aliyun.darabonbastring.Client.trim((String)DistinctClause.distFilter);
                tempDistinctClauseString = "" + tempDistinctClauseString + ",dist_filter:" + distFilterTrimed + "";
            }
            if (!Common.empty((String)DistinctClause.updateTotalHit)) {
                String updateTotalHitTrimed = com.aliyun.darabonbastring.Client.trim((String)DistinctClause.updateTotalHit);
                tempDistinctClauseString = "" + tempDistinctClauseString + ",update_total_hit:" + updateTotalHitTrimed + "";
            }
            if (!Common.empty((String)DistinctClause.grade)) {
                String gradeTrimed = com.aliyun.darabonbastring.Client.trim((String)DistinctClause.grade);
                tempDistinctClauseString = "" + tempDistinctClauseString + ",grade:" + gradeTrimed + "";
            }
            if (!Common.empty((String)tempClauseString)) {
                tempClauseString = "" + tempClauseString + ";" + tempDistinctClauseString + "";
                continue;
            }
            tempClauseString = "" + tempDistinctClauseString + "";
        }
        return tempClauseString;
    }

    public String buildHaQuerySortClauseStr(List<HaQuerySortClause> Clause) throws Exception {
        String tempClauseString = "";
        for (HaQuerySortClause SortClause : Clause) {
            String fieldValueTrimed = com.aliyun.darabonbastring.Client.trim((String)SortClause.sortOrder);
            String keyFieldTrimed = com.aliyun.darabonbastring.Client.trim((String)SortClause.sortKey);
            if (!Common.equalString((String)fieldValueTrimed, (String)"+") && !Common.equalString((String)fieldValueTrimed, (String)"-") || Common.empty((String)fieldValueTrimed) || Common.empty((String)keyFieldTrimed)) continue;
            if (Common.empty((String)tempClauseString)) {
                tempClauseString = "" + fieldValueTrimed + "" + keyFieldTrimed + "";
                continue;
            }
            tempClauseString = "" + tempClauseString + ";" + fieldValueTrimed + "" + keyFieldTrimed + "";
        }
        return tempClauseString;
    }

    public String buildHaQueryconfigClauseStr(HaQueryconfigClause Clause) throws Exception {
        String tempClauseString = "";
        if (Common.isUnset((Object)TeaModel.buildMap((TeaModel)Clause))) {
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("name", (Object)"ParameterMissing"), new TeaPair("message", (Object)"'HaQueryconfigClause' can not be unset")}));
        }
        if (Common.isUnset((Object)Clause.start)) {
            Clause.start = null;
        }
        if (Common.isUnset((Object)Clause.hit)) {
            Clause.hit = null;
        }
        if (Common.isUnset((Object)Clause.format)) {
            Clause.format = null;
        }
        tempClauseString = "start:" + Common.defaultString((String)Clause.start, (String)"0") + "";
        tempClauseString = "" + tempClauseString + ",hit:" + Common.defaultString((String)Clause.hit, (String)"10") + "";
        tempClauseString = "" + tempClauseString + ",format:" + com.aliyun.darabonbastring.Client.toLower((String)Common.defaultString((String)Clause.format, (String)"json")) + "";
        if (!Common.isUnset(Clause.customConfig)) {
            for (String keyField : com.aliyun.darabonba.map.Client.keySet(Clause.customConfig)) {
                String fieldValue = Clause.customConfig.get(keyField);
                if (Common.empty((String)fieldValue)) continue;
                String fieldValueTrimed = com.aliyun.darabonbastring.Client.trim((String)fieldValue);
                String keyFieldTrimed = com.aliyun.darabonbastring.Client.trim((String)keyField);
                if (!Common.empty((String)tempClauseString)) {
                    tempClauseString = "" + tempClauseString + "," + keyFieldTrimed + ":" + fieldValueTrimed + "";
                    continue;
                }
                tempClauseString = "" + keyFieldTrimed + ":" + fieldValueTrimed + "";
            }
        }
        return tempClauseString;
    }

    public String buildSQLSearchQuery(SQLQuery sqlquery) throws Exception {
        if (Common.isUnset((Object)sqlquery.query)) {
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("name", (Object)"ParameterMissing"), new TeaPair("message", (Object)"'SQLQuery.query' can not be unset")}));
        }
        String tempString = "query=" + sqlquery.query + "";
        String kvpairs = this.buildSearcKvPairClauseStr(sqlquery.kvpairs);
        if (!Common.empty((String)kvpairs)) {
            tempString = "" + tempString + "&&kvpair=" + kvpairs + "";
        }
        return tempString;
    }

    public String buildSearcKvPairClauseStr(Map<String, String> kvPair) throws Exception {
        String tempkvpairsString = "__ops_request_id:" + Common.getNonce() + "";
        if (!Common.isUnset(kvPair)) {
            for (String keyField : com.aliyun.darabonba.map.Client.keySet(kvPair)) {
                String fieldValue = kvPair.get(keyField);
                if (Common.empty((String)fieldValue)) continue;
                String fieldValueTrimed = com.aliyun.darabonbastring.Client.trim((String)fieldValue);
                String keyFieldTrimed = com.aliyun.darabonbastring.Client.trim((String)keyField);
                tempkvpairsString = "" + tempkvpairsString + "," + keyFieldTrimed + ":" + fieldValueTrimed + "";
            }
        }
        return tempkvpairsString;
    }

    public SearchResponseModel Search(SearchRequestModel request) throws Exception {
        return (SearchResponseModel)TeaModel.toModel(this._request("GET", "/query", TeaModel.buildMap((TeaModel)request.query), request.headers, null, this.buildRuntimeOptions()), (TeaModel)new SearchResponseModel());
    }

    public SearchResponseModel SearchRest(SearchRequestModel request, String indexName) throws Exception {
        return (SearchResponseModel)TeaModel.toModel(this._request("POST", "/" + indexName + "/search", null, request.headers, request.body, this.buildRuntimeOptions()), (TeaModel)new SearchResponseModel());
    }

    public SearchBytesResponseModel SearchBytes(SearchRequestModel request) throws Exception {
        return (SearchBytesResponseModel)TeaModel.toModel(this._request_search_bytes("GET", "/query", TeaModel.buildMap((TeaModel)request.query), request.headers, null, this.buildRuntimeOptions()), (TeaModel)new SearchBytesResponseModel());
    }

    public SearchBytesResponseModel SearchRestBytes(SearchRequestModel request, String indexName) throws Exception {
        return (SearchBytesResponseModel)TeaModel.toModel(this._request_search_bytes("POST", "/" + indexName + "/search", null, request.headers, request.body, this.buildRuntimeOptions()), (TeaModel)new SearchBytesResponseModel());
    }

    public PushDocumentsResponseModel pushDocuments(String dataSourceName, String keyField, PushDocumentsRequestModel request) throws Exception {
        request.headers = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("X-Opensearch-Swift-PK-Field", (Object)keyField)});
        return (PushDocumentsResponseModel)TeaModel.toModel(this._request("POST", "/update/" + dataSourceName + "/actions/bulk", null, request.headers, request.body, this.buildRuntimeOptions()), (TeaModel)new PushDocumentsResponseModel());
    }

    public RuntimeOptions buildRuntimeOptions() throws Exception {
        return RuntimeOptions.build((Map)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("connectTimeout", (Object)5000), new TeaPair("readTimeout", (Object)10000), new TeaPair("autoretry", (Object)false), new TeaPair("ignoreSSL", (Object)false), new TeaPair("maxIdleConns", (Object)50), new TeaPair("httpProxy", (Object)this._httpProxy)}));
    }
}

