/**
 * Copyright The Apache Software Foundation
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;

import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

/**
 * LayeredHTable is used to read data of layered hot/cold table.
 * when reading hot table, cold data will be filtered.
 * when reading cold table, cold data in hot table will be read and merged.
 */
@InterfaceAudience.Private
@InterfaceStability.Stable
public abstract class LayeredHTable extends HTable {
  /**
   * Creates an object to access a HBase table.
   * Used by HBase internally.  DO NOT USE. See {@link ConnectionFactory} class comment for how to
   * get a {@link Table} instance (use {@link Table} instead of {@link LayeredHTable}).
   *
   * @param connection           Connection to be used.
   * @param builder              The table builder
   * @param rpcCallerFactory     The RPC caller factory
   * @param rpcControllerFactory The RPC controller factory
   * @param pool                 ExecutorService to be used.
   */
  @InterfaceAudience.Private
  protected LayeredHTable(final ClusterConnection connection,
      final TableBuilderBase builder, final RpcRetryingCallerFactory rpcCallerFactory,
      final RpcControllerFactory rpcControllerFactory, final ExecutorService pool) {
    super(connection, builder, rpcCallerFactory, rpcControllerFactory, pool);
  }

  protected ResultScanner getRawScanner(Scan scan) throws IOException {
    return super.getScanner(scan);
  }

  protected Result rawGet(Get get, final boolean checkExistenceOnly) throws IOException {
    return super.get(get,checkExistenceOnly);
  }

  public Result[] rawGet(List<Get> gets) throws IOException {
    return super.get(gets);
  }

}
