/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

/**
 * Created by mazhenlin on 2019/1/22.
 */
@InterfaceAudience.Private
@InterfaceStability.Stable
public class RawAsyncHotTableImpl extends RawAsyncLayeredTableImpl {
  protected long hotTtl = -1;

  RawAsyncHotTableImpl(AsyncConnectionImpl conn, AsyncTableBuilderBase<?> builder, long hotTtl) {
    super(conn, builder);
    this.hotTtl = hotTtl;
  }

  @Override public ResultScanner getScanner(Scan scan) {
    Scan hotScan = null;
    try {
      hotScan = ClientUtil.removeColdDataFromScan(scan,hotTtl);
    } catch (IOException ignore) {
      /// nothing indeed thrown
    }
    return getRawScanner(hotScan);
  }

  @Override public CompletableFuture<Result> get(Get get) {
    Get hotGet = null;
    try {
      hotGet = ClientUtil.removeColdDataFromGet(get, hotTtl);
    } catch (IOException ignore) {
      /// nothing indeed thrown
    }
    return rawGet(hotGet);
  }

  @Override public List<CompletableFuture<Result>> get(List<Get> gets) {
    List<Get> hotGets = null;
    try {
      hotGets = ClientUtil.removeColdDataFromGets(gets, hotTtl);
    } catch (IOException ignore) {
      /// nothing indeed thrown
    }

    return rawGet(hotGets);
  }


}
