/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.hbase.client;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import org.apache.yetus.audience.InterfaceAudience;

/**
 * RawAsyncLayeredTableImpl is used to read data of layered hot/cold table.
 * when reading hot table, cold data will be filtered.
 * when reading cold table, cold data in hot table will be read and merged.
 */
@InterfaceAudience.Private
public abstract class RawAsyncLayeredTableImpl extends RawAsyncTableImpl {

  RawAsyncLayeredTableImpl(AsyncConnectionImpl conn, AsyncTableBuilderBase<?> builder) {
    super(conn,builder);
  }

  protected ResultScanner getRawScanner(Scan scan) {
    return super.getScanner(scan);
  }

  protected CompletableFuture<Result> rawGet(Get get) {
    return super.get(get);
  }

  public List<CompletableFuture<Result>> rawGet(List<Get> gets) {
    return super.get(gets);
  }

}
