/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.type.ArrayTypeInfo;
import com.aliyun.odps.type.MapTypeInfo;
import com.aliyun.odps.type.PrimitiveTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public final class Column {
    private String name;
    private OdpsType type;
    private TypeInfo typeInfo;
    private String comment;
    private String label;
    private List<OdpsType> genericOdpsTypeList;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    @Deprecated
    public Column(String name, OdpsType type, String comment) {
        ajc$this(name, type, comment, null, null);
        Column ajc$this;
        String string = name;
        OdpsType odpsType = type;
        String string2 = comment;
        Object[] objectArray = new Object[]{string, odpsType, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)ajc$this, (Object)ajc$this, (Object[])objectArray);
        Column.init$_aroundBody1$advice(ajc$this, string, odpsType, string2, joinPoint, OdpsDeprecatedLogger.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public Column(String name, TypeInfo typeInfo, String comment) {
        this(name, typeInfo, comment, null);
    }

    public Column(String name, TypeInfo typeInfo) {
        this(name, typeInfo, null);
    }

    Column(String name, TypeInfo typeInfo, String comment, String label) {
        this.name = name;
        this.comment = comment;
        this.typeInfo = typeInfo;
        this.label = label;
        this.type = typeInfo.getOdpsType();
        this.initGenericOdpsTypeList();
    }

    private void initGenericOdpsTypeList() {
        switch (this.type) {
            case ARRAY: {
                this.genericOdpsTypeList = new ArrayList<OdpsType>();
                this.genericOdpsTypeList.add(((ArrayTypeInfo)this.typeInfo).getElementTypeInfo().getOdpsType());
                break;
            }
            case MAP: {
                this.genericOdpsTypeList = new ArrayList<OdpsType>();
                MapTypeInfo mapTypeInfo = (MapTypeInfo)this.typeInfo;
                this.genericOdpsTypeList.add(mapTypeInfo.getKeyTypeInfo().getOdpsType());
                this.genericOdpsTypeList.add(mapTypeInfo.getValueTypeInfo().getOdpsType());
                break;
            }
        }
    }

    Column(String name, OdpsType type, String comment, String label, List<OdpsType> genericOdpsTypeList) {
        this.name = name;
        this.comment = comment;
        this.label = label;
        this.type = type;
        this.genericOdpsTypeList = genericOdpsTypeList;
        this.initTypeInfo();
    }

    public Column(String name, OdpsType type) {
        this(name, type, null);
    }

    private void initTypeInfo() {
        switch (this.type) {
            case ARRAY: {
                this.initArrayTypeInfo();
                break;
            }
            case MAP: {
                this.initMapTypeInfo();
                break;
            }
            case VARCHAR: {
                throw new IllegalArgumentException("The length of " + (Object)((Object)this.type) + " must be specified, pls use TypeInfoFactory.getVarcharTypeInfo to new Column.");
            }
            case CHAR: {
                throw new IllegalArgumentException("The length of " + (Object)((Object)this.type) + " must be specified, pls use TypeInfoFactory.getCharTypeInfo to new Column.");
            }
            default: {
                if (this.typeInfo != null) break;
                this.typeInfo = TypeInfoFactory.getPrimitiveTypeInfo(this.type);
            }
        }
    }

    private void initMapTypeInfo() {
        if (this.genericOdpsTypeList == null) {
            return;
        }
        if (this.genericOdpsTypeList.size() < 2) {
            throw new IllegalArgumentException("Error genericOdpsTypeList for Map.");
        }
        PrimitiveTypeInfo keyType = TypeInfoFactory.getPrimitiveTypeInfo(this.genericOdpsTypeList.get(0));
        PrimitiveTypeInfo valueType = TypeInfoFactory.getPrimitiveTypeInfo(this.genericOdpsTypeList.get(1));
        this.typeInfo = TypeInfoFactory.getMapTypeInfo(keyType, valueType);
    }

    private void initArrayTypeInfo() {
        if (this.genericOdpsTypeList == null) {
            return;
        }
        if (this.genericOdpsTypeList.size() < 1) {
            throw new IllegalArgumentException("Error genericOdpsTypeList for Array.");
        }
        PrimitiveTypeInfo valueType = TypeInfoFactory.getPrimitiveTypeInfo(this.genericOdpsTypeList.get(0));
        this.typeInfo = TypeInfoFactory.getArrayTypeInfo(valueType);
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public OdpsType getType() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        return (OdpsType)((Object)Column.getType_aroundBody3$advice(this, joinPoint, OdpsDeprecatedLogger.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    public TypeInfo getTypeInfo() {
        if (this.typeInfo == null) {
            throw new IllegalArgumentException("Failed to get TypeInfo for " + this.type.toString() + ", please set generic type list first.");
        }
        return this.typeInfo;
    }

    public String getComment() {
        return this.comment;
    }

    @Deprecated
    public Long getLabel() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        return (Long)Column.getLabel_aroundBody5$advice(this, joinPoint, OdpsDeprecatedLogger.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public String getCategoryLabel() {
        return this.label;
    }

    public List<OdpsType> getGenericTypeList() {
        return this.genericOdpsTypeList;
    }

    public void setGenericTypeList(List<OdpsType> genericOdpsTypeList) {
        this.genericOdpsTypeList = genericOdpsTypeList;
        this.initTypeInfo();
    }

    static {
        Column.ajc$preClinit();
    }

    private static /* synthetic */ void init$_aroundBody0(Column ajc$this, String name, OdpsType type, String comment, JoinPoint joinPoint) {
    }

    private static /* synthetic */ Object init$_aroundBody1$advice(Column ajc$this, String name, OdpsType type, String comment, JoinPoint thisJoinPoint, OdpsDeprecatedLogger ajc$aspectInstance, ProceedingJoinPoint point) {
        try {
            String methodSignature = point.getSignature().toString();
            Long calledTimes = OdpsDeprecatedLogger.getDeprecatedCalls().get(methodSignature);
            calledTimes = calledTimes == null ? Long.valueOf(1L) : Long.valueOf(calledTimes + 1L);
            OdpsDeprecatedLogger.getDeprecatedCalls().put(methodSignature, calledTimes);
        }
        catch (Throwable e) {
            // empty catch block
        }
        ProceedingJoinPoint proceedingJoinPoint = point;
        Column.init$_aroundBody0(ajc$this, name, type, comment, (JoinPoint)proceedingJoinPoint);
        return null;
    }

    private static /* synthetic */ Object getType_aroundBody3$advice(Column ajc$this, JoinPoint thisJoinPoint, OdpsDeprecatedLogger ajc$aspectInstance, ProceedingJoinPoint point) {
        try {
            String methodSignature = point.getSignature().toString();
            Long calledTimes = OdpsDeprecatedLogger.getDeprecatedCalls().get(methodSignature);
            calledTimes = calledTimes == null ? Long.valueOf(1L) : Long.valueOf(calledTimes + 1L);
            OdpsDeprecatedLogger.getDeprecatedCalls().put(methodSignature, calledTimes);
        }
        catch (Throwable e) {
            // empty catch block
        }
        ProceedingJoinPoint proceedingJoinPoint = point;
        return ajc$this.type;
    }

    private static /* synthetic */ Long getLabel_aroundBody4(Column ajc$this, JoinPoint joinPoint) {
        if (ajc$this.label == null) {
            return null;
        }
        try {
            return Long.parseLong(ajc$this.label);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private static /* synthetic */ Object getLabel_aroundBody5$advice(Column ajc$this, JoinPoint thisJoinPoint, OdpsDeprecatedLogger ajc$aspectInstance, ProceedingJoinPoint point) {
        try {
            String methodSignature = point.getSignature().toString();
            Long calledTimes = OdpsDeprecatedLogger.getDeprecatedCalls().get(methodSignature);
            calledTimes = calledTimes == null ? Long.valueOf(1L) : Long.valueOf(calledTimes + 1L);
            OdpsDeprecatedLogger.getDeprecatedCalls().put(methodSignature, calledTimes);
        }
        catch (Throwable e) {
            // empty catch block
        }
        ProceedingJoinPoint proceedingJoinPoint = point;
        return Column.getLabel_aroundBody4(ajc$this, (JoinPoint)proceedingJoinPoint);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Column.java", Column.class);
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "com.aliyun.odps.Column", "java.lang.String:com.aliyun.odps.OdpsType:java.lang.String", "name:type:comment", ""), 55);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getType", "com.aliyun.odps.Column", "", "", "", "com.aliyun.odps.OdpsType"), 193);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLabel", "com.aliyun.odps.Column", "", "", "", "java.lang.Long"), 228);
    }
}

