/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.conf;

import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.Survey;
import com.aliyun.odps.io.Writable;
import com.aliyun.odps.io.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class Configuration
implements Iterable<Map.Entry<String, String>>,
Writable {
    private static final Log LOG;
    private boolean quietmode = true;
    private ArrayList<Object> resources = new ArrayList();
    private Set<String> finalParameters = new HashSet<String>();
    private boolean loadDefaults = true;
    private static final WeakHashMap<Configuration, Object> REGISTRY;
    private static final CopyOnWriteArrayList<String> defaultResources;
    private Properties properties;
    private Properties overlay;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private static Pattern varPat;
    private static int MAX_SUBST;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public Configuration() {
        this(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration(boolean loadDefaults) {
        if (this.classLoader == null) {
            this.classLoader = Configuration.class.getClassLoader();
        }
        this.loadDefaults = loadDefaults;
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            REGISTRY.put(this, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration(Configuration other) {
        if (this.classLoader == null) {
            this.classLoader = Configuration.class.getClassLoader();
        }
        this.resources = (ArrayList)other.resources.clone();
        Object object = other;
        synchronized (object) {
            if (other.properties != null) {
                this.properties = (Properties)other.properties.clone();
            }
            if (other.overlay != null) {
                this.overlay = (Properties)other.overlay.clone();
            }
        }
        this.finalParameters = new HashSet<String>(other.finalParameters);
        object = Configuration.class;
        synchronized (Configuration.class) {
            REGISTRY.put(this, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void checkState(String name) {
    }

    public static synchronized void addDefaultResource(String name) {
        if (!defaultResources.contains(name)) {
            defaultResources.add(name);
            for (Configuration conf : REGISTRY.keySet()) {
                if (!conf.loadDefaults) continue;
                conf.reloadConfiguration();
            }
        }
    }

    @Survey
    public void addResource(String name) {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Configuration.addResource_aroundBody1$advice(this, string, joinPoint, OdpsDeprecatedLogger.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @Survey
    public void addResource(URL url) {
        URL uRL = url;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)uRL);
        Configuration.addResource_aroundBody3$advice(this, uRL, joinPoint, OdpsDeprecatedLogger.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @Survey
    public void addResource(InputStream in) {
        InputStream inputStream = in;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)inputStream);
        Configuration.addResource_aroundBody5$advice(this, inputStream, joinPoint, OdpsDeprecatedLogger.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public synchronized void reloadConfiguration() {
        this.properties = null;
        this.finalParameters.clear();
    }

    private synchronized void addResourceObject(Object resource) {
        this.resources.add(resource);
        this.reloadConfiguration();
    }

    private String substituteVars(String expr) {
        if (expr == null) {
            return null;
        }
        Matcher match = varPat.matcher("");
        String eval = expr;
        for (int s = 0; s < MAX_SUBST; ++s) {
            match.reset(eval);
            if (!match.find()) {
                return eval;
            }
            String var = match.group();
            var = var.substring(2, var.length() - 1);
            String val = null;
            try {
                val = System.getProperty(var);
            }
            catch (SecurityException se) {
                LOG.warn((Object)("No permission to get system property: " + var));
            }
            if (val == null) {
                val = this.getRaw(var);
            }
            if (val == null) {
                return eval;
            }
            eval = eval.substring(0, match.start()) + val + eval.substring(match.end());
        }
        throw new IllegalStateException("Variable substitution depth too large: " + MAX_SUBST + " " + expr);
    }

    public String get(String name) {
        return this.substituteVars(this.getProps().getProperty(name));
    }

    public String getRaw(String name) {
        return this.getProps().getProperty(name);
    }

    public void set(String name, String value) {
        this.checkState(name);
        this.getOverlay().setProperty(name, value);
        this.getProps().setProperty(name, value);
    }

    public void setIfUnset(String name, String value) {
        if (this.get(name) == null) {
            this.set(name, value);
        }
    }

    private synchronized Properties getOverlay() {
        if (this.overlay == null) {
            this.overlay = new Properties();
        }
        return this.overlay;
    }

    public String get(String name, String defaultValue) {
        return this.substituteVars(this.getProps().getProperty(name, defaultValue));
    }

    public int getInt(String name, int defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            String hexString = this.getHexDigits(valueString);
            if (hexString != null) {
                return Integer.parseInt(hexString, 16);
            }
            return Integer.parseInt(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public void setInt(String name, int value) {
        this.set(name, Integer.toString(value));
    }

    public long getLong(String name, long defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            String hexString = this.getHexDigits(valueString);
            if (hexString != null) {
                return Long.parseLong(hexString, 16);
            }
            return Long.parseLong(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private String getHexDigits(String value) {
        boolean negative = false;
        String str = value;
        String hexString = null;
        if (value.startsWith("-")) {
            negative = true;
            str = value.substring(1);
        }
        if (str.startsWith("0x") || str.startsWith("0X")) {
            hexString = str.substring(2);
            if (negative) {
                hexString = "-" + hexString;
            }
            return hexString;
        }
        return null;
    }

    public void setLong(String name, long value) {
        this.set(name, Long.toString(value));
    }

    public float getFloat(String name, float defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public void setFloat(String name, float value) {
        this.set(name, Float.toString(value));
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String valueString = this.get(name);
        if ("true".equals(valueString)) {
            return true;
        }
        if ("false".equals(valueString)) {
            return false;
        }
        return defaultValue;
    }

    public void setBoolean(String name, boolean value) {
        this.set(name, Boolean.toString(value));
    }

    public void setBooleanIfUnset(String name, boolean value) {
        this.setIfUnset(name, Boolean.toString(value));
    }

    public IntegerRanges getRange(String name, String defaultValue) {
        return new IntegerRanges(this.get(name, defaultValue));
    }

    public Collection<String> getStringCollection(String name) {
        String valueString = this.get(name);
        return StringUtils.getStringCollection(valueString);
    }

    public String[] getStrings(String name) {
        String valueString = this.get(name);
        return StringUtils.getStrings(valueString);
    }

    public String[] getStrings(String name, String ... defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        return StringUtils.getStrings(valueString);
    }

    public void setStrings(String name, String ... values) {
        this.set(name, StringUtils.arrayToString(values));
    }

    public Class<?> getClassByName(String name) throws ClassNotFoundException {
        return Class.forName(name, false, this.classLoader);
    }

    public Class<?>[] getClasses(String name, Class<?> ... defaultValue) {
        String[] classnames = this.getStrings(name);
        if (classnames == null) {
            return defaultValue;
        }
        try {
            Class[] classes = new Class[classnames.length];
            for (int i = 0; i < classnames.length; ++i) {
                classes[i] = this.getClassByName(classnames[i]);
            }
            return classes;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<?> getClass(String name, Class<?> defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return this.getClassByName(valueString);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("ODPS-0730001: ClassNotFoundException - " + e.getMessage());
        }
    }

    public <U> Class<? extends U> getClass(String name, Class<? extends U> defaultValue, Class<U> xface) {
        try {
            Class<?> theClass = this.getClass(name, defaultValue);
            if (theClass != null && !xface.isAssignableFrom(theClass)) {
                throw new RuntimeException(theClass + " not " + xface.getName());
            }
            if (theClass != null) {
                return theClass.asSubclass(xface);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setClass(String name, Class<?> theClass, Class<?> xface) {
        if (!xface.isAssignableFrom(theClass)) {
            throw new RuntimeException(theClass + " not " + xface.getName());
        }
        this.set(name, theClass.getName());
    }

    public File getFile(String dirsProp, String path) throws IOException {
        String[] dirs = this.getStrings(dirsProp);
        int hashCode = path.hashCode();
        for (int i = 0; i < dirs.length; ++i) {
            int index = (hashCode + i & Integer.MAX_VALUE) % dirs.length;
            File file = new File(dirs[index], path);
            File dir = file.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) continue;
            return file;
        }
        throw new IOException("No valid local directories in property: " + dirsProp);
    }

    public URL getResource(String name) {
        return this.classLoader.getResource(name);
    }

    public InputStream getConfResourceAsInputStream(String name) {
        try {
            URL url = this.getResource(name);
            if (url == null) {
                LOG.info((Object)(name + " not found"));
                return null;
            }
            LOG.info((Object)("found resource " + name + " at " + url));
            return url.openStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Reader getConfResourceAsReader(String name) {
        try {
            URL url = this.getResource(name);
            if (url == null) {
                LOG.info((Object)(name + " not found"));
                return null;
            }
            LOG.info((Object)("found resource " + name + " at " + url));
            return new InputStreamReader(url.openStream());
        }
        catch (Exception e) {
            return null;
        }
    }

    private synchronized Properties getProps() {
        if (this.properties == null) {
            this.properties = new Properties();
            this.loadResources(this.properties, this.resources, this.quietmode);
            if (this.overlay != null) {
                this.properties.putAll((Map<?, ?>)this.overlay);
            }
        }
        return this.properties;
    }

    public int size() {
        return this.getProps().size();
    }

    public void clear() {
        this.getProps().clear();
        this.getOverlay().clear();
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<Object, Object> item : this.getProps().entrySet()) {
            if (!(item.getKey() instanceof String) || !(item.getValue() instanceof String)) continue;
            result.put((String)item.getKey(), (String)item.getValue());
        }
        return result.entrySet().iterator();
    }

    private void loadResources(Properties properties, ArrayList resources, boolean quiet) {
        if (this.loadDefaults) {
            for (String resource : defaultResources) {
                this.loadResource(properties, resource, quiet);
            }
        }
        for (String resource : resources) {
            this.loadResource(properties, resource, quiet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResource(Properties properties, Object name, boolean quiet) {
        try {
            URL url;
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setIgnoringComments(true);
            docBuilderFactory.setNamespaceAware(true);
            try {
                docBuilderFactory.setXIncludeAware(true);
            }
            catch (UnsupportedOperationException e) {
                LOG.error((Object)("Failed to set setXIncludeAware(true) for parser " + docBuilderFactory + ":" + e), (Throwable)e);
            }
            DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
            Document doc = null;
            Element root = null;
            if (name instanceof URL) {
                url = (URL)name;
                if (url != null) {
                    if (!quiet) {
                        LOG.info((Object)("parsing " + url));
                    }
                    doc = builder.parse(url.toString());
                }
            } else if (name instanceof String) {
                url = this.getResource((String)name);
                if (url != null) {
                    if (!quiet) {
                        LOG.info((Object)("parsing " + url));
                    }
                    doc = builder.parse(url.toString());
                }
            } else if (name instanceof InputStream) {
                try {
                    doc = builder.parse((InputStream)name);
                }
                finally {
                    ((InputStream)name).close();
                }
            } else if (name instanceof Element) {
                root = (Element)name;
            }
            if (doc == null && root == null) {
                if (quiet) {
                    return;
                }
                throw new RuntimeException(name + " not found");
            }
            if (root == null) {
                root = doc.getDocumentElement();
            }
            if (!"configuration".equals(root.getTagName())) {
                LOG.fatal((Object)"bad conf file: top-level element not <configuration>");
            }
            NodeList props = root.getChildNodes();
            for (int i = 0; i < props.getLength(); ++i) {
                Node propNode = props.item(i);
                if (!(propNode instanceof Element)) continue;
                Element prop = (Element)propNode;
                if ("configuration".equals(prop.getTagName())) {
                    this.loadResource(properties, prop, quiet);
                    continue;
                }
                if (!"property".equals(prop.getTagName())) {
                    LOG.warn((Object)"bad conf file: element not <property>");
                }
                NodeList fields = prop.getChildNodes();
                String attr = null;
                String value = null;
                boolean finalParameter = false;
                for (int j = 0; j < fields.getLength(); ++j) {
                    Node fieldNode = fields.item(j);
                    if (!(fieldNode instanceof Element)) continue;
                    Element field = (Element)fieldNode;
                    if ("name".equals(field.getTagName()) && field.hasChildNodes()) {
                        attr = ((Text)field.getFirstChild()).getData().trim();
                    }
                    if ("value".equals(field.getTagName()) && field.hasChildNodes()) {
                        value = ((Text)field.getFirstChild()).getData();
                    }
                    if (!"final".equals(field.getTagName()) || !field.hasChildNodes()) continue;
                    finalParameter = "true".equals(((Text)field.getFirstChild()).getData());
                }
                if (attr == null || value == null) continue;
                if (!this.finalParameters.contains(attr)) {
                    properties.setProperty(attr, value);
                    if (!finalParameter) continue;
                    this.finalParameters.add(attr);
                    continue;
                }
                LOG.warn((Object)(name + ":a attempt to override final parameter: " + attr + ";  Ignoring."));
            }
        }
        catch (IOException e) {
            LOG.fatal((Object)("error parsing conf file: " + e));
            throw new RuntimeException(e);
        }
        catch (DOMException e) {
            LOG.fatal((Object)("error parsing conf file: " + e));
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            LOG.fatal((Object)("error parsing conf file: " + e));
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            LOG.fatal((Object)("error parsing conf file: " + e));
            throw new RuntimeException(e);
        }
    }

    public void writeXml(OutputStream out) throws IOException {
        Properties properties = this.getProps();
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element conf = doc.createElement("configuration");
            doc.appendChild(conf);
            conf.appendChild(doc.createTextNode("\n"));
            Enumeration<Object> e = properties.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Object object = properties.get(name);
                String value = null;
                if (!(object instanceof String)) continue;
                value = (String)object;
                Element propNode = doc.createElement("property");
                conf.appendChild(propNode);
                Element nameNode = doc.createElement("name");
                nameNode.appendChild(doc.createTextNode(name));
                propNode.appendChild(nameNode);
                Element valueNode = doc.createElement("value");
                valueNode.appendChild(doc.createTextNode(value));
                propNode.appendChild(valueNode);
                conf.appendChild(doc.createTextNode("\n"));
            }
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(out);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Configuration: ");
        if (this.loadDefaults) {
            this.toString(defaultResources, sb);
            if (this.resources.size() > 0) {
                sb.append(", ");
            }
        }
        this.toString(this.resources, sb);
        return sb.toString();
    }

    private void toString(List resources, StringBuffer sb) {
        ListIterator i = resources.listIterator();
        while (i.hasNext()) {
            if (i.nextIndex() != 0) {
                sb.append(", ");
            }
            sb.append(i.next());
        }
    }

    public synchronized void setQuietMode(boolean quietmode) {
        this.quietmode = quietmode;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.clear();
        int size = WritableUtils.readVInt(in);
        for (int i = 0; i < size; ++i) {
            this.set(com.aliyun.odps.io.Text.readString(in), com.aliyun.odps.io.Text.readString(in));
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Properties props = this.getProps();
        WritableUtils.writeVInt(out, props.size());
        for (Map.Entry<Object, Object> item : props.entrySet()) {
            com.aliyun.odps.io.Text.writeString(out, (String)item.getKey());
            com.aliyun.odps.io.Text.writeString(out, (String)item.getValue());
        }
    }

    static {
        Configuration.ajc$preClinit();
        LOG = LogFactory.getLog(Configuration.class);
        REGISTRY = new WeakHashMap();
        defaultResources = new CopyOnWriteArrayList();
        varPat = Pattern.compile("\\$\\{[^\\}\\$ ]+\\}");
        MAX_SUBST = 20;
    }

    private static /* synthetic */ Object addResource_aroundBody1$advice(Configuration ajc$this, String name, JoinPoint thisJoinPoint, OdpsDeprecatedLogger ajc$aspectInstance, ProceedingJoinPoint point) {
        try {
            String callerClass = Thread.currentThread().getStackTrace()[3].getClassName();
            if (!callerClass.startsWith("com.aliyun.odps.")) {
                String methodSignature = point.getSignature().toString();
                Long calledTimes = OdpsDeprecatedLogger.getDeprecatedCalls().get(methodSignature);
                calledTimes = calledTimes == null ? Long.valueOf(1L) : Long.valueOf(calledTimes + 1L);
                OdpsDeprecatedLogger.getDeprecatedCalls().put(methodSignature, calledTimes);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        ProceedingJoinPoint proceedingJoinPoint = point;
        ajc$this.addResourceObject(name);
        return null;
    }

    private static /* synthetic */ Object addResource_aroundBody3$advice(Configuration ajc$this, URL url, JoinPoint thisJoinPoint, OdpsDeprecatedLogger ajc$aspectInstance, ProceedingJoinPoint point) {
        try {
            String callerClass = Thread.currentThread().getStackTrace()[3].getClassName();
            if (!callerClass.startsWith("com.aliyun.odps.")) {
                String methodSignature = point.getSignature().toString();
                Long calledTimes = OdpsDeprecatedLogger.getDeprecatedCalls().get(methodSignature);
                calledTimes = calledTimes == null ? Long.valueOf(1L) : Long.valueOf(calledTimes + 1L);
                OdpsDeprecatedLogger.getDeprecatedCalls().put(methodSignature, calledTimes);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        ProceedingJoinPoint proceedingJoinPoint = point;
        ajc$this.addResourceObject(url);
        return null;
    }

    private static /* synthetic */ Object addResource_aroundBody5$advice(Configuration ajc$this, InputStream in, JoinPoint thisJoinPoint, OdpsDeprecatedLogger ajc$aspectInstance, ProceedingJoinPoint point) {
        try {
            String callerClass = Thread.currentThread().getStackTrace()[3].getClassName();
            if (!callerClass.startsWith("com.aliyun.odps.")) {
                String methodSignature = point.getSignature().toString();
                Long calledTimes = OdpsDeprecatedLogger.getDeprecatedCalls().get(methodSignature);
                calledTimes = calledTimes == null ? Long.valueOf(1L) : Long.valueOf(calledTimes + 1L);
                OdpsDeprecatedLogger.getDeprecatedCalls().put(methodSignature, calledTimes);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        ProceedingJoinPoint proceedingJoinPoint = point;
        ajc$this.addResourceObject(in);
        return null;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Configuration.java", Configuration.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addResource", "com.aliyun.odps.conf.Configuration", "java.lang.String", "name", "", "void"), 288);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addResource", "com.aliyun.odps.conf.Configuration", "java.net.URL", "url", "", "void"), 301);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addResource", "com.aliyun.odps.conf.Configuration", "java.io.InputStream", "in", "", "void"), 315);
    }

    static class IntegerRanges {
        List<Range> ranges = new ArrayList<Range>();

        public IntegerRanges() {
        }

        public IntegerRanges(String newValue) {
            StringTokenizer itr = new StringTokenizer(newValue, ",");
            while (itr.hasMoreTokens()) {
                String rng = itr.nextToken().trim();
                String[] parts = rng.split("-", 3);
                if (parts.length < 1 || parts.length > 2) {
                    throw new IllegalArgumentException("integer range badly formed: " + rng);
                }
                Range r = new Range();
                r.start = IntegerRanges.convertToInt(parts[0], 0);
                r.end = parts.length == 2 ? IntegerRanges.convertToInt(parts[1], Integer.MAX_VALUE) : r.start;
                if (r.start > r.end) {
                    throw new IllegalArgumentException("IntegerRange from " + r.start + " to " + r.end + " is invalid");
                }
                this.ranges.add(r);
            }
        }

        private static int convertToInt(String value, int defaultValue) {
            String trim = value.trim();
            if (trim.length() == 0) {
                return defaultValue;
            }
            return Integer.parseInt(trim);
        }

        public boolean isIncluded(int value) {
            for (Range r : this.ranges) {
                if (r.start > value || value > r.end) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            boolean first = true;
            for (Range r : this.ranges) {
                if (first) {
                    first = false;
                } else {
                    result.append(',');
                }
                result.append(r.start);
                result.append('-');
                result.append(r.end);
            }
            return result.toString();
        }

        private static class Range {
            int start;
            int end;

            private Range() {
            }
        }
    }

    static class StringUtils {
        StringUtils() {
        }

        static Collection<String> getStringCollection(String str) {
            ArrayList<String> values = new ArrayList<String>();
            if (str == null) {
                return values;
            }
            StringTokenizer tokenizer = new StringTokenizer(str, ",");
            values = new ArrayList();
            while (tokenizer.hasMoreTokens()) {
                values.add(tokenizer.nextToken());
            }
            return values;
        }

        public static String[] getStrings(String str) {
            Collection<String> values = StringUtils.getStringCollection(str);
            if (values.size() == 0) {
                return null;
            }
            return values.toArray(new String[values.size()]);
        }

        public static String arrayToString(String[] strs) {
            if (strs.length == 0) {
                return "";
            }
            StringBuffer sbuf = new StringBuffer();
            sbuf.append(strs[0]);
            for (int idx = 1; idx < strs.length; ++idx) {
                sbuf.append(",");
                sbuf.append(strs[idx]);
            }
            return sbuf.toString();
        }
    }
}

