/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.data;

import com.aliyun.odps.OdpsType;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Binary;
import com.aliyun.odps.data.Char;
import com.aliyun.odps.data.IntervalDayTime;
import com.aliyun.odps.data.IntervalYearMonth;
import com.aliyun.odps.data.SimpleStruct;
import com.aliyun.odps.data.Struct;
import com.aliyun.odps.data.Varchar;
import com.aliyun.odps.type.ArrayTypeInfo;
import com.aliyun.odps.type.CharTypeInfo;
import com.aliyun.odps.type.DecimalTypeInfo;
import com.aliyun.odps.type.MapTypeInfo;
import com.aliyun.odps.type.StructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.VarcharTypeInfo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OdpsTypeTransformer {
    private static Map<OdpsType, Class> ODPS_TYPE_MAPPER = new HashMap<OdpsType, Class>();

    OdpsTypeTransformer() {
    }

    public static Class odpsTypeToJavaType(OdpsType type) {
        if (ODPS_TYPE_MAPPER.containsKey((Object)type)) {
            return ODPS_TYPE_MAPPER.get((Object)type);
        }
        throw new IllegalArgumentException("Cannot get Java type for Odps type: " + (Object)((Object)type));
    }

    private static void validateChar(Char value, CharTypeInfo typeInfo) {
        if (value.length() > typeInfo.getLength()) {
            throw new IllegalArgumentException(String.format("InvalidData: %s data is overflow, pls check data length: %s.", typeInfo.getTypeName(), value.length()));
        }
    }

    private static void validateVarChar(Varchar value, VarcharTypeInfo typeInfo) {
        if (value.length() > typeInfo.getLength()) {
            throw new IllegalArgumentException(String.format("InvalidData: %s data is overflow, pls check data length: %s.", typeInfo.getTypeName(), value.length()));
        }
    }

    private static void validateBigint(Long value) {
        if (value == Long.MIN_VALUE) {
            throw new IllegalArgumentException("InvalidData: Bigint out of range.");
        }
    }

    private static void validateDecimal(BigDecimal value, DecimalTypeInfo typeInfo) {
        BigDecimal tmpValue = value.setScale(typeInfo.getScale(), RoundingMode.HALF_UP);
        int intLength = tmpValue.precision() - tmpValue.scale();
        if (intLength > typeInfo.getPrecision() - typeInfo.getScale()) {
            throw new IllegalArgumentException(String.format("InvalidData: decimal value %s overflow, max integer digit number is %s.", value, typeInfo.getPrecision() - typeInfo.getScale()));
        }
    }

    private static List transformArray(List value, ArrayTypeInfo typeInfo) {
        ArrayList<Object> newList = new ArrayList<Object>(value.size());
        TypeInfo elementTypeInfo = typeInfo.getElementTypeInfo();
        for (Object obj : value) {
            newList.add(OdpsTypeTransformer.transform(obj, elementTypeInfo));
        }
        return newList;
    }

    private static Map transformMap(Map value, MapTypeInfo typeInfo) {
        TypeInfo keyTypeInfo = typeInfo.getKeyTypeInfo();
        TypeInfo valTypeInfo = typeInfo.getValueTypeInfo();
        HashMap<Object, Object> newMap = new HashMap<Object, Object>(value.size(), 1.0f);
        for (Map.Entry entry : value.entrySet()) {
            Object entryKey = OdpsTypeTransformer.transform(entry.getKey(), keyTypeInfo);
            Object entryValue = OdpsTypeTransformer.transform(entry.getValue(), valTypeInfo);
            newMap.put(entryKey, entryValue);
        }
        return newMap;
    }

    private static Struct transformStruct(Struct value, StructTypeInfo typeInfo) {
        ArrayList<Object> elements = new ArrayList<Object>();
        for (int i = 0; i < typeInfo.getFieldCount(); ++i) {
            TypeInfo fieldTypeInfo = value.getFieldTypeInfo(i);
            elements.add(OdpsTypeTransformer.transform(value.getFieldValue(i), fieldTypeInfo));
        }
        return new SimpleStruct(typeInfo, elements);
    }

    static Object transform(Object value, TypeInfo typeInfo) {
        if (value == null) {
            return null;
        }
        switch (typeInfo.getOdpsType()) {
            case STRING: {
                if (!(value instanceof byte[])) break;
                value = ArrayRecord.bytesToString((byte[])value);
                break;
            }
            case BIGINT: {
                OdpsTypeTransformer.validateBigint((Long)value);
                break;
            }
            case DECIMAL: {
                OdpsTypeTransformer.validateDecimal((BigDecimal)value, (DecimalTypeInfo)typeInfo);
                break;
            }
            case CHAR: {
                OdpsTypeTransformer.validateChar((Char)value, (CharTypeInfo)typeInfo);
                break;
            }
            case VARCHAR: {
                OdpsTypeTransformer.validateVarChar((Varchar)value, (VarcharTypeInfo)typeInfo);
                break;
            }
            case ARRAY: {
                return OdpsTypeTransformer.transformArray((List)value, (ArrayTypeInfo)typeInfo);
            }
            case MAP: {
                return OdpsTypeTransformer.transformMap((Map)value, (MapTypeInfo)typeInfo);
            }
            case STRUCT: {
                return OdpsTypeTransformer.transformStruct((Struct)value, (StructTypeInfo)typeInfo);
            }
        }
        return OdpsTypeTransformer.odpsTypeToJavaType(typeInfo.getOdpsType()).cast(value);
    }

    static {
        ODPS_TYPE_MAPPER.put(OdpsType.BIGINT, Long.class);
        ODPS_TYPE_MAPPER.put(OdpsType.STRING, String.class);
        ODPS_TYPE_MAPPER.put(OdpsType.DATETIME, java.util.Date.class);
        ODPS_TYPE_MAPPER.put(OdpsType.DOUBLE, Double.class);
        ODPS_TYPE_MAPPER.put(OdpsType.BOOLEAN, Boolean.class);
        ODPS_TYPE_MAPPER.put(OdpsType.DECIMAL, BigDecimal.class);
        ODPS_TYPE_MAPPER.put(OdpsType.ARRAY, List.class);
        ODPS_TYPE_MAPPER.put(OdpsType.MAP, Map.class);
        ODPS_TYPE_MAPPER.put(OdpsType.STRUCT, Struct.class);
        ODPS_TYPE_MAPPER.put(OdpsType.INT, Integer.class);
        ODPS_TYPE_MAPPER.put(OdpsType.TINYINT, Byte.class);
        ODPS_TYPE_MAPPER.put(OdpsType.SMALLINT, Short.class);
        ODPS_TYPE_MAPPER.put(OdpsType.DATE, Date.class);
        ODPS_TYPE_MAPPER.put(OdpsType.TIMESTAMP, Timestamp.class);
        ODPS_TYPE_MAPPER.put(OdpsType.FLOAT, Float.class);
        ODPS_TYPE_MAPPER.put(OdpsType.CHAR, Char.class);
        ODPS_TYPE_MAPPER.put(OdpsType.BINARY, Binary.class);
        ODPS_TYPE_MAPPER.put(OdpsType.VARCHAR, Varchar.class);
        ODPS_TYPE_MAPPER.put(OdpsType.INTERVAL_YEAR_MONTH, IntervalYearMonth.class);
        ODPS_TYPE_MAPPER.put(OdpsType.INTERVAL_DAY_TIME, IntervalDayTime.class);
    }
}

