/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Column;
import com.aliyun.odps.type.TypeInfoFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TableSchema {
    private ArrayList<Column> columns = new ArrayList();
    private ArrayList<Column> partitionColumns = new ArrayList();
    private HashMap<String, Integer> nameMap = new HashMap();
    private HashMap<String, Integer> partitionNameMap = new HashMap();

    public static Builder builder() {
        return new Builder();
    }

    public void addColumn(Column c) {
        if (c == null) {
            throw new IllegalArgumentException("Column is null.");
        }
        if (this.nameMap.containsKey(c.getName()) || this.partitionNameMap.containsKey(c.getName())) {
            throw new IllegalArgumentException("Column " + c.getName() + " duplicated.");
        }
        this.nameMap.put(c.getName(), this.columns.size());
        this.columns.add(c);
    }

    public void addPartitionColumn(Column c) {
        if (c == null) {
            throw new IllegalArgumentException("Column is null.");
        }
        if (this.nameMap.containsKey(c.getName()) || this.partitionNameMap.containsKey(c.getName())) {
            throw new IllegalArgumentException("Column " + c.getName() + " duplicated.");
        }
        this.partitionNameMap.put(c.getName(), this.partitionColumns.size());
        this.partitionColumns.add(c);
    }

    public Column getColumn(int idx) {
        if (idx < 0 || idx >= this.columns.size()) {
            throw new IllegalArgumentException("idx out of range");
        }
        return this.columns.get(idx);
    }

    public int getColumnIndex(String name) {
        Integer idx = this.nameMap.get(name);
        if (idx == null) {
            throw new IllegalArgumentException("No such column:" + name);
        }
        return idx;
    }

    public Column getColumn(String name) {
        return this.columns.get(this.getColumnIndex(name));
    }

    public void setColumns(List<Column> columns) {
        this.nameMap.clear();
        this.columns.clear();
        for (Column column : columns) {
            this.addColumn(column);
        }
    }

    public List<Column> getColumns() {
        return (List)this.columns.clone();
    }

    public void setPartitionColumns(ArrayList<Column> partitionColumns) {
        this.partitionNameMap.clear();
        this.partitionColumns.clear();
        for (Column column : partitionColumns) {
            this.addPartitionColumn(column);
        }
    }

    public List<Column> getPartitionColumns() {
        return (List)this.partitionColumns.clone();
    }

    public List<Column> getAllColumns() {
        List<Column> allColumns = this.getColumns();
        allColumns.addAll(this.partitionColumns);
        return allColumns;
    }

    public Column getPartitionColumn(String name) {
        return this.partitionColumns.get(this.getPartitionColumnIndex(name));
    }

    public int getPartitionColumnIndex(String name) {
        return this.partitionNameMap.get(name);
    }

    public boolean containsColumn(String name) {
        return this.nameMap.containsKey(name);
    }

    public boolean containsPartitionColumn(String name) {
        return this.partitionNameMap.containsKey(name);
    }

    public Column getPartitionColumn(int idx) {
        if (idx < 0 || idx >= this.partitionColumns.size()) {
            throw new IllegalArgumentException("idx out of range");
        }
        return this.partitionColumns.get(idx);
    }

    public boolean basicallyEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableSchema that = (TableSchema)o;
        List<Column> columnsA = this.getAllColumns();
        List<Column> columnsB = that.getAllColumns();
        if (columnsA.size() != columnsB.size()) {
            return false;
        }
        for (int i = 0; i < columnsA.size(); ++i) {
            Column columnA = columnsA.get(i);
            Column columnB = columnsB.get(i);
            if (columnA.getName().equals(columnB.getName()) && columnA.getTypeInfo().getTypeName().equals(columnB.getTypeInfo().getTypeName())) continue;
            return false;
        }
        return true;
    }

    public static class Builder {
        private final TableSchema schema = new TableSchema();

        public Builder withColumns(List<Column> columns) {
            for (Column column : columns) {
                this.withColumn(column);
            }
            return this;
        }

        public Builder withColumn(Column column) {
            this.schema.addColumn(column);
            return this;
        }

        public Builder withPartitionColumn(Column column) {
            this.schema.addPartitionColumn(column);
            return this;
        }

        public Builder withBigintColumn(String columnName) {
            this.schema.addColumn(new Column(columnName, TypeInfoFactory.BIGINT));
            return this;
        }

        public Builder withStringColumn(String columnName) {
            this.schema.addColumn(new Column(columnName, TypeInfoFactory.STRING));
            return this;
        }

        public Builder withDoubleColumn(String columnName) {
            this.schema.addColumn(new Column(columnName, TypeInfoFactory.DOUBLE));
            return this;
        }

        public Builder withDecimalColumn(String columnName) {
            this.schema.addColumn(new Column(columnName, TypeInfoFactory.DECIMAL));
            return this;
        }

        public Builder withDatetimeColumn(String columnName) {
            this.schema.addColumn(new Column(columnName, TypeInfoFactory.DATETIME));
            return this;
        }

        public Builder withBooleanColumn(String columnName) {
            this.schema.addColumn(new Column(columnName, TypeInfoFactory.BOOLEAN));
            return this;
        }

        public TableSchema build() {
            return this.schema;
        }
    }
}

