/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.data;

import com.aliyun.odps.OdpsType;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Binary;
import com.aliyun.odps.data.Char;
import com.aliyun.odps.data.IntervalDayTime;
import com.aliyun.odps.data.IntervalYearMonth;
import com.aliyun.odps.data.JsonValue;
import com.aliyun.odps.data.SimpleStruct;
import com.aliyun.odps.data.Struct;
import com.aliyun.odps.data.Varchar;
import com.aliyun.odps.type.ArrayTypeInfo;
import com.aliyun.odps.type.CharTypeInfo;
import com.aliyun.odps.type.DecimalTypeInfo;
import com.aliyun.odps.type.MapTypeInfo;
import com.aliyun.odps.type.StructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.VarcharTypeInfo;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.chrono.IsoChronology;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OdpsTypeTransformer {
    private static final int UTF8_ENCODED_CHAR_MAX_SIZE = 6;
    private static final long DATETIME_MAX_TICKS = 253402387200000L;
    private static final long DATETIME_MIN_TICKS = -62167305600000L;
    public static final Map<OdpsType, Class> ODPS_TYPE_MAPPER = new HashMap<OdpsType, Class>();
    public static final Map<OdpsType, Class> ODPS_TYPE_MAPPER_V2 = new HashMap<OdpsType, Class>();

    OdpsTypeTransformer() {
    }

    @Deprecated
    public static Class odpsTypeToJavaType(OdpsType type) {
        return OdpsTypeTransformer.odpsTypeToJavaType(ODPS_TYPE_MAPPER_V2, type);
    }

    public static Class odpsTypeToJavaType(Map<OdpsType, Class> mapper, OdpsType type) {
        if (mapper.containsKey((Object)type)) {
            return mapper.get((Object)type);
        }
        throw new IllegalArgumentException("Cannot get Java type for Odps type: " + (Object)((Object)type));
    }

    private static void validateString(String value, long limit) {
        try {
            if ((long)(value.length() * 6) > limit && (long)value.getBytes("utf-8").length > limit) {
                throw new IllegalArgumentException("InvalidData: The string's length is more than " + limit + " bytes.");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static void validateChar(Char value, CharTypeInfo typeInfo) {
        if (value.length() > typeInfo.getLength()) {
            throw new IllegalArgumentException(String.format("InvalidData: %s data is overflow, pls check data length: %s.", typeInfo.getTypeName(), value.length()));
        }
    }

    private static void validateVarChar(Varchar value, VarcharTypeInfo typeInfo) {
        if (value.length() > typeInfo.getLength()) {
            throw new IllegalArgumentException(String.format("InvalidData: %s data is overflow, pls check data length: %s.", typeInfo.getTypeName(), value.length()));
        }
    }

    private static void validateBigint(Long value) {
        if (value == Long.MIN_VALUE) {
            throw new IllegalArgumentException("InvalidData: Bigint out of range.");
        }
    }

    private static void validateDateTime(java.util.Date value) {
        OdpsTypeTransformer.validateDateTime(value.getTime());
    }

    private static void validateDateTime(ZonedDateTime value) {
        OdpsTypeTransformer.validateDateTime(value.toInstant().toEpochMilli());
    }

    private static void validateDateTime(long epochMilli) {
        if (epochMilli < -62167305600000L || epochMilli > 253402387200000L) {
            throw new IllegalArgumentException(String.format("InvalidData: Datetime(%s) out of range.", epochMilli));
        }
    }

    private static void validateDecimal(BigDecimal value, DecimalTypeInfo typeInfo) {
        BigDecimal tmpValue = value.setScale(typeInfo.getScale(), RoundingMode.HALF_UP);
        int intLength = tmpValue.precision() - tmpValue.scale();
        if (intLength > typeInfo.getPrecision() - typeInfo.getScale()) {
            throw new IllegalArgumentException(String.format("InvalidData: decimal value %s overflow, max integer digit number is %s.", value, typeInfo.getPrecision() - typeInfo.getScale()));
        }
    }

    static <T> T getCompatibleType(Object value, TypeInfo typeInfo) {
        return OdpsTypeTransformer.getCompatibleType(value, typeInfo, null);
    }

    static <T> T getCompatibleType(Object value, TypeInfo typeInfo, Calendar calendar) {
        return OdpsTypeTransformer.transform(value, typeInfo, calendar, false, true, false, -1L);
    }

    static <T> T getOriginalType(Object value, TypeInfo typeInfo) {
        return OdpsTypeTransformer.transform(value, typeInfo, null, false, false, false, -1L);
    }

    static <T> T transformAndValidate(Object value, TypeInfo typeInfo, Calendar calendar, boolean strict, long fieldMaxSize) {
        if (typeInfo.getOdpsType() == OdpsType.STRING && value instanceof byte[]) {
            return (T)value;
        }
        return OdpsTypeTransformer.transform(value, typeInfo, calendar, true, false, strict, fieldMaxSize);
    }

    static <T> T transform(Object value, TypeInfo typeInfo, Calendar calendar, boolean setData, boolean compatible, boolean strict, long fieldMaxSize) {
        if (value == null) {
            return null;
        }
        HashMap<T, T> transformedResult = value;
        Map<OdpsType, Class> transformMapper = ODPS_TYPE_MAPPER;
        switch (typeInfo.getOdpsType()) {
            case JSON: {
                if (!setData) break;
                if (strict) {
                    OdpsTypeTransformer.validateString(((Object)transformedResult).toString(), fieldMaxSize);
                }
                return (T)transformedResult;
            }
            case STRING: {
                if (!setData) break;
                if (value instanceof byte[]) {
                    transformedResult = ArrayRecord.bytesToString((byte[])value);
                }
                if (!strict) break;
                OdpsTypeTransformer.validateString((String)((Object)transformedResult), fieldMaxSize);
                break;
            }
            case BIGINT: {
                if (!setData) break;
                OdpsTypeTransformer.validateBigint((Long)((Object)transformedResult));
                break;
            }
            case DECIMAL: {
                if (!setData) break;
                OdpsTypeTransformer.validateDecimal((BigDecimal)((Object)transformedResult), (DecimalTypeInfo)typeInfo);
                break;
            }
            case CHAR: {
                if (!setData) break;
                OdpsTypeTransformer.validateChar((Char)((Object)transformedResult), (CharTypeInfo)typeInfo);
                break;
            }
            case VARCHAR: {
                if (!setData) break;
                OdpsTypeTransformer.validateVarChar((Varchar)((Object)transformedResult), (VarcharTypeInfo)typeInfo);
                break;
            }
            case DATETIME: {
                if (setData) {
                    if (transformedResult instanceof ZonedDateTime) {
                        transformMapper = ODPS_TYPE_MAPPER_V2;
                        OdpsTypeTransformer.validateDateTime((ZonedDateTime)((Object)transformedResult));
                        break;
                    }
                    OdpsTypeTransformer.validateDateTime((java.util.Date)((Object)transformedResult));
                    break;
                }
                if (compatible) {
                    if (!(value instanceof ZonedDateTime)) break;
                    transformedResult = java.util.Date.from(((ZonedDateTime)((Object)value)).toInstant());
                    break;
                }
                if (!(value instanceof ZonedDateTime)) break;
                transformMapper = ODPS_TYPE_MAPPER_V2;
                break;
            }
            case DATE: {
                if (setData) {
                    if (value instanceof LocalDate) {
                        transformMapper = ODPS_TYPE_MAPPER_V2;
                        break;
                    }
                    if (calendar == null) break;
                    transformMapper = ODPS_TYPE_MAPPER_V2;
                    transformedResult = OdpsTypeTransformer.dateToLocalDate((Date)((Object)value), calendar);
                    break;
                }
                if (compatible) {
                    if (!(value instanceof LocalDate)) break;
                    transformedResult = OdpsTypeTransformer.localDateToDate((LocalDate)((Object)value), calendar);
                    break;
                }
                if (!(value instanceof LocalDate)) break;
                transformMapper = ODPS_TYPE_MAPPER_V2;
                break;
            }
            case TIMESTAMP: 
            case TIMESTAMP_NTZ: {
                if (setData) {
                    if (!(value instanceof Instant)) break;
                    transformMapper = ODPS_TYPE_MAPPER_V2;
                    break;
                }
                if (compatible) {
                    if (!(value instanceof Instant)) break;
                    transformedResult = Timestamp.from((Instant)((Object)value));
                    break;
                }
                if (!(value instanceof Instant)) break;
                transformMapper = ODPS_TYPE_MAPPER_V2;
                break;
            }
            case ARRAY: {
                List arrayValue = value;
                TypeInfo elementTypeInfo = ((ArrayTypeInfo)typeInfo).getElementTypeInfo();
                ArrayList<T> newList = new ArrayList<T>(arrayValue.size());
                for (Object obj : arrayValue) {
                    newList.add(OdpsTypeTransformer.transform(obj, elementTypeInfo, calendar, setData, compatible, strict, fieldMaxSize));
                }
                transformedResult = newList;
                break;
            }
            case MAP: {
                TypeInfo keyTypeInfo = ((MapTypeInfo)typeInfo).getKeyTypeInfo();
                TypeInfo valTypeInfo = ((MapTypeInfo)typeInfo).getValueTypeInfo();
                Map map = (Map)((Object)value);
                HashMap<T, T> newMap = new HashMap<T, T>(map.size(), 1.0f);
                for (Map.Entry entry : map.entrySet()) {
                    T entryKey = OdpsTypeTransformer.transform(entry.getKey(), keyTypeInfo, calendar, setData, compatible, strict, fieldMaxSize);
                    T entryValue = OdpsTypeTransformer.transform(entry.getValue(), valTypeInfo, calendar, setData, compatible, strict, fieldMaxSize);
                    newMap.put(entryKey, entryValue);
                }
                transformedResult = newMap;
                break;
            }
            case STRUCT: {
                Struct struct = (Struct)((Object)value);
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                ArrayList<Object> elements = new ArrayList<Object>();
                for (int i = 0; i < structTypeInfo.getFieldCount(); ++i) {
                    TypeInfo fieldTypeInfo = struct.getFieldTypeInfo(i);
                    elements.add(OdpsTypeTransformer.transform(struct.getFieldValue(i), fieldTypeInfo, calendar, setData, compatible, strict, fieldMaxSize));
                }
                transformedResult = new SimpleStruct(structTypeInfo, elements);
                break;
            }
        }
        return OdpsTypeTransformer.odpsTypeToJavaType(transformMapper, typeInfo.getOdpsType()).cast(transformedResult);
    }

    @Deprecated
    public static LocalDate dateToLocalDate(Date date, Calendar calendar) {
        if (calendar == null) {
            calendar = ArrayRecord.DEFAULT_CALENDAR;
        }
        calendar = (Calendar)calendar.clone();
        calendar.clear();
        calendar.setLenient(true);
        calendar.setTime(date);
        return IsoChronology.INSTANCE.date(IsoChronology.INSTANCE.eraOf(calendar.get(0)), calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    static Date localDateToDate(LocalDate localDate, Calendar calendar) {
        if (calendar == null) {
            calendar = ArrayRecord.DEFAULT_CALENDAR;
        }
        Calendar c = (Calendar)calendar.clone();
        c.clear();
        c.set(1, localDate.getYear());
        c.set(2, localDate.getMonthValue() - 1);
        c.set(5, localDate.getDayOfMonth());
        return new Date(c.getTime().getTime());
    }

    static {
        ODPS_TYPE_MAPPER.put(OdpsType.BIGINT, Long.class);
        ODPS_TYPE_MAPPER.put(OdpsType.STRING, String.class);
        ODPS_TYPE_MAPPER.put(OdpsType.DATETIME, java.util.Date.class);
        ODPS_TYPE_MAPPER.put(OdpsType.DOUBLE, Double.class);
        ODPS_TYPE_MAPPER.put(OdpsType.BOOLEAN, Boolean.class);
        ODPS_TYPE_MAPPER.put(OdpsType.DECIMAL, BigDecimal.class);
        ODPS_TYPE_MAPPER.put(OdpsType.ARRAY, List.class);
        ODPS_TYPE_MAPPER.put(OdpsType.MAP, Map.class);
        ODPS_TYPE_MAPPER.put(OdpsType.STRUCT, Struct.class);
        ODPS_TYPE_MAPPER.put(OdpsType.INT, Integer.class);
        ODPS_TYPE_MAPPER.put(OdpsType.TINYINT, Byte.class);
        ODPS_TYPE_MAPPER.put(OdpsType.SMALLINT, Short.class);
        ODPS_TYPE_MAPPER.put(OdpsType.DATE, Date.class);
        ODPS_TYPE_MAPPER.put(OdpsType.TIMESTAMP, Timestamp.class);
        ODPS_TYPE_MAPPER.put(OdpsType.TIMESTAMP_NTZ, LocalDateTime.class);
        ODPS_TYPE_MAPPER.put(OdpsType.FLOAT, Float.class);
        ODPS_TYPE_MAPPER.put(OdpsType.CHAR, Char.class);
        ODPS_TYPE_MAPPER.put(OdpsType.BINARY, Binary.class);
        ODPS_TYPE_MAPPER.put(OdpsType.VARCHAR, Varchar.class);
        ODPS_TYPE_MAPPER.put(OdpsType.INTERVAL_YEAR_MONTH, IntervalYearMonth.class);
        ODPS_TYPE_MAPPER.put(OdpsType.INTERVAL_DAY_TIME, IntervalDayTime.class);
        ODPS_TYPE_MAPPER.put(OdpsType.JSON, JsonValue.class);
        ODPS_TYPE_MAPPER_V2.putAll(ODPS_TYPE_MAPPER);
        ODPS_TYPE_MAPPER_V2.put(OdpsType.DATE, LocalDate.class);
        ODPS_TYPE_MAPPER_V2.put(OdpsType.TIMESTAMP, Instant.class);
        ODPS_TYPE_MAPPER_V2.put(OdpsType.DATETIME, ZonedDateTime.class);
    }
}

