/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.type;

import com.aliyun.odps.OdpsType;
import com.aliyun.odps.type.ArrayTypeInfo;
import com.aliyun.odps.type.CharTypeInfo;
import com.aliyun.odps.type.DecimalTypeInfo;
import com.aliyun.odps.type.MapTypeInfo;
import com.aliyun.odps.type.PrimitiveTypeInfo;
import com.aliyun.odps.type.SimpleArrayTypeInfo;
import com.aliyun.odps.type.SimpleMapTypeInfo;
import com.aliyun.odps.type.SimplePrimitiveTypeInfo;
import com.aliyun.odps.type.SimpleStructTypeInfo;
import com.aliyun.odps.type.StructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.VarcharTypeInfo;
import java.util.HashMap;
import java.util.List;

public class TypeInfoFactory {
    public static final PrimitiveTypeInfo BOOLEAN = new SimplePrimitiveTypeInfo(OdpsType.BOOLEAN);
    public static final PrimitiveTypeInfo VOID = new SimplePrimitiveTypeInfo(OdpsType.VOID);
    public static final PrimitiveTypeInfo TINYINT = new SimplePrimitiveTypeInfo(OdpsType.TINYINT);
    public static final PrimitiveTypeInfo SMALLINT = new SimplePrimitiveTypeInfo(OdpsType.SMALLINT);
    public static final PrimitiveTypeInfo INT = new SimplePrimitiveTypeInfo(OdpsType.INT);
    public static final PrimitiveTypeInfo BIGINT = new SimplePrimitiveTypeInfo(OdpsType.BIGINT);
    public static final PrimitiveTypeInfo FLOAT = new SimplePrimitiveTypeInfo(OdpsType.FLOAT);
    public static final PrimitiveTypeInfo DOUBLE = new SimplePrimitiveTypeInfo(OdpsType.DOUBLE);
    public static final PrimitiveTypeInfo STRING = new SimplePrimitiveTypeInfo(OdpsType.STRING);
    public static final PrimitiveTypeInfo DATE = new SimplePrimitiveTypeInfo(OdpsType.DATE);
    public static final PrimitiveTypeInfo DATETIME = new SimplePrimitiveTypeInfo(OdpsType.DATETIME);
    public static final PrimitiveTypeInfo TIMESTAMP = new SimplePrimitiveTypeInfo(OdpsType.TIMESTAMP);
    public static final PrimitiveTypeInfo TIMESTAMP_NTZ = new SimplePrimitiveTypeInfo(OdpsType.TIMESTAMP_NTZ);
    public static final PrimitiveTypeInfo BINARY = new SimplePrimitiveTypeInfo(OdpsType.BINARY);
    public static final PrimitiveTypeInfo INTERVAL_DAY_TIME = new SimplePrimitiveTypeInfo(OdpsType.INTERVAL_DAY_TIME);
    public static final PrimitiveTypeInfo INTERVAL_YEAR_MONTH = new SimplePrimitiveTypeInfo(OdpsType.INTERVAL_YEAR_MONTH);
    public static final PrimitiveTypeInfo UNKNOWN = new SimplePrimitiveTypeInfo(OdpsType.UNKNOWN);
    public static final DecimalTypeInfo DECIMAL = new DecimalTypeInfo();
    public static final PrimitiveTypeInfo JSON = new SimplePrimitiveTypeInfo(OdpsType.JSON);
    private static HashMap<OdpsType, PrimitiveTypeInfo> typeInfoMap = new HashMap();

    private TypeInfoFactory() {
    }

    public static PrimitiveTypeInfo getPrimitiveTypeInfo(OdpsType odpsType) {
        PrimitiveTypeInfo typeInfo = typeInfoMap.get((Object)odpsType);
        if (typeInfo != null) {
            return typeInfo;
        }
        throw new IllegalArgumentException("Error get PrimitiveTypeInfo instance for: " + (Object)((Object)odpsType));
    }

    public static ArrayTypeInfo getArrayTypeInfo(TypeInfo valueType) {
        return new SimpleArrayTypeInfo(valueType);
    }

    public static MapTypeInfo getMapTypeInfo(TypeInfo keyType, TypeInfo valueType) {
        return new SimpleMapTypeInfo(keyType, valueType);
    }

    public static CharTypeInfo getCharTypeInfo(int length) {
        return new CharTypeInfo(length);
    }

    public static VarcharTypeInfo getVarcharTypeInfo(int length) {
        return new VarcharTypeInfo(length);
    }

    public static DecimalTypeInfo getDecimalTypeInfo(int precision, int scale) {
        if (precision == 54 && scale == 18) {
            return DECIMAL;
        }
        return new DecimalTypeInfo(precision, scale);
    }

    public static StructTypeInfo getStructTypeInfo(List<String> names, List<TypeInfo> typeInfos) {
        return new SimpleStructTypeInfo(names, typeInfos);
    }

    static {
        typeInfoMap.put(BOOLEAN.getOdpsType(), BOOLEAN);
        typeInfoMap.put(VOID.getOdpsType(), VOID);
        typeInfoMap.put(TINYINT.getOdpsType(), TINYINT);
        typeInfoMap.put(SMALLINT.getOdpsType(), SMALLINT);
        typeInfoMap.put(INT.getOdpsType(), INT);
        typeInfoMap.put(BIGINT.getOdpsType(), BIGINT);
        typeInfoMap.put(FLOAT.getOdpsType(), FLOAT);
        typeInfoMap.put(DOUBLE.getOdpsType(), DOUBLE);
        typeInfoMap.put(STRING.getOdpsType(), STRING);
        typeInfoMap.put(DATE.getOdpsType(), DATE);
        typeInfoMap.put(DATETIME.getOdpsType(), DATETIME);
        typeInfoMap.put(TIMESTAMP.getOdpsType(), TIMESTAMP);
        typeInfoMap.put(TIMESTAMP_NTZ.getOdpsType(), TIMESTAMP_NTZ);
        typeInfoMap.put(BINARY.getOdpsType(), BINARY);
        typeInfoMap.put(INTERVAL_DAY_TIME.getOdpsType(), INTERVAL_DAY_TIME);
        typeInfoMap.put(INTERVAL_YEAR_MONTH.getOdpsType(), INTERVAL_YEAR_MONTH);
        typeInfoMap.put(UNKNOWN.getOdpsType(), UNKNOWN);
        typeInfoMap.put(DECIMAL.getOdpsType(), DECIMAL);
        typeInfoMap.put(JSON.getOdpsType(), JSON);
    }
}

