/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tea;

import com.aliyun.tea.NameInMap;
import com.aliyun.tea.TeaException;
import com.aliyun.tea.ValidateException;
import com.aliyun.tea.Validation;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class TeaModel {
    public Map<String, Object> toMap() {
        return TeaModel.changeToMap(this);
    }

    public static Map<String, Object> toMap(Object object) {
        Map<String, Object> map = new HashMap<String, Object>();
        if (null != object && object instanceof Map) {
            return (Map)object;
        }
        if (null == object || !TeaModel.class.isAssignableFrom(object.getClass())) {
            return map;
        }
        map = TeaModel.changeToMap(object);
        return map;
    }

    private static Map<String, Object> changeToMap(Object object) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            for (Field field : object.getClass().getFields()) {
                NameInMap anno = field.getAnnotation(NameInMap.class);
                String key = anno == null ? field.getName() : anno.value();
                if (null != field.get(object) && List.class.isAssignableFrom(field.get(object).getClass())) {
                    List arrayField = (List)field.get(object);
                    ArrayList<Object> fieldList = new ArrayList<Object>();
                    for (int i = 0; i < arrayField.size(); ++i) {
                        fieldList.add(TeaModel.parseObject(arrayField.get(i)));
                    }
                    map.put(key, fieldList);
                    continue;
                }
                if (null != field.get(object) && TeaModel.class.isAssignableFrom(field.get(object).getClass())) {
                    map.put(key, TeaModel.toMap(field.get(object)));
                    continue;
                }
                if (null != field.get(object) && Map.class.isAssignableFrom(field.get(object).getClass())) {
                    Map valueMap = (Map)field.get(object);
                    HashMap result = new HashMap();
                    for (Map.Entry entry : valueMap.entrySet()) {
                        result.put(entry.getKey(), TeaModel.parseObject(entry.getValue()));
                    }
                    map.put(key, result);
                    continue;
                }
                if (null != field.get(object) && InputStream.class.isAssignableFrom(field.get(object).getClass()) || null != field.get(object) && OutputStream.class.isAssignableFrom(field.get(object).getClass())) continue;
                map.put(key, field.get(object));
            }
        }
        catch (Exception e) {
            throw new TeaException(e.getMessage(), e);
        }
        return map;
    }

    public static Object parseObject(Object o) {
        if (null == o) {
            return o;
        }
        Class<?> clazz = o.getClass();
        if (List.class.isAssignableFrom(clazz)) {
            List list = (List)o;
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object object : list) {
                result.add(TeaModel.parseObject(object));
            }
            return result;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            Map map = (Map)o;
            HashMap result = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                result.put(entry.getKey(), TeaModel.parseObject(entry.getValue()));
            }
            return result;
        }
        if (TeaModel.class.isAssignableFrom(clazz)) {
            return ((TeaModel)o).toMap();
        }
        return o;
    }

    private static Object buildObject(Object o, Class self, Type subType) {
        Class<?> valueClass = o.getClass();
        if (Map.class.isAssignableFrom(self) && Map.class.isAssignableFrom(valueClass)) {
            Map valueMap = (Map)o;
            HashMap result = new HashMap();
            for (Map.Entry entry : valueMap.entrySet()) {
                if (null == subType || subType instanceof WildcardType) {
                    result.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (subType instanceof Class) {
                    result.put(entry.getKey(), TeaModel.buildObject(entry.getValue(), (Class)subType, null));
                    continue;
                }
                ParameterizedType parameterizedType = (ParameterizedType)subType;
                Type[] types = parameterizedType.getActualTypeArguments();
                result.put(entry.getKey(), TeaModel.buildObject(entry.getValue(), (Class)parameterizedType.getRawType(), types[types.length - 1]));
            }
            return result;
        }
        if (List.class.isAssignableFrom(self) && List.class.isAssignableFrom(valueClass)) {
            List valueList = (List)o;
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object object : valueList) {
                if (null == subType || subType instanceof WildcardType) {
                    result.add(object);
                    continue;
                }
                if (subType instanceof Class) {
                    result.add(TeaModel.buildObject(object, (Class)subType, null));
                    continue;
                }
                ParameterizedType parameterizedType = (ParameterizedType)subType;
                Type[] types = parameterizedType.getActualTypeArguments();
                result.add(TeaModel.buildObject(object, (Class)parameterizedType.getRawType(), types[types.length - 1]));
            }
            return result;
        }
        if (TeaModel.class.isAssignableFrom(self) && Map.class.isAssignableFrom(valueClass)) {
            try {
                return TeaModel.toModel((Map)o, (TeaModel)self.newInstance());
            }
            catch (Exception e) {
                throw new TeaException(e.getMessage(), e);
            }
        }
        return o;
    }

    private static Type getType(Field field, int index) {
        ParameterizedType genericType = (ParameterizedType)field.getGenericType();
        Type[] actualTypeArguments = genericType.getActualTypeArguments();
        Type actualTypeArgument = actualTypeArguments[index];
        return actualTypeArgument;
    }

    public static <T extends TeaModel> T toModel(Map<String, ?> map, T model) {
        T result = model;
        for (Field field : result.getClass().getFields()) {
            NameInMap anno = field.getAnnotation(NameInMap.class);
            String key = anno == null ? field.getName() : anno.value();
            Object value = map.get(key);
            if (value == null) continue;
            result = TeaModel.setTeaModelField(result, field, value, false);
        }
        return result;
    }

    private static <T extends TeaModel> T setTeaModelField(T model, Field field, Object value, boolean userBuild) {
        try {
            Class<?> clazz = field.getType();
            Object resultValue = TeaModel.parseNumber(value, clazz);
            T result = model;
            if (TeaModel.class.isAssignableFrom(clazz)) {
                Object data = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (userBuild) {
                    field.set(result, TeaModel.build(TeaModel.toMap(resultValue), (TeaModel)data));
                } else if (!userBuild && Map.class.isAssignableFrom(resultValue.getClass())) {
                    field.set(result, TeaModel.toModel((Map)resultValue, (TeaModel)data));
                } else {
                    field.set(result, resultValue);
                }
            } else if (Map.class.isAssignableFrom(clazz)) {
                field.set(result, TeaModel.buildObject(resultValue, Map.class, TeaModel.getType(field, 1)));
            } else if (List.class.isAssignableFrom(clazz)) {
                field.set(result, TeaModel.buildObject(resultValue, List.class, TeaModel.getType(field, 0)));
            } else if (Integer.class.isAssignableFrom(clazz)) {
                field.set(result, Integer.parseInt(String.valueOf(resultValue)));
            } else if (Double.class.isAssignableFrom(clazz)) {
                field.set(result, Double.parseDouble(String.valueOf(resultValue)));
            } else if (Float.class.isAssignableFrom(clazz)) {
                field.set(result, Float.valueOf(Float.parseFloat(String.valueOf(resultValue))));
            } else if (Long.class.isAssignableFrom(clazz)) {
                field.set(result, Long.parseLong(String.valueOf(resultValue)));
            } else if (Boolean.class.isAssignableFrom(clazz)) {
                field.set(result, Boolean.parseBoolean(String.valueOf(resultValue)));
            } else {
                field.set(result, resultValue);
            }
            return result;
        }
        catch (Exception e) {
            throw new TeaException(e.getMessage(), e);
        }
    }

    public static <T extends TeaModel> T build(Map<String, ?> map, T model) {
        T result = model;
        for (Field field : model.getClass().getFields()) {
            NameInMap anno;
            String key = field.getName();
            Object value = map.get(key);
            if (value == null && (null == (anno = field.getAnnotation(NameInMap.class)) || null == (value = map.get(key = anno.value())))) continue;
            result = TeaModel.setTeaModelField(result, field, value, true);
        }
        return result;
    }

    private static Object parseNumber(Object value, Class clazz) {
        if (value instanceof Double && (clazz == Long.class || clazz == Long.TYPE)) {
            BigDecimal bigDecimal = new BigDecimal(value.toString());
            return bigDecimal.longValue();
        }
        if (value instanceof Double && (clazz == Integer.class || clazz == Integer.TYPE)) {
            BigDecimal bigDecimal = new BigDecimal(value.toString());
            return bigDecimal.intValue();
        }
        if (value instanceof Double && (clazz == Float.class || clazz == Float.TYPE)) {
            BigDecimal bigDecimal = new BigDecimal(value.toString());
            return Float.valueOf(bigDecimal.floatValue());
        }
        return value;
    }

    public void validate() {
        Field[] fields = this.getClass().getFields();
        try {
            for (int i = 0; i < fields.length; ++i) {
                Object object = fields[i].get(this);
                Validation validation = fields[i].getAnnotation(Validation.class);
                boolean required = null != validation ? validation.required() : false;
                if (required && null == object) {
                    throw new ValidateException("Field " + fields[i].getName() + " is required");
                }
                if (null == validation || null == object) continue;
                String pattern = validation.pattern();
                int maxLength = validation.maxLength();
                int minLength = validation.minLength();
                if ("".equals(pattern) && maxLength <= 0 && minLength <= 0) continue;
                this.determineType(fields[i].getType(), object, pattern, maxLength, minLength, fields[i].getName());
            }
        }
        catch (Exception e) {
            throw new ValidateException(e.getMessage(), e);
        }
    }

    private void determineType(Class clazz, Object object, String pattern, int maxLength, int minLength, String fieldName) {
        if (Map.class.isAssignableFrom(clazz)) {
            this.validateMap(pattern, maxLength, minLength, (Map)object, fieldName);
        } else if (TeaModel.class.isAssignableFrom(clazz)) {
            ((TeaModel)object).validate();
        } else if (List.class.isAssignableFrom(clazz)) {
            List list = (List)object;
            for (int j = 0; j < list.size(); ++j) {
                this.determineType(list.get(j).getClass(), list.get(j), pattern, maxLength, minLength, fieldName);
            }
        } else if (clazz.isArray()) {
            Object[] objects = (Object[])object;
            for (int j = 0; j < objects.length; ++j) {
                this.determineType(clazz.getComponentType(), objects[j], pattern, maxLength, minLength, fieldName);
            }
        } else {
            String value = String.valueOf(object);
            if (maxLength > 0 && value.length() > maxLength) {
                throw new ValidateException(this.getClass().getName() + "." + fieldName + " exceeds the maximum length");
            }
            if (minLength > 0 && value.length() < minLength) {
                throw new ValidateException(this.getClass().getName() + "." + fieldName + " less than minimum length");
            }
            if (!"".equals(pattern) && !Pattern.matches(pattern, value)) {
                throw new ValidateException(this.getClass().getName() + "." + fieldName + " regular match failed");
            }
        }
    }

    private void validateMap(String pattern, int maxLength, int minLength, Map<String, Object> map, String fieldName) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            this.determineType(entry.getValue().getClass(), entry.getValue(), pattern, maxLength, minLength, fieldName);
        }
    }

    public static Map<String, Object> buildMap(TeaModel teaModel) {
        if (null == teaModel) {
            return null;
        }
        return teaModel.toMap();
    }

    public static void validateParams(TeaModel teaModel, String paramName) {
        if (null == teaModel) {
            throw new ValidateException("parameter " + paramName + " is not allowed as null");
        }
        teaModel.validate();
    }
}

