$ = jQuery

$.extend REPLIT,
  number = 0
  aceInConsole: (content) ->
    if content != ""
      content = """
                <div class="aceConsoleDiv"> \
                  <div class="aceConsoleButtons"> \
                    <button data-tooltip="" data-title="Expand code" onclick='REPLIT.expand(#{number})'><i class="icon-plus icon-2x" aria-label="plus" role="img"></i></button> \
                    <button data-tooltip="" data-title="Collapse code" onclick='REPLIT.collapse(#{number})'><i class="icon-minus icon-2x" aria-label="minus" role="img"></i></button> \
                    <button data-tooltip="" data-title="Replay code" onclick='REPLIT.replay(#{number})'><i class="icon-retweet icon-2x" aria-label="retweet" role="img"></i></button> \
                    <button data-tooltip="" data-title="Replace in editor" onclick='REPLIT.transfer(#{number})'><i class="icon-arrow-left icon-2x" aria-label="arrow-left" role="img"></i></button> \
                    <button data-tooltip="" data-title="Append to editor" onclick='REPLIT.append(#{number})'><i class="icon-double-angle-left icon-2x" aria-label="double-angle-left" role="img"></i></button> \
                  </div> \
                  <div class="aceConsole" id=editor#{number}>#{content}</div> \
                </div> \
                """
      @OnOutputHtml(content)

      editor = ace.edit("editor"+number)
      editor.getSession().setMode("ace/mode/javascript")
      editor.setReadOnly(true)
      editor.setShowPrintMargin(false)
      editor.getSession().foldAll()
      number++

  expand: (number) ->
    editor = ace.edit ('editor' + number)
    editor.getSession().unfold()
  collapse: (number) ->
    editor = ace.edit ('editor' + number)
    editor.getSession().foldAll()
  replay: (number) ->
    editor = ace.edit ('editor' + number)
    @jqconsole.AbortPrompt()
    @Evaluate editor.getSession().getValue()
  transfer: (number) ->
    editor = ace.edit ('editor' + number)
    REPLIT.editor.getSession().doc.setValue editor.getSession().getValue()
    REPLIT.editor.focus()
  append: (number) ->
    editor = ace.edit ('editor' + number)
    position = REPLIT.editor.getCursorPosition()
    REPLIT.editor.getSession().insert position, editor.getSession().getValue()
    REPLIT.editor.focus()