$ = jQuery

$.extend REPLIT,
  exampleContent: [
    name:"ListTables"
    sdkLink:"http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#listTables-property"
    apiLink:"http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ListTables.html"
    code:"""
            var params = {
                /*
                // optional (for pagination, returned as LastEvaluatedTableName)
                ExclusiveStartTableName: 'table_name',

                // optional (to further limit the number of table names returned per page)
                Limit: 1 
                */
            };
            dynamodb.listTables(params, function(err, data) {
                if (err) console.log(err, err.stack); // an error occurred
                else     console.log(data);           // successful response
            });
        """
  ,
    name:"CreateTable"
    sdkLink:"http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#createTable-property"
    apiLink:"http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_CreateTable.html"
    code:"""
            var params = {
                TableName: 'table_name',
                KeySchema: [ // The type of of schema.  Must start with a HASH type, with an optional second RANGE.
                    { // Required HASH type attribute
                        AttributeName: 'hash_key_attribute_name',
                        KeyType: 'HASH',
                    },
                    { // Optional RANGE key type for HASH + RANGE tables
                        AttributeName: 'range_key_attribute_name',
                        KeyType: 'RANGE',
                    }
                ],
                AttributeDefinitions: [ // The names and types of all primary and index key attributes only
                    {
                        AttributeName: 'hash_key_attribute_name',
                        AttributeType: 'S', // (S | N | B) for string, number, binary
                    },
                    {
                        AttributeName: 'range_key_attribute_name',
                        AttributeType: 'S', // (S | N | B) for string, number, binary
                    },
                    {
                        AttributeName: 'index_hash_key_attribute_name_1',
                        AttributeType: 'S', // (S | N | B) for string, number, binary
                    },
                    {
                        AttributeName: 'index_range_key_attribute_name_1',
                        AttributeType: 'S', // (S | N | B) for string, number, binary
                    },
                    {
                        AttributeName: 'index_range_key_attribute_name_2',
                        AttributeType: 'S', // (S | N | B) for string, number, binary
                    },
                    
                    // ... more attributes ...
                ],
                ProvisionedThroughput: { // required provisioned throughput for the table
                    ReadCapacityUnits: 1, 
                    WriteCapacityUnits: 1, 
                },
                GlobalSecondaryIndexes: [ // optional (list of GlobalSecondaryIndex)
                    { 
                        IndexName: 'index_name_1', 
                        KeySchema: [
                            { // Required HASH type attribute
                                AttributeName: 'index_hash_key_attribute_name_1',
                                KeyType: 'HASH',
                            },
                            { // Optional RANGE key type for HASH + RANGE secondary indexes
                                AttributeName: 'index_range_key_attribute_name_1', 
                                KeyType: 'RANGE', 
                            }
                        ],
                        Projection: { // attributes to project into the index
                            ProjectionType: 'INCLUDE', // (ALL | KEYS_ONLY | INCLUDE)
                            NonKeyAttributes: [ // required / allowed only for INCLUDE
                                'attribute_name_1',
                                // ... more attribute names ...
                            ],
                        },
                        ProvisionedThroughput: { // throughput to provision to the index
                            ReadCapacityUnits: 1,
                            WriteCapacityUnits: 1,
                        },
                    },
                    // ... more global secondary indexes ...
                ],
                LocalSecondaryIndexes: [ // optional (list of LocalSecondaryIndex)
                    { 
                        IndexName: 'index_name_2',
                        KeySchema: [ 
                            { // Required HASH type attribute - must match the table's HASH key attribute name
                                AttributeName: 'hash_key_attribute_name',
                                KeyType: 'HASH',
                            },
                            { // alternate RANGE key attribute for the secondary index
                                AttributeName: 'index_range_key_attribute_name_2', 
                                KeyType: 'RANGE', 
                            }
                        ],
                        Projection: { // required
                            ProjectionType: 'INCLUDE', // (ALL | KEYS_ONLY | INCLUDE)
                            NonKeyAttributes: [ // required / allowed only for INCLUDE
                                'attribute_name_1',
                                // ... more attribute names ...
                            ],
                        },
                    },
                    // ... more local secondary indexes ...
                ],
            };
            dynamodb.createTable(params, function(err, data) {
                if (err) print(err); // an error occurred
                else print(data); // successful response
            });
        """
  ,
    name:"WaitFor"
    sdkLink:"http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#waitFor-property"
    apiLink:""
    code:"""
            // Waits for table to become ACTIVE.  
            // Useful for waiting for table operations like CreateTable to complete. 
            var params = {
                TableName: 'table_name',
            };
            // Supports 'tableExists' and 'tableNotExists'
            dynamodb.waitFor('tableExists', params, function(err, data) {
                if (err) print(err); // an error occurred
                else print(data); // successful response
            });
        """
  ,
    name:"UpdateTable"
    sdkLink:"http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#updateTable-property"
    apiLink:"http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_UpdateTable.html"
    code:"""
            // Update Base Table Throughput
            var params = {
                TableName: 'table_name',
                ProvisionedThroughput: {
                    ReadCapacityUnits: 2,
                    WriteCapacityUnits: 2,
                }
            };

            // Update Global Secondary Index Throughput
            var params = {
                TableName: 'table_name',
                GlobalSecondaryIndexUpdates: [
                    {
                        Update: {
                            IndexName: 'index_name_1',
                            ProvisionedThroughput: {
                                ReadCapacityUnits: 2,
                                WriteCapacityUnits: 2
                            }
                        }
                    },
                    // ... more optional indexes ...
                ]
            };

            // Add Global Secondary Index
            var params = {
                TableName: 'table_name',
                AttributeDefinitions: [ // only required if adding new index
                    {
                        AttributeName: 'index_hash_key_attribute_name_3',
                        AttributeType: 'S' // (S | N | B) for string, number, binary
                    },
                    // ... more attributes ...
                ],
                GlobalSecondaryIndexUpdates: [
                    {
                        Create: {
                            IndexName: 'index_name_3',
                            KeySchema: [
                                {
                                    AttributeName: 'index_hash_key_attribute_name_3',
                                    KeyType: 'HASH'
                                },
                                // optional RANGE key
                            ],
                            Projection: { // attributes to project into the index
                                ProjectionType: 'KEYS_ONLY', // (ALL | KEYS_ONLY | INCLUDE)
                            },
                            ProvisionedThroughput: {
                                ReadCapacityUnits: 1,
                                WriteCapacityUnits: 1
                            }
                        }
                    },
                    // ... more optional indexes ...
                ],
            };

            // Delete Global Secondary Index
            var params = {
                TableName: 'table_name',
                GlobalSecondaryIndexUpdates: [
                    {
                        Delete: {
                            IndexName: 'index_name_3'
                        }
                    },
                    // ... more optional indexes ...
                ]
            };

            dynamodb.updateTable(params, function(err, data) {
                if (err) print(err); // an error occurred
                else print(data); // successful response
            });
        """
  ,
    name:"DescribeTable"
    sdkLink:"http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#describeTable-property"
    apiLink:"http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DescribeTable.html"
    code:"""
            var params = {
                TableName: 'table_name',
            };
            dynamodb.describeTable(params, function(err, data) {
                if (err) print(err); // an error occurred
                else print(data); // successful response
            });
        """
  ,
    name:"PutItem"
    sdkLink:"http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#putItem-property"
    apiLink:"http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_PutItem.html"
    code:"""
            // Basic PutItem
            var params = {
                TableName: 'table_name',
                Item: { // a map of attribute name to AttributeValue
                
                    // attribute_name: attribute_value,
                    // Note: attribute_value (string | number | boolean | null | Uint8Array | dynamodb.Set(array, S|N|B) | Array | Object)

                    // primary keys are required
                    hash_key_attribute_name: 'attribute_value',
                    range_key_attribute_name: 'range_attribute_value', // optional if table is hash-only

                    Price: 500,
                    InStock: true,
                    QuantityOnHand: null,
                    Pic: dynamodb.StrToBin("someURI"),
                    Color: dynamodb.Set(["Red", "Black"], "S"),
                    RelatedItems: [341, 472, 649],
                    ProductReviews: {
                        FiveStar: [
                           "Excellent! Can't recommend it highly enough!  Buy it!",
                           "Do yourself a favor and buy this."
                        ],
                        OneStar: [
                           "Terrible product!  Do not buy this."
                        ]
                    }
                    // more attributes ...
                },
                ReturnValues: 'NONE', // optional (NONE | ALL_OLD)
                ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)
                ReturnItemCollectionMetrics: 'NONE', // optional (NONE | SIZE)
            };

            // See http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html for more details on expression language
            // Conditional Put - Put if doesn't already exist
            var params = {
                TableName: 'table_name',
                Item: {
                    hash_key_attribute_name: 'attribute_value',
                    range_key_attribute_name: 'range_attribute_value', // optional if table is hash-only
                },

                // put if doesn't already exist
                ConditionExpression: 'attribute_not_exists(hash_key_attribute_name) AND attribute_not_exists(range_key_attribute_name)',
            };

            // // Conditional Put - Expression Attribute Names and Values
            var params = {
                TableName: 'table_name',
                Item: {
                    hash_key_attribute_name: 'attribute_value',
                    range_key_attribute_name: 'range_attribute_value', // optional if table is hash-only
                },

                // Put if existing ProductReviews.FiveStar is a list data type
                ConditionExpression: 'attribute_type(#pr.FiveStar, :val)',
                ExpressionAttributeNames: {
                    '#pr': 'ProductReviews',
                    // ... more expression attribute names ...
                },
                ExpressionAttributeValues: {
                    ':val': 'L',
                    // ... more expression attribute values ...
                }
            };

            dynamodb.putItem(params, function(err, data) {
                if (err) print(err); // an error occurred
                else print(data); // successful response
            });
        """
  ,
    name:"GetItem"
    sdkLink:"http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#getItem-property"
    apiLink:"http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_GetItem.html"
    code:"""
            var params = {
                TableName: 'table_name',
                Key: { // required - a map of attribute name to AttributeValue for all primary key attributes
                    hash_key_attribute_name: 'attribute_value', // (string | number | boolean | null | Uint8Array)
                    range_key_attribute_name: 'range_attribute_value', // optional if table is hash-only
                },
                
                // optional - list of attributes to return (default is to return all)
                ProjectionExpression: 'InStock, QuantityOnHand, ProductReviews.FiveStar, #ri', 
                
                // optional - used for name substitution (e.g. for convenience or reserved word conflicts)
                ExpressionAttributeNames: {
                    '#ri': 'RelatedItems',
                    // ... more expression attribute names ...
                },
                ConsistentRead: false, // optional (true | false)
                ReturnConsumedCapacity: 'NONE', // optional (INDEXES | TOTAL | NONE)
            };
            dynamodb.getItem(params, function(err, data) {
                if (err) print(err); // an error occurred
                else print(data); // successful response
            });
        """
  ,
    name:"UpdateItem"
    sdkLink:"http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#updateItem-property"
    apiLink:"http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_UpdateItem.html"
    code:"""
            var params = {
                TableName: 'table_name',
                Key: { // required - a map of attribute name to AttributeValue for all primary key attributes
                    hash_key_attribute_name: 'attribute_value', // (string | number | boolean | null | Uint8Array)
                    range_key_attribute_name: 'range_attribute_value', // optional if table is hash-only
                },

                /*
                // optional expression for conditional update
                ConditionExpression: 'EXPRESSION STRING',
                */

                // see http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Modifying.html
                // for more information on expression syntax
                UpdateExpression: 'SET #list[0] = :val1 REMOVE #m.#nestedField1, #m.#nestedField2 ADD #aNumber :val2 DELETE #aSet :val3',
                ExpressionAttributeNames: {
                   '#list': 'RelatedItems',
                   '#m': 'ProductReviews',
                   '#nestedField1': 'FiveStar',
                   '#nestedField2': 'OneStar',
                   '#aNumber': 'Price',
                   '#aSet': 'Color'
                },
                ExpressionAttributeValues: {
                   ':val1': 9001,
                   ':val2': -499,
                   ':val3': dynamodb.Set(["Red"], "S")
                },

                ReturnValues: 'ALL_NEW', // optional (NONE | ALL_OLD | UPDATED_OLD | ALL_NEW | UPDATED_NEW)
                ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)
                ReturnItemCollectionMetrics: 'NONE', // optional (NONE | SIZE)
            };
            dynamodb.updateItem(params, function(err, data) {
                if (err) print(err); // an error occurred
                else print(data); // successful response
            });
        """
  ,
    name:"DeleteItem"
    sdkLink:"http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#deleteItem-property"
    apiLink:"http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteItem.html"
    code:"""
            var params = {
                TableName: 'table_name',
                Key: { // required - a map of attribute name to AttributeValue for all primary key attributes
                    hash_key_attribute_name: 'attribute_value', // (string | number | boolean | null | Uint8Array)
                    range_key_attribute_name: 'range_attribute_value', // optional if table is hash-only
                },

                /*
                // optional - expression to make delete conditional
                ConditionExpression: 'EXPRESSION STRING',
                ExpressionAttributeNames: {
                    someKey: 'STRING_VALUE',
                    // ... more expression attribute names ...
                },
                ExpressionAttributeValues: {
                    someKey: value,
                    // ... more expression attribute values ...
                },
                */

                ReturnValues: 'ALL_OLD', // optional (NONE | ALL_OLD)
                ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)
                ReturnItemCollectionMetrics: 'NONE', // optional (NONE | SIZE)
            };
            dynamodb.deleteItem(params, function(err, data) {
                if (err) print(err); // an error occurred
                else print(data); // successful response
            });
        """
  ,
    name:"BatchWriteItem"
    sdkLink:"http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#batchWriteItem-property"
    apiLink:"http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_BatchWriteItem.html"
    code:"""
            var params = {
                RequestItems: { // A map of TableName to Put or Delete requests for that table
                    table_name: [ // a list of Put or Delete requests for that table
                        { // An example PutRequest
                            PutRequest: {
                                Item: { // a map of attribute name to AttributeValue    
                                    hash_key_attribute_name: 'attribute_value',
                                    range_key_attribute_name: 'range_attribute_value', // optional if table is hash-only
                                    // attribute_value (string | number | boolean | null | Uint8Array | dynamodb.Set | Array | Object)
                                    // ... more attributes ...
                                }
                            }
                        },
                        { // An example DeleteRequest
                            DeleteRequest: {
                                Key: {  // a map of attribute name to AttributeValue    
                                    hash_key_attribute_name: 'attribute_value2',
                                    range_key_attribute_name: 'range_attribute_value', // optional if table is hash-only
                                    // attribute_value (string | number | boolean | null | Uint8Array | dynamodb.Set | Array | Object)
                                    // ... more attributes ...
                                }
                            }
                        },
                        // ... more put or delete requests for this table ...
                        {
                            PutRequest: {
                                Item: {
                                    hash_key_attribute_name: 'attribute_value3',
                                    range_key_attribute_name: 'range_attribute_value3',
                                }
                            }
                        },
                        {
                            PutRequest: {
                                Item: {
                                    hash_key_attribute_name: 'attribute_value3',
                                    range_key_attribute_name: 'range_attribute_value4',
                                    index_hash_key_attribute_name_1: 'index_hash_value_1',
                                    index_range_key_attribute_name_1: 'index_range_value_1'
                                }
                            }
                        },
                    ],
                    // ... more tables ...
                },
                ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)
                ReturnItemCollectionMetrics: 'NONE', // optional (NONE | SIZE)
            };
            dynamodb.batchWriteItem(params, function(err, data) {
                if (err) print(err); // an error occurred
                else print(data); // successful response
            });
        """
  ,
    name:"BatchGetItem"
    sdkLink:"http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#batchGetItem-property"
    apiLink:"http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_BatchGetItem.html"
    code:"""
            var params = {
                RequestItems: { // map of TableName to list of Key to get from each table
                    table_name: {
                        Keys: [ // a list of primary key value maps
                            { // required - a map of attribute name to AttributeValue for all primary key attributes
                                hash_key_attribute_name: 'attribute_value', // (string | number | boolean | null | Uint8Array)
                                range_key_attribute_name: 'range_attribute_value', // optional if table is hash-only
                            },
                            // ... more keys to get from this table ...
                        ],
                        
                        /*
                        // optional - list of attributes to return (default is to return all)
                        ProjectionExpression: 'EXPRESSION STRING', 
                        
                        // optional - used for name substitution (e.g. for convenience or reserved word conflicts)
                        ExpressionAttributeNames: {
                            someKey: value,
                                // ... more expression attribute values ...
                        },
                        */

                        ConsistentRead: false, // optional (true | false)
                    },
                    // ... more tables and keys ...
                },
                ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)
            };
            dynamodb.batchGetItem(params, function(err, data) {
                if (err) print(err); // an error occurred
                else print(data); // successful response
            });
        """
  ,
    name:"Query"
    sdkLink:"http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#query-property"
    apiLink:"http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_Query.html"
    code:"""
            var params = {
                TableName: 'table_name',
                // IndexName: 'index_name', // optional (if querying an index)

                // Expression to filter on indexed attributes
                KeyConditionExpression: '#hashkey = :hk_val AND #rangekey > :rk_val',
                ExpressionAttributeNames: {
                   '#hashkey': 'hash_key_attribute_name',
                   '#rangekey': 'range_key_attribute_name',
                },
                ExpressionAttributeValues: {
                   ':hk_val': 'attribute_value3',
                   ':rk_val': 'range_attribute_value3',
                },

                /*
                // optional - list of attributes to return (default is to return all)
                ProjectionExpression: 'EXPRESSION STRING',

                // optional - filter expression to apply on results of KeyConditionExpression
                FilterExpression: 'EXPRESSION STRING',
                */

                ScanIndexForward: true, // optional (true | false) defines direction of Query in the index
                Limit: 1, // optional (limit the number of items to evaluate)
                ConsistentRead: false, // optional (true | false)
                ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)

                /*
                // optional (for pagination, returned by prior calls as LastEvaluatedKey)
                ExclusiveStartKey: {
                    attribute_name: attribute_value,
                    // attribute_value (string | number | boolean | null | Uint8Array | dynamodb.Set | Array | Object)
                    // anotherKey: ...
                },
                */
            };
            dynamodb.query(params, function(err, data) {
                if (err) print(err); // an error occurred
                else print(data); // successful response
            });
        """
  ,
    name:"Scan"
    sdkLink:"http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#scan-property"
    apiLink:"http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_Scan.html"
    code:"""
            var params = {
                TableName: 'table_name',
                IndexName: 'index_name_1', // optional - name of index to scan

                /*
                // optional expression to filter results
                FilterExpression: 'STRING_VALUE',
                
                // optional - list of attributes to return (default is to return all)
                ProjectionExpression: 'STRING_VALUE',

                // optional - if used by relevant expressions
                ExpressionAttributeNames: {
                    someKey: 'STRING_VALUE',
                    // ... more expression attribute names ...
                },
                ExpressionAttributeValues: {
                    someKey: value,
                    // ... more expression attribute values ...
                },

                Limit: 1, // optional (limit the number of items to evaluate)

                Select: 'ALL_ATTRIBUTES', // optional (ALL_ATTRIBUTES | COUNT)

                ExclusiveStartKey: { // optional (for pagination, returned by prior calls as LastEvaluatedKey)
                    attribute_name: attribute_value,
                    // attribute_value (string | number | boolean | null | Uint8Array | dynamodb.Set | Array | Object)
                    // anotherKey: ...
                },

                Segment: 0, // optional (for parallel scan)

                TotalSegments: 0, // optional (for parallel scan)
                
                ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)
                */
            };
            dynamodb.scan(params, function(err, data) {
                if (err) print(err); // an error occurred
                else print(data); // successful response
            });
        """
  ,
    name:"DeleteTable"
    sdkLink:"http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#deleteTable-property"
    apiLink:"http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteTable.html"
    code:"""
            var params = {
                TableName: 'table_name',
            };
            dynamodb.deleteTable(params, function(err, data) {
                if (err) print(err); // an error occurred
                else print(data); // successful response
            });
        """
  ]