$ = jQuery

$.extend REPLIT,
	setSnippets: (m)->
    m.snippets.concat(@snippetContents)

  snippetContents: [
    name: "AttributeValue"
    tabTrigger: "AttributeValue"
    content:"""
        // Enter only one of the possible attribute value types.
        // For a more convenient shorthand command, use the shortcut
        // for each type, such as 'S', 'N', 'B'.
        {
            S: 'STRING_VALUE',
            N: 'NUMBER_VALUE',
            B: 'BASE64_ENCODED_STRING',
            SS: [ 'STRING_VALUE_1', 'STRING_VALUE_2', ],
            NS: [ 'NUMBER_VALUE_1', 'NUMBER_VALUE_2', ],
            BS: [ 'BASE64_ENCODED_STRING_1', 'BASE64_ENCODED_STRING_2', ]
        }"""
  ,
    name: "batchGetItem"
    tabTrigger: "batchGetItem"
    content:"""
        var params = {
            RequestItems: { // map of TableName to list of Key to get from each table
                ${1:table_name_1}: {
                    Keys: [ // a list of primary key value maps
                        {
                            key_attribute_name: 'STRING_VALUE',
                            // ... more key attributes, if the primary key is hash/range
                        },
                        // ... more keys to get from this table ...
                    ],
                    AttributesToGet: [ // option (attributes to retrieve from this table)
                        'attribute_name',
                        // ... more attribute names ...
                    ],
                    ConsistentRead: false, // optional (true | false)
                },
                // ... more tables and keys ...
            },
            ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)
        };
        dynamodb.batchGetItem(params, function(err, data) {
            if (err) print(err); // an error occurred
            else print(data); // successful response
        
        });"""
  ,
    name: "Keys"
    tabTrigger: "Keys"
    content:"""
        Keys: [ // a list of primary key value maps
            {
                key_attribute_name: 'STRING_VALUE',
                // ... more key attributes, if the primary key is hash/range
            },
            // ... more keys to get from this table ...
        ],"""
  ,
    name: "batchWriteItem"
    tabTrigger: "batchWriteItem"
    content:"""
        var params = {
            RequestItems: { // A map of TableName to Put or Delete requests for that table
                ${1:table_name_1}: [ // a list of Put or Delete requests for that table
                    { // An example PutRequest
                        PutRequest: {
                            Item: { // a map of attribute name to AttributeValue    
                                attribute_name: 'STRING_VALUE',
                                // ... more attributes ...
                            }
                        }
                    },
                    { // An example DeleteRequest
                        DeleteRequest: {
                            Key: { 
                                key_attribute_name: 'STRING_VALUE',
                                // more primary attributes (if the primary key is hash/range schema)
                            }
                        }
                    },
                    // ... more put or delete requests ...
                ],
                // ... more tables ...
            },
            ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)
            ReturnItemCollectionMetrics: 'NONE', // optional (NONE | SIZE)
        };
        dynamodb.batchWriteItem(params, function(err, data) {
            if (err) print(err); // an error occurred
            else print(data); // successful response
        });"""
  ,
    name: "RequestItems"
    tabTrigger: "RequestItems"
    content:"""
        RequestItems: { // A map of TableName to Put or Delete requests for that table
            ${1:table_name_1}: [ // a list of Put or Delete requests for that table
                { // An example PutRequest
                    PutRequest: {
                        Item: { // a map of attribute name to AttributeValue    
                            attribute_name: 'STRING_VALUE',
                            // ... more attributes ...
                        }
                    }
                },
                { // An example DeleteRequest
                    DeleteRequest: {
                        Key: { 
                            key_attribute_name: 'STRING_VALUE',
                            // more primary attributes (if the primary key is hash/range schema)
                        }
                    }
                },
                // ... more put or delete requests ...
            ],
            // ... more tables ...
        }"""
  ,
    name: "createTable"
    tabTrigger: "createTable"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            KeySchema: [ // The type of of schema.  Must start with a HASH type, with an optional second RANGE.
                { // Required HASH type attribute
                    AttributeName: 'hash_key_attribute_name',
                    KeyType: 'HASH',
                },
                { // Optional RANGE key type for HASH + RANGE tables
                    AttributeName: 'range_key_attribute_name', 
                    KeyType: 'RANGE', 
                }
            ],
            AttributeDefinitions: [ // The names and types of all primary and index key attributes only
                {
                    AttributeName: 'attribute_name',
                    AttributeType: 'S', // (S | N | B) for string, number, binary
                },
                // ... more attributes ...
            ],
            ProvisionedThroughput: { // required provisioned throughput for the table
                ReadCapacityUnits: 0, 
                WriteCapacityUnits: 0, 
            },
            GlobalSecondaryIndexes: [ // optional (list of GlobalSecondaryIndex)
                { 
                    IndexName: 'index_name_1', 
                    KeySchema: [
                        { // Required HASH type attribute
                            AttributeName: 'hash_key_attribute_name',
                            KeyType: 'HASH',
                        },
                        { // Optional RANGE key type for HASH + RANGE secondary indexes
                            AttributeName: 'range_key_attribute_name', 
                            KeyType: 'RANGE', 
                        }
                    ],
                    Projection: { // attributes to project into the index
                        ProjectionType: 'ALL', // (ALL | KEYS_ONLY | INCLUDE)
                        NonKeyAttributes: [ // required / allowed only for INCLUDE
                            'attribute_name_1',
                            // ... more attribute names ...
                        ],
                    },
                    ProvisionedThroughput: { // throughput to provision to the index
                        ReadCapacityUnits: 0,
                        WriteCapacityUnits: 0,
                    },
                },
                // ... more global secondary indexes ...
            ],
            LocalSecondaryIndexes: [ // optional (list of LocalSecondaryIndex)
                { 
                    IndexName: 'index_name_2',
                    KeySchema: [ 
                        { // Required HASH type attribute - must match the table's HASH key attribute name
                            AttributeName: 'hash_key_attribute_name',
                            KeyType: 'HASH',
                        },
                        { // alternate RANGE key attribute for the secondary index
                            AttributeName: 'range_key_attribute_name', 
                            KeyType: 'RANGE', 
                        }
                    ],
                    Projection: { // required
                        NonKeyAttributes: [
                            'STRING_VALUE',
                            // ... more items ...
                        ],
                        ProjectionType: 'ALL | KEYS_ONLY | INCLUDE',
                    },
                },
                // ... more local secondary indexes ...
            ],
        };
        dynamodb.createTable(params, function(err, data) {
            if (err) print(err); // an error occurred
            else print(data); // successful response
        
        });"""
  ,
    name: "AttributeDefinitions"
    tabTrigger: "AttributeDefinitions"
    content:"""
        AttributeDefinitions: [ // The names and types of all primary and index key attributes only
            {
                AttributeName: 'attribute_name',
                AttributeType: 'S', // (S | N | B) for string, number, binary
            },
            // ... more attributes ...
        ],"""
  ,
    name: "AttributeDefinition"
    tabTrigger: "AttributeDefinition"
    content:"""
        {
            AttributeName: 'attribute_name',
            AttributeType: 'S', // (S | N | B) for string, number, binary
        
        },"""
  ,
    name: "GlobalSecondaryIndex"
    tabTrigger: "GlobalSecondaryIndex"
    content:"""
        { 
            IndexName: 'index_name', 
            KeySchema: [
                { // Required HASH type attribute
                    AttributeName: 'hash_key_attribute_name',
                    KeyType: 'HASH',
                },
                { // Optional RANGE key type for HASH + RANGE secondary indexes
                    AttributeName: 'range_key_attribute_name', 
                    KeyType: 'RANGE', 
                }
            ],
            Projection: { // attributes to project into the index
                ProjectionType: 'ALL', // (ALL | KEYS_ONLY | INCLUDE)
                NonKeyAttributes: [ // required / allowed only for INCLUDE
                    'attribute_name_1',
                    // ... more attribute names ...
                ],
            },
            ProvisionedThroughput: { // throughput to provision to the index
                ReadCapacityUnits: 0,
                WriteCapacityUnits: 0,
            },
        },"""
  ,
    name: "GlobalSecondaryIndexes"
    tabTrigger: "GlobalSecondaryIndexes"
    content:"""
        GlobalSecondaryIndexes: [ // optional (list of GlobalSecondaryIndex)
            { 
                IndexName: 'index_name_1', 
                KeySchema: [
                    { // Required HASH type attribute
                        AttributeName: 'hash_key_attribute_name',
                        KeyType: 'HASH',
                    },
                    { // Optional RANGE key type for HASH + RANGE secondary indexes
                        AttributeName: 'range_key_attribute_name', 
                        KeyType: 'RANGE', 
                    }
                ],
                Projection: { // attributes to project into the index
                    ProjectionType: 'ALL', // (ALL | KEYS_ONLY | INCLUDE)
                    NonKeyAttributes: [ // required / allowed only for INCLUDE
                        'attribute_name_1',
                        // ... more attribute names ...
                    ],
                },
                ProvisionedThroughput: { // throughput to provision to the index
                    ReadCapacityUnits: 0,
                    WriteCapacityUnits: 0,
                },
            },
            // ... more global secondary indexes ...
        ],
        """
  ,
    name: "LocalSecondaryIndex"
    tabTrigger: "LocalSecondaryIndex"
    content:"""
        { 
            IndexName: 'index_name',
            KeySchema: [ 
                { // Required HASH type attribute - must match the table's HASH key attribute name
                    AttributeName: 'hash_key_attribute_name',
                    KeyType: 'HASH',
                },
                { // alternate RANGE key attribute for the secondary index
                    AttributeName: 'range_key_attribute_name', 
                    KeyType: 'RANGE', 
                }
            ],
            Projection: { // required
                NonKeyAttributes: [
                    'STRING_VALUE',
                    // ... more items ...
                ],
                ProjectionType: 'ALL | KEYS_ONLY | INCLUDE',
            },
        
        },"""
  ,
    name: "LocalSecondaryIndexes"
    tabTrigger: "LocalSecondaryIndexes"
    content:"""
        LocalSecondaryIndexes: [ // optional (list of LocalSecondaryIndex)
            { 
                IndexName: 'index_name',
                KeySchema: [ 
                    { // Required HASH type attribute - must match the table's HASH key attribute name
                        AttributeName: 'hash_key_attribute_name',
                        KeyType: 'HASH',
                    },
                    { // alternate RANGE key attribute for the secondary index
                        AttributeName: 'range_key_attribute_name', 
                        KeyType: 'RANGE', 
                    }
                ],
                Projection: { // required
                    NonKeyAttributes: [
                        'STRING_VALUE',
                        // ... more items ...
                    ],
                    ProjectionType: 'ALL | KEYS_ONLY | INCLUDE',
                },
            },
            // ... more local secondary indexes ...
        ],"""
  ,
    name: "ProvisionedThroughput"
    tabTrigger: "ProvisionedThroughput"
    content:"""
        ProvisionedThroughput: {
            ReadCapacityUnits: 0, 
            WriteCapacityUnits: 0, 
        },"""
  ,
    name: "KeySchema"
    tabTrigger: "KeySchema"
    content:"""
        KeySchema: [ // The type of of schema.  Must start with a HASH type, with an optional second RANGE.
            { // Required HASH type attribute
                AttributeName: 'hash_key_attribute_name',
                KeyType: 'HASH',
            },
            { // Optional RANGE key type
                AttributeName: 'range_key_attribute_name', 
                KeyType: 'RANGE', 
            }
        ],"""
  ,
    name: "deleteItem"
    tabTrigger: "deleteItem"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            Key: { // a map of attribute name to AttributeValue for all primary key attributes
            
                attribute_name: 'STRING_VALUE'
                // more attributes...
        
            },
            Expected: [ // Optional list of Condition objects
                dynamodb.Condition('attribute_1', "NOT_NULL"),
                dynamodb.Condition('attribute_2', 'EQ', 'expected_value'), 
                // more attributes...
            ],
            ReturnValues: 'NONE', // optional (NONE | ALL_OLD)
            ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)
            ReturnItemCollectionMetrics: 'NONE', // optional (NONE | SIZE)
        };
        dynamodb.deleteItem(params, function(err, data) {
            if (err) print(err); // an error occurred
            else print(data); // successful response
        });"""
  ,
    name: "deleteTable"
    tabTrigger: "deleteTable"
    content:"""
        var params = {
            TableName: '${1:table_name}',
        };
        dynamodb.deleteTable(params, function(err, data) {
            if (err) print(err); // an error occurred
            else print(data); // successful response
        });"""
  ,
    name: "describeTable"
    tabTrigger: "describeTable"
    content:"""
        var params = {
            TableName: '${1:table_name}',
        };
        dynamodb.describeTable(params, function(err, data) {
            if (err) print(err); // an error occurred
            else print(data); // successful response
        });"""
  ,
    name: "describeTables (all)"
    tabTrigger: "describeTables-all"
    content:"""
dynamodb.listTables().eachPage(function(err, data) {
    if (err) {
        print(err); // an error occurred
    } else if (data) {
        for (var i in data.TableNames) {
            var tableName = data.TableNames[i];
            var params = {
                TableName: tableName,
            };
            dynamodb.describeTable(params, function(err, data) {
                if (err) print(err); // an error occurred
                else print(data); // successful response
            });
        }
    }
});"""
  ,
    name: "getItem"
    tabTrigger: "getItem"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            Key: { // a map of attribute name to AttributeValue for all primary key attributes
            
                attribute_name: 'STRING_VALUE'
                // more attributes...
        
            },
            AttributesToGet: [ // optional (list of specific attribute names to return)
                'attribute_name',
                // ... more attribute names ...
            ],
            ConsistentRead: false, // optional (true | false)
            ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)
        };
        dynamodb.getItem(params, function(err, data) {
            if (err) print(err); // an error occurred
            else print(data); // successful response
        });"""
  ,
    name: "getItem (basic)"
    tabTrigger: "getItem-basic"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            Key: { // a map of attribute name to AttributeValue for all primary key attributes
            
                attribute_name: 'STRING_VALUE'
                // more attributes...
        
            },
            // ... other optional parameters ...
        };
        dynamodb.getItem(params, function(err, data) {
            if (err) print(err); // an error occurred
            else print(data); // successful response
        });"""
  ,
    name: "Key"
    tabTrigger: "Key"
    content:"""
        Key: { // a map of attribute name to AttributeValue for all primary key attributes
        
            attribute_name: 'STRING_VALUE'
            // more attributes...
        
        }"""
  ,
    name: "listTables"
    tabTrigger: "listTables"
    content:"""
        var params = {
            ExclusiveStartTableName: '${1:table_name}', // optional (for pagination, returned as LastEvaluatedTableName)
            Limit: 0, // optional (to further limit the number of table names returned per page)
        };
        dynamodb.listTables(params, function(err, data) {
            if (err) print(err); // an error occurred
            else print(data); // successful response
        
        });"""
  ,
    name: "listTables (all)"
    tabTrigger: "listTables-all"
    content:"""
dynamodb.listTables().eachPage(function(err, data) {
    if (err) {
        print(err); // an error occurred
    } else if (data) {
        print(data);
    }
});"""
  ,
    name: "listTables (and describe)"
    tabTrigger: "listTables-and-describe"
    content:"""
dynamodb.listTables().eachPage(function(err, data) {
    if (err) {
        print(err); // an error occurred
    } else if (data) {
        for (var i in data.TableNames) {
            var tableName = data.TableNames[i];
            var params = {
                TableName: tableName,
            };
            dynamodb.describeTable(params, function(err, data) {
                if (err) print(err); // an error occurred
                else print(data); // successful response
            });
        }
    }
});"""
  ,
    name: "putItem"
    tabTrigger: "putItem"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            Item: { // a map of attribute name to AttributeValue
            
                ${2:attribute_name}: '${3:STRING_VALUE}'
                // more attributes...
            },
            Expected: [ // Optional list of Condition objects
                dynamodb.Condition('attribute_1', "NOT_NULL"),
                dynamodb.Condition('attribute_2', 'EQ', 'expected_value'), 
                // more attributes...
            ],
            ReturnValues: '${6:NONE}', // optional (NONE | ALL_OLD)
            ReturnConsumedCapacity: '${7:NONE}', // optional (NONE | TOTAL | INDEXES)
            ReturnItemCollectionMetrics: '${8:NONE}', // optional (NONE | SIZE)
        };
        dynamodb.putItem(params, function(err, data) {
            if (err) print(err); // an error occurred
            else print(data); // successful response
        });"""
  ,
    name: "putItem (required only)"
    tabTrigger: "putItem-required"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            Item: { // a map of attribute name to AttributeValue
                
                attribute_name: 'STRING_VALUE'
                // more attributes...
            }
        };
        dynamodb.putItem(params, function(err, data) {
            if (err) print(err); // an error occurred
            else print(data); // successful response
        });"""
  ,
    name: "putItem (conditional)"
    tabTrigger: "putItem-conditional"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            Item: { // a map of attribute name to AttributeValue
            
                attribute_name: 'STRING_VALUE'
                // more attributes...
            },
            Expected: [ // Optional list of Condition objects
                dynamodb.Condition('attribute_1', "NOT_NULL"),
                dynamodb.Condition('attribute_2', 'EQ', 'expected_value'), 
                // more attributes...
            ],
            ReturnValues: 'NONE', // optional (NONE | ALL_OLD)
        };
        dynamodb.putItem(params, function(err, data) {
            if (err) print(err); // an error occurred
            else print(data); // successful response
        });"""
  ,
    name: "query"
    tabTrigger: "query"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            IndexName: 'index_name', // optional (if querying an index)
            // indexed attributes to query must include the hash key value of the table or index 
            // with 'EQ' operator. Range conditions: EQ | NE | IN | LE | LT | GE | GT |
            // BETWEEN | NOT_NULL | NULL | CONTAINS | NOT_CONTAINS | BEGINS_WITH)
            KeyConditions: [
                dynamodb.Condition('attribute_name', 'EQ', 'STRING_VALUE'),
                // optional range key condition ...
            ],
            ScanIndexForward: true, // optional (true | false) defines direction of Query in the index
            Limit: 0, // optional (limit the number of items to evaluate)
            ConsistentRead: false, // optional (true | false)
            Select: 'ALL_ATTRIBUTES', // optional (ALL_ATTRIBUTES | ALL_PROJECTED_ATTRIBUTES | 
                                      //           SPECIFIC_ATTRIBUTES | COUNT)
            AttributesToGet: [ // optional (list of specific attribute names to return)
                'attribute_name',
                // ... more attributes ...
            ],
            ExclusiveStartKey: { // optional (for pagination, returned by prior calls as LastEvaluatedKey)
                attribute_name: 'STRING_VALUE',
                // anotherKey: ...
        
            },
            ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)
        };
        dynamodb.query(params, function(err, data) {
            if (err) print(err); // an error occurred
            else print(data); // successful response
        });"""
  ,
    name: "query (and paginate)"
    tabTrigger: "query-paginate"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            // indexed attributes to query must include the hash key value of the table or index 
            // with 'EQ' operator. Range conditions: EQ | NE | IN | LE | LT | GE | GT |
            // BETWEEN | NOT_NULL | NULL | CONTAINS | NOT_CONTAINS | BEGINS_WITH)
            KeyConditions: [
                dynamodb.Condition('attribute_name', 'EQ', 'STRING_VALUE'),
                // optional range key condition ...
            ]
        };
        
        // A callback that paginates through an entire DynamoDB table
        function doQuery(response) {
            console.log(response.error);
            if (response.error) print(response.error); // an error occurred
            else {
                print(response.data); // successful response
                
                // More data.  Keep calling query.
                if ('LastEvaluatedKey' in response.data) {
                    response.request.params.ExclusiveStartKey = response.data.LastEvaluatedKey;
                    dynamodb.query(response.request.params)
                        .on('complete', doQuery)
                        .send();
              } 
            }
        }
        
        // Kick off the query
        console.log("Starting a Query on the table");
        dynamodb.query(params)
            .on('complete', doQuery)
            .send();"""
  ,
    name: "query (basic)"
    tabTrigger: "query-basic"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            // indexed attributes to query must include the hash key value of the table or index 
            // with 'EQ' operator. Range conditions: EQ | NE | IN | LE | LT | GE | GT |
            // BETWEEN | NOT_NULL | NULL | CONTAINS | NOT_CONTAINS | BEGINS_WITH)
            KeyConditions: [
                dynamodb.Condition('attribute_name', 'EQ', 'STRING_VALUE'),
                // optional range key condition ...
            ],
        };
        dynamodb.query(params, function(err, data) {
            if (err) print(err); // an error occurred
            else print(data); // successful response
        
        });"""
  ,
    name: "KeyConditions"
    tabTrigger: "KeyConditions"
    content:"""
        // indexed attributes to query must include the hash key value of the table or index 
        // with 'EQ' operator. Range conditions: EQ | NE | IN | LE | LT | GE | GT |
        // BETWEEN | NOT_NULL | NULL | CONTAINS | NOT_CONTAINS | BEGINS_WITH)
        KeyConditions: [
            dynamodb.Condition('attribute_name', 'EQ', 'STRING_VALUE'),
            // optional range key condition ...
        ],"""
  ,
    name: "ConsistentRead"
    tabTrigger: "ConsistentRead"
    content:"""
        ConsistentRead: true,"""
  ,
    name: "scan"
    tabTrigger: "scan"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            Limit: 0, // optional (limit the number of items to evaluate)
            ScanFilter: [ // Optional list of Condition objects
                dynamodb.Condition('attribute_1', "NOT_NULL"),
                dynamodb.Condition('attribute_2', 'EQ', 'expected_value'), 
                // more attriubtes
            ],
            Select: 'ALL_ATTRIBUTES', // optional (ALL_ATTRIBUTES | ALL_PROJECTED_ATTRIBUTES | 
                                      //           SPECIFIC_ATTRIBUTES | COUNT)
            AttributesToGet: [ // optional (list of specific attribute names to return)
                'attribute_name',
                // ... more attributes ...
            ],
            Segment: 0, // optional (for parallel scan)
            TotalSegments: 0, // optional (for parallel scan)
            ExclusiveStartKey: { // optional (for pagination, returned by prior calls as LastEvaluatedKey)
                attribute_name: 'STRING_VALUE',
                // anotherKey: ...
            },
            ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)
        };
        dynamodb.scan(params, function(err, data) {
            if (err) print(err); // an error occurred
            else print(data); // successful response
        });"""
  ,
    name: "scan (basic)"
    tabTrigger: "scan-basic"
    content:"""
        var params = {
            TableName: '${1:table_name}',
        };
        dynamodb.scan(params, function(err, data) {
            if (err) print(err); // an error occurred
            else print(data); // successful response
        });"""
  ,
    name: "scan (and paginate)"
    tabTrigger: "scan-paginate"
    content:"""
        var params = {
            TableName: '${1:table_name}'
            // ... other optional parameters like Limit or ScanFilter ...
        };
        
        // A callback that paginates through an entire DynamoDB table
        function doScan(response) {
            if (response.error) print(response.error); // an error occurred
            else {
                print(response.data); // successful response
                
                // More data.  Keep calling scan.
                if ('LastEvaluatedKey' in response.data) {
                    response.request.params.ExclusiveStartKey = response.data.LastEvaluatedKey;
                    dynamodb.scan(response.request.params)
                        .on('complete', doScan)
                        .send();
              } 
            }
        }
        
        // Kick off the scan
        console.log("Starting a Scan of the table");
        dynamodb.scan(params)
            .on('complete', doScan)
            .send();"""
  ,
    name: "Condition"
    tabTrigger: "Condition"
    content:"""
        // Range conditions: EQ | NE | IN | LE | LT | GE | GT |
        // BETWEEN | NOT_NULL | NULL | CONTAINS | NOT_CONTAINS | BEGINS_WITH)
        dynamodb.Condition('attribute_name', 'EQ', 'STRING_VALUE'),"""
  ,
    name: "ScanFilter"
    tabTrigger: "ScanFilter"
    content:"""
        ScanFilter: [ // Optional list of Condition objects
            dynamodb.Condition('attribute_1', "NOT_NULL"),
            dynamodb.Condition('attribute_2', 'EQ', 'expected_value'), 
            // more attriubtes
        ],"""
  ,
    name: "updateItem"
    tabTrigger: "updateItem"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            Key: { // The primary key of the item (a map of attribute name to AttributeValue)
        
                attribute_name: 'STRING_VALUE'
                // more attributes...
            },
            AttributeUpdates: { // The attributes to update (map of attribute name to AttributeValueUpdate)
        
                attribute_name: {
                    Action: 'PUT', // PUT (replace)
                                   // ADD (adds to number or set)
                                   // DELETE (delete attribute or remove from set)
                    Value: 'STRING_VALUE'
                },
                // more attribute updates: ...
            },
            Expected: [ // Optional list of Condition objects
                dynamodb.Condition('attribute_1', "NOT_NULL"),
                dynamodb.Condition('attribute_2', 'EQ', 'expected_value'), 
                // more attributes...
            ],
            ReturnValues: 'NONE', // optional (NONE | ALL_OLD | UPDATED_OLD | ALL_NEW | UPDATED_NEW)
            ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)
            ReturnItemCollectionMetrics: 'NONE', // optional (NONE | SIZE)
        };
        dynamodb.updateItem(params, function(err, data) {
            if (err) print(err); // an error occurred
            else print(data); // successful response
        });"""
  ,
    name: "updateItem (required)"
    tabTrigger: "updateItem-required"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            Key: { // The primary key of the item (a map of attribute name to AttributeValue)
        
                attribute_name: 'STRING_VALUE'
                // more attributes...
            },
            AttributeUpdates: { // The attributes to update (map of attribute name to AttributeValueUpdate)
        
                attribute_name: {
                    Action: 'PUT', // PUT (replace)
                                   // ADD (adds to number or set)
                                   // DELETE (delete attribute or remove from set)
                    Value: 'STRING_VALUE'
                },
                // more attribute updates: ...
            }
        };
        dynamodb.updateItem(params, function(err, data) {
            if (err) print(err); // an error occurred
            else print(data); // successful response
        });"""
  ,
    name: "updateItem (conditional)"
    tabTrigger: "updateItem-conditional"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            Key: { // The primary key of the item (a map of attribute name to AttributeValue)
        
                attribute_name: 'STRING_VALUE'
                // more attributes...
            },
            AttributeUpdates: { // The attributes to update (map of attribute name to AttributeValueUpdate)
        
                attribute_name: {
                    Action: 'PUT', // PUT (replace)
                                   // ADD (adds to number or set)
                                   // DELETE (delete attribute or remove from set)
                    Value: 'STRING_VALUE'
                },
                // more attribute updates: ...
            },
            Expected: [ // Optional list of Condition objects
                dynamodb.Condition('attribute_1', "NOT_NULL"),
                dynamodb.Condition('attribute_2', 'EQ', 'expected_value'), 
                // more attributes...
            ],
            ReturnValues: 'NONE', // optional (NONE | ALL_OLD | UPDATED_OLD | ALL_NEW | UPDATED_NEW)
        };
        dynamodb.updateItem(params, function(err, data) {
            if (err) print(err); // an error occurred
            else print(data); // successful response
        });"""
  ,
    name: "updateItem (expressions)"
    tabTrigger: "updateItem-expressions"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            Key: { // The primary key of the item (a map of attribute name to AttributeValue)
        
                attribute_name: 'STRING_VALUE'
                // more attributes...
            },
            UpdateExpression: 'set foo = :bar',
            ConditionExpression: 'status = :expected_status'
            ExpressionAttributeValues: {
                :bar : 123,
                :expected_status : 'ACTIVE'
            },
            ReturnValues: 'NONE', // optional (NONE | ALL_OLD | UPDATED_OLD | ALL_NEW | UPDATED_NEW)
        };
        dynamodb.updateItem(params, function(err, data) {
            if (err) print(err); // an error occurred
            else print(data); // successful response
        });"""
  ,
    name: "Expected"
    tabTrigger: "Expected"
    content:"""
        Expected: [ // Optional list of Condition objects
            dynamodb.Condition('attribute_1', "NOT_NULL"),
            dynamodb.Condition('attribute_2', 'EQ', 'expected_value'), 
            // more attributes...
        ],"""
  ,
    name: "AttributeUpdates"
    tabTrigger: "AttributeUpdates"
    content:"""
        AttributeUpdates: { // The attributes to update (map of attribute name to AttributeValueUpdate)
    
            attribute_name: {
                Action: 'PUT', // PUT (replace)
                               // ADD (adds to number or set)
                               // DELETE (delete attribute or remove from set)
                Value: 'STRING_VALUE'
            },
            // more attribute updates: ...
    
        },"""
  ,
    name: "AttributeValueUpdate"
    tabTrigger: "AttributeValueUpdate"
    content:"""
        {
            Action: 'PUT', // PUT (replace)
                           // ADD (adds to number or set)
                           // DELETE (delete attribute or remove from set)
            Value: 'STRING_VALUE'
        }"""
  ,
    name: "ExpectedAttributeValue"
    tabTrigger: "ExpectedAttributeValue"
    content:"""
        {
            Exists: true, // optional (if false, Value must be null)
            Value: 'STRING_VALUE'
        
        }"""
  ,
    name: "updateTable"
    tabTrigger: "updateTable"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            GlobalSecondaryIndexUpdates: [{ // optional
                    Update: {
                        IndexName: 'index_name',
                        ProvisionedThroughput: {
                            ReadCapacityUnits: 0, 
                            WriteCapacityUnits: 0,
                        },
                    },
                },
                // ... more optional indexes ...
            ],
            ProvisionedThroughput: {
                ReadCapacityUnits: 0,
                WriteCapacityUnits: 0,
            },
        };
        dynamodb.updateTable(params, function(err, data) {
            if (err) print(err); // an error occurred
            else print(data); // successful response
        });"""
  ,
    name: "updateTable (table throughput)"
    tabTrigger: "updateTable-table"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            ProvisionedThroughput: {
                ReadCapacityUnits: 0,
                WriteCapacityUnits: 0,
            },
        };
        dynamodb.updateTable(params, function(err, data) {
            if (err) print(err); // an error occurred
            else print(data); // successful response
        });"""
  ,
    name: "updateTable (index throughput)"
    tabTrigger: "updateTable-index"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            GlobalSecondaryIndexUpdates: [{ // optional
                    Update: {
                        IndexName: 'index_name',
                        ProvisionedThroughput: {
                            ReadCapacityUnits: 0, 
                            WriteCapacityUnits: 0,
                        },
                    },
                },
                // ... more optional indexes ...
            ],
        };
        dynamodb.updateTable(params, function(err, data) {
            if (err) print(err); // an error occurred
            else print(data); // successful response
        });"""
  ,
    content:"""
    var params = {
        TableName: '${1:STRING_VALUE}', // required
    };
    dynamodb.waitFor('tableExists', params, function(err, data) {
        if (err) print(err); // an error occurred
        else print(data); // successful response
    });"""
    name: "waitFor"
    tabTrigger: "waitFor"
	]


