/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.embedded;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.local.embedded.DDBExceptionMappingInvocationHandler;
import com.amazonaws.services.dynamodbv2.local.shared.access.AmazonDynamoDBLocal;
import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDBClient;
import com.amazonaws.services.dynamodbv2.local.shared.access.sqlite.SQLiteDBAccess;
import com.amazonaws.services.dynamodbv2.local.shared.jobs.JobsRegister;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DynamoDBEmbedded {
    public static final String SQLITE4JAVA_PKG = "com.almworks.sqlite4java";

    public static AmazonDynamoDBLocal create() {
        return DynamoDBEmbedded.create(null);
    }

    public static AmazonDynamoDBLocal create(File file) {
        JobsRegister jobs = new JobsRegister(Executors.newFixedThreadPool(10), false);
        LocalDBClient impl = new LocalDBClient(file == null ? new SQLiteDBAccess() : new SQLiteDBAccess(file), jobs);
        return (AmazonDynamoDBLocal)Proxy.newProxyInstance(AmazonDynamoDB.class.getClassLoader(), new Class[]{AmazonDynamoDBLocal.class}, (InvocationHandler)new DDBExceptionMappingInvocationHandler(impl));
    }

    static {
        Logger.getLogger(SQLITE4JAVA_PKG).setLevel(Level.OFF);
    }
}

