(function() {
  var $;

  $ = jQuery;

  $.extend(REPLIT, {
    exampleContent: [
      {
        name: "ListTables",
        sdkLink: "http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#listTables-property",
        apiLink: "http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ListTables.html",
        code: "var params = {\n    /*\n    // optional (for pagination, returned as LastEvaluatedTableName)\n    ExclusiveStartTableName: 'table_name',\n\n    // optional (to further limit the number of table names returned per page)\n    Limit: 1 \n    */\n};\ndynamodb.listTables(params, function(err, data) {\n    if (err) console.log(err, err.stack); // an error occurred\n    else     console.log(data);           // successful response\n});"
      }, {
        name: "CreateTable",
        sdkLink: "http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#createTable-property",
        apiLink: "http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_CreateTable.html",
        code: "var params = {\n    TableName: 'table_name',\n    KeySchema: [ // The type of of schema.  Must start with a HASH type, with an optional second RANGE.\n        { // Required HASH type attribute\n            AttributeName: 'hash_key_attribute_name',\n            KeyType: 'HASH',\n        },\n        { // Optional RANGE key type for HASH + RANGE tables\n            AttributeName: 'range_key_attribute_name',\n            KeyType: 'RANGE',\n        }\n    ],\n    AttributeDefinitions: [ // The names and types of all primary and index key attributes only\n        {\n            AttributeName: 'hash_key_attribute_name',\n            AttributeType: 'S', // (S | N | B) for string, number, binary\n        },\n        {\n            AttributeName: 'range_key_attribute_name',\n            AttributeType: 'S', // (S | N | B) for string, number, binary\n        },\n        {\n            AttributeName: 'index_hash_key_attribute_name_1',\n            AttributeType: 'S', // (S | N | B) for string, number, binary\n        },\n        {\n            AttributeName: 'index_range_key_attribute_name_1',\n            AttributeType: 'S', // (S | N | B) for string, number, binary\n        },\n        {\n            AttributeName: 'index_range_key_attribute_name_2',\n            AttributeType: 'S', // (S | N | B) for string, number, binary\n        },\n        \n        // ... more attributes ...\n    ],\n    ProvisionedThroughput: { // required provisioned throughput for the table\n        ReadCapacityUnits: 1, \n        WriteCapacityUnits: 1, \n    },\n    GlobalSecondaryIndexes: [ // optional (list of GlobalSecondaryIndex)\n        { \n            IndexName: 'index_name_1', \n            KeySchema: [\n                { // Required HASH type attribute\n                    AttributeName: 'index_hash_key_attribute_name_1',\n                    KeyType: 'HASH',\n                },\n                { // Optional RANGE key type for HASH + RANGE secondary indexes\n                    AttributeName: 'index_range_key_attribute_name_1', \n                    KeyType: 'RANGE', \n                }\n            ],\n            Projection: { // attributes to project into the index\n                ProjectionType: 'INCLUDE', // (ALL | KEYS_ONLY | INCLUDE)\n                NonKeyAttributes: [ // required / allowed only for INCLUDE\n                    'attribute_name_1',\n                    // ... more attribute names ...\n                ],\n            },\n            ProvisionedThroughput: { // throughput to provision to the index\n                ReadCapacityUnits: 1,\n                WriteCapacityUnits: 1,\n            },\n        },\n        // ... more global secondary indexes ...\n    ],\n    LocalSecondaryIndexes: [ // optional (list of LocalSecondaryIndex)\n        { \n            IndexName: 'index_name_2',\n            KeySchema: [ \n                { // Required HASH type attribute - must match the table's HASH key attribute name\n                    AttributeName: 'hash_key_attribute_name',\n                    KeyType: 'HASH',\n                },\n                { // alternate RANGE key attribute for the secondary index\n                    AttributeName: 'index_range_key_attribute_name_2', \n                    KeyType: 'RANGE', \n                }\n            ],\n            Projection: { // required\n                ProjectionType: 'INCLUDE', // (ALL | KEYS_ONLY | INCLUDE)\n                NonKeyAttributes: [ // required / allowed only for INCLUDE\n                    'attribute_name_1',\n                    // ... more attribute names ...\n                ],\n            },\n        },\n        // ... more local secondary indexes ...\n    ],\n};\ndynamodb.createTable(params, function(err, data) {\n    if (err) print(err); // an error occurred\n    else print(data); // successful response\n});"
      }, {
        name: "WaitFor",
        sdkLink: "http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#waitFor-property",
        apiLink: "",
        code: "// Waits for table to become ACTIVE.  \n// Useful for waiting for table operations like CreateTable to complete. \nvar params = {\n    TableName: 'table_name',\n};\n// Supports 'tableExists' and 'tableNotExists'\ndynamodb.waitFor('tableExists', params, function(err, data) {\n    if (err) print(err); // an error occurred\n    else print(data); // successful response\n});"
      }, {
        name: "UpdateTable",
        sdkLink: "http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#updateTable-property",
        apiLink: "http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_UpdateTable.html",
        code: "// Update Base Table Throughput\nvar params = {\n    TableName: 'table_name',\n    ProvisionedThroughput: {\n        ReadCapacityUnits: 2,\n        WriteCapacityUnits: 2,\n    }\n};\n\n// Update Global Secondary Index Throughput\nvar params = {\n    TableName: 'table_name',\n    GlobalSecondaryIndexUpdates: [\n        {\n            Update: {\n                IndexName: 'index_name_1',\n                ProvisionedThroughput: {\n                    ReadCapacityUnits: 2,\n                    WriteCapacityUnits: 2\n                }\n            }\n        },\n        // ... more optional indexes ...\n    ]\n};\n\n// Add Global Secondary Index\nvar params = {\n    TableName: 'table_name',\n    AttributeDefinitions: [ // only required if adding new index\n        {\n            AttributeName: 'index_hash_key_attribute_name_3',\n            AttributeType: 'S' // (S | N | B) for string, number, binary\n        },\n        // ... more attributes ...\n    ],\n    GlobalSecondaryIndexUpdates: [\n        {\n            Create: {\n                IndexName: 'index_name_3',\n                KeySchema: [\n                    {\n                        AttributeName: 'index_hash_key_attribute_name_3',\n                        KeyType: 'HASH'\n                    },\n                    // optional RANGE key\n                ],\n                Projection: { // attributes to project into the index\n                    ProjectionType: 'KEYS_ONLY', // (ALL | KEYS_ONLY | INCLUDE)\n                },\n                ProvisionedThroughput: {\n                    ReadCapacityUnits: 1,\n                    WriteCapacityUnits: 1\n                }\n            }\n        },\n        // ... more optional indexes ...\n    ],\n};\n\n// Delete Global Secondary Index\nvar params = {\n    TableName: 'table_name',\n    GlobalSecondaryIndexUpdates: [\n        {\n            Delete: {\n                IndexName: 'index_name_3'\n            }\n        },\n        // ... more optional indexes ...\n    ]\n};\n\ndynamodb.updateTable(params, function(err, data) {\n    if (err) print(err); // an error occurred\n    else print(data); // successful response\n});"
      }, {
        name: "DescribeTable",
        sdkLink: "http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#describeTable-property",
        apiLink: "http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DescribeTable.html",
        code: "var params = {\n    TableName: 'table_name',\n};\ndynamodb.describeTable(params, function(err, data) {\n    if (err) print(err); // an error occurred\n    else print(data); // successful response\n});"
      }, {
        name: "PutItem",
        sdkLink: "http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#putItem-property",
        apiLink: "http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_PutItem.html",
        code: "// Basic PutItem\nvar params = {\n    TableName: 'table_name',\n    Item: { // a map of attribute name to AttributeValue\n    \n        // attribute_name: attribute_value,\n        // Note: attribute_value (string | number | boolean | null | Uint8Array | dynamodb.Set(array, S|N|B) | Array | Object)\n\n        // primary keys are required\n        hash_key_attribute_name: 'attribute_value',\n        range_key_attribute_name: 'range_attribute_value', // optional if table is hash-only\n\n        Price: 500,\n        InStock: true,\n        QuantityOnHand: null,\n        Pic: dynamodb.StrToBin(\"someURI\"),\n        Color: dynamodb.Set([\"Red\", \"Black\"], \"S\"),\n        RelatedItems: [341, 472, 649],\n        ProductReviews: {\n            FiveStar: [\n               \"Excellent! Can't recommend it highly enough!  Buy it!\",\n               \"Do yourself a favor and buy this.\"\n            ],\n            OneStar: [\n               \"Terrible product!  Do not buy this.\"\n            ]\n        }\n        // more attributes ...\n    },\n    ReturnValues: 'NONE', // optional (NONE | ALL_OLD)\n    ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)\n    ReturnItemCollectionMetrics: 'NONE', // optional (NONE | SIZE)\n};\n\n// See http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html for more details on expression language\n// Conditional Put - Put if doesn't already exist\nvar params = {\n    TableName: 'table_name',\n    Item: {\n        hash_key_attribute_name: 'attribute_value',\n        range_key_attribute_name: 'range_attribute_value', // optional if table is hash-only\n    },\n\n    // put if doesn't already exist\n    ConditionExpression: 'attribute_not_exists(hash_key_attribute_name) AND attribute_not_exists(range_key_attribute_name)',\n};\n\n// // Conditional Put - Expression Attribute Names and Values\nvar params = {\n    TableName: 'table_name',\n    Item: {\n        hash_key_attribute_name: 'attribute_value',\n        range_key_attribute_name: 'range_attribute_value', // optional if table is hash-only\n    },\n\n    // Put if existing ProductReviews.FiveStar is a list data type\n    ConditionExpression: 'attribute_type(#pr.FiveStar, :val)',\n    ExpressionAttributeNames: {\n        '#pr': 'ProductReviews',\n        // ... more expression attribute names ...\n    },\n    ExpressionAttributeValues: {\n        ':val': 'L',\n        // ... more expression attribute values ...\n    }\n};\n\ndynamodb.putItem(params, function(err, data) {\n    if (err) print(err); // an error occurred\n    else print(data); // successful response\n});"
      }, {
        name: "GetItem",
        sdkLink: "http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#getItem-property",
        apiLink: "http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_GetItem.html",
        code: "var params = {\n    TableName: 'table_name',\n    Key: { // required - a map of attribute name to AttributeValue for all primary key attributes\n        hash_key_attribute_name: 'attribute_value', // (string | number | boolean | null | Uint8Array)\n        range_key_attribute_name: 'range_attribute_value', // optional if table is hash-only\n    },\n    \n    // optional - list of attributes to return (default is to return all)\n    ProjectionExpression: 'InStock, QuantityOnHand, ProductReviews.FiveStar, #ri', \n    \n    // optional - used for name substitution (e.g. for convenience or reserved word conflicts)\n    ExpressionAttributeNames: {\n        '#ri': 'RelatedItems',\n        // ... more expression attribute names ...\n    },\n    ConsistentRead: false, // optional (true | false)\n    ReturnConsumedCapacity: 'NONE', // optional (INDEXES | TOTAL | NONE)\n};\ndynamodb.getItem(params, function(err, data) {\n    if (err) print(err); // an error occurred\n    else print(data); // successful response\n});"
      }, {
        name: "UpdateItem",
        sdkLink: "http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#updateItem-property",
        apiLink: "http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_UpdateItem.html",
        code: "var params = {\n    TableName: 'table_name',\n    Key: { // required - a map of attribute name to AttributeValue for all primary key attributes\n        hash_key_attribute_name: 'attribute_value', // (string | number | boolean | null | Uint8Array)\n        range_key_attribute_name: 'range_attribute_value', // optional if table is hash-only\n    },\n\n    /*\n    // optional expression for conditional update\n    ConditionExpression: 'EXPRESSION STRING',\n    */\n\n    // see http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Modifying.html\n    // for more information on expression syntax\n    UpdateExpression: 'SET #list[0] = :val1 REMOVE #m.#nestedField1, #m.#nestedField2 ADD #aNumber :val2 DELETE #aSet :val3',\n    ExpressionAttributeNames: {\n       '#list': 'RelatedItems',\n       '#m': 'ProductReviews',\n       '#nestedField1': 'FiveStar',\n       '#nestedField2': 'OneStar',\n       '#aNumber': 'Price',\n       '#aSet': 'Color'\n    },\n    ExpressionAttributeValues: {\n       ':val1': 9001,\n       ':val2': -499,\n       ':val3': dynamodb.Set([\"Red\"], \"S\")\n    },\n\n    ReturnValues: 'ALL_NEW', // optional (NONE | ALL_OLD | UPDATED_OLD | ALL_NEW | UPDATED_NEW)\n    ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)\n    ReturnItemCollectionMetrics: 'NONE', // optional (NONE | SIZE)\n};\ndynamodb.updateItem(params, function(err, data) {\n    if (err) print(err); // an error occurred\n    else print(data); // successful response\n});"
      }, {
        name: "DeleteItem",
        sdkLink: "http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#deleteItem-property",
        apiLink: "http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteItem.html",
        code: "var params = {\n    TableName: 'table_name',\n    Key: { // required - a map of attribute name to AttributeValue for all primary key attributes\n        hash_key_attribute_name: 'attribute_value', // (string | number | boolean | null | Uint8Array)\n        range_key_attribute_name: 'range_attribute_value', // optional if table is hash-only\n    },\n\n    /*\n    // optional - expression to make delete conditional\n    ConditionExpression: 'EXPRESSION STRING',\n    ExpressionAttributeNames: {\n        someKey: 'STRING_VALUE',\n        // ... more expression attribute names ...\n    },\n    ExpressionAttributeValues: {\n        someKey: value,\n        // ... more expression attribute values ...\n    },\n    */\n\n    ReturnValues: 'ALL_OLD', // optional (NONE | ALL_OLD)\n    ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)\n    ReturnItemCollectionMetrics: 'NONE', // optional (NONE | SIZE)\n};\ndynamodb.deleteItem(params, function(err, data) {\n    if (err) print(err); // an error occurred\n    else print(data); // successful response\n});"
      }, {
        name: "BatchWriteItem",
        sdkLink: "http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#batchWriteItem-property",
        apiLink: "http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_BatchWriteItem.html",
        code: "var params = {\n    RequestItems: { // A map of TableName to Put or Delete requests for that table\n        table_name: [ // a list of Put or Delete requests for that table\n            { // An example PutRequest\n                PutRequest: {\n                    Item: { // a map of attribute name to AttributeValue    \n                        hash_key_attribute_name: 'attribute_value',\n                        range_key_attribute_name: 'range_attribute_value', // optional if table is hash-only\n                        // attribute_value (string | number | boolean | null | Uint8Array | dynamodb.Set | Array | Object)\n                        // ... more attributes ...\n                    }\n                }\n            },\n            { // An example DeleteRequest\n                DeleteRequest: {\n                    Key: {  // a map of attribute name to AttributeValue    \n                        hash_key_attribute_name: 'attribute_value2',\n                        range_key_attribute_name: 'range_attribute_value', // optional if table is hash-only\n                        // attribute_value (string | number | boolean | null | Uint8Array | dynamodb.Set | Array | Object)\n                        // ... more attributes ...\n                    }\n                }\n            },\n            // ... more put or delete requests for this table ...\n            {\n                PutRequest: {\n                    Item: {\n                        hash_key_attribute_name: 'attribute_value3',\n                        range_key_attribute_name: 'range_attribute_value3',\n                    }\n                }\n            },\n            {\n                PutRequest: {\n                    Item: {\n                        hash_key_attribute_name: 'attribute_value3',\n                        range_key_attribute_name: 'range_attribute_value4',\n                        index_hash_key_attribute_name_1: 'index_hash_value_1',\n                        index_range_key_attribute_name_1: 'index_range_value_1'\n                    }\n                }\n            },\n        ],\n        // ... more tables ...\n    },\n    ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)\n    ReturnItemCollectionMetrics: 'NONE', // optional (NONE | SIZE)\n};\ndynamodb.batchWriteItem(params, function(err, data) {\n    if (err) print(err); // an error occurred\n    else print(data); // successful response\n});"
      }, {
        name: "BatchGetItem",
        sdkLink: "http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#batchGetItem-property",
        apiLink: "http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_BatchGetItem.html",
        code: "var params = {\n    RequestItems: { // map of TableName to list of Key to get from each table\n        table_name: {\n            Keys: [ // a list of primary key value maps\n                { // required - a map of attribute name to AttributeValue for all primary key attributes\n                    hash_key_attribute_name: 'attribute_value', // (string | number | boolean | null | Uint8Array)\n                    range_key_attribute_name: 'range_attribute_value', // optional if table is hash-only\n                },\n                // ... more keys to get from this table ...\n            ],\n            \n            /*\n            // optional - list of attributes to return (default is to return all)\n            ProjectionExpression: 'EXPRESSION STRING', \n            \n            // optional - used for name substitution (e.g. for convenience or reserved word conflicts)\n            ExpressionAttributeNames: {\n                someKey: value,\n                    // ... more expression attribute values ...\n            },\n            */\n\n            ConsistentRead: false, // optional (true | false)\n        },\n        // ... more tables and keys ...\n    },\n    ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)\n};\ndynamodb.batchGetItem(params, function(err, data) {\n    if (err) print(err); // an error occurred\n    else print(data); // successful response\n});"
      }, {
        name: "Query",
        sdkLink: "http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#query-property",
        apiLink: "http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_Query.html",
        code: "var params = {\n    TableName: 'table_name',\n    // IndexName: 'index_name', // optional (if querying an index)\n\n    // Expression to filter on indexed attributes\n    KeyConditionExpression: '#hashkey = :hk_val AND #rangekey > :rk_val',\n    ExpressionAttributeNames: {\n       '#hashkey': 'hash_key_attribute_name',\n       '#rangekey': 'range_key_attribute_name',\n    },\n    ExpressionAttributeValues: {\n       ':hk_val': 'attribute_value3',\n       ':rk_val': 'range_attribute_value3',\n    },\n\n    /*\n    // optional - list of attributes to return (default is to return all)\n    ProjectionExpression: 'EXPRESSION STRING',\n\n    // optional - filter expression to apply on results of KeyConditionExpression\n    FilterExpression: 'EXPRESSION STRING',\n    */\n\n    ScanIndexForward: true, // optional (true | false) defines direction of Query in the index\n    Limit: 1, // optional (limit the number of items to evaluate)\n    ConsistentRead: false, // optional (true | false)\n    ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)\n\n    /*\n    // optional (for pagination, returned by prior calls as LastEvaluatedKey)\n    ExclusiveStartKey: {\n        attribute_name: attribute_value,\n        // attribute_value (string | number | boolean | null | Uint8Array | dynamodb.Set | Array | Object)\n        // anotherKey: ...\n    },\n    */\n};\ndynamodb.query(params, function(err, data) {\n    if (err) print(err); // an error occurred\n    else print(data); // successful response\n});"
      }, {
        name: "Scan",
        sdkLink: "http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#scan-property",
        apiLink: "http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_Scan.html",
        code: "var params = {\n    TableName: 'table_name',\n    IndexName: 'index_name_1', // optional - name of index to scan\n\n    /*\n    // optional expression to filter results\n    FilterExpression: 'STRING_VALUE',\n    \n    // optional - list of attributes to return (default is to return all)\n    ProjectionExpression: 'STRING_VALUE',\n\n    // optional - if used by relevant expressions\n    ExpressionAttributeNames: {\n        someKey: 'STRING_VALUE',\n        // ... more expression attribute names ...\n    },\n    ExpressionAttributeValues: {\n        someKey: value,\n        // ... more expression attribute values ...\n    },\n\n    Limit: 1, // optional (limit the number of items to evaluate)\n\n    Select: 'ALL_ATTRIBUTES', // optional (ALL_ATTRIBUTES | COUNT)\n\n    ExclusiveStartKey: { // optional (for pagination, returned by prior calls as LastEvaluatedKey)\n        attribute_name: attribute_value,\n        // attribute_value (string | number | boolean | null | Uint8Array | dynamodb.Set | Array | Object)\n        // anotherKey: ...\n    },\n\n    Segment: 0, // optional (for parallel scan)\n\n    TotalSegments: 0, // optional (for parallel scan)\n    \n    ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)\n    */\n};\ndynamodb.scan(params, function(err, data) {\n    if (err) print(err); // an error occurred\n    else print(data); // successful response\n});"
      }, {
        name: "DeleteTable",
        sdkLink: "http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/DynamoDB.html#deleteTable-property",
        apiLink: "http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteTable.html",
        code: "var params = {\n    TableName: 'table_name',\n};\ndynamodb.deleteTable(params, function(err, data) {\n    if (err) print(err); // an error occurred\n    else print(data); // successful response\n});"
      }
    ]
  });

}).call(this);
