/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.server;

import com.amazonaws.services.dynamodbv2.local.server.AbstractLocalDynamoDBServerHandler;
import com.amazonaws.services.dynamodbv2.local.shared.logging.LogManager;
import java.net.SocketException;
import java.net.URL;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;

public class DynamoDBProxyServer {
    private static final String SHELL_CONTEXT_PATH = "/shell";
    private static final String SHELL_CONTEXT_RESOURCE_BASE = ".";
    private static final String[] WELCOME_FILES_LIST = new String[]{"index.html"};
    private static final String RESOURCE_BASE_PATH = "/DynamoDBShell/";
    private final int port;
    private final Server server;
    private final AbstractLocalDynamoDBServerHandler serverHandler;
    protected static Logger logger = LogManager.getLogger(DynamoDBProxyServer.class);

    public DynamoDBProxyServer(int port, AbstractLocalDynamoDBServerHandler a) {
        this.port = port;
        this.server = new Server(this.port);
        this.server.setHandler((Handler)this.setUpShell(a));
        this.serverHandler = a;
    }

    public ContextHandlerCollection setUpShell(AbstractLocalDynamoDBServerHandler a) {
        ContextHandler contextShell = new ContextHandler();
        ContextHandler contextDDB = new ContextHandler();
        contextShell.setContextPath(SHELL_CONTEXT_PATH);
        contextShell.setResourceBase(SHELL_CONTEXT_RESOURCE_BASE);
        ResourceHandler rh = new ResourceHandler();
        rh.setDirectoriesListed(true);
        rh.setWelcomeFiles(WELCOME_FILES_LIST);
        URL resourceBasePath = this.getClass().getResource(RESOURCE_BASE_PATH);
        if (resourceBasePath != null) {
            rh.setResourceBase(resourceBasePath.toExternalForm());
        }
        contextShell.setHandler((Handler)rh);
        contextDDB.setHandler((Handler)a);
        ContextHandlerCollection handler = new ContextHandlerCollection();
        handler.addHandler((Handler)contextDDB);
        handler.addHandler((Handler)contextShell);
        return handler;
    }

    public void start() throws Exception {
        try {
            this.server.start();
        }
        catch (SocketException e) {
            System.err.println(String.format("Could not start server on port %d: %s", this.port, e.getMessage()));
            this.server.stop();
        }
    }

    public void stop() throws Exception {
        this.server.stop();
        this.serverHandler.close();
    }
}

