/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.shared.access;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams;
import com.amazonaws.services.dynamodbv2.local.shared.access.AmazonDynamoDBLocal;
import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDBAccess;
import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDynamoDBClient;
import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDynamoDBStreamsClient;
import com.amazonaws.services.dynamodbv2.local.shared.jobs.JobsRegister;
import com.amazonaws.services.dynamodbv2.local.shared.logging.LogManager;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.Logger;

public class LocalDBClient
implements AmazonDynamoDBLocal {
    private static final Logger logger = LogManager.getLogger(LocalDBClient.class);
    private final LocalDBAccess dbAccess;
    private final JobsRegister jobs;
    private final LocalDynamoDBStreamsClient streamsDynamoDB;
    private final LocalDynamoDBClient dynamoDB;

    @Deprecated
    public LocalDBClient(LocalDBAccess dbAccess) {
        this(dbAccess, new JobsRegister(Executors.newFixedThreadPool(10), false));
    }

    public LocalDBClient(LocalDBAccess dbAccess, JobsRegister jobs) {
        this.dbAccess = dbAccess;
        this.jobs = jobs;
        this.streamsDynamoDB = new LocalDynamoDBStreamsClient(dbAccess, jobs);
        this.dynamoDB = new LocalDynamoDBClient(dbAccess, jobs);
    }

    @Override
    public void dilateEventTimes(long ms) {
        this.streamsDynamoDB.dilateEventTimes(ms);
    }

    @Override
    public void triggerShardRollovers() {
        this.streamsDynamoDB.triggerShardRollovers();
    }

    @Override
    public AmazonDynamoDB amazonDynamoDB() {
        return this.dynamoDB;
    }

    @Override
    public AmazonDynamoDBStreams amazonDynamoDBStreams() {
        return this.streamsDynamoDB;
    }

    @Override
    public void shutdown() {
        logger.info("Shutting down");
        this.jobs.shutdown();
        this.dbAccess.close();
    }
}

