$ = jQuery

$.extend REPLIT,
	setSnippets: (m)->
    m.snippets.concat(@snippetContents)

  snippetContents: [
    name: "AttributeValue"
    tabTrigger: "AttributeValue"
    content:"""
        // Enter only one of the possible attribute value types.
        // For a more convenient shorthand command, use the shortcut
        // for each type, such as 'S', 'N', 'B'.
        {
            S: 'STRING_VALUE',
            N: 'NUMBER_VALUE',
            B: 'BASE64_ENCODED_STRING',
            SS: [ 'STRING_VALUE_1', 'STRING_VALUE_2', ],
            NS: [ 'NUMBER_VALUE_1', 'NUMBER_VALUE_2', ],
            BS: [ 'BASE64_ENCODED_STRING_1', 'BASE64_ENCODED_STRING_2', ]
        }"""
  ,
    name: "S"
    tabTrigger: "S"
    content:"""
        { S: '${1:STRING_VALUE}' }"""
  ,
    name: "N"
    tabTrigger: "N"
    content:"""
        { N: '${1:NUMBER_VALUE}' }"""
  ,
    name: "B"
    tabTrigger: "B"
    content:"""
        { B: '${1:BASE64_ENCODED_STRING}' }"""
  ,
    name: "SS"
    tabTrigger: "SS"
    content:"""
        [ '${1:STRING_VALUE_1}', '${2:STRING_VALUE_2}', ${3: }]"""
  ,
    name: "NS"
    tabTrigger: "NS"
    content:"""
        [ '${1:NUMBER_VALUE_1}', '${2:NUMBER_VALUE_2}', ${3: }]"""
  ,
    name: "BS"
    tabTrigger: "BS"
    content:"""
        [ '${1:BASE64_ENCODED_STRING_1}', '${2:BASE64_ENCODED_STRING_2}', ${3: }]"""
  ,
    name: "batchGetItem"
    tabTrigger: "batchGetItem"
    content:"""
        var params = {
            RequestItems: { // map of TableName to list of Key to get from each table
                ${1:table_name_1}: {
                    Keys: [ // a list of primary key value maps
                        {
                            key_attribute_name: 'STRING_VALUE',
                            // ... more key attributes, if the primary key is hash/range
                        },
                        // ... more keys to get from this table ...
                    ],
                    AttributesToGet: [ // option (attributes to retrieve from this table)
                        'attribute_name',
                        // ... more attribute names ...
                    ],
                    ConsistentRead: false, // optional (true | false)
                },
                // ... more tables and keys ...
            },
            ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)
        };
        docClient.batchGet(params, function(err, data) {
            if (err) ppJson(err); // an error occurred
            else ppJson(data); // successful response
        
        });"""
  ,
    name: "Keys"
    tabTrigger: "Keys"
    content:"""
        Keys: [ // a list of primary key value maps
            {
                key_attribute_name: { S: 'STRING_VALUE' },
                // ... more key attributes, if the primary key is hash/range
            },
            // ... more keys to get from this table ...
        ],"""
  ,
    name: "batchWriteItem"
    tabTrigger: "batchWriteItem"
    content:"""
        var params = {
            RequestItems: { // A map of TableName to Put or Delete requests for that table
                ${1:table_name_1}: [ // a list of Put or Delete requests for that table
                    { // An example PutRequest
                        PutRequest: {
                            Item: { // a map of attribute name to AttributeValue    
                                attribute_name: 'STRING_VALUE',
                                // ... more attributes ...
                            }
                        }
                    },
                    { // An example DeleteRequest
                        DeleteRequest: {
                            Key: { 
                                key_attribute_name: 'STRING_VALUE',
                                // more primary attributes (if the primary key is hash/range schema)
                            }
                        }
                    },
                    // ... more put or delete requests ...
                ],
                // ... more tables ...
            },
            ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)
            ReturnItemCollectionMetrics: 'NONE', // optional (NONE | SIZE)
        };
        dynamodb.batchWrite(params, function(err, data) {
            if (err) ppJson(err); // an error occurred
            else ppJson(data); // successful response
        });"""
  ,
    name: "RequestItems"
    tabTrigger: "RequestItems"
    content:"""
        RequestItems: { // A map of TableName to Put or Delete requests for that table
            ${1:table_name_1}: [ // a list of Put or Delete requests for that table
                { // An example PutRequest
                    PutRequest: {
                        Item: { // a map of attribute name to AttributeValue    
                            attribute_name: 'STRING_VALUE',
                            // ... more attributes ...
                        }
                    }
                },
                { // An example DeleteRequest
                    DeleteRequest: {
                        Key: { 
                            key_attribute_name: 'STRING_VALUE',
                            // more primary attributes (if the primary key is hash/range schema)
                        }
                    }
                },
                // ... more put or delete requests ...
            ],
            // ... more tables ...
        }"""
  ,
    name: "createTable"
    tabTrigger: "createTable"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            KeySchema: [ // The type of of schema.  Must start with a HASH type, with an optional second RANGE.
                { // Required HASH type attribute
                    AttributeName: 'hash_key_attribute_name',
                    KeyType: 'HASH',
                },
                { // Optional RANGE key type for HASH + RANGE tables
                    AttributeName: 'range_key_attribute_name', 
                    KeyType: 'RANGE', 
                }
            ],
            AttributeDefinitions: [ // The names and types of all primary and index key attributes only
                {
                    AttributeName: 'attribute_name',
                    AttributeType: 'S', // (S | N | B) for string, number, binary
                },
                // ... more attributes ...
            ],
            ProvisionedThroughput: { // required provisioned throughput for the table
                ReadCapacityUnits: 0, 
                WriteCapacityUnits: 0, 
            },
            GlobalSecondaryIndexes: [ // optional (list of GlobalSecondaryIndex)
                { 
                    IndexName: 'index_name_1', 
                    KeySchema: [
                        { // Required HASH type attribute
                            AttributeName: 'hash_key_attribute_name',
                            KeyType: 'HASH',
                        },
                        { // Optional RANGE key type for HASH + RANGE secondary indexes
                            AttributeName: 'range_key_attribute_name', 
                            KeyType: 'RANGE', 
                        }
                    ],
                    Projection: { // attributes to project into the index
                        ProjectionType: 'ALL', // (ALL | KEYS_ONLY | INCLUDE)
                        NonKeyAttributes: [ // required / allowed only for INCLUDE
                            'attribute_name_1',
                            // ... more attribute names ...
                        ],
                    },
                    ProvisionedThroughput: { // throughput to provision to the index
                        ReadCapacityUnits: 0,
                        WriteCapacityUnits: 0,
                    },
                },
                // ... more global secondary indexes ...
            ],
            LocalSecondaryIndexes: [ // optional (list of LocalSecondaryIndex)
                { 
                    IndexName: 'index_name_2',
                    KeySchema: [ 
                        { // Required HASH type attribute - must match the table's HASH key attribute name
                            AttributeName: 'hash_key_attribute_name',
                            KeyType: 'HASH',
                        },
                        { // alternate RANGE key attribute for the secondary index
                            AttributeName: 'range_key_attribute_name', 
                            KeyType: 'RANGE', 
                        }
                    ],
                    Projection: { // required
                        NonKeyAttributes: [
                            'STRING_VALUE',
                            // ... more items ...
                        ],
                        ProjectionType: 'ALL | KEYS_ONLY | INCLUDE',
                    },
                },
                // ... more local secondary indexes ...
            ],
        };
        dynamodb.createTable(params, function(err, data) {
            if (err) ppJson(err); // an error occurred
            else ppJson(data); // successful response
        
        });"""
  ,
    name: "AttributeDefinitions"
    tabTrigger: "AttributeDefinitions"
    content:"""
        AttributeDefinitions: [ // The names and types of all primary and index key attributes only
            {
                AttributeName: 'attribute_name',
                AttributeType: 'S', // (S | N | B) for string, number, binary
            },
            // ... more attributes ...
        ],"""
  ,
    name: "AttributeDefinition"
    tabTrigger: "AttributeDefinition"
    content:"""
        {
            AttributeName: 'attribute_name',
            AttributeType: 'S', // (S | N | B) for string, number, binary
        
        },"""
  ,
    name: "GlobalSecondaryIndex"
    tabTrigger: "GlobalSecondaryIndex"
    content:"""
        { 
            IndexName: 'index_name', 
            KeySchema: [
                { // Required HASH type attribute
                    AttributeName: 'hash_key_attribute_name',
                    KeyType: 'HASH',
                },
                { // Optional RANGE key type for HASH + RANGE secondary indexes
                    AttributeName: 'range_key_attribute_name', 
                    KeyType: 'RANGE', 
                }
            ],
            Projection: { // attributes to project into the index
                ProjectionType: 'ALL', // (ALL | KEYS_ONLY | INCLUDE)
                NonKeyAttributes: [ // required / allowed only for INCLUDE
                    'attribute_name_1',
                    // ... more attribute names ...
                ],
            },
            ProvisionedThroughput: { // throughput to provision to the index
                ReadCapacityUnits: 0,
                WriteCapacityUnits: 0,
            },
        },"""
  ,
    name: "GlobalSecondaryIndexes"
    tabTrigger: "GlobalSecondaryIndexes"
    content:"""
        GlobalSecondaryIndexes: [ // optional (list of GlobalSecondaryIndex)
            { 
                IndexName: 'index_name_1', 
                KeySchema: [
                    { // Required HASH type attribute
                        AttributeName: 'hash_key_attribute_name',
                        KeyType: 'HASH',
                    },
                    { // Optional RANGE key type for HASH + RANGE secondary indexes
                        AttributeName: 'range_key_attribute_name', 
                        KeyType: 'RANGE', 
                    }
                ],
                Projection: { // attributes to project into the index
                    ProjectionType: 'ALL', // (ALL | KEYS_ONLY | INCLUDE)
                    NonKeyAttributes: [ // required / allowed only for INCLUDE
                        'attribute_name_1',
                        // ... more attribute names ...
                    ],
                },
                ProvisionedThroughput: { // throughput to provision to the index
                    ReadCapacityUnits: 0,
                    WriteCapacityUnits: 0,
                },
            },
            // ... more global secondary indexes ...
        ],
        """
  ,
    name: "LocalSecondaryIndex"
    tabTrigger: "LocalSecondaryIndex"
    content:"""
        { 
            IndexName: 'index_name',
            KeySchema: [ 
                { // Required HASH type attribute - must match the table's HASH key attribute name
                    AttributeName: 'hash_key_attribute_name',
                    KeyType: 'HASH',
                },
                { // alternate RANGE key attribute for the secondary index
                    AttributeName: 'range_key_attribute_name', 
                    KeyType: 'RANGE', 
                }
            ],
            Projection: { // required
                NonKeyAttributes: [
                    'STRING_VALUE',
                    // ... more items ...
                ],
                ProjectionType: 'ALL | KEYS_ONLY | INCLUDE',
            },
        
        },"""
  ,
    name: "LocalSecondaryIndexes"
    tabTrigger: "LocalSecondaryIndexes"
    content:"""
        LocalSecondaryIndexes: [ // optional (list of LocalSecondaryIndex)
            { 
                IndexName: 'index_name',
                KeySchema: [ 
                    { // Required HASH type attribute - must match the table's HASH key attribute name
                        AttributeName: 'hash_key_attribute_name',
                        KeyType: 'HASH',
                    },
                    { // alternate RANGE key attribute for the secondary index
                        AttributeName: 'range_key_attribute_name', 
                        KeyType: 'RANGE', 
                    }
                ],
                Projection: { // required
                    NonKeyAttributes: [
                        'STRING_VALUE',
                        // ... more items ...
                    ],
                    ProjectionType: 'ALL | KEYS_ONLY | INCLUDE',
                },
            },
            // ... more local secondary indexes ...
        ],"""
  ,
    name: "ProvisionedThroughput"
    tabTrigger: "ProvisionedThroughput"
    content:"""
        ProvisionedThroughput: {
            ReadCapacityUnits: 0, 
            WriteCapacityUnits: 0, 
        },"""
  ,
    name: "KeySchema"
    tabTrigger: "KeySchema"
    content:"""
        KeySchema: [ // The type of of schema.  Must start with a HASH type, with an optional second RANGE.
            { // Required HASH type attribute
                AttributeName: 'hash_key_attribute_name',
                KeyType: 'HASH',
            },
            { // Optional RANGE key type
                AttributeName: 'range_key_attribute_name', 
                KeyType: 'RANGE', 
            }
        ],"""
  ,
    name: "deleteItem"
    tabTrigger: "deleteItem"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            Key: { // a map of attribute name to AttributeValue for all primary key attributes
            
                attribute_name: 'STRING_VALUE',
                // more attributes...
        
            },
            ConditionExpression: 'attribute_exists(attribute_name)', // optional String describing the constraint to be placed on an attribute
            ExpressionAttributeNames: { // a map of substitutions for attribute names with special characters
                //'#name': 'attribute name'
            },
            ExpressionAttributeValues: { // a map of substitutions for all attribute values
                //':value': 'VALUE'
            },
            ReturnValues: 'NONE', // optional (NONE | ALL_OLD)
            ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)
            ReturnItemCollectionMetrics: 'NONE', // optional (NONE | SIZE)
        };
        docClient.delete(params, function(err, data) {
            if (err) ppJson(err); // an error occurred
            else ppJson(data); // successful response
        });"""
  ,
    name: "deleteTable"
    tabTrigger: "deleteTable"
    content:"""
        var params = {
            TableName: '${1:table_name}',
        };
        dynamodb.deleteTable(params, function(err, data) {
            if (err) ppJson(err); // an error occurred
            else ppJson(data); // successful response
        });"""
  ,
    name: "describeTable"
    tabTrigger: "describeTable"
    content:"""
        var params = {
            TableName: '${1:table_name}',
        };
        dynamodb.describeTable(params, function(err, data) {
            if (err) ppJson(err); // an error occurred
            else ppJson(data); // successful response
        });"""
  ,
    name: "describeTables (all)"
    tabTrigger: "describeTables-all"
    content:"""
        dynamodb.listTables().eachPage(function(err, data) {
        if (err) {
            ppJson(err); // an error occurred
        } else if (data) {
            for (var i in data.TableNames) {
                var tableName = data.TableNames[i];
                var params = {
                    TableName: tableName,
                };
                dynamodb.describeTable(params, function(err, data) {
                    if (err) ppJson(err); // an error occurred
                    else ppJson(data); // successful response
            });
            }
        }
});"""
  ,
    name: "getItem"
    tabTrigger: "getItem"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            Key: { // a map of attribute name to AttributeValue for all primary key attributes
            
                attribute_name: 'STRING_VALUE'
                // more attributes...
        
            },
            AttributesToGet: [ // optional (list of specific attribute names to return)
                'attribute_name',
                // ... more attribute names ...
            ],
            ConsistentRead: false, // optional (true | false)
            ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)
        };
        docClient.get(params, function(err, data) {
            if (err) ppJson(err); // an error occurred
            else ppJson(data); // successful response
        });"""
  ,
    name: "getItem (basic)"
    tabTrigger: "getItem-basic"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            Key: { // a map of attribute name to AttributeValue for all primary key attributes
            
                attribute_name: 'STRING_VALUE'
                // more attributes...
        
            },
            // ... other optional parameters ...
        };
        docClient.get(params, function(err, data) {
            if (err) ppJson(err); // an error occurred
            else ppJson(data); // successful response
        });"""
  ,
    name: "Key"
    tabTrigger: "Key"
    content:"""
        Key: { // a map of attribute name to AttributeValue for all primary key attributes
        
            attribute_name: { S: 'STRING_VALUE' }
            // more attributes...
        
        }"""
  ,
    name: "listTables"
    tabTrigger: "listTables"
    content:"""
        var params = {
            ExclusiveStartTableName: '${1:table_name}', // optional (for pagination, returned as LastEvaluatedTableName)
            Limit: 0, // optional (to further limit the number of table names returned per page)
        };
        dynamodb.listTables(params, function(err, data) {
            if (err) ppJson(err); // an error occurred
            else ppJson(data); // successful response
        
        });"""
  ,
    name: "listTables (all)"
    tabTrigger: "listTables-all"
    content:"""
        dynamodb.listTables().eachPage(function(err, data) {
            if (err) {
                ppJson(err); // an error occurred
            } else if (data) {
                ppJson(data);
            }
        });"""
  ,
    name: "listTables (and describe)"
    tabTrigger: "listTables-and-describe"
    content:"""
        dynamodb.listTables().eachPage(function(err, data) {
            if (err) {
                ppJson(err); // an error occurred
            } else if (data) {
                for (var i in data.TableNames) {
                    var tableName = data.TableNames[i];
                    var params = {
                        TableName: tableName,
                    };
                    dynamodb.describeTable(params, function(err, data) {
                        if (err) ppJson(err); // an error occurred
                        else ppJson(data); // successful response
                    });
                }
            }
        });"""
  ,
    name: "putItem"
    tabTrigger: "putItem"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            Item: { // a map of attribute name to AttributeValue
            
                ${2:attribute_name}: ${3:'STRING_VALUE'}
                // more attributes...
            },
            ConditionExpression: 'attribute_not_exists(attribute_name)', // optional String describing the constraint to be placed on an attribute
            ExpressionAttributeNames: { // a map of substitutions for attribute names with special characters
                //'#name': 'attribute name'
            },
            ExpressionAttributeValues: { // a map of substitutions for all attribute values
                //':value': 'VALUE'
            },
            ReturnValues: '${6:NONE}', // optional (NONE | ALL_OLD)
            ReturnConsumedCapacity: '${7:NONE}', // optional (NONE | TOTAL | INDEXES)
            ReturnItemCollectionMetrics: '${8:NONE}', // optional (NONE | SIZE)
        };
        docClient.put(params, function(err, data) {
            if (err) ppJson(err); // an error occurred
            else ppJson(data); // successful response
        });"""
  ,
    name: "putItem (required only)"
    tabTrigger: "putItem-required"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            Item: { // a map of attribute name to AttributeValue
                
                attribute_name: 'STRING_VALUE'
                // more attributes...
            }
        };
        docClient.put(params, function(err, data) {
            if (err) ppJson(err); // an error occurred
            else ppJson(data); // successful response
        });"""
  ,
    name: "putItem (conditional)"
    tabTrigger: "putItem-conditional"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            Item: { // a map of attribute name to AttributeValue
            
                attribute_name: { S: 'STRING_VALUE' }
                // more attributes...
            },
            ConditionExpression: 'attribute = :value',
            ExpressionAttributeValues: {
                ':value': 'VALUE'
            },
            ReturnValues: 'NONE', // optional (NONE | ALL_OLD)
        };
        docClient.put(params, function(err, data) {
            if (err) ppJson(err); // an error occurred
            else ppJson(data); // successful response
        });"""
  ,
    name: "query"
    tabTrigger: "query"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            IndexName: 'index_name', // optional (if querying an index)
            KeyConditionExpression: 'attribute_name = :value', // a string representing a constraint on the attribute
            ExpressionAttributeNames: { // a map of substitutions for attribute names with special characters
                //'#name': 'attribute name'
            },
            ExpressionAttributeValues: { // a map of substitutions for all attribute values
              ':value': 'STRING_VALUE'
            },
            ScanIndexForward: true, // optional (true | false) defines direction of Query in the index
            Limit: 0, // optional (limit the number of items to evaluate)
            ConsistentRead: false, // optional (true | false)
            Select: 'ALL_ATTRIBUTES', // optional (ALL_ATTRIBUTES | ALL_PROJECTED_ATTRIBUTES | 
                                      //           SPECIFIC_ATTRIBUTES | COUNT)
            AttributesToGet: [ // optional (list of specific attribute names to return)
                'attribute_name',
                // ... more attributes ...
            ],
            ExclusiveStartKey: { // optional (for pagination, returned by prior calls as LastEvaluatedKey)
                attribute_name: 'STRING_VALUE',
                // anotherKey: ...
        
            },
            ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)
        };
        docClient.query(params, function(err, data) {
            if (err) ppJson(err); // an error occurred
            else ppJson(data); // successful response
        });"""
  ,
    name: "query (and paginate)"
    tabTrigger: "query-paginate"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            KeyConditionExpression: 'attribute_name = :value', // a string representing a constraint on the attribute
            ExpressionAttributeNames: { // a map of substitutions for attribute names with special characters
                //'#name': 'attribute name'
            },
            ExpressionAttributeValues: { // a map of substitutions for all attribute values
              ':value': 'STRING_VALUE'
            },
        };
        
        // A callback that paginates through an entire DynamoDB table
        function doQuery(response) {
            console.log(response.error);
            if (response.error) ppJson(response.error); // an error occurred
            else {
                ppJson(response.data); // successful response
                
                // More data.  Keep calling query.
                if ('LastEvaluatedKey' in response.data) {
                    response.request.params.ExclusiveStartKey = response.data.LastEvaluatedKey;
                    docClient.query(response.request.params)
                        .on('complete', doQuery)
                        .send();
              } 
            }
        }
        
        // Kick off the query
        console.log("Starting a Query on the table");
        docClient.query(params)
            .on('complete', doQuery)
            .send();"""
  ,
    name: "query (basic)"
    tabTrigger: "query-basic"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            KeyConditionExpression: 'attribute_name = :value', // a string representing a constraint on the attribute
            ExpressionAttributeNames: { // a map of substitutions for attribute names with special characters
                //'#name': 'attribute name'
            },
            ExpressionAttributeValues: { // a map of substitutions for all attribute values
              ':value': 'STRING_VALUE'
            }
        };
        docClient.query(params, function(err, data) {
            if (err) ppJson(err); // an error occurred
            else ppJson(data); // successful response
        
        });"""
  ,
    name: "KeyConditionExpression"
    tabTrigger: "KeyConditionExpression"
    content:"""
        KeyConditionExpression: 'attribute_name = :value', // a string representing a constraint on the attribute
        ExpressionAttributeNames: { // a map of substitutions for attribute names with special characters
            //'#name': 'attribute name'
        },
        ExpressionAttributeValues: { // a map of substitutions for all attribute values
            ':value': 'STRING_VALUE'
        },"""
  ,
    name: "ConsistentRead"
    tabTrigger: "ConsistentRead"
    content:"""
        ConsistentRead: true,"""
  ,
    name: "scan"
    tabTrigger: "scan"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            Limit: 0, // optional (limit the number of items to evaluate)
            FilterExpression: 'attribute_name = :value', // a string representing a constraint on the attribute
            ExpressionAttributeNames: { // a map of substitutions for attribute names with special characters
                //'#name': 'attribute name'
            },
            ExpressionAttributeValues: { // a map of substitutions for all attribute values
                ':value': 'STRING_VALUE'
            },
            Select: 'ALL_ATTRIBUTES', // optional (ALL_ATTRIBUTES | ALL_PROJECTED_ATTRIBUTES | 
                                      //           SPECIFIC_ATTRIBUTES | COUNT)
            AttributesToGet: [ // optional (list of specific attribute names to return)
                'attribute_name',
                // ... more attributes ...
            ],
            ConsistentRead: false, // optional (true | false)
            Segment: 0, // optional (for parallel scan)
            TotalSegments: 0, // optional (for parallel scan)
            ExclusiveStartKey: { // optional (for pagination, returned by prior calls as LastEvaluatedKey)
                attribute_name: { S: 'STRING_VALUE' },
                // anotherKey: ...
            },
            ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)
        };
        docClient.scan(params, function(err, data) {
            if (err) ppJson(err); // an error occurred
            else ppJson(data); // successful response
        });"""
  ,
    name: "scan (basic)"
    tabTrigger: "scan-basic"
    content:"""
        var params = {
            TableName: '${1:table_name}',
        };
        docClient.scan(params, function(err, data) {
            if (err) ppJson(err); // an error occurred
            else ppJson(data); // successful response
        });"""
  ,
    name: "scan (and paginate)"
    tabTrigger: "scan-paginate"
    content:"""
        var params = {
            TableName: '${1:table_name}'
            // ... other optional parameters like Limit or ScanFilter ...
        };
        
        // A callback that paginates through an entire DynamoDB table
        function doScan(response) {
            if (response.error) ppJson(response.error); // an error occurred
            else {
                ppJson(response.data); // successful response
                
                // More data.  Keep calling scan.
                if ('LastEvaluatedKey' in response.data) {
                    response.request.params.ExclusiveStartKey = response.data.LastEvaluatedKey;
                    docClient.scan(response.request.params)
                        .on('complete', doScan)
                        .send();
              } 
            }
        }
        
        // Kick off the scan
        console.log("Starting a Scan of the table");
        docClient.scan(params)
            .on('complete', doScan)
            .send();"""
  ,
    name: "FilterExpression"
    tabTrigger: "FilterExpression"
    content:"""
        FilterExpression: 'attribute_name = :value', // a string representing a constraint on the attribute
        ExpressionAttributeNames: { // a map of substitutions for attribute names with special characters
            //'#name': 'attribute name'
        },
        ExpressionAttributeValues: { // a map of substitutions for all attribute values
            ':value': 'STRING_VALUE'
        },"""
  ,
    name: "updateItem"
    tabTrigger: "updateItem"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            Key: { // The primary key of the item (a map of attribute name to AttributeValue)
        
                attribute_name: 'STRING_VALUE'
                // more attributes...
            },
            UpdateExpression: 'SET attribute_name :value', // String representation of the update to an attribute
                // SET set-action , ... 
                // REMOVE remove-action , ...  (for document support)
                // ADD add-action , ... 
                // DELETE delete-action , ...  (previous DELETE equivalent)
            ConditionExpression: 'attribute_exists(attribute_name)', // optional String describing the constraint to be placed on an attribute
            ExpressionAttributeNames: { // a map of substitutions for attribute names with special characters
                //'#name': 'attribute name'
            },
            ExpressionAttributeValues: { // a map of substitutions for all attribute values
                ':value': 'VALUE'
            },
            ReturnValues: 'NONE', // optional (NONE | ALL_OLD | UPDATED_OLD | ALL_NEW | UPDATED_NEW)
            ReturnConsumedCapacity: 'NONE', // optional (NONE | TOTAL | INDEXES)
            ReturnItemCollectionMetrics: 'NONE', // optional (NONE | SIZE)
        };
        docClient.update(params, function(err, data) {
            if (err) ppJson(err); // an error occurred
            else ppJson(data); // successful response
        });"""
  ,
    name: "updateItem (required)"
    tabTrigger: "updateItem-required"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            Key: { // The primary key of the item (a map of attribute name to AttributeValue)
        
                attribute_name: 'STRING_VALUE'
                // more attributes...
            },
            UpdateExpression: 'SET attribute_name :value', // String representation of the update to an attribute
                // SET set-action , ... 
                // REMOVE remove-action , ...  (for document support)
                // ADD add-action , ... 
                // DELETE delete-action , ...  (previous DELETE equivalent)
            ExpressionAttributeNames: { // a map of substitutions for attribute names with special characters
                //'#name': 'attribute name'
            },
            ExpressionAttributeValues: { // a map of substitutions for all attribute values
                ':value': 'VALUE'
            }
        };
        docClient.update(params, function(err, data) {
            if (err) ppJson(err); // an error occurred
            else ppJson(data); // successful response
        });"""
  ,
    name: "updateItem (conditional)"
    tabTrigger: "updateItem-conditional"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            Key: { // The primary key of the item (a map of attribute name to AttributeValue)
        
                attribute_name: 'STRING_VALUE'
                // more attributes...
            },
            UpdateExpression: 'SET attribute_name :value', // String representation of the update to an attribute
                // SET set-action , ... 
                // REMOVE remove-action , ...  (for document support)
                // ADD add-action , ... 
                // DELETE delete-action , ...  (previous DELETE equivalent)
            ConditionExpression: 'attribute_exists(attribute_name)', // optional String describing the constraint to be placed on an attribute
            ExpressionAttributeNames: { // a map of substitutions for attribute names with special characters
                //'#name': 'attribute name'
            },
            ExpressionAttributeValues: { // a map of substitutions for all attribute values
                ':value': 'VALUE'
            },
            ReturnValues: 'NONE', // optional (NONE | ALL_OLD | UPDATED_OLD | ALL_NEW | UPDATED_NEW)
        };
        docClient.update(params, function(err, data) {
            if (err) ppJson(err); // an error occurred
            else ppJson(data); // successful response
        });"""
  ,
    name: "ConditionExpression"
    tabTrigger: "ConditionExpression"
    content:"""
        ConditionExpression: 'attribute_exists('STRING_VALUE')'// optional String describing the constraint to be placed on an attribute
        """
  ,
    name: "UpdateExpression"
    tabTrigger: "UpdateExpression"
    content:"""
        UpdateExpression: 'SET attribute_name :value', // String representation of the update to an attribute
                // SET set-action , ... 
                // REMOVE remove-action , ...  (for document support)
                // ADD add-action , ... 
                // DELETE delete-action , ...  (previous DELETE equivalent)
        """
  ,
    name: "ExpressionAttributeNames"
    tabTrigger: "ExpressionAttributeNames"
    content:"""
        ExpressionAttributeNames: { // a map of substitutions for attribute names with special characters
            //'#name': 'attribute name'
        },
        """
  ,
    name: "ExpressionAttributeValues"
    tabTrigger: "ExpressionAttributeValues"
    content:"""
        ExpressionAttributeValues: { // a map of substitutions for all attribute values
            ':value': 'VALUE'
        },
        """
  ,
    name: "updateTable"
    tabTrigger: "updateTable"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            GlobalSecondaryIndexUpdates: [{ // optional
                    Update: {
                        IndexName: 'index_name',
                        ProvisionedThroughput: {
                            ReadCapacityUnits: 0, 
                            WriteCapacityUnits: 0,
                        },
                    },
                },
                // ... more optional indexes ...
            ],
            ProvisionedThroughput: {
                ReadCapacityUnits: 0,
                WriteCapacityUnits: 0,
            },
        };
        dynamodb.updateTable(params, function(err, data) {
            if (err) ppJson(err); // an error occurred
            else ppJson(data); // successful response
        });"""
  ,
    name: "updateTable (table throughput)"
    tabTrigger: "updateTable-table"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            ProvisionedThroughput: {
                ReadCapacityUnits: 0,
                WriteCapacityUnits: 0,
            },
        };
        dynamodb.updateTable(params, function(err, data) {
            if (err) ppJson(err); // an error occurred
            else ppJson(data); // successful response
        });"""
  ,
    name: "updateTable (index throughput)"
    tabTrigger: "updateTable-index"
    content:"""
        var params = {
            TableName: '${1:table_name}',
            GlobalSecondaryIndexUpdates: [{ // optional
                    Update: {
                        IndexName: 'index_name',
                        ProvisionedThroughput: {
                            ReadCapacityUnits: 0, 
                            WriteCapacityUnits: 0,
                        },
                    },
                },
                // ... more optional indexes ...
            ],
        };
        dynamodb.updateTable(params, function(err, data) {
            if (err) ppJson(err); // an error occurred
            else ppJson(data); // successful response
        });"""
  ,
    content:"""
    var params = {
        TableName: '${1:STRING_VALUE}', // required
    };
    dynamodb.waitFor('tableExists', params, function(err, data) {
        if (err) ppJson(err); // an error occurred
        else ppJson(data); // successful response
    });"""
    name: "waitFor"
    tabTrigger: "waitFor"
	]


