/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.shared.validate;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.dynamodbv2.exceptions.AWSExceptionFactory;
import com.amazonaws.services.dynamodbv2.exceptions.AmazonServiceExceptionType;
import com.amazonaws.services.dynamodbv2.exceptions.DynamoDBLocalServiceException;
import com.amazonaws.services.dynamodbv2.local.shared.access.api.dp.TransactWriteItemsFunction;
import com.amazonaws.services.dynamodbv2.local.shared.exceptions.LocalDBClientExceptionMessage;
import com.amazonaws.services.dynamodbv2.model.CancellationReason;
import com.amazonaws.services.dynamodbv2.model.TransactWriteItem;

public class TransactionErrorMapper {
    private final AWSExceptionFactory awsExceptionFactory;

    public TransactionErrorMapper(AWSExceptionFactory awsExceptionFactory) {
        this.awsExceptionFactory = awsExceptionFactory;
    }

    public CancellationReason getEmptyCancellationReason() {
        return new CancellationReason().withCode("None");
    }

    public CancellationReason mapToCancellationReasonWhenGettingExistingItem(DynamoDBLocalServiceException e) {
        String msg;
        if (e.getErrorCode() == AmazonServiceExceptionType.VALIDATION_EXCEPTION.getErrorCode() && (msg = e.getMessage()).equals(LocalDBClientExceptionMessage.ITEM_TOO_BIG.getMessage())) {
            return new CancellationReason().withCode("ValidationError").withMessage(e.getMessage());
        }
        throw e;
    }

    public CancellationReason mapToCancellationReasonWhenHandlingTransactionOperation(DynamoDBLocalServiceException e, TransactWriteItem item, int memberPosition) {
        if (e.getErrorCode() == AmazonServiceExceptionType.VALIDATION_EXCEPTION.getErrorCode()) {
            String msg = e.getMessage();
            if (msg == LocalDBClientExceptionMessage.ITEM_CONTAINS_NULL_ATTRVALUE.getMessage()) {
                throw this.buildCoralValidationException("null", item, memberPosition, "key", LocalDBClientExceptionMessage.MEMBER_NULL.getMessage());
            }
            if (msg == LocalDBClientExceptionMessage.INCONSISTENT_INDEX_TYPES.getMessage() || msg == LocalDBClientExceptionMessage.KEY_VALUE_TOO_BIG.getMessage() || msg == LocalDBClientExceptionMessage.ITEM_UPD_TOO_LARGE.getMessage() || msg == LocalDBClientExceptionMessage.INCONSISTENT_TYPES.getMessage()) {
                return new CancellationReason().withCode("ValidationError").withMessage(msg);
            }
        }
        if (e.getErrorCode() == AmazonServiceExceptionType.CONDITIONAL_CHECK_FAILED_EXCEPTION.getErrorCode()) {
            return new CancellationReason().withCode("ConditionalCheckFailed").withMessage(e.getMessage());
        }
        throw e;
    }

    public DynamoDBLocalServiceException mapToCorrectExceptionForPutRequest(DynamoDBLocalServiceException e, TransactWriteItem item, int itemPosition) {
        if (e.getMessage() == LocalDBClientExceptionMessage.INVALID_PUT_NULL.getMessage()) {
            throw this.buildCoralValidationException("null", item, itemPosition + 1, "item", LocalDBClientExceptionMessage.MEMBER_NULL.getMessage());
        }
        throw e;
    }

    public DynamoDBLocalServiceException mapToCorrectExceptionForKeyedRequest(DynamoDBLocalServiceException e, TransactWriteItem item, int itemPosition) {
        if (e.getMessage() == LocalDBClientExceptionMessage.MISSING_KEY.getMessage()) {
            throw this.buildCoralValidationException("null", item, itemPosition + 1, "key", LocalDBClientExceptionMessage.MEMBER_NULL.getMessage());
        }
        throw e;
    }

    public DynamoDBLocalServiceException mapToCorrectExceptionForUpdateRequest(DynamoDBLocalServiceException e, TransactWriteItem item, int itemPosition) {
        if (e.getMessage().startsWith(this.awsExceptionFactory.EXPR_ATTR_VALUES_WITHOUT_EXPRESSIONS.getMessage())) {
            throw this.buildCoralValidationException("null", item, itemPosition + 1, "updateExpression", LocalDBClientExceptionMessage.MEMBER_NULL.getMessage());
        }
        return this.mapToCorrectExceptionForKeyedRequest(e, item, itemPosition);
    }

    public AmazonServiceException buildCoralValidationException(String value, TransactWriteItem writeItem, int writeItemPosition, String fieldName, String errorDetails) {
        TransactWriteItemsFunction.OperationType operationType = TransactWriteItemsFunction.OperationType.get(writeItem);
        String member = String.format("transactItems.%d.member.%s.%s", writeItemPosition, operationType.getApiName(), fieldName);
        return AWSExceptionFactory.buildCoralValidationException(value, member, errorDetails);
    }
}

