/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.server;

import com.amazonaws.services.dynamodbv2.dataMembers.RequestData;
import com.amazonaws.services.dynamodbv2.dataMembers.ResponseData;
import com.amazonaws.services.dynamodbv2.exceptions.AWSExceptionFactory;
import com.amazonaws.services.dynamodbv2.exceptions.AmazonServiceExceptionType;
import com.amazonaws.services.dynamodbv2.exceptions.DynamoDBLocalServiceException;
import com.amazonaws.services.dynamodbv2.local.dispatchers.BatchGetItemDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.BatchWriteItemDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.CreateTableDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.DeleteItemDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.DeleteTableDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.DescribeLimitsDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.DescribeStreamDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.DescribeTableDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.Dispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.GetItemDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.GetRecordsDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.GetShardIteratorDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.ListStreamsDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.ListTablesDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.PutItemDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.QueryDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.ScanDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.UpdateItemDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.UpdateTableDispatcher;
import com.amazonaws.services.dynamodbv2.local.exceptions.ExceptionBean;
import com.amazonaws.services.dynamodbv2.local.server.AbstractLocalDynamoDBServerHandler;
import com.amazonaws.services.dynamodbv2.local.server.DynamoDBRequestHandler;
import com.amazonaws.services.dynamodbv2.local.shared.logging.LogManager;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeLimitsRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeStreamRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetRecordsRequest;
import com.amazonaws.services.dynamodbv2.model.GetShardIteratorRequest;
import com.amazonaws.services.dynamodbv2.model.ListStreamsRequest;
import com.amazonaws.services.dynamodbv2.model.ListTablesRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.zip.CRC32;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.Request;

public class LocalDynamoDBServerHandler
extends AbstractLocalDynamoDBServerHandler {
    public static final String UPDATE_TABLE = "UpdateTable";
    public static final String UPDATE_ITEM = "UpdateItem";
    public static final String SCAN = "Scan";
    public static final String QUERY = "Query";
    public static final String PUT_ITEM = "PutItem";
    public static final String LIST_TABLES = "ListTables";
    public static final String LIST_STREAMS = "ListStreams";
    public static final String GET_SHARD_ITERATOR = "GetShardIterator";
    public static final String GET_RECORDS = "GetRecords";
    public static final String GET_ITEM = "GetItem";
    public static final String DESCRIBE_TABLE = "DescribeTable";
    public static final String DESCRIBE_STREAM = "DescribeStream";
    public static final String DESCRIBE_LIMITS = "DescribeLimits";
    public static final String DELETE_TABLE = "DeleteTable";
    public static final String DELETE_ITEM = "DeleteItem";
    public static final String CREATE_TABLE = "CreateTable";
    public static final String BATCH_WRITE_ITEM = "BatchWriteItem";
    public static final String BATCH_GET_ITEM = "BatchGetItem";
    private static final String AUTHORIZATION_SPLIT = "=|/";
    private static final String TARGET_COMPONENTS_SPLIT = "\\.";
    static Logger logger = LogManager.getLogger(LocalDynamoDBServerHandler.class);
    private static Map<String, Dispatcher> dispatchers;
    private static Map<String, Class> classes;
    private static final int MAX_REQUEST_SIZE = 0x1000000;
    private static final String INCOMPATIBLE_VERSION_0 = "DynamoDB_20110924";
    private static final String INCOMPATIBLE_VERSION_1 = "DynamoDB_20111205";
    public static final String COMPATIBLE_VERSION_DYNAMO_DB = "DynamoDB_20120810";
    public static final String COMPATIBLE_VERSION_DYNAMO_DB_STREAMS = "DynamoDBStreams_20120810";
    private static final byte[] EMPTY_BODY;
    private static final Map<String, Set> ACTION_VERSION_COMPATIBILITY;
    private final HashSet<String> corsSet = new HashSet();

    public LocalDynamoDBServerHandler(DynamoDBRequestHandler primaryHandler, String corsParam) {
        super(primaryHandler);
        if (corsParam != null) {
            this.setUpCors(corsParam);
        }
        this.init();
    }

    private void setUpCors(String corsParam) {
        StringTokenizer st = new StringTokenizer(corsParam, ",");
        while (st.hasMoreTokens()) {
            this.corsSet.add(st.nextToken().trim());
        }
    }

    private void init() {
        dispatchers = new HashMap<String, Dispatcher>();
        dispatchers.put(BATCH_GET_ITEM, new BatchGetItemDispatcher(this.jsonMapper));
        dispatchers.put(BATCH_WRITE_ITEM, new BatchWriteItemDispatcher(this.jsonMapper));
        dispatchers.put(CREATE_TABLE, new CreateTableDispatcher(this.jsonMapper));
        dispatchers.put(DELETE_ITEM, new DeleteItemDispatcher(this.jsonMapper));
        dispatchers.put(DELETE_TABLE, new DeleteTableDispatcher(this.jsonMapper));
        dispatchers.put(DESCRIBE_STREAM, new DescribeStreamDispatcher(this.jsonMapper));
        dispatchers.put(DESCRIBE_TABLE, new DescribeTableDispatcher(this.jsonMapper));
        dispatchers.put(DESCRIBE_LIMITS, new DescribeLimitsDispatcher(this.jsonMapper));
        dispatchers.put(GET_ITEM, new GetItemDispatcher(this.jsonMapper));
        dispatchers.put(GET_RECORDS, new GetRecordsDispatcher(this.jsonMapper));
        dispatchers.put(GET_SHARD_ITERATOR, new GetShardIteratorDispatcher(this.jsonMapper));
        dispatchers.put(LIST_STREAMS, new ListStreamsDispatcher(this.jsonMapper));
        dispatchers.put(LIST_TABLES, new ListTablesDispatcher(this.jsonMapper));
        dispatchers.put(PUT_ITEM, new PutItemDispatcher(this.jsonMapper));
        dispatchers.put(QUERY, new QueryDispatcher(this.jsonMapper));
        dispatchers.put(SCAN, new ScanDispatcher(this.jsonMapper));
        dispatchers.put(UPDATE_ITEM, new UpdateItemDispatcher(this.jsonMapper));
        dispatchers.put(UPDATE_TABLE, new UpdateTableDispatcher(this.jsonMapper));
        classes = new HashMap<String, Class>();
        classes.put(BATCH_GET_ITEM, BatchGetItemRequest.class);
        classes.put(BATCH_WRITE_ITEM, BatchWriteItemRequest.class);
        classes.put(CREATE_TABLE, CreateTableRequest.class);
        classes.put(DELETE_ITEM, DeleteItemRequest.class);
        classes.put(DELETE_TABLE, DeleteTableRequest.class);
        classes.put(DESCRIBE_STREAM, DescribeStreamRequest.class);
        classes.put(DESCRIBE_TABLE, DescribeTableRequest.class);
        classes.put(DESCRIBE_LIMITS, DescribeLimitsRequest.class);
        classes.put(GET_ITEM, GetItemRequest.class);
        classes.put(GET_RECORDS, GetRecordsRequest.class);
        classes.put(GET_SHARD_ITERATOR, GetShardIteratorRequest.class);
        classes.put(LIST_STREAMS, ListStreamsRequest.class);
        classes.put(LIST_TABLES, ListTablesRequest.class);
        classes.put(PUT_ITEM, PutItemRequest.class);
        classes.put(QUERY, QueryRequest.class);
        classes.put(SCAN, ScanRequest.class);
        classes.put(UPDATE_ITEM, UpdateItemRequest.class);
        classes.put(UPDATE_TABLE, UpdateTableRequest.class);
    }

    private static byte[] fromStream(InputStream inStream) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[0x1000000];
        int totalBytesRead = 0;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        while ((bytesRead = inStream.read(buffer)) != -1) {
            if ((totalBytesRead += bytesRead) > 0x1000000) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.REQUEST_TOO_LARGE);
            }
            output.write(buffer, 0, bytesRead);
        }
        return output.toByteArray();
    }

    private boolean isPreFlight(RequestData req) {
        return req.getHttpServletRequest().getHeader("Origin") != null && req.getHttpServletRequest().getMethod().equals("OPTIONS") && req.getHttpServletRequest().getHeader("Access-Control-Request-Method") != null;
    }

    private void send(ResponseData response) throws IOException {
        response.getHttpServletResponse().setHeader("x-amzn-RequestId", UUID.randomUUID().toString());
        logger.info((Object)response);
        response.getHttpServletResponse().getOutputStream().write(response.getResponseBody());
    }

    protected String getAccessKey(Request req) {
        String[] auth = req.getHeader("Authorization").split(AUTHORIZATION_SPLIT);
        return auth[1];
    }

    protected void packageDynamoDBResponse(RequestData req, ResponseData res) throws DynamoDBLocalServiceException {
        res.getHttpServletResponse().setContentType("application/x-amz-json-1.0");
        if (req.getBaseRequest().getHeader("Authorization") == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.MISSING_AUTHENTICATION_TOKEN);
        }
        String[] auth = req.getBaseRequest().getHeader("Authorization").split(AUTHORIZATION_SPLIT);
        String accessKey = this.getAccessKey(req.getBaseRequest());
        String region = auth[3];
        String[] amzTargetComponents = req.getBaseRequest().getHeader("X-Amz-Target").split(TARGET_COMPONENTS_SPLIT);
        if (amzTargetComponents[0].equals(INCOMPATIBLE_VERSION_0) || amzTargetComponents[0].equals(INCOMPATIBLE_VERSION_1)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.INVALID_VERSION);
        }
        String version = amzTargetComponents[0];
        String amzTarget = amzTargetComponents[1];
        this.validateTargetActionVersionCompatibility(amzTarget, version);
        logger.info("accessKey: " + accessKey + "\t" + region);
        logger.info("target: " + amzTarget);
        Dispatcher dispatcher = dispatchers.get(amzTarget);
        if (dispatcher == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.INVALID_ACTION);
        }
        Class requestClass = classes.get(amzTarget);
        try {
            res.setResponseBody(dispatcher.enact(accessKey, region, this.jsonMapper.readValue(req.getRequestBody(), requestClass), this.primaryHandler));
        }
        catch (DynamoDBLocalServiceException e) {
            logger.warn("DynamoDBLocalServiceException exception occured", (Throwable)((Object)e));
            throw e;
        }
        catch (Exception e) {
            logger.error("Unexpected exception occured", (Throwable)e);
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.INTERNAL_FAILURE);
        }
        res.getHttpServletResponse().setStatus(200);
        for (DynamoDBRequestHandler handler : this.secondaryHandlers.values()) {
            try {
                dispatcher.enact(accessKey, region, this.jsonMapper.readValue(req.getRequestBody(), requestClass), handler);
            }
            catch (Exception e) {
                logger.error("Secondary Handler failed:", (Throwable)e);
            }
        }
        CRC32 checksum = new CRC32();
        checksum.update(res.getResponseBody(), 0, res.getResponseBody().length);
        res.getHttpServletResponse().setHeader("x-amz-crc32", "" + checksum.getValue());
    }

    private void validateTargetActionVersionCompatibility(String action, String version) {
        Set compatibleActions = ACTION_VERSION_COMPATIBILITY.get(version);
        if (compatibleActions == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.INVALID_ACTION);
        }
        if (!compatibleActions.contains(action)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.UNKNOWN_OPERATION_EXCEPTION);
        }
    }

    private void packagePreFlight(RequestData req, ResponseData res) throws DynamoDBLocalServiceException {
        String reqMethod = req.getHttpServletRequest().getHeader("Access-Control-Request-Method");
        String reqHeaders = req.getHttpServletRequest().getHeader("Access-Control-Request-Headers");
        if (reqHeaders == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, "Invalid PreFlight Headers");
        }
        res.getHttpServletResponse().addHeader("Access-Control-Allow-Methods", reqMethod);
        res.getHttpServletResponse().addHeader("Access-Control-Allow-Headers", reqHeaders);
        res.getHttpServletResponse().addHeader("Access-Control-Max-Age", "1728000");
        res.getHttpServletResponse().setStatus(200);
        res.setResponseBody(EMPTY_BODY);
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestData req = new RequestData(baseRequest, request);
        ResponseData res = new ResponseData(response);
        try {
            req.setRequestBody(LocalDynamoDBServerHandler.fromStream((InputStream)req.getHttpServletRequest().getInputStream()));
            if (this.isPreFlight(req)) {
                this.packagePreFlight(req, res);
            } else {
                this.packageDynamoDBResponse(req, res);
            }
            if (this.corsSet.contains("*") || this.corsSet.contains(req.getHttpServletRequest().getHeader("Origin"))) {
                res.getHttpServletResponse().addHeader("Access-Control-Allow-Origin", req.getHttpServletRequest().getHeader("Origin"));
            }
        }
        catch (DynamoDBLocalServiceException e) {
            res.getHttpServletResponse().setStatus(e.getStatusCode());
            res.setResponseBody(this.jsonMapper.writeValueAsBytes(new ExceptionBean(e.getErrorCode(), e.getMessage())));
        }
        catch (Exception e) {
            AmazonServiceExceptionType internalFailure = AmazonServiceExceptionType.INTERNAL_FAILURE;
            res.getHttpServletResponse().setStatus(internalFailure.getResponseStatus());
            res.setResponseBody(this.jsonMapper.writeValueAsBytes(new ExceptionBean(internalFailure)));
            logger.error("Unknown error", (Throwable)e);
        }
        baseRequest.setHandled(true);
        logger.info((Object)req);
        this.send(res);
    }

    static {
        EMPTY_BODY = new byte[0];
        ACTION_VERSION_COMPATIBILITY = new HashMap<String, Set>();
        ACTION_VERSION_COMPATIBILITY.put(COMPATIBLE_VERSION_DYNAMO_DB, new HashSet<String>(Arrays.asList(UPDATE_TABLE, UPDATE_ITEM, SCAN, QUERY, PUT_ITEM, LIST_TABLES, GET_ITEM, DESCRIBE_TABLE, DESCRIBE_LIMITS, DELETE_TABLE, DELETE_ITEM, CREATE_TABLE, BATCH_WRITE_ITEM, BATCH_GET_ITEM)));
        ACTION_VERSION_COMPATIBILITY.put(COMPATIBLE_VERSION_DYNAMO_DB_STREAMS, new HashSet<String>(Arrays.asList(LIST_STREAMS, GET_SHARD_ITERATOR, GET_RECORDS, DESCRIBE_STREAM)));
    }
}

