/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.embedded;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams;
import com.amazonaws.services.dynamodbv2.exceptions.AmazonServiceExceptionType;
import com.amazonaws.services.dynamodbv2.exceptions.DynamoDBLocalServiceException;
import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDBClient;
import com.amazonaws.services.dynamodbv2.model.TransactionCanceledException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class DDBExceptionMappingInvocationHandler
implements InvocationHandler {
    private final LocalDBClient impl;
    private final ReentrantReadWriteLock shutdownLock = new ReentrantReadWriteLock();
    private boolean isShutdown = false;

    DDBExceptionMappingInvocationHandler(LocalDBClient impl) {
        this.impl = impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("shutdown") || method.getName().equals("shutdownNow")) {
            this.shutdownLock.writeLock().lock();
            try {
                List<Runnable> runnables = null;
                if (!this.isShutdown) {
                    if (method.getName().equals("shutdownNow")) {
                        runnables = this.impl.shutdownNow();
                    } else {
                        this.impl.shutdown();
                    }
                    this.isShutdown = true;
                }
                List<Runnable> list = runnables;
                return list;
            }
            finally {
                this.shutdownLock.writeLock().unlock();
            }
        }
        this.shutdownLock.readLock().lock();
        try {
            if (!this.isShutdown) {
                Object result = null;
                try {
                    result = AmazonDynamoDB.class.equals(method.getDeclaringClass()) ? method.invoke((Object)this.impl.amazonDynamoDB(), args) : (AmazonDynamoDBStreams.class.equals(method.getDeclaringClass()) ? method.invoke((Object)this.impl.amazonDynamoDBStreams(), args) : method.invoke((Object)this.impl, args));
                    Object object = result;
                    return object;
                }
                catch (InvocationTargetException ie) {
                    Throwable e = ie.getTargetException();
                    if (e.getClass().isAssignableFrom(DynamoDBLocalServiceException.class)) {
                        DDBExceptionMappingInvocationHandler.handleDynamoDBLocalServiceException((DynamoDBLocalServiceException)((Object)e));
                    }
                    throw e;
                }
            }
            throw new AmazonServiceException("Embedded server is shut down");
        }
        finally {
            this.shutdownLock.readLock().unlock();
        }
    }

    private static void handleDynamoDBLocalServiceException(DynamoDBLocalServiceException le) throws Throwable {
        AmazonServiceException ase;
        AmazonServiceExceptionType exceptionType = AmazonServiceExceptionType.valueOfErrorCode(le.getErrorCode());
        Class<? extends AmazonServiceException> clientException = exceptionType.getClientClass();
        if (AmazonServiceException.class.equals(clientException)) {
            ase = new AmazonServiceException(le.getMessage());
        } else if (TransactionCanceledException.class.equals(clientException)) {
            TransactionCanceledException tce = new TransactionCanceledException(le.getMessage());
            tce.setCancellationReasons(le.getCancellationReasons());
            ase = tce;
        } else {
            Constructor<? extends AmazonServiceException> constructor = clientException.getConstructor(String.class);
            ase = constructor.newInstance(le.getMessage());
        }
        DDBExceptionMappingInvocationHandler.copyAmazonServiceExceptionFields(ase, le);
        throw ase;
    }

    private static void copyAmazonServiceExceptionFields(AmazonServiceException dst, AmazonServiceException src) {
        if (src == null || dst == null) {
            return;
        }
        dst.setErrorCode(src.getErrorCode());
        dst.setStatusCode(src.getStatusCode());
        dst.setRequestId(src.getRequestId());
        dst.setServiceName(src.getServiceName());
        dst.setErrorType(src.getErrorType());
    }
}

