/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.main;

import com.amazonaws.services.dynamodbv2.exceptions.DynamoDBLocalServiceException;
import com.amazonaws.services.dynamodbv2.local.main.CommandLineInput;
import com.amazonaws.services.dynamodbv2.local.server.DynamoDBProxyServer;
import com.amazonaws.services.dynamodbv2.local.server.LocalDynamoDBRequestHandler;
import com.amazonaws.services.dynamodbv2.local.server.LocalDynamoDBServerHandler;
import com.amazonaws.services.dynamodbv2.local.shared.access.sqlite.SQLiteDBAccess;
import java.io.File;
import java.io.FilenameFilter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.ParseException;

public class ServerRunner {
    private static final String WARN = "WARN";
    private static final String ORG_ECLIPSE_JETTY_LEVEL = "org.eclipse.jetty.LEVEL";
    private static final String ORG_ECLIPSE_JETTY_UTIL_LOG_ANNOUNCE = "org.eclipse.jetty.util.log.announce";
    public static final String PROJECT_NAME = "DynamoDBLocal";
    public static final int AUTHORITY_LEVEL = 0;
    public static final int DEFAULT_PORT = 8000;
    public static final String FATAL_ERROR = "A fatal error occured";
    private static final String CLI_ERROR = "Error processing the supplied command line arguments";

    public static void main(String[] args) throws Exception {
        CommandLineInput cli = null;
        try {
            cli = new CommandLineInput(args);
            if (!cli.init()) {
                return;
            }
        }
        catch (ParseException e) {
            System.err.print(CLI_ERROR);
            return;
        }
        try {
            DynamoDBProxyServer server = ServerRunner.createServerFromCommandLineArgs(args);
            server.start();
        }
        catch (DynamoDBLocalServiceException e) {
            System.err.print(FATAL_ERROR + (Object)((Object)e));
        }
        catch (ParseException e) {
            System.err.print(CLI_ERROR);
        }
        catch (IllegalArgumentException e) {
            System.err.print(CLI_ERROR);
        }
    }

    public static DynamoDBProxyServer createServerFromCommandLineArgs(String[] args) throws DynamoDBLocalServiceException, ParseException {
        CommandLineInput cli = new CommandLineInput(args);
        if (!cli.init()) {
            throw new IllegalArgumentException("CLI was not initialized");
        }
        if (cli.shouldOptimizeDBBeforeStartup()) {
            File[] allDBFiles;
            for (File dbFile : allDBFiles = new File(cli.getDbPath()).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".db");
                }
            })) {
                if (!dbFile.isFile()) continue;
                SQLiteDBAccess dbAccess = new SQLiteDBAccess(dbFile);
                dbAccess.optimizeDBBeforeStartup();
                dbAccess.close();
            }
        }
        String sb = "Initializing DynamoDB Local with the following configuration:\nPort:\t" + cli.getPort() + "\nInMemory:\t" + cli.isInMemory() + "\nDbPath:\t" + cli.getDbPath() + "\nSharedDb:\t" + cli.getSharedDb() + "\nshouldDelayTransientStatuses:\t" + cli.shouldDelayTransientStatuses() + "\nCorsParams:\t" + cli.getCorsParams() + "\n";
        System.out.println(sb);
        return ServerRunner.createServer(cli);
    }

    public static DynamoDBProxyServer createServer(CommandLineInput cli) {
        return new DynamoDBProxyServer(cli.getPort(), new LocalDynamoDBServerHandler(new LocalDynamoDBRequestHandler(0, cli.isInMemory(), cli.getDbPath(), cli.getSharedDb(), cli.shouldDelayTransientStatuses()), cli.getCorsParams()));
    }

    static {
        System.setProperty(ORG_ECLIPSE_JETTY_UTIL_LOG_ANNOUNCE, "false");
        System.setProperty(ORG_ECLIPSE_JETTY_LEVEL, WARN);
        Logger.getLogger("com.almworks.sqlite4java").setLevel(Level.WARNING);
    }
}

