/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.lang.eval.Alphabet;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.IDFAState;
import org.partiql.lang.eval.LikeMatchingAutomataKt;
import org.partiql.lang.eval.NFAState;
import org.partiql.lang.util.StringExtensionsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0012\u0018\u00002\u00020\u0001B;\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00000\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004J\u0016\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0000J\b\u0010\u001c\u001a\u00020\tH\u0016J\u0012\u0010\u001d\u001a\u00020\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u00012\u0006\u0010!\u001a\u00020\"H\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\n\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000f\u00a8\u0006#"}, d2={"Lorg/partiql/lang/eval/DFAState;", "Lorg/partiql/lang/eval/IDFAState;", "nfaStates", "", "Lorg/partiql/lang/eval/NFAState;", "outgoing", "", "Lorg/partiql/lang/eval/Alphabet;", "accepting", "", "start", "(Ljava/util/Set;Ljava/util/Map;ZZ)V", "getAccepting", "()Z", "setAccepting", "(Z)V", "getNfaStates", "()Ljava/util/Set;", "getOutgoing", "()Ljava/util/Map;", "getStart", "setStart", "addNFAStates", "", "nfaState", "addTransition", "transition", "target", "isAccepting", "run", "word", "", "step", "codePoint", "", "IonSQLSandbox"})
class DFAState
implements IDFAState {
    @NotNull
    private final Set<NFAState> nfaStates;
    @NotNull
    private final Map<Alphabet, DFAState> outgoing;
    private boolean accepting;
    private boolean start;

    public final void addTransition(@NotNull Alphabet transition, @NotNull DFAState target) {
        Intrinsics.checkParameterIsNotNull(transition, "transition");
        Intrinsics.checkParameterIsNotNull(target, "target");
        if (Intrinsics.areEqual(transition, Alphabet.Epsilon.INSTANCE)) {
            Void void_ = ExceptionsKt.errNoContext("DFA cannot have epsilon transitions: " + transition + ", " + target, true);
            throw null;
        }
        boolean bl = this.outgoing.containsKey(transition);
        if (bl) {
            if (Intrinsics.areEqual(target, this.outgoing.get(transition)) ^ true) {
                Void void_ = ExceptionsKt.errNoContext("DFA cannot have a transition that maps to different targets : " + transition + " -> " + target + " AND " + transition + "  -> " + this.outgoing + ".get(transition)", true);
                throw null;
            }
        } else if (!bl) {
            this.outgoing.put(transition, target);
        }
    }

    public final void addNFAStates(@NotNull NFAState nfaState) {
        Intrinsics.checkParameterIsNotNull(nfaState, "nfaState");
        this.nfaStates.add(nfaState);
        this.accepting = this.accepting || nfaState.isAccepting();
        this.start = this.start || nfaState.isStartState();
    }

    @Override
    public boolean isAccepting() {
        return this.accepting;
    }

    @Override
    @Nullable
    public IDFAState step(int codePoint) {
        Alphabet.Letter trans = new Alphabet.Letter(codePoint);
        boolean bl = this.outgoing.containsKey(trans);
        if (bl) {
            return this.outgoing.get(trans);
        }
        if (this.outgoing.containsKey(Alphabet.AnyOneChar.INSTANCE)) {
            return this.outgoing.get(Alphabet.AnyOneChar.INSTANCE);
        }
        return LikeMatchingAutomataKt.getDFADeadState();
    }

    @Override
    public boolean run(@Nullable String word) {
        IDFAState currentState = this;
        String string = word;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            Sequence<Integer> $this$forEach$iv = StringExtensionsKt.codePointSequence(it);
            boolean $i$f$forEach = false;
            Iterator<Integer> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Integer element$iv = iterator2.next();
                int ele = ((Number)element$iv).intValue();
                boolean bl4 = false;
                IDFAState newState = currentState.step(ele);
                IDFAState iDFAState = newState;
                if (iDFAState == null) {
                    return false;
                }
                if (Intrinsics.areEqual(iDFAState, LikeMatchingAutomataKt.getDFADeadState())) {
                    return false;
                }
                currentState = newState;
            }
        }
        return currentState.isAccepting();
    }

    @NotNull
    public final Set<NFAState> getNfaStates() {
        return this.nfaStates;
    }

    @NotNull
    public final Map<Alphabet, DFAState> getOutgoing() {
        return this.outgoing;
    }

    public final boolean getAccepting() {
        return this.accepting;
    }

    public final void setAccepting(boolean bl) {
        this.accepting = bl;
    }

    public final boolean getStart() {
        return this.start;
    }

    public final void setStart(boolean bl) {
        this.start = bl;
    }

    public DFAState(@NotNull Set<NFAState> nfaStates, @NotNull Map<Alphabet, DFAState> outgoing, boolean accepting, boolean start) {
        Intrinsics.checkParameterIsNotNull(nfaStates, "nfaStates");
        Intrinsics.checkParameterIsNotNull(outgoing, "outgoing");
        this.nfaStates = nfaStates;
        this.outgoing = outgoing;
        this.accepting = accepting;
        this.start = start;
    }

    public /* synthetic */ DFAState(Set set2, Map map2, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        NFAState it;
        Iterable $this$filterTo$iv$iv;
        boolean $i$f$filterTo;
        Collection destination$iv$iv;
        boolean $i$f$filter;
        Iterable $this$filter$iv;
        if ((n & 4) != 0) {
            $this$filter$iv = set2;
            $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (NFAState)element$iv$iv;
                boolean bl3 = false;
                if (!it.isAccepting()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            boolean bl4 = bl = !$this$filter$iv.isEmpty();
        }
        if ((n & 8) != 0) {
            $this$filter$iv = set2;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (NFAState)element$iv$iv;
                boolean bl5 = false;
                if (!it.isStartState()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection collection = (List)destination$iv$iv;
            boolean bl6 = false;
            bl2 = !collection.isEmpty();
        }
        this(set2, map2, bl, bl2);
    }
}

