/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.builtins;

import com.amazon.ion.Timestamp;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.lang.eval.Environment;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.eval.ExprValueExtensionsKt;
import org.partiql.lang.eval.ExprValueFactory;
import org.partiql.lang.eval.NullPropagatingExprFunction;
import org.partiql.lang.eval.builtins.ExtractExprFunction$WhenMappings;
import org.partiql.lang.syntax.DatePart;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0016J\u001e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0016J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002J\f\u0010\u000f\u001a\u00020\r*\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/partiql/lang/eval/builtins/ExtractExprFunction;", "Lorg/partiql/lang/eval/NullPropagatingExprFunction;", "valueFactory", "Lorg/partiql/lang/eval/ExprValueFactory;", "(Lorg/partiql/lang/eval/ExprValueFactory;)V", "call", "Lorg/partiql/lang/eval/ExprValue;", "env", "Lorg/partiql/lang/eval/Environment;", "args", "", "eval", "hourOffset", "", "Lcom/amazon/ion/Timestamp;", "minuteOffset", "IonSQLSandbox"})
public final class ExtractExprFunction
extends NullPropagatingExprFunction {
    private final int hourOffset(@NotNull Timestamp $this$hourOffset) {
        Integer n = $this$hourOffset.getLocalOffset();
        return (n != null ? n : 0) / 60;
    }

    private final int minuteOffset(@NotNull Timestamp $this$minuteOffset) {
        Integer n = $this$minuteOffset.getLocalOffset();
        return (n != null ? n : 0) % 60;
    }

    @Override
    @NotNull
    public ExprValue eval(@NotNull Environment env, @NotNull List<? extends ExprValue> args) {
        int n;
        Intrinsics.checkParameterIsNotNull(env, "env");
        Intrinsics.checkParameterIsNotNull(args, "args");
        DatePart datePart = ExprValueExtensionsKt.datePartValue(args.get(0));
        Timestamp timestamp = ExprValueExtensionsKt.timestampValue(args.get(1));
        switch (ExtractExprFunction$WhenMappings.$EnumSwitchMapping$0[datePart.ordinal()]) {
            case 1: {
                n = timestamp.getYear();
                break;
            }
            case 2: {
                n = timestamp.getMonth();
                break;
            }
            case 3: {
                n = timestamp.getDay();
                break;
            }
            case 4: {
                n = timestamp.getHour();
                break;
            }
            case 5: {
                n = timestamp.getMinute();
                break;
            }
            case 6: {
                n = timestamp.getSecond();
                break;
            }
            case 7: {
                n = this.hourOffset(timestamp);
                break;
            }
            case 8: {
                n = this.minuteOffset(timestamp);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int extracted = n;
        return this.getValueFactory().newInt(extracted);
    }

    @Override
    @NotNull
    public ExprValue call(@NotNull Environment env, @NotNull List<? extends ExprValue> args) {
        Intrinsics.checkParameterIsNotNull(env, "env");
        Intrinsics.checkParameterIsNotNull(args, "args");
        this.checkArity(args);
        return ExprValueExtensionsKt.isUnknown(args.get(1)) ? this.getValueFactory().getNullValue() : this.eval(env, args);
    }

    public ExtractExprFunction(@NotNull ExprValueFactory valueFactory) {
        Intrinsics.checkParameterIsNotNull(valueFactory, "valueFactory");
        super("extract", 2, valueFactory);
    }
}

