/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.ast.passes;

import com.amazon.ion.IntegerSize;
import com.amazon.ion.IonInt;
import com.amazon.ion.IonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.partiql.lang.ast.AstNode;
import org.partiql.lang.ast.CallAgg;
import org.partiql.lang.ast.DataType;
import org.partiql.lang.ast.ExprNode;
import org.partiql.lang.ast.GroupingStrategy;
import org.partiql.lang.ast.Literal;
import org.partiql.lang.ast.MetaContainer;
import org.partiql.lang.ast.NAry;
import org.partiql.lang.ast.NAryOp;
import org.partiql.lang.ast.Select;
import org.partiql.lang.ast.SelectListItemStar;
import org.partiql.lang.ast.SelectProjection;
import org.partiql.lang.ast.SelectProjectionList;
import org.partiql.lang.ast.SelectProjectionPivot;
import org.partiql.lang.ast.SelectProjectionValue;
import org.partiql.lang.ast.SetQuantifier;
import org.partiql.lang.ast.UtilKt;
import org.partiql.lang.ast.passes.SemanticException;
import org.partiql.lang.errors.ErrorCode;
import org.partiql.lang.errors.Property;
import org.partiql.lang.errors.PropertyValueMap;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.util.PropertyMapHelpersKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lorg/partiql/lang/ast/passes/AstSanityValidator;", "", "()V", "checkArity", "", "functionName", "", "expectedRange", "Lkotlin/ranges/IntRange;", "actual", "", "metas", "Lorg/partiql/lang/ast/MetaContainer;", "validate", "astNode", "Lorg/partiql/lang/ast/AstNode;", "IonSQLSandbox"})
public final class AstSanityValidator {
    public static final AstSanityValidator INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final void validate(@NotNull AstNode astNode) {
        Intrinsics.checkParameterIsNotNull(astNode, "astNode");
        Iterable $this$forEach$iv = astNode;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void sqlDataType;
            Object asterisk;
            Iterable metas;
            SelectProjection setQuantifier;
            SetQuantifier op;
            List<Object> args2;
            NAryOp ionValue2;
            KMappedMarker metas2;
            AstNode node = (AstNode)element$iv;
            boolean bl = false;
            AstNode astNode2 = node;
            if (astNode2 instanceof Literal) {
                Literal literal = (Literal)node;
                IonValue ionValue3 = literal.component1();
                metas2 = literal.component2();
                if (!(ionValue2 instanceof IonInt) || ((IonInt)((Object)ionValue2)).getIntegerSize() != IntegerSize.BIG_INTEGER) continue;
                Void void_ = ExceptionsKt.errIntOverflow(ExceptionsKt.errorContextFrom((MetaContainer)metas2));
                throw null;
            }
            if (astNode2 instanceof NAry) {
                NAry nAry = (NAry)node;
                ionValue2 = nAry.component1();
                args2 = nAry.component2();
                INSTANCE.checkArity(((NAryOp)((Object)op)).getSymbol(), ((NAryOp)((Object)op)).getArityRange(), args2.size(), ((NAry)node).getMetas());
                continue;
            }
            if (astNode2 instanceof CallAgg) {
                CallAgg callAgg = (CallAgg)node;
                op = callAgg.component2();
                metas2 = callAgg.component4();
                if (setQuantifier != SetQuantifier.DISTINCT || !metas2.hasMeta("$is_count_star")) continue;
                Void void_ = ExceptionsKt.err("COUNT(DISTINCT *) is not supported", ErrorCode.EVALUATOR_COUNT_DISTINCT_STAR, ExceptionsKt.errorContextFrom((MetaContainer)metas2), false);
                throw null;
            }
            if (astNode2 instanceof Select) {
                void having2;
                void groupBy2;
                Object object = (Select)node;
                setQuantifier = ((Select)object).component2();
                metas2 = ((Select)object).component5();
                ExprNode exprNode = ((Select)object).component6();
                metas = ((Select)object).component9();
                if (groupBy2 != null) {
                    void projection2;
                    if (groupBy2.getGrouping() == GroupingStrategy.PARTIAL) {
                        object = ExceptionsKt.errorContextFrom((MetaContainer)metas);
                        ErrorCode errorCode = ErrorCode.EVALUATOR_FEATURE_NOT_SUPPORTED_YET;
                        String string = "GROUP PARTIAL not supported yet";
                        boolean bl2 = false;
                        boolean bl3 = false;
                        Object it = object;
                        boolean bl4 = false;
                        ((PropertyValueMap)it).set(Property.FEATURE_NAME, "GROUP PARTIAL");
                        Object object2 = object;
                        Void void_ = ExceptionsKt.err(string, errorCode, (PropertyValueMap)object2, false);
                        throw null;
                    }
                    object = projection2;
                    if (object instanceof SelectProjectionPivot) {
                        PropertyValueMap propertyValueMap = ExceptionsKt.errorContextFrom((MetaContainer)metas);
                        ErrorCode errorCode = ErrorCode.EVALUATOR_FEATURE_NOT_SUPPORTED_YET;
                        String string = "PIVOT with GROUP BY not supported yet";
                        boolean bl5 = false;
                        boolean it = false;
                        PropertyValueMap it2 = propertyValueMap;
                        boolean bl6 = false;
                        it2.set(Property.FEATURE_NAME, "PIVOT with GROUP BY");
                        PropertyValueMap propertyValueMap2 = propertyValueMap;
                        Void void_ = ExceptionsKt.err(string, errorCode, propertyValueMap2, false);
                        throw null;
                    }
                    if (object instanceof SelectProjectionValue || object instanceof SelectProjectionList) {
                        // empty if block
                    }
                }
                if (groupBy2 != null && !groupBy2.getGroupByItems().isEmpty() || having2 == null) continue;
                throw (Throwable)new SemanticException("HAVING used without GROUP BY (or grouping expressions)", ErrorCode.SEMANTIC_HAVING_USED_WITHOUT_GROUP_BY, UtilKt.addSourceLocation(new PropertyValueMap(null, 1, null), (MetaContainer)metas), null, 8, null);
            }
            if (astNode2 instanceof SelectProjectionList) {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = ((SelectProjectionList)node).getItems();
                boolean $i$f$filterIsInstance = false;
                metas = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof SelectListItemStar)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                asterisk = (SelectListItemStar)CollectionsKt.firstOrNull((List)destination$iv$iv);
                if (asterisk == null || ((SelectProjectionList)node).getItems().size() <= 1) continue;
                throw (Throwable)new SemanticException("`*` cannot be used with other select list items", ErrorCode.SEMANTIC_ASTERISK_USED_WITH_OTHER_ITEMS, UtilKt.addSourceLocation(new PropertyValueMap(null, 1, null), ((SelectListItemStar)asterisk).getMetas()), null, 8, null);
            }
            if (!(astNode2 instanceof DataType)) continue;
            DataType dataType = (DataType)node;
            asterisk = dataType.component1();
            args2 = dataType.component2();
            if (sqlDataType.getArityRange().contains(args2.size())) continue;
            INSTANCE.checkArity(sqlDataType.name(), sqlDataType.getArityRange(), args2.size(), ((DataType)node).getMetas());
        }
    }

    private final void checkArity(String functionName, IntRange expectedRange, int actual, MetaContainer metas) {
        if (!expectedRange.contains(actual)) {
            throw (Throwable)new SemanticException("Incorrect arity", ErrorCode.SEMANTIC_INCORRECT_NODE_ARITY, UtilKt.addSourceLocation(PropertyMapHelpersKt.propertyValueMapOf(PropertyMapHelpersKt.to(Property.FUNCTION_NAME, functionName), PropertyMapHelpersKt.to(Property.EXPECTED_ARITY_MIN, expectedRange.getFirst()), PropertyMapHelpersKt.to(Property.EXPECTED_ARITY_MAX, expectedRange.getLast()), PropertyMapHelpersKt.to(Property.ACTUAL_ARITY, actual)), metas), null, 8, null);
        }
    }

    private AstSanityValidator() {
    }

    static {
        AstSanityValidator astSanityValidator;
        INSTANCE = astSanityValidator = new AstSanityValidator();
    }
}

