/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ion.impl;

import com.amazon.ion.Decimal;
import com.amazon.ion.IntegerSize;
import com.amazon.ion.IonType;
import com.amazon.ion.NullValueException;
import com.amazon.ion.SymbolTable;
import com.amazon.ion.SymbolToken;
import com.amazon.ion.Timestamp;
import com.amazon.ion.UnknownSymbolException;
import com.amazon.ion.impl.IonBinary;
import com.amazon.ion.impl.IonReaderBinaryRawX;
import com.amazon.ion.impl.SharedSymbolTable;
import com.amazon.ion.impl.SymbolTokenImpl;
import com.amazon.ion.impl.UnifiedInputStreamX;
import com.amazon.ion.impl._Private_ReaderWriter;
import com.amazon.ion.impl._Private_ScalarConversions;
import com.amazon.ion.impl._Private_Utils;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IonReaderBinarySystemX
extends IonReaderBinaryRawX
implements _Private_ReaderWriter {
    SymbolTable _symbols;
    static final int MAX_BINARY_LENGTH_INT = 4;
    static final int MAX_BINARY_LENGTH_LONG = 8;
    static final BigInteger MIN_LONG_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    static final BigInteger MAX_LONG_VALUE = BigInteger.valueOf(Long.MAX_VALUE);

    @Deprecated
    IonReaderBinarySystemX(byte[] bytes, int offset, int length) {
        this(UnifiedInputStreamX.makeStream(bytes, offset, length));
    }

    IonReaderBinarySystemX(UnifiedInputStreamX in) {
        this.init_raw(in);
        this._symbols = SharedSymbolTable.getSystemSymbolTable(1);
    }

    @Override
    public final int getFieldId() {
        return this._value_field_id;
    }

    @Override
    public SymbolToken[] getTypeAnnotationSymbols() {
        this.load_annotations();
        int count = this._annotation_count;
        if (count == 0) {
            return SymbolToken.EMPTY_ARRAY;
        }
        SymbolTable symtab = this.getSymbolTable();
        SymbolToken[] result = new SymbolToken[count];
        for (int i = 0; i < count; ++i) {
            int sid = this._annotation_ids[i];
            String text = symtab.findKnownSymbol(sid);
            result[i] = new SymbolTokenImpl(text, sid);
        }
        return result;
    }

    private void load_once() {
        if (this._v.isEmpty()) {
            try {
                this.load_scalar_value();
            }
            catch (IOException e) {
                this.error(e);
            }
        }
    }

    protected final void prepare_value(int as_type) {
        this.load_once();
        if (as_type != 0 && !this._v.hasValueOfType(as_type)) {
            if (IonType.SYMBOL.equals((Object)this._value_type) && !_Private_ScalarConversions.ValueVariant.isNumericType(as_type)) assert (IonType.SYMBOL.equals((Object)this._value_type) && !_Private_ScalarConversions.ValueVariant.isNumericType(as_type));
            if (!this._v.can_convert(as_type)) {
                String message = "can't cast from " + _Private_ScalarConversions.getValueTypeName(this._v.getAuthoritativeType()) + " to " + _Private_ScalarConversions.getValueTypeName(as_type);
                throw new IllegalStateException(message);
            }
            int fnid = this._v.get_conversion_fnid(as_type);
            this._v.cast(fnid);
        }
    }

    protected final void load_cached_value(int value_type) throws IOException {
        if (this._v.isEmpty()) {
            this.load_scalar_value();
        }
    }

    private final void load_scalar_value() throws IOException {
        switch (this._value_type) {
            case NULL: 
            case BOOL: 
            case INT: 
            case FLOAT: 
            case DECIMAL: 
            case TIMESTAMP: 
            case SYMBOL: 
            case STRING: {
                break;
            }
            default: {
                return;
            }
        }
        if (this._value_is_null) {
            this._v.setValueToNull(this._value_type);
            this._v.setAuthoritativeType(1);
            return;
        }
        switch (this._value_type) {
            default: {
                return;
            }
            case BOOL: {
                this._v.setValue(this._value_is_true);
                this._v.setAuthoritativeType(2);
                break;
            }
            case INT: {
                boolean is_negative;
                boolean bl = is_negative = this._value_tid == 3;
                if (this._value_len == 0) {
                    if (is_negative) {
                        this.throwIllegalNegativeZeroException();
                    }
                    int v = 0;
                    this._v.setValue(v);
                    this._v.setAuthoritativeType(3);
                    break;
                }
                if (this._value_len <= 8) {
                    long v = this.readULong(this._value_len);
                    if (v < 0L) {
                        int signum = !is_negative ? 1 : -1;
                        BigInteger big = IonBinary.unsignedLongToBigInteger(signum, v);
                        this._v.setValue(big);
                        if (big.compareTo(MIN_LONG_VALUE) < 0 || big.compareTo(MAX_LONG_VALUE) > 0) {
                            this._v.setAuthoritativeType(5);
                            break;
                        }
                        this._v.addValue(big.longValue());
                        this._v.setAuthoritativeType(4);
                        break;
                    }
                    if (is_negative) {
                        if (v == 0L) {
                            this.throwIllegalNegativeZeroException();
                        }
                        v = -v;
                    }
                    if (v < Integer.MIN_VALUE || v > Integer.MAX_VALUE) {
                        this._v.setValue(v);
                        this._v.setAuthoritativeType(4);
                        break;
                    }
                    this._v.setValue((int)v);
                    this._v.setAuthoritativeType(3);
                    break;
                }
                BigInteger v = this.readBigInteger(this._value_len, is_negative);
                this._v.setValue(v);
                this._v.setAuthoritativeType(5);
                break;
            }
            case FLOAT: {
                double d = this._value_len == 0 ? 0.0 : this.readFloat(this._value_len);
                this._v.setValue(d);
                this._v.setAuthoritativeType(7);
                break;
            }
            case DECIMAL: {
                Decimal dec = this.readDecimal(this._value_len);
                this._v.setValue(dec);
                this._v.setAuthoritativeType(6);
                break;
            }
            case TIMESTAMP: {
                Timestamp t = this.readTimestamp(this._value_len);
                this._v.setValue(t);
                this._v.setAuthoritativeType(10);
                break;
            }
            case SYMBOL: {
                long sid = this.readULong(this._value_len);
                if (sid < 0L || sid > Integer.MAX_VALUE) {
                    String message = "symbol id [" + sid + "] out of range (1-" + Integer.MAX_VALUE + ")";
                    this.throwErrorAt(message);
                }
                this._v.setValue((int)sid);
                this._v.setAuthoritativeType(3);
                break;
            }
            case STRING: {
                String s = this.readString(this._value_len);
                this._v.setValue(s);
                this._v.setAuthoritativeType(8);
            }
        }
        this._state = IonReaderBinaryRawX.State.S_AFTER_VALUE;
    }

    @Override
    public boolean isNullValue() {
        return this._value_is_null;
    }

    @Override
    public boolean booleanValue() {
        this.prepare_value(2);
        return this._v.getBoolean();
    }

    @Override
    public double doubleValue() {
        this.prepare_value(7);
        return this._v.getDouble();
    }

    private void checkIsIntApplicableType() {
        if (this._value_type != IonType.INT && this._value_type != IonType.DECIMAL && this._value_type != IonType.FLOAT) {
            throw new IllegalStateException("Unexpected value type: " + (Object)((Object)this._value_type));
        }
    }

    @Override
    public int intValue() {
        this.checkIsIntApplicableType();
        this.prepare_value(3);
        return this._v.getInt();
    }

    @Override
    public long longValue() {
        this.checkIsIntApplicableType();
        this.prepare_value(4);
        return this._v.getLong();
    }

    @Override
    public BigInteger bigIntegerValue() {
        this.checkIsIntApplicableType();
        if (this._value_is_null) {
            return null;
        }
        this.prepare_value(5);
        return this._v.getBigInteger();
    }

    @Override
    public BigDecimal bigDecimalValue() {
        if (this._value_is_null) {
            return null;
        }
        this.prepare_value(6);
        return this._v.getBigDecimal();
    }

    @Override
    public Decimal decimalValue() {
        if (this._value_is_null) {
            return null;
        }
        this.prepare_value(6);
        return this._v.getDecimal();
    }

    @Override
    public Date dateValue() {
        if (this._value_is_null) {
            return null;
        }
        this.prepare_value(9);
        return this._v.getDate();
    }

    @Override
    public Timestamp timestampValue() {
        if (this._value_is_null) {
            return null;
        }
        this.prepare_value(10);
        return this._v.getTimestamp();
    }

    @Override
    public IntegerSize getIntegerSize() {
        this.load_once();
        if (this._value_type != IonType.INT || this._v.isNull()) {
            return null;
        }
        return _Private_ScalarConversions.getIntegerSize(this._v.getAuthoritativeType());
    }

    @Override
    public String stringValue() {
        if (!IonType.isText(this._value_type)) {
            throw new IllegalStateException("Unexpected value type: " + (Object)((Object)this._value_type));
        }
        if (this._value_is_null) {
            return null;
        }
        if (this._value_type == IonType.SYMBOL) {
            if (!this._v.hasValueOfType(8)) {
                int sid = this.getSymbolId();
                String name = this._symbols.findKnownSymbol(sid);
                if (name == null) {
                    throw new UnknownSymbolException(sid);
                }
                this._v.addValue(name);
            }
        } else {
            this.prepare_value(8);
        }
        return this._v.getString();
    }

    @Override
    public SymbolToken symbolValue() {
        if (this._value_type != IonType.SYMBOL) {
            throw new IllegalStateException("Unexpected value type: " + (Object)((Object)this._value_type));
        }
        if (this._value_is_null) {
            return null;
        }
        int sid = this.getSymbolId();
        assert (sid != -1);
        String text = this._symbols.findKnownSymbol(sid);
        return new SymbolTokenImpl(text, sid);
    }

    int getSymbolId() {
        if (this._value_type != IonType.SYMBOL) {
            throw new IllegalStateException("Unexpected value type: " + (Object)((Object)this._value_type));
        }
        if (this._value_is_null) {
            throw new NullValueException();
        }
        this.prepare_value(3);
        return this._v.getInt();
    }

    @Override
    public String getFieldName() {
        String name;
        if (this._value_field_id == -1) {
            name = null;
        } else {
            name = this._symbols.findKnownSymbol(this._value_field_id);
            if (name == null) {
                throw new UnknownSymbolException(this._value_field_id);
            }
        }
        return name;
    }

    @Override
    public SymbolToken getFieldNameSymbol() {
        if (this._value_field_id == -1) {
            return null;
        }
        int sid = this._value_field_id;
        String text = this._symbols.findKnownSymbol(sid);
        return new SymbolTokenImpl(text, sid);
    }

    @Override
    public final Iterator<String> iterateTypeAnnotations() {
        String[] annotations = this.getTypeAnnotations();
        return _Private_Utils.stringIterator(annotations);
    }

    @Override
    public final String[] getTypeAnnotations() {
        String[] anns;
        this.load_annotations();
        if (this._annotation_count < 1) {
            anns = _Private_Utils.EMPTY_STRING_ARRAY;
        } else {
            anns = new String[this._annotation_count];
            for (int ii = 0; ii < this._annotation_count; ++ii) {
                anns[ii] = this._symbols.findKnownSymbol(this._annotation_ids[ii]);
                if (anns[ii] != null) continue;
                throw new UnknownSymbolException(this._annotation_ids[ii]);
            }
        }
        return anns;
    }

    @Override
    public SymbolTable getSymbolTable() {
        return this._symbols;
    }

    @Override
    public SymbolTable pop_passed_symbol_table() {
        return null;
    }

    private void throwIllegalNegativeZeroException() {
        throw this.newErrorAt("negative zero is illegal in the binary format");
    }
}

