/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.shared.partiql;

import com.amazonaws.services.dynamodbv2.local.shared.model.AttributeValue;
import java.util.Collections;
import java.util.List;
import org.partiql.lang.ast.ExprNode;

public final class ParsedPartiQLRequest<T extends ExprNode> {
    private final T exprNode;
    private final String subscriberId;
    private final List<AttributeValue> parameters;
    private final Integer maxItemSize;
    private final boolean isConsistentRead;
    private final String continuationToken;
    private final String requestHash;
    private final long smallRequestLogicalIOThreshold;
    private final boolean areIonNumericTypesAllowed;

    private ParsedPartiQLRequest(Builder<T> builder) {
        this.exprNode = ((Builder)builder).exprNode;
        this.subscriberId = ((Builder)builder).subscriberId;
        this.parameters = ((Builder)builder).parameters == null ? Collections.emptyList() : Collections.unmodifiableList(((Builder)builder).parameters);
        this.maxItemSize = ((Builder)builder).maxItemSize;
        this.isConsistentRead = ((Builder)builder).isConsistentRead;
        this.continuationToken = ((Builder)builder).continuationToken;
        this.requestHash = ((Builder)builder).requestHash;
        this.smallRequestLogicalIOThreshold = ((Builder)builder).smallRequestLogicalIOThreshold;
        this.areIonNumericTypesAllowed = ((Builder)builder).areIonNumericTypesAllowed;
    }

    public T getExprNode() {
        return this.exprNode;
    }

    public String getSubscriberId() {
        return this.subscriberId;
    }

    public List<AttributeValue> getParameters() {
        return this.parameters;
    }

    public Integer getMaxItemSize() {
        return this.maxItemSize;
    }

    public boolean getIsConsistentRead() {
        return this.isConsistentRead;
    }

    public String getContinuationToken() {
        return this.continuationToken;
    }

    public String getRequestHash() {
        return this.requestHash;
    }

    public long getSmallRequestLogicalIOThreshold() {
        return this.smallRequestLogicalIOThreshold;
    }

    public boolean getAreIonNumericTypesAllowed() {
        return this.areIonNumericTypesAllowed;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder<T extends ExprNode> {
        private T exprNode;
        private String subscriberId;
        private List<AttributeValue> parameters;
        private Integer maxItemSize;
        private boolean isConsistentRead;
        private String continuationToken;
        private String requestHash;
        private long smallRequestLogicalIOThreshold;
        private boolean areIonNumericTypesAllowed;

        private Builder() {
        }

        public Builder exprNode(T exprNode) {
            this.exprNode = exprNode;
            return this;
        }

        public Builder subscriberId(String subscriberId) {
            this.subscriberId = subscriberId;
            return this;
        }

        public Builder parameters(List<AttributeValue> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder maxItemSize(Integer maxItemSize) {
            this.maxItemSize = maxItemSize;
            return this;
        }

        public Builder isConsistentRead(boolean isConsistentRead) {
            this.isConsistentRead = isConsistentRead;
            return this;
        }

        public Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public Builder requestHash(String requestHash) {
            this.requestHash = requestHash;
            return this;
        }

        public Builder smallRequestLogicalIOThreshold(long smallRequestLogicalIOThreshold) {
            this.smallRequestLogicalIOThreshold = smallRequestLogicalIOThreshold;
            return this;
        }

        public Builder areIonNumericTypesAllowed(boolean areIonNumericTypesAllowed) {
            this.areIonNumericTypesAllowed = areIonNumericTypesAllowed;
            return this;
        }

        public ParsedPartiQLRequest build() {
            return new ParsedPartiQLRequest(this);
        }
    }
}

