/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.exceptions;

import com.amazonaws.services.dynamodbv2.exceptions.AmazonServiceExceptionType;
import com.amazonaws.services.dynamodbv2.exceptions.DynamoDBLocalServiceException;
import com.amazonaws.services.dynamodbv2.local.shared.validate.ErrorFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AWSExceptionFactory
extends ErrorFactory {
    static Logger logger = LogManager.getLogger(AWSExceptionFactory.class);

    public static DynamoDBLocalServiceException buildInternalServerException(String msg) {
        return AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.INTERNAL_SERVER_ERROR, msg);
    }

    public static DynamoDBLocalServiceException buildAWSException(AmazonServiceExceptionType type) {
        return AWSExceptionFactory.buildAWSException(type, null);
    }

    public static DynamoDBLocalServiceException buildAWSException(AmazonServiceExceptionType type, String msg) {
        DynamoDBLocalServiceException ret = null;
        String errorMessage = msg == null ? type.getMessage() : msg;
        ret = new DynamoDBLocalServiceException(errorMessage);
        ret.setStatusCode(type.getResponseStatus());
        ret.setErrorCode(type.getErrorCode());
        return ret;
    }

    @Override
    protected RuntimeException newConditionalCheckFailedException(String message) {
        return AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.CONDITIONAL_CHECK_FAILED_EXCEPTION, message);
    }

    @Override
    protected RuntimeException newInternalServerError(String message) {
        return AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.INTERNAL_SERVER_ERROR, message);
    }

    @Override
    protected RuntimeException newItemCollectionSizeLimitExceededException(String message) {
        return AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.ITEM_COLLECTION_SIZE_LIMIT_EXCEEDED_EXCEPTION, message);
    }

    @Override
    protected RuntimeException newLimitExceededException(String message) {
        return AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.LIMIT_EXCEEDED_EXCEPTION, message);
    }

    @Override
    protected RuntimeException newProvisionedThroughputExceededException(String message) {
        return AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.PROVISIONED_THROUGHPUT_EXCEEDED_EXCEPTION, message);
    }

    @Override
    protected RuntimeException newResourceInUseException(String message) {
        return AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_IN_USE_EXCEPTION, message);
    }

    @Override
    protected RuntimeException newResourceNotFoundException(String message) {
        return AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_NOT_FOUND_EXCEPTION, message);
    }

    @Override
    protected RuntimeException newThrottlingException(String message) {
        return AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.THROTTLING_EXCEPTION, message);
    }

    @Override
    protected RuntimeException newValidationException(String message) {
        return AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, message);
    }
}

