/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.server;

import com.amazonaws.services.dynamodbv2.local.server.AbstractLocalDynamoDBServerHandler;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;

public class DynamoDBProxyServer {
    private final String SHELL_CONTEXT_PATH = "/shell";
    private final String SHELL_CONTEXT_RESOURCE_BASE = ".";
    private final String[] WELCOME_FILES_LIST = new String[]{"index.html"};
    private final String RESOURCE_BASE_PATH = "/DynamoDBShell/";
    private final Server server;
    private final AbstractLocalDynamoDBServerHandler serverHandler;
    protected static Logger logger = LogManager.getLogger(DynamoDBProxyServer.class);

    public DynamoDBProxyServer(int port, AbstractLocalDynamoDBServerHandler a) {
        this.server = new Server(port);
        this.server.setHandler((Handler)this.setUpShell(a));
        this.serverHandler = a;
    }

    public ContextHandlerCollection setUpShell(AbstractLocalDynamoDBServerHandler a) {
        ContextHandler contextShell = new ContextHandler();
        ContextHandler contextDDB = new ContextHandler();
        contextShell.setContextPath("/shell");
        contextShell.setResourceBase(".");
        ResourceHandler rh = new ResourceHandler();
        rh.setDirectoriesListed(true);
        rh.setWelcomeFiles(this.WELCOME_FILES_LIST);
        URL resourceBasePath = this.getClass().getResource("/DynamoDBShell/");
        if (resourceBasePath != null) {
            rh.setResourceBase(resourceBasePath.toExternalForm());
        }
        contextShell.setHandler((Handler)rh);
        contextDDB.setHandler((Handler)a);
        ContextHandlerCollection handler = new ContextHandlerCollection();
        handler.addHandler((Handler)contextDDB);
        handler.addHandler((Handler)contextShell);
        return handler;
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
        this.serverHandler.close();
    }
}

