/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.shared.access;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.regions.Region;
import com.amazonaws.services.dynamodbv2.datamodel.DocumentFactory;
import com.amazonaws.services.dynamodbv2.datamodel.DocumentNodeType;
import com.amazonaws.services.dynamodbv2.datamodel.Expression;
import com.amazonaws.services.dynamodbv2.datamodel.ExpressionExecutor;
import com.amazonaws.services.dynamodbv2.datamodel.ProjectionExpression;
import com.amazonaws.services.dynamodbv2.datamodel.UpdateExpression;
import com.amazonaws.services.dynamodbv2.dbenv.DbEnv;
import com.amazonaws.services.dynamodbv2.exceptions.AWSExceptionFactory;
import com.amazonaws.services.dynamodbv2.exceptions.AmazonServiceExceptionType;
import com.amazonaws.services.dynamodbv2.local.shared.access.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.local.shared.access.DDBType;
import com.amazonaws.services.dynamodbv2.local.shared.access.ExceptionHandler;
import com.amazonaws.services.dynamodbv2.local.shared.access.ListTablesResultInfo;
import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDBAccess;
import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDBComparisonOperator;
import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDBInputConverter;
import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDBOutputConverter;
import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDBUtils;
import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDBValidatorUtils;
import com.amazonaws.services.dynamodbv2.local.shared.access.QueryResultInfo;
import com.amazonaws.services.dynamodbv2.local.shared.access.TableInfo;
import com.amazonaws.services.dynamodbv2.local.shared.dataaccess.LocalDocumentFactory;
import com.amazonaws.services.dynamodbv2.local.shared.env.LocalDBEnv;
import com.amazonaws.services.dynamodbv2.local.shared.exceptions.ExpressionExecutionException;
import com.amazonaws.services.dynamodbv2.local.shared.exceptions.LocalDBAccessException;
import com.amazonaws.services.dynamodbv2.local.shared.exceptions.LocalDBClientExceptionMessage;
import com.amazonaws.services.dynamodbv2.local.shared.exceptions.LocalDBClientExceptionType;
import com.amazonaws.services.dynamodbv2.local.shared.helpers.ExpressionUtils;
import com.amazonaws.services.dynamodbv2.local.shared.jobs.CreateGSIJobScheduler;
import com.amazonaws.services.dynamodbv2.local.shared.jobs.DeleteGSIJobScheduler;
import com.amazonaws.services.dynamodbv2.local.shared.jobs.JobsRegister;
import com.amazonaws.services.dynamodbv2.local.shared.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.local.shared.model.DeleteRequest;
import com.amazonaws.services.dynamodbv2.local.shared.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.local.shared.model.PutRequest;
import com.amazonaws.services.dynamodbv2.local.shared.model.WriteRequest;
import com.amazonaws.services.dynamodbv2.local.shared.validate.RangeQueryExpressionsWrapper;
import com.amazonaws.services.dynamodbv2.local.shared.validate.UpdateItemExpressionsWrapper;
import com.amazonaws.services.dynamodbv2.model.AttributeAction;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.ConditionalOperator;
import com.amazonaws.services.dynamodbv2.model.CreateGlobalSecondaryIndexAction;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.DeleteGlobalSecondaryIndexAction;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexUpdate;
import com.amazonaws.services.dynamodbv2.model.IndexStatus;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.ListTablesRequest;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProjectionType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputDescription;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.Select;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.TableStatus;
import com.amazonaws.services.dynamodbv2.model.UpdateGlobalSecondaryIndexAction;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateTableResult;
import com.amazonaws.services.dynamodbv2.rr.ExpressionWrapper;
import com.amazonaws.services.dynamodbv2.rr.ProjectionExpressionWrapper;
import com.amazonaws.services.dynamodbv2.rr.UpdateExpressionWrapper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalDBClient
implements AmazonDynamoDB {
    private static final Charset UTF8 = Charset.forName("UTF8");
    public static final String DEFAULT_ACCOUNT_NUMBER = "000000000000";
    public static final String DEFAULT_REGION = "ddblocal";
    private static final Logger logger = LogManager.getLogger(LocalDBClient.class);
    private LocalDBAccess dbAccess;
    private final JobsRegister jobs;
    private final LocalDBInputConverter inputConverter;
    private final DbEnv localDBEnv;
    private final DocumentFactory documentFactory;
    private final LocalDBOutputConverter localDBOutputConverter;
    private final AWSExceptionFactory awsExceptionFactory;

    @Deprecated
    public LocalDBClient(LocalDBAccess dbAccess) {
        this(dbAccess, new JobsRegister(Executors.newFixedThreadPool(10), false));
    }

    public LocalDBClient(LocalDBAccess dbAccess, JobsRegister jobs) {
        this.dbAccess = dbAccess;
        this.localDBEnv = new LocalDBEnv();
        this.documentFactory = new LocalDocumentFactory();
        this.awsExceptionFactory = new AWSExceptionFactory();
        this.localDBOutputConverter = new LocalDBOutputConverter();
        this.inputConverter = new LocalDBInputConverter(this.localDBEnv, this.awsExceptionFactory, this.documentFactory, 65536);
        this.jobs = jobs;
        this.jobs.schedule(new CreateGSIJobScheduler(dbAccess, this.jobs));
        this.jobs.schedule(new DeleteGSIJobScheduler(dbAccess, this.jobs));
    }

    public BatchGetItemResult batchGetItem(BatchGetItemRequest batchGetItemRequest) throws AmazonServiceException, AmazonClientException {
        if (batchGetItemRequest.getRequestItems() == null || batchGetItemRequest.getRequestItems().isEmpty()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.BATCH_GET_NULL_REQUESTS.getMessage());
        }
        LocalDBValidatorUtils.validateExprAndAttrToGet(batchGetItemRequest, this.inputConverter);
        Map requestItems = this.inputConverter.externalToInternalBatchGet(null, batchGetItemRequest.getRequestItems());
        int count = 0;
        for (Map.Entry entry : requestItems.entrySet()) {
            String tableName = (String)entry.getKey();
            com.amazonaws.services.dynamodbv2.local.shared.model.KeysAndAttributes requests = (com.amazonaws.services.dynamodbv2.local.shared.model.KeysAndAttributes)entry.getValue();
            count = this.validateBatchGetEntry(tableName, requests, count);
        }
        BatchGetItemResult batchGetResult = new BatchGetItemResult();
        HashMap<String, List<Map<String, AttributeValue>>> responses = new HashMap<String, List<Map<String, AttributeValue>>>();
        HashMap<String, com.amazonaws.services.dynamodbv2.local.shared.model.KeysAndAttributes> unprocessedKeys = new HashMap<String, com.amazonaws.services.dynamodbv2.local.shared.model.KeysAndAttributes>();
        long totalSize = 0L;
        for (Map.Entry entry : requestItems.entrySet()) {
            String tableName = (String)entry.getKey();
            com.amazonaws.services.dynamodbv2.local.shared.model.KeysAndAttributes requests = (com.amazonaws.services.dynamodbv2.local.shared.model.KeysAndAttributes)entry.getValue();
            totalSize = this.doBatchGet(tableName, requests, responses, unprocessedKeys, totalSize);
        }
        batchGetResult.setResponses(this.localDBOutputConverter.internalToExternalBatchGetResponses(responses));
        batchGetResult.setUnprocessedKeys(this.localDBOutputConverter.internalToExternalBatchGetRequests(unprocessedKeys));
        return batchGetResult;
    }

    public BatchWriteItemResult batchWriteItem(BatchWriteItemRequest batchWriteItemRequest) throws AmazonServiceException, AmazonClientException {
        if (batchWriteItemRequest.getRequestItems() == null || batchWriteItemRequest.getRequestItems().isEmpty()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.BATCH_WRITE_NULL_REQUESTS.getMessage());
        }
        int count = 0;
        Long totalRequestSize = 0L;
        Map requestItems = this.inputConverter.externalToInternalBatchWrite(null, batchWriteItemRequest.getRequestItems());
        HashMap<String, ArrayList<Map<String, AttributeValue>>> putsToMake = new HashMap<String, ArrayList<Map<String, AttributeValue>>>();
        HashMap<String, ArrayList<Map<String, AttributeValue>>> deletesToMake = new HashMap<String, ArrayList<Map<String, AttributeValue>>>();
        final HashMap<String, String> tableNameToHashKeyNameMap = new HashMap<String, String>();
        final HashMap<String, String> tableNameToRangeKeyNameMap = new HashMap<String, String>();
        for (Map.Entry entry : requestItems.entrySet()) {
            String tableName = (String)entry.getKey();
            this.validateTableName(tableName);
            TableInfo info = this.validateTableExists(tableName);
            List requests = entry.getValue();
            if (requests == null || requests.isEmpty()) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.BATCH_WRITE_NULL_REQUEST_ENTRY.getMessage());
            }
            if ((count += requests.size()) > 25) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.BATCH_WRITE_TOO_MANY_REQUESTS.getMessage());
            }
            ArrayList<Map<String, AttributeValue>> putsList = new ArrayList<Map<String, AttributeValue>>();
            ArrayList<Map<String, AttributeValue>> deletesList = new ArrayList<Map<String, AttributeValue>>();
            HashSet<Map<String, AttributeValue>> keySet = new HashSet<Map<String, AttributeValue>>();
            for (WriteRequest writeRequest : requests) {
                totalRequestSize = this.validateBatchWriteWriteRequest(writeRequest, info, putsList, deletesList, keySet, totalRequestSize);
            }
            putsToMake.put(tableName, putsList);
            deletesToMake.put(tableName, deletesList);
            tableNameToHashKeyNameMap.put(tableName, info.getHashKey().getAttributeName());
            if (!info.hasRangeKey()) continue;
            tableNameToRangeKeyNameMap.put(tableName, info.getRangeKey().getAttributeName());
        }
        BatchWriteItemResult batchWriteResult = new BatchWriteItemResult();
        HashMap<String, List<WriteRequest>> unprocessedItems = new HashMap<String, List<WriteRequest>>();
        try {
            String tableName;
            for (Map.Entry entry : putsToMake.entrySet()) {
                tableName = (String)entry.getKey();
                final List records = (List)entry.getValue();
                while (!records.isEmpty()) {
                    new LocalDBAccess.ReadLockWithTimeout(this.dbAccess.getLockForTable(tableName), 10){

                        @Override
                        public void criticalSection() {
                            Map curRecord = (Map)records.get(0);
                            AttributeValue rangeKey = null;
                            if (tableNameToRangeKeyNameMap.containsKey(tableName)) {
                                rangeKey = (AttributeValue)curRecord.get(tableNameToRangeKeyNameMap.get(tableName));
                            }
                            LocalDBClient.this.dbAccess.putRecord(tableName, curRecord, (AttributeValue)curRecord.get(tableNameToHashKeyNameMap.get(tableName)), rangeKey, false);
                            records.remove(0);
                        }
                    }.execute();
                }
            }
            for (Map.Entry entry : deletesToMake.entrySet()) {
                tableName = (String)entry.getKey();
                final List keys = (List)entry.getValue();
                while (!keys.isEmpty()) {
                    new LocalDBAccess.ReadLockWithTimeout(this.dbAccess.getLockForTable(tableName), 10){

                        @Override
                        public void criticalSection() {
                            Map curKey = (Map)keys.get(0);
                            LocalDBClient.this.dbAccess.deleteRecord(tableName, curKey);
                            keys.remove(0);
                        }
                    }.execute();
                }
            }
        }
        catch (LocalDBAccessException accessException) {
            ArrayList<WriteRequest> tableRequests;
            String tableName;
            for (Map.Entry entry : deletesToMake.entrySet()) {
                tableName = (String)entry.getKey();
                tableRequests = new ArrayList<WriteRequest>();
                for (Map primaryKey : (List)entry.getValue()) {
                    tableRequests.add(new WriteRequest().withDeleteRequest(new DeleteRequest().withKey(primaryKey)));
                }
                unprocessedItems.put(tableName, tableRequests);
            }
            for (Map.Entry entry : putsToMake.entrySet()) {
                tableName = (String)entry.getKey();
                tableRequests = unprocessedItems.containsKey(tableName) ? (List)unprocessedItems.get(tableName) : new ArrayList();
                for (Map record : (List)entry.getValue()) {
                    tableRequests.add(new WriteRequest().withPutRequest(new PutRequest().withItem(record)));
                }
                unprocessedItems.put(tableName, tableRequests);
            }
        }
        batchWriteResult.setUnprocessedItems(this.localDBOutputConverter.internalToExternalBatchWriteRequests(unprocessedItems));
        return batchWriteResult;
    }

    public CreateTableResult createTable(CreateTableRequest createTableRequest) throws AmazonServiceException, AmazonClientException {
        int maxSize;
        boolean isTheRequestCreatingGSIs;
        AttributeDefinition rangeKey;
        if (createTableRequest == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.INVALID_PARAMETER_VALUE, "createTableRequest was null");
        }
        final String tableName = createTableRequest.getTableName();
        this.validateTableName(tableName);
        List keySchema = createTableRequest.getKeySchema();
        this.validateKeySchema(keySchema);
        int numKeysOnBaseTable = keySchema.size();
        boolean isHashAndRangeKey = numKeysOnBaseTable == 2;
        final List allAttributes = createTableRequest.getAttributeDefinitions();
        this.validateAttributeDefinitions(allAttributes);
        final AttributeDefinition hashKey = LocalDBUtils.findAttributeDefinition((KeySchemaElement)keySchema.get(0), allAttributes);
        if (hashKey == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NON_SPECIFIED_HASH_KEY.getMessage());
        }
        AttributeDefinition attributeDefinition = rangeKey = isHashAndRangeKey ? LocalDBUtils.findAttributeDefinition((KeySchemaElement)keySchema.get(1), allAttributes) : null;
        if (isHashAndRangeKey && rangeKey == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NON_SPECIFIED_RANGE_KEY.getMessage());
        }
        final List lsiIndexes = createTableRequest.getLocalSecondaryIndexes();
        if (!isHashAndRangeKey && lsiIndexes != null && lsiIndexes.size() > 0) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_LSI_ALLOWED.getMessage());
        }
        HashSet<String> lsiNames = new HashSet<String>();
        ArrayList<String> lsiProjAttr = new ArrayList<String>();
        int numLSIKeys = this.validateLSISchema(lsiIndexes, hashKey.getAttributeName(), allAttributes, rangeKey, lsiNames, lsiProjAttr);
        final List gsiIndexes = createTableRequest.getGlobalSecondaryIndexes();
        boolean bl = isTheRequestCreatingGSIs = gsiIndexes != null;
        if (isTheRequestCreatingGSIs) {
            if (gsiIndexes.isEmpty()) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.EMPTY_GSI_LIST.getMessage());
            }
            if (gsiIndexes.size() > 5) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MANY_GSI_VALIDATION_EXCEPTION.getMessage());
            }
        }
        List<GlobalSecondaryIndexDescription> gsiDescList = LocalDBUtils.getGsiDescListFrom(gsiIndexes);
        int numGSIKeys = this.validateGSISchemas(gsiDescList, hashKey, rangeKey, allAttributes, new ArrayList<String>(lsiNames), lsiProjAttr.size());
        int n = maxSize = isHashAndRangeKey ? 2 + numLSIKeys + numGSIKeys : 1 + numGSIKeys;
        if (allAttributes.size() > maxSize) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MANY_ATTRIBUTES.getMessage());
        }
        final ProvisionedThroughput throughput = createTableRequest.getProvisionedThroughput();
        this.validateProvisionedThroughputIncrease(throughput, null);
        this.validateProvisionedThroughputWithGSIs(tableName, throughput, gsiDescList);
        new LocalDBAccess.WriteLockWithTimeout(this.dbAccess.getLockForTable(tableName), 10){

            @Override
            public void criticalSection() {
                LocalDBClient.this.validateTableNotExists(tableName);
                LocalDBClient.this.dbAccess.createTable(tableName, hashKey, rangeKey, allAttributes, lsiIndexes, gsiIndexes, throughput);
            }
        }.execute();
        TableDescription newTableDesc = this.getTableDescriptionHelper(tableName);
        newTableDesc.setItemCount(Long.valueOf(0L));
        newTableDesc.setTableSizeBytes(Long.valueOf(0L));
        CreateTableResult createResult = new CreateTableResult().withTableDescription(newTableDesc);
        return createResult;
    }

    public DeleteItemResult deleteItem(DeleteItemRequest deleteItemRequest) throws AmazonClientException {
        String tableName = deleteItemRequest.getTableName();
        this.validateTableName(tableName);
        TableInfo tableInfo = this.validateTableExists(tableName);
        Map<String, ExpectedAttributeValue> expected = this.inputConverter.externalToInternalExpectedAttributes(deleteItemRequest.getExpected(), 409600);
        ReturnValue returnVals = this.validateReturnType(deleteItemRequest.getReturnValues(), false);
        LocalDBValidatorUtils.validateExpressions(deleteItemRequest, this.inputConverter);
        if (deleteItemRequest.getKey() == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.MISSING_KEY.getMessage());
        }
        Map primaryKey = (Map)this.inputConverter.externalToInternalAttributes(deleteItemRequest.getKey());
        this.validateGetKey(primaryKey, tableInfo);
        this.validateExpecations(expected, deleteItemRequest.getConditionalOperator());
        if (deleteItemRequest.getConditionExpression() == null && expected.isEmpty() && returnVals != ReturnValue.ALL_OLD) {
            return this.itemDelete(tableName, primaryKey);
        }
        if (deleteItemRequest.getConditionExpression() != null) {
            ExpressionWrapper conditionExpressionWrapper = this.inputConverter.externalToInternalConditionExpression(deleteItemRequest.getConditionExpression(), deleteItemRequest.getExpressionAttributeNames(), deleteItemRequest.getExpressionAttributeValues());
            LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(this.dbAccess.getTableInfo(tableName), conditionExpressionWrapper, this.awsExceptionFactory);
            Expression conditionExpression = conditionExpressionWrapper == null ? null : conditionExpressionWrapper.getExpression();
            return this.itemDeleteWithConditionExpression(tableName, returnVals, primaryKey, conditionExpression);
        }
        return this.itemDeleteConditionalOperator(tableName, expected, returnVals, primaryKey, deleteItemRequest.getConditionalOperator());
    }

    private DeleteItemResult itemDeleteWithConditionExpression(final String tableName, final ReturnValue returnVals, final Map<String, AttributeValue> primaryKey, final Expression conditionExpression) {
        final DeleteItemResult deleteResult = new DeleteItemResult();
        new LocalDBAccess.WriteLockWithTimeout(this.dbAccess.getLockForTable(tableName), 10){

            @Override
            public void criticalSection() {
                Map<String, AttributeValue> oldItem = LocalDBClient.this.dbAccess.getRecord(tableName, primaryKey);
                if (!LocalDBClient.this.doesItemMatchConditionExpression(oldItem, conditionExpression)) {
                    ((LocalDBClient)LocalDBClient.this).awsExceptionFactory.CONDITIONAL_CHECK_FAILED.throwAsException();
                }
                LocalDBClient.this.dbAccess.deleteRecord(tableName, primaryKey);
                if (oldItem != null && returnVals == ReturnValue.ALL_OLD) {
                    deleteResult.setAttributes(LocalDBClient.this.localDBOutputConverter.internalToExternalAttributes(oldItem));
                }
            }
        }.execute();
        return deleteResult;
    }

    protected boolean doesItemMatchConditionExpression(Map<String, AttributeValue> item, Expression conditionExpression) {
        if (conditionExpression == null) {
            return true;
        }
        boolean result = false;
        try {
            result = LocalDBUtils.doesItemMatchCondition(item, conditionExpression, this.localDBEnv, this.documentFactory);
        }
        catch (ExpressionExecutionException eee) {
            ExceptionHandler.processExecutionExceptions(ExceptionHandler.ExpressionExecutionContext.EXPECTED_EXPRESSION, eee, this.awsExceptionFactory);
        }
        return result;
    }

    private DeleteItemResult itemDelete(final String tableName, final Map<String, AttributeValue> primaryKey) {
        new LocalDBAccess.ReadLockWithTimeout(this.dbAccess.getLockForTable(tableName), 10){

            @Override
            public void criticalSection() {
                LocalDBClient.this.dbAccess.deleteRecord(tableName, primaryKey);
            }
        }.execute();
        return new DeleteItemResult();
    }

    private DeleteItemResult itemDeleteConditionalOperator(final String tableName, final Map<String, ExpectedAttributeValue> expected, final ReturnValue returnVals, final Map<String, AttributeValue> primaryKey, final String conditionalOperatorAsString) {
        final DeleteItemResult deleteResult = new DeleteItemResult();
        new LocalDBAccess.WriteLockWithTimeout(this.dbAccess.getLockForTable(tableName), 10){

            @Override
            public void criticalSection() {
                Map<String, AttributeValue> oldItem = LocalDBClient.this.dbAccess.getRecord(tableName, primaryKey);
                Map conditions = LocalDBClient.this.convertToConditions(expected);
                LocalDBClient.this.validateConditions(conditions, conditionalOperatorAsString);
                if (!LocalDBClient.this.doesItemMatchConditionalOperator(oldItem, conditions, LocalDBClient.this.conditionalOperatorFrom(conditionalOperatorAsString))) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.CONDITIONAL_CHECK_FAILED_EXCEPTION, LocalDBClientExceptionMessage.CONDITIONAL_CHECK_FAILED.getMessage());
                }
                LocalDBClient.this.dbAccess.deleteRecord(tableName, primaryKey);
                if (oldItem != null && returnVals == ReturnValue.ALL_OLD) {
                    deleteResult.setAttributes(LocalDBClient.this.localDBOutputConverter.internalToExternalAttributes(oldItem));
                }
            }
        }.execute();
        return deleteResult;
    }

    public DeleteTableResult deleteTable(DeleteTableRequest deleteTableRequest) throws AmazonClientException {
        final String tableName = deleteTableRequest.getTableName();
        this.validateTableName(tableName);
        TableDescription description = this.getTableDescriptionHelper(tableName);
        description = this.fillDescriptionHelper(description);
        new LocalDBAccess.WriteLockWithTimeout(this.dbAccess.getLockForTable(tableName), 10){

            @Override
            public void criticalSection() {
                LocalDBClient.this.dbAccess.deleteTable(tableName);
            }
        }.execute();
        DeleteTableResult deleteResult = new DeleteTableResult().withTableDescription(description);
        return deleteResult;
    }

    public DescribeTableResult describeTable(DescribeTableRequest describeTableRequest) throws AmazonServiceException, AmazonClientException {
        String tableName = describeTableRequest.getTableName();
        this.validateTableName(tableName);
        TableDescription description = this.getTableDescriptionHelper(tableName);
        description = this.fillDescriptionHelper(description);
        DescribeTableResult describeResult = new DescribeTableResult().withTable(description);
        return describeResult;
    }

    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return null;
    }

    public GetItemResult getItem(GetItemRequest getItemRequest) throws AmazonServiceException, AmazonClientException {
        String tableName = getItemRequest.getTableName();
        this.validateTableName(tableName);
        this.validateAttributesToGet(getItemRequest.getAttributesToGet());
        LocalDBValidatorUtils.validateExpressions(getItemRequest, this.inputConverter);
        TableInfo tableInfo = this.validateTableExists(tableName);
        ProjectionExpressionWrapper projectionExpressionWrapper = this.inputConverter.externalToInternalProjectionExpression(getItemRequest.getProjectionExpression(), getItemRequest.getExpressionAttributeNames());
        ProjectionExpression projectionExpression = projectionExpressionWrapper == null ? null : projectionExpressionWrapper.getProjection();
        LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(tableInfo, projectionExpressionWrapper, this.awsExceptionFactory);
        if (getItemRequest.getKey() == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.MISSING_KEY.getMessage());
        }
        Map primaryKey = (Map)this.inputConverter.externalToInternalAttributes(getItemRequest.getKey());
        this.validateGetKey(primaryKey, tableInfo);
        Map<String, AttributeValue> item = this.dbAccess.getRecord(tableName, primaryKey);
        Map<String, AttributeValue> filteredAttributes = null;
        filteredAttributes = getItemRequest.getProjectionExpression() != null ? LocalDBUtils.projectAttributes(item, projectionExpression) : LocalDBUtils.projectAttributes(item, getItemRequest.getAttributesToGet());
        GetItemResult getResult = new GetItemResult().withItem(this.localDBOutputConverter.internalToExternalAttributes(filteredAttributes));
        return getResult;
    }

    public ListTablesResult listTables() throws AmazonServiceException, AmazonClientException {
        ListTablesResultInfo initResults = this.dbAccess.listTables(null, 100L);
        ListTablesResult listResult = new ListTablesResult().withTableNames(initResults.getTableNames()).withLastEvaluatedTableName(initResults.getLastEvaluatedTableName());
        return listResult;
    }

    public ListTablesResult listTables(ListTablesRequest listTablesRequest) throws AmazonServiceException, AmazonClientException {
        long limit = this.validateLimitValueListTables(listTablesRequest.getLimit());
        String exclusiveStartTableName = listTablesRequest.getExclusiveStartTableName();
        if (exclusiveStartTableName != null) {
            this.validateTableName(exclusiveStartTableName);
        }
        ListTablesResultInfo initResults = this.dbAccess.listTables(exclusiveStartTableName, limit);
        ListTablesResult listResult = new ListTablesResult().withTableNames(initResults.getTableNames()).withLastEvaluatedTableName(initResults.getLastEvaluatedTableName());
        return listResult;
    }

    public PutItemResult putItem(final PutItemRequest putItemRequest) throws AmazonServiceException, AmazonClientException {
        final String tableName = putItemRequest.getTableName();
        this.validateTableName(tableName);
        final TableInfo tableInfo = this.validateTableExists(tableName);
        final ReturnValue returnVals = this.validateReturnType(putItemRequest.getReturnValues(), false);
        LocalDBValidatorUtils.validateExpressions(putItemRequest, this.inputConverter);
        if (putItemRequest.getItem() == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_PUT_NULL.getMessage());
        }
        final Map record = (Map)this.inputConverter.externalToInternalAttributes(putItemRequest.getItem());
        final Map<String, AttributeValue> key = this.validatePutItem(record, tableInfo);
        final Map<String, ExpectedAttributeValue> expected = this.inputConverter.externalToInternalExpectedAttributes(putItemRequest.getExpected(), 409600);
        final PutItemResult putResult = new PutItemResult();
        String conditionExpressionString = putItemRequest.getConditionExpression();
        String conditionalOperatorAsString = putItemRequest.getConditionalOperator();
        this.validateExpecations(expected, conditionalOperatorAsString);
        if (conditionExpressionString == null && expected.isEmpty()) {
            new LocalDBAccess.WriteLockWithTimeout(this.dbAccess.getLockForTable(tableName), 10){

                @Override
                public void criticalSection() {
                    LocalDBClient.this.putItem(tableName, tableInfo, returnVals, record, key, putResult);
                }
            }.execute();
        } else if (conditionExpressionString != null) {
            ExpressionWrapper conditionExpressionWrapper = this.inputConverter.externalToInternalConditionExpression(conditionExpressionString, putItemRequest.getExpressionAttributeNames(), putItemRequest.getExpressionAttributeValues());
            final Expression conditionExpression = conditionExpressionWrapper == null ? null : conditionExpressionWrapper.getExpression();
            LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(tableInfo, conditionExpressionWrapper, this.awsExceptionFactory);
            new LocalDBAccess.WriteLockWithTimeout(this.dbAccess.getLockForTable(tableName), 10){

                @Override
                public void criticalSection() {
                    LocalDBClient.this.putItemWithConditionExpression(tableName, tableInfo, returnVals, record, key, conditionExpression, putResult);
                }
            }.execute();
        } else {
            new LocalDBAccess.WriteLockWithTimeout(this.dbAccess.getLockForTable(tableName), 10){

                @Override
                public void criticalSection() {
                    LocalDBClient.this.putItemConditionalOperator(putItemRequest, tableName, tableInfo, returnVals, record, key, expected, putResult);
                }
            }.execute();
        }
        return putResult;
    }

    protected void putItemWithConditionExpression(String tableName, TableInfo tableInfo, ReturnValue returnVals, Map<String, AttributeValue> record, Map<String, AttributeValue> key, Expression conditionExpression, PutItemResult putResult) {
        Map<String, AttributeValue> oldItem = this.dbAccess.getRecord(tableName, key);
        if (conditionExpression != null && !LocalDBUtils.doesItemMatchCondition(oldItem, conditionExpression, this.localDBEnv, this.documentFactory)) {
            this.awsExceptionFactory.CONDITIONAL_CHECK_FAILED.throwAsException();
        }
        AttributeValue rangeKey = null;
        if (tableInfo != null && tableInfo.hasRangeKey()) {
            rangeKey = key.get(tableInfo.getRangeKey().getAttributeName());
        }
        this.dbAccess.putRecord(tableName, record, key.get(tableInfo.getHashKey().getAttributeName()), rangeKey, false);
        if (returnVals == ReturnValue.ALL_OLD) {
            putResult.setAttributes(this.localDBOutputConverter.internalToExternalAttributes(oldItem));
        }
    }

    private void putItemConditionalOperator(PutItemRequest putItemRequest, String tableName, TableInfo tableInfo, ReturnValue returnVals, Map<String, AttributeValue> record, Map<String, AttributeValue> key, Map<String, ExpectedAttributeValue> expected, PutItemResult putResult) {
        Map<String, AttributeValue> oldItem = this.dbAccess.getRecord(tableName, key);
        String conditionalOperatorAsString = putItemRequest.getConditionalOperator();
        this.validateExpecations(expected, conditionalOperatorAsString);
        Map<String, com.amazonaws.services.dynamodbv2.local.shared.model.Condition> conditions = this.convertToConditions(expected);
        this.validateConditions(conditions, conditionalOperatorAsString);
        if (!this.doesItemMatchConditionalOperator(oldItem, conditions, this.conditionalOperatorFrom(conditionalOperatorAsString))) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.CONDITIONAL_CHECK_FAILED_EXCEPTION, LocalDBClientExceptionMessage.CONDITIONAL_CHECK_FAILED.getMessage());
        }
        AttributeValue rangeKey = null;
        if (tableInfo.hasRangeKey()) {
            rangeKey = key.get(tableInfo.getRangeKey().getAttributeName());
        }
        this.dbAccess.putRecord(tableName, record, key.get(tableInfo.getHashKey().getAttributeName()), rangeKey, false);
        if (returnVals == ReturnValue.ALL_OLD) {
            putResult.setAttributes(this.localDBOutputConverter.internalToExternalAttributes(oldItem));
        }
    }

    private void putItem(String tableName, TableInfo tableInfo, ReturnValue returnVals, Map<String, AttributeValue> record, Map<String, AttributeValue> key, PutItemResult putResult) {
        Map<String, AttributeValue> oldItem = null;
        if (returnVals == ReturnValue.ALL_OLD) {
            oldItem = this.dbAccess.getRecord(tableName, key);
        }
        AttributeValue rangeKey = null;
        if (tableInfo.hasRangeKey()) {
            rangeKey = key.get(tableInfo.getRangeKey().getAttributeName());
        }
        this.dbAccess.putRecord(tableName, record, key.get(tableInfo.getHashKey().getAttributeName()), rangeKey, false);
        if (returnVals == ReturnValue.ALL_OLD) {
            putResult.setAttributes(this.localDBOutputConverter.internalToExternalAttributes(oldItem));
        }
    }

    private ConditionalOperator conditionalOperatorFrom(String conditionalOperator) {
        return conditionalOperator == null ? ConditionalOperator.AND : ConditionalOperator.fromValue((String)conditionalOperator);
    }

    public QueryResult query(QueryRequest queryRequest) throws AmazonClientException {
        int keySchemaSize;
        AttributeDefinition hashKeyDef;
        String tableName = queryRequest.getTableName();
        this.validateTableName(tableName);
        TableInfo tableInfo = this.validateTableExists(tableName);
        long limit = this.validateLimitValue(queryRequest.getLimit());
        Boolean asc = queryRequest.getScanIndexForward();
        boolean ascending = asc == null ? true : asc;
        boolean isGSIIndex = false;
        String indexName = queryRequest.getIndexName();
        if (indexName != null) {
            if (!tableInfo.hasIndex(indexName)) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.format(LocalDBClientExceptionMessage.SECONDARY_INDEXES_NOT_FOUND.getMessage(), indexName));
            }
            if (tableInfo.isGSIIndex(indexName)) {
                isGSIIndex = true;
            }
        }
        LocalDBValidatorUtils.validateExpressions(queryRequest, this.inputConverter);
        RangeQueryExpressionsWrapper rangeQueryExpressionsWrapper = this.inputConverter.externalToInternalExpressions(queryRequest.getFilterExpression(), queryRequest.getProjectionExpression(), queryRequest.getKeyConditionExpression(), queryRequest.getExpressionAttributeNames(), queryRequest.getExpressionAttributeValues());
        ExpressionWrapper filterExpressionWrapper = rangeQueryExpressionsWrapper == null ? null : rangeQueryExpressionsWrapper.getFilterExpressionWrapper();
        ProjectionExpressionWrapper projectionExpressionWrapper = rangeQueryExpressionsWrapper == null ? null : rangeQueryExpressionsWrapper.getProjectionExpressionWrapper();
        ExpressionWrapper keyConditionExpressionWrapper = rangeQueryExpressionsWrapper == null ? null : rangeQueryExpressionsWrapper.getKeyConditionExpressionWrapper();
        Expression filterExpression = filterExpressionWrapper == null ? null : filterExpressionWrapper.getExpression();
        ProjectionExpression projectionExpression = projectionExpressionWrapper == null ? null : projectionExpressionWrapper.getProjection();
        LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(tableInfo, filterExpressionWrapper, this.awsExceptionFactory);
        LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(tableInfo, projectionExpressionWrapper, this.awsExceptionFactory);
        LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(tableInfo, keyConditionExpressionWrapper, this.awsExceptionFactory);
        Map<String, com.amazonaws.services.dynamodbv2.local.shared.model.Condition> conditions = this.inputConverter.externalToInternalKeyConditions(queryRequest.getKeyConditions(), keyConditionExpressionWrapper);
        if (conditions == null) {
            this.awsExceptionFactory.MISSING_KEY_CONDITIONS_AND_EXPRESSION.throwAsException();
        } else if (conditions.size() == 0 || conditions.size() > 2) {
            this.awsExceptionFactory.INVALID_KEY_CONDITIONS_SIZE.throwAsException();
        }
        if (indexName != null && tableInfo.isGSIIndex(indexName)) {
            if (queryRequest.getConsistentRead() != null && queryRequest.getConsistentRead().booleanValue()) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.CONSISTENT_GSI_QUERY.getMessage());
            }
            hashKeyDef = tableInfo.getGSIHashKey(indexName);
        } else {
            hashKeyDef = tableInfo.getHashKey();
        }
        AttributeDefinition rangeKeyDef = null;
        rangeKeyDef = indexName != null ? (tableInfo.isGSIIndex(indexName) ? tableInfo.getGSIRangeKey(indexName) : tableInfo.getLSIRangeKey(indexName)) : tableInfo.getRangeKey();
        int n = keySchemaSize = rangeKeyDef == null ? 1 : 2;
        if (conditions.size() > keySchemaSize) {
            this.awsExceptionFactory.UNSUPPORTED_QUERY_KEY_CONDITION_SEQUENCE.throwAsException();
        }
        this.validateHashKeyCondition(hashKeyDef, conditions);
        if (rangeKeyDef != null) {
            this.validateRangeKeyCondition(rangeKeyDef, conditions);
        }
        Map exclusiveStartKey = null;
        if (queryRequest.getExclusiveStartKey() != null) {
            exclusiveStartKey = (Map)this.inputConverter.externalToInternalAttributes(queryRequest.getExclusiveStartKey());
        }
        List<AttributeDefinition> keyDefs = this.getKeyAttributes(tableInfo, indexName);
        this.validateExclusiveStartKeyQuery(exclusiveStartKey, keyDefs, conditions, ascending, tableInfo.getRangeKey());
        Map<String, com.amazonaws.services.dynamodbv2.local.shared.model.Condition> queryFilters = this.inputConverter.externalToInternalConditions(queryRequest.getQueryFilter());
        if (queryFilters == null) {
            queryFilters = new HashMap();
        }
        this.validateConditions(queryFilters, queryRequest.getConditionalOperator());
        if (indexName != null) {
            this.validateQueryFilterAndFilterExprOnIndex(queryFilters, filterExpression, indexName, tableInfo);
        }
        Select select = this.validateSelect(queryRequest.getSelect(), queryRequest.getAttributesToGet(), projectionExpression, indexName, tableInfo);
        QueryResultInfo results = this.dbAccess.queryRecords(tableName, indexName, conditions, exclusiveStartKey, limit, ascending, null, null, false, isGSIIndex);
        QueryResult queryResult = new QueryResult();
        int scannedItemCount = 0;
        List<Map<String, AttributeValue>> dbRecords = results.getReturnedRecords();
        Map<String, AttributeValue> lastEvaluatedItem = null;
        long totalSize = 0L;
        ArrayList<Map<String, AttributeValue>> dbRecordsAfterFiltering = new ArrayList<Map<String, AttributeValue>>();
        ConditionalOperator conditionalOperator = this.conditionalOperatorFrom(queryRequest.getConditionalOperator());
        for (Map<String, AttributeValue> item : dbRecords) {
            ++scannedItemCount;
            lastEvaluatedItem = item;
            if (!this.doesItemMatchConditionalOperator(item, queryFilters, conditionalOperator) || !this.doesItemMatchFilterExpression(item, filterExpression)) continue;
            dbRecordsAfterFiltering.add(item);
            if ((totalSize += LocalDBUtils.getItemSizeBytes(item)) < 0x100000L) continue;
            break;
        }
        if (scannedItemCount == dbRecords.size()) {
            lastEvaluatedItem = results.getLastEvaluatedItem();
        }
        queryResult.setCount(Integer.valueOf(dbRecordsAfterFiltering.size()));
        queryResult.setScannedCount(Integer.valueOf(scannedItemCount));
        if (select != Select.COUNT) {
            ArrayList<Map<String, AttributeValue>> filteredList = new ArrayList<Map<String, AttributeValue>>();
            if (queryRequest.getProjectionExpression() != null) {
                filteredList.addAll(LocalDBUtils.projectAttributesList(dbRecordsAfterFiltering, projectionExpression));
            } else {
                List<String> attributesToGet = this.determineAttributesToGetForQuery(queryRequest, tableInfo, indexName, select);
                filteredList.addAll(LocalDBUtils.projectAttributesList(dbRecordsAfterFiltering, attributesToGet));
            }
            queryResult.setItems(this.localDBOutputConverter.internalToExternalItemList(filteredList));
        }
        ArrayList<String> keyAttrs = new ArrayList<String>();
        for (AttributeDefinition attrDef : keyDefs) {
            keyAttrs.add(attrDef.getAttributeName());
        }
        Map<String, AttributeValue> lastKey = LocalDBUtils.projectAttributes(lastEvaluatedItem, keyAttrs);
        if (lastKey != null && this.exclusiveStartFitsConditions(lastKey, conditions, ascending, tableInfo.getRangeKey())) {
            queryResult.setLastEvaluatedKey(this.localDBOutputConverter.internalToExternalAttributes(lastKey));
        } else {
            queryResult.setLastEvaluatedKey(null);
        }
        if (indexName == null && !tableInfo.hasRangeKey()) {
            queryResult.setLastEvaluatedKey(null);
        }
        return queryResult;
    }

    private List<String> determineAttributesToGetForQuery(QueryRequest queryRequest, TableInfo tableInfo, String indexName, Select select) {
        if (select == Select.SPECIFIC_ATTRIBUTES) {
            return queryRequest.getAttributesToGet();
        }
        if (select == Select.ALL_PROJECTED_ATTRIBUTES) {
            Projection indexProjection = tableInfo.getProjection(indexName);
            switch (ProjectionType.fromValue((String)indexProjection.getProjectionType())) {
                case INCLUDE: {
                    List<String> attributesToGet = this.getAttributeNames(this.getKeyAttributes(tableInfo, indexName));
                    attributesToGet.addAll(indexProjection.getNonKeyAttributes());
                    return attributesToGet;
                }
                case KEYS_ONLY: {
                    return this.getAttributeNames(this.getKeyAttributes(tableInfo, indexName));
                }
                case ALL: {
                    return null;
                }
            }
        } else {
            return null;
        }
        LocalDBUtils.ldClientFail(LocalDBClientExceptionType.UNREACHABLE_CODE);
        return null;
    }

    private void validateQueryFilterAndFilterExprOnIndex(Map<String, com.amazonaws.services.dynamodbv2.local.shared.model.Condition> queryFilter, Expression expression, String indexName, TableInfo tableInfo) {
        List<String> attributesThatAreNotProjectedOnIndex = this.getNonProjectedAttributeNames(queryFilter, expression, indexName, tableInfo);
        if (attributesThatAreNotProjectedOnIndex.size() > 0) {
            Collections.sort(attributesThatAreNotProjectedOnIndex);
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.format(LocalDBClientExceptionMessage.INVALID_PARAMETER_VALUE.getMessage(), "Secondary index " + indexName + " does not project one or more filter attributes: " + attributesThatAreNotProjectedOnIndex));
        }
    }

    private List<String> getNonProjectedAttributeNames(Map<String, com.amazonaws.services.dynamodbv2.local.shared.model.Condition> queryFilter, Expression expression, String indexName, TableInfo tableInfo) {
        Projection projection = tableInfo.getProjection(indexName);
        ProjectionType projectionType = ProjectionType.fromValue((String)projection.getProjectionType());
        if (projectionType == ProjectionType.ALL) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        if (queryFilter != null) {
            list.addAll(queryFilter.keySet());
        }
        if (expression != null) {
            list.addAll(ExpressionUtils.getConditionExpressionTopLevelAttributes(expression, this.localDBEnv));
        }
        if (projection.getNonKeyAttributes() != null) {
            list.removeAll(projection.getNonKeyAttributes());
        }
        list.removeAll(this.getKeyAttributeNames(tableInfo));
        return list;
    }

    private ArrayList<String> getKeyAttributeNames(TableInfo tableInfo) {
        ArrayList<String> list = new ArrayList<String>();
        for (KeySchemaElement keySchemaElement : tableInfo.getKeySchema()) {
            list.add(keySchemaElement.getAttributeName());
        }
        return list;
    }

    private List<AttributeDefinition> getKeyAttributes(TableInfo tableInfo, String indexName) {
        ArrayList<AttributeDefinition> attributesToGet = new ArrayList<AttributeDefinition>();
        HashSet<String> attrs = new HashSet<String>();
        attributesToGet.add(tableInfo.getHashKey());
        attrs.add(tableInfo.getHashKey().getAttributeName());
        if (tableInfo.hasRangeKey()) {
            attributesToGet.add(tableInfo.getRangeKey());
            attrs.add(tableInfo.getRangeKey().getAttributeName());
        }
        if (indexName != null) {
            if (tableInfo.isLSIIndex(indexName)) {
                String indexRangeKeyName = tableInfo.getLSIRangeKey(indexName).getAttributeName();
                if (!attrs.contains(indexRangeKeyName)) {
                    attributesToGet.add(tableInfo.getLSIRangeKey(indexName));
                }
            } else {
                String gsiRangeKey;
                String gsiHashKey = tableInfo.getGSIHashKey(indexName).getAttributeName();
                if (!attrs.contains(gsiHashKey)) {
                    attributesToGet.add(tableInfo.getGSIHashKey(indexName));
                }
                if (tableInfo.getGSIRangeKey(indexName) != null && !attrs.contains(gsiRangeKey = tableInfo.getGSIRangeKey(indexName).getAttributeName())) {
                    attributesToGet.add(tableInfo.getGSIRangeKey(indexName));
                }
            }
        }
        return attributesToGet;
    }

    public List<String> getAttributeNames(List<AttributeDefinition> attrsDefs) {
        ArrayList<String> attributes = new ArrayList<String>();
        for (AttributeDefinition attrDef : attrsDefs) {
            attributes.add(attrDef.getAttributeName());
        }
        return attributes;
    }

    public ScanResult scan(ScanRequest scanRequest) throws AmazonServiceException, AmazonClientException {
        String tableName = scanRequest.getTableName();
        this.validateTableName(tableName);
        TableInfo info = this.validateTableExists(tableName);
        String indexName = scanRequest.getIndexName();
        if (indexName != null && !info.hasIndex(indexName)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.format(LocalDBClientExceptionMessage.SECONDARY_INDEXES_NOT_FOUND.getMessage(), indexName));
        }
        boolean isGsiIndex = indexName != null && info.isGSIIndex(indexName);
        LocalDBValidatorUtils.validateExpressions(scanRequest, this.inputConverter);
        HashMap<String, com.amazonaws.services.dynamodbv2.local.shared.model.Condition> scanFilter = this.inputConverter.externalToInternalConditions(scanRequest.getScanFilter());
        scanFilter = scanFilter == null ? new HashMap<String, com.amazonaws.services.dynamodbv2.local.shared.model.Condition>() : scanFilter;
        this.validateConditions(scanFilter, scanRequest.getConditionalOperator());
        long limit = this.validateLimitValue(scanRequest.getLimit());
        RangeQueryExpressionsWrapper rangeQueryExpressionsWrapper = this.inputConverter.externalToInternalExpressions(scanRequest.getFilterExpression(), scanRequest.getProjectionExpression(), null, scanRequest.getExpressionAttributeNames(), scanRequest.getExpressionAttributeValues());
        ExpressionWrapper filterExpressionWrapper = rangeQueryExpressionsWrapper == null ? null : rangeQueryExpressionsWrapper.getFilterExpressionWrapper();
        Expression filterExpression = filterExpressionWrapper == null ? null : filterExpressionWrapper.getExpression();
        ProjectionExpressionWrapper projectionExpressionWrapper = rangeQueryExpressionsWrapper == null ? null : rangeQueryExpressionsWrapper.getProjectionExpressionWrapper();
        ProjectionExpression projectionExpression = projectionExpressionWrapper == null ? null : projectionExpressionWrapper.getProjection();
        Map exclusiveStartKey = null;
        if (scanRequest.getExclusiveStartKey() != null) {
            exclusiveStartKey = (Map)this.inputConverter.externalToInternalAttributes(scanRequest.getExclusiveStartKey());
        }
        List<AttributeDefinition> keyDefs = this.getKeyAttributes(info, indexName);
        this.validateExclusiveStartKey(exclusiveStartKey, keyDefs);
        Select select = this.validateSelect(scanRequest.getSelect(), scanRequest.getAttributesToGet(), projectionExpression, indexName, info);
        String projectionExpressionString = scanRequest.getProjectionExpression();
        List<String> attributesToGet = this.determineAttributesToGetForScan(scanRequest, info, indexName, select);
        byte[] beginHash = null;
        byte[] endHash = null;
        if (scanRequest.getSegment() != null | scanRequest.getTotalSegments() != null) {
            this.validateParallelScanRequest(scanRequest.getSegment(), scanRequest.getTotalSegments());
            beginHash = LocalDBClient.getSegmentBeginningHashKey(scanRequest.getTotalSegments(), scanRequest.getSegment());
            endHash = LocalDBClient.getSegmentEndHashKey(scanRequest.getTotalSegments(), scanRequest.getSegment());
            this.validateParallelScanExclusiveStartKey(beginHash, endHash, exclusiveStartKey, info.getHashKey());
        }
        LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(info, filterExpressionWrapper, this.awsExceptionFactory);
        LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(info, projectionExpressionWrapper, this.awsExceptionFactory);
        QueryResultInfo results = this.dbAccess.queryRecords(tableName, indexName, null, exclusiveStartKey, limit, true, beginHash, endHash, true, isGsiIndex);
        ScanResult scanResult = new ScanResult();
        int scannedItemCount = 0;
        long totalSize = 0L;
        List<Map<String, AttributeValue>> dbRecords = results.getReturnedRecords();
        ConditionalOperator conditionalOperator = this.conditionalOperatorFrom(scanRequest.getConditionalOperator());
        ArrayList<Map<String, AttributeValue>> dbRecordsAfterFiltering = new ArrayList<Map<String, AttributeValue>>();
        for (Map<String, AttributeValue> item : dbRecords) {
            long itemSize;
            if (this.doesItemMatchConditionalOperator(item, scanFilter, conditionalOperator) && this.doesItemMatchFilterExpression(item, filterExpression)) {
                if (select != Select.COUNT) {
                    Map<String, AttributeValue> filteredItem = null;
                    filteredItem = projectionExpressionString == null && attributesToGet != null ? LocalDBUtils.projectAttributes(item, attributesToGet) : (projectionExpressionString != null ? LocalDBUtils.projectAttributes(item, projectionExpression) : item);
                    if (filteredItem != null) {
                        dbRecordsAfterFiltering.add(filteredItem);
                    }
                } else {
                    dbRecordsAfterFiltering.add(item);
                }
            }
            if (totalSize + (itemSize = LocalDBUtils.getItemSizeBytes(item)) >= 0x100000L) {
                ++scannedItemCount;
                break;
            }
            totalSize += itemSize;
            ++scannedItemCount;
        }
        if (select != Select.COUNT) {
            scanResult.setItems(this.localDBOutputConverter.internalToExternalItemList(dbRecordsAfterFiltering));
        }
        scanResult.setCount(Integer.valueOf(dbRecordsAfterFiltering.size()));
        scanResult.setScannedCount(Integer.valueOf(scannedItemCount));
        Map<String, AttributeValue> lastItem = scannedItemCount > 0 && scannedItemCount < results.getReturnedRecords().size() ? results.getReturnedRecords().get(scannedItemCount - 1) : results.getLastEvaluatedItem();
        Map<String, AttributeValue> lastKey = LocalDBUtils.projectAttributes(lastItem, this.getAttributeNames(keyDefs));
        scanResult.setLastEvaluatedKey(this.localDBOutputConverter.internalToExternalAttributes(lastKey));
        return scanResult;
    }

    private boolean doesItemMatchFilterExpression(Map<String, AttributeValue> item, Expression filterExpression) {
        if (filterExpression == null) {
            return true;
        }
        boolean itemMatchesFilter = false;
        try {
            itemMatchesFilter = LocalDBUtils.doesItemMatchCondition(item, filterExpression, this.localDBEnv, this.documentFactory);
        }
        catch (ExpressionExecutionException eee) {
            ExceptionHandler.processFilterExpressionExecutionException(eee, this.awsExceptionFactory);
        }
        return itemMatchesFilter;
    }

    private void validateParallelScanExclusiveStartKey(byte[] beginHash, byte[] endHash, Map<String, AttributeValue> exclusiveStartKey, AttributeDefinition hashKeyDef) {
        if (exclusiveStartKey == null) {
            return;
        }
        byte[] exclusiveStartHashVal = LocalDBUtils.getHashValue(exclusiveStartKey.get(hashKeyDef.getAttributeName()));
        if (LocalDBUtils.compareUnsignedByteArrays(exclusiveStartHashVal, beginHash) < 0 || LocalDBUtils.compareUnsignedByteArrays(exclusiveStartHashVal, endHash) > 0) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_EXCLUSIVE_START_KEY_FOR_SCAN.getMessage());
        }
    }

    private void validateParallelScanRequest(Integer segment, Integer totalSegments) {
        if (segment == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.SEGMENT_NOT_SET.getMessage());
        }
        if (totalSegments == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOTAL_SEGMENTS_NOT_SET.getMessage());
        }
        if (segment < 0 || segment >= totalSegments) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, "1 validation error detected: Value '" + segment + "' at 'segment' failed to satisfy constraint:" + " Member must have value less than or equal to " + (totalSegments - 1));
        }
        if (totalSegments <= 0 || totalSegments > 1000000) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, "1 validation error detected: Value '" + totalSegments + "' at 'totalSegments' failed to satisfy" + " constraint: Member must have value less than or equal to " + 1000000);
        }
    }

    private List<String> determineAttributesToGetForScan(ScanRequest scanRequest, TableInfo tableInfo, String indexName, Select select) {
        switch (select) {
            case SPECIFIC_ATTRIBUTES: {
                return scanRequest.getAttributesToGet();
            }
            case ALL_PROJECTED_ATTRIBUTES: {
                Projection indexProjection = tableInfo.getProjection(indexName);
                switch (ProjectionType.fromValue((String)indexProjection.getProjectionType())) {
                    case INCLUDE: {
                        List<String> attributesToGet = this.getAttributeNames(this.getKeyAttributes(tableInfo, indexName));
                        attributesToGet.addAll(indexProjection.getNonKeyAttributes());
                        return attributesToGet;
                    }
                    case KEYS_ONLY: {
                        return this.getAttributeNames(this.getKeyAttributes(tableInfo, indexName));
                    }
                    case ALL: {
                        return null;
                    }
                }
                LocalDBUtils.ldClientFail(LocalDBClientExceptionType.UNREACHABLE_CODE);
                break;
            }
            case ALL_ATTRIBUTES: {
                return null;
            }
            case COUNT: {
                return null;
            }
            default: {
                LocalDBUtils.ldClientFail(LocalDBClientExceptionType.UNREACHABLE_CODE);
            }
        }
        return null;
    }

    public void setEndpoint(String endpoint) throws IllegalArgumentException {
        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.INVALID_ACTION, "Regions are not supported in LocalDynamoDB");
    }

    public void shutdown() {
        logger.info("Shutting down");
        this.jobs.shutdown();
        this.dbAccess.close();
    }

    public UpdateItemResult updateItem(final UpdateItemRequest updateItemRequest) throws AmazonClientException {
        final String tableName = updateItemRequest.getTableName();
        this.validateTableName(tableName);
        final TableInfo tableInfo = this.validateTableExists(tableName);
        final Map expected = this.inputConverter.externalToInternalExpectedAttributes(updateItemRequest.getExpected(), 409600);
        final ReturnValue returnVals = this.validateReturnType(updateItemRequest.getReturnValues(), true);
        LocalDBValidatorUtils.validateExpressions(updateItemRequest, this.inputConverter);
        final Map updatesToMake = updateItemRequest.getAttributeUpdates();
        if (updateItemRequest.getKey() == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.MISSING_KEY.getMessage());
        }
        final Map primaryKey = (Map)this.inputConverter.externalToInternalAttributes(updateItemRequest.getKey());
        this.validateGetKey(primaryKey, tableInfo);
        final UpdateItemResult updateItemResult = new UpdateItemResult();
        new LocalDBAccess.WriteLockWithTimeout(this.dbAccess.getLockForTable(tableName), 10){

            @Override
            public void criticalSection() {
                HashMap<String, AttributeValue> oldItem;
                String conditionExpressionString = updateItemRequest.getConditionExpression();
                String updateExpressionString = updateItemRequest.getUpdateExpression();
                Map expressionAttributeNames = updateItemRequest.getExpressionAttributeNames();
                UpdateItemExpressionsWrapper updateItemExpressionsWrapper = LocalDBClient.this.inputConverter.externalToInternalUpdateAndConditionExpressions(updateExpressionString, conditionExpressionString, expressionAttributeNames, updateItemRequest.getExpressionAttributeValues());
                Map<String, AttributeValue> item = LocalDBClient.this.dbAccess.getRecord(tableName, primaryKey);
                if (item == null) {
                    oldItem = null;
                    item = new HashMap<String, AttributeValue>(primaryKey);
                } else {
                    oldItem = new HashMap<String, AttributeValue>();
                    for (Map.Entry<String, AttributeValue> entry : item.entrySet()) {
                        oldItem.put(entry.getKey(), entry.getValue());
                    }
                }
                String conditionalOperatorAsString = updateItemRequest.getConditionalOperator();
                Map conditions = null;
                if (conditionExpressionString == null) {
                    LocalDBClient.this.validateExpecations(expected, conditionalOperatorAsString);
                    conditions = LocalDBClient.this.convertToConditions(expected);
                    LocalDBClient.this.validateConditions(conditions, conditionalOperatorAsString);
                }
                ExpressionWrapper conditionExpressionWrapper = updateItemExpressionsWrapper == null ? null : updateItemExpressionsWrapper.getConditionExpressionWrapper();
                Expression conditionExpression = conditionExpressionWrapper == null ? null : conditionExpressionWrapper.getExpression();
                LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(tableInfo, conditionExpressionWrapper, LocalDBClient.this.awsExceptionFactory);
                if (!LocalDBClient.this.doesItemMatchConditionalOperator(oldItem, conditions, LocalDBClient.this.conditionalOperatorFrom(conditionalOperatorAsString)) || !LocalDBClient.this.doesItemMatchConditionExpression(oldItem, conditionExpression)) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.CONDITIONAL_CHECK_FAILED_EXCEPTION, LocalDBClientExceptionMessage.CONDITIONAL_CHECK_FAILED.getMessage());
                }
                HashMap itemChangesForExpr = new HashMap();
                if (updateExpressionString == null) {
                    LocalDBClient.this.validateAttributeUpdates(updatesToMake, tableInfo, oldItem);
                    LocalDBClient.this.doUpdates(updatesToMake, item);
                } else {
                    UpdateExpressionWrapper updateExpressionWrapper = updateItemExpressionsWrapper == null ? null : updateItemExpressionsWrapper.getUpdateExpressionWrapper();
                    UpdateExpression updateExpression = updateExpressionWrapper == null ? null : updateExpressionWrapper.getUpdateExpr();
                    LocalDBValidatorUtils.validateThatKeyAttributesNotUpdated(tableInfo, updateExpression, LocalDBClient.this.awsExceptionFactory);
                    LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(tableInfo, updateExpressionWrapper, LocalDBClient.this.awsExceptionFactory);
                    LocalDBClient.this.doUpdates(updateExpression, item, itemChangesForExpr, (ReturnValue)(ReturnValue.UPDATED_NEW.equals((Object)returnVals) || ReturnValue.UPDATED_OLD.equals((Object)returnVals) ? returnVals : null));
                }
                if (LocalDBUtils.getItemSizeBytes(item) > 409600L) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.ITEM_UPD_TOO_LARGE.getMessage());
                }
                Map key = (Map)LocalDBClient.this.inputConverter.externalToInternalAttributes(updateItemRequest.getKey());
                AttributeValue rangeKey = null;
                if (tableInfo.hasRangeKey()) {
                    rangeKey = (AttributeValue)key.get(tableInfo.getRangeKey().getAttributeName());
                }
                LocalDBClient.this.dbAccess.putRecord(tableName, item, (AttributeValue)key.get(tableInfo.getHashKey().getAttributeName()), rangeKey, true);
                updateItemResult.setAttributes(LocalDBClient.this.localDBOutputConverter.internalToExternalAttributes(LocalDBClient.this.getReturnedValsFromUpdate(returnVals, updateExpressionString == null ? updatesToMake : itemChangesForExpr, oldItem, item)));
            }
        }.execute();
        return updateItemResult;
    }

    public UpdateTableResult updateTable(final UpdateTableRequest updateTableRequest) throws AmazonServiceException, AmazonClientException {
        final String tableName = updateTableRequest.getTableName();
        this.validateTableName(tableName);
        final TableInfo info = this.validateTableExists(tableName);
        new LocalDBAccess.WriteLockWithTimeout(this.dbAccess.getLockForTable(tableName), 10){

            @Override
            public void criticalSection() {
                ProvisionedThroughput updatedThroughput;
                ArrayList<GlobalSecondaryIndexDescription> updatedGSIDescList;
                boolean doesRequestHaveOnlineGSIRequests;
                ProvisionedThroughput newThroughput = updateTableRequest.getProvisionedThroughput();
                List gsiUpdates = updateTableRequest.getGlobalSecondaryIndexUpdates();
                boolean doesRequestUpdateBaseTableIOPS = newThroughput != null;
                boolean bl = doesRequestHaveOnlineGSIRequests = gsiUpdates != null && !gsiUpdates.isEmpty();
                if (!doesRequestUpdateBaseTableIOPS && !doesRequestHaveOnlineGSIRequests) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NOTHING_TO_UPDATE.getMessage());
                }
                ArrayList<String> indicesCurrentlyCreatingNotBackfilling = new ArrayList<String>();
                ArrayList<String> indicesCurrentlyCreatingBackfilling = new ArrayList<String>();
                ArrayList<String> indicesCurrentlyUpdating = new ArrayList<String>();
                ArrayList<String> indicesCurrentlyDeleting = new ArrayList<String>();
                if (info.hasGSIs()) {
                    for (GlobalSecondaryIndexDescription existingGSI : info.getGSIDescriptions()) {
                        switch (IndexStatus.fromValue((String)existingGSI.getIndexStatus())) {
                            case CREATING: {
                                if (existingGSI.isBackfilling().booleanValue()) {
                                    indicesCurrentlyCreatingBackfilling.add(existingGSI.getIndexName());
                                    break;
                                }
                                indicesCurrentlyCreatingNotBackfilling.add(existingGSI.getIndexName());
                                break;
                            }
                            case UPDATING: {
                                indicesCurrentlyUpdating.add(existingGSI.getIndexName());
                                break;
                            }
                            case DELETING: {
                                indicesCurrentlyDeleting.add(existingGSI.getIndexName());
                                break;
                            }
                        }
                    }
                }
                if (doesRequestUpdateBaseTableIOPS) {
                    String indexName;
                    Iterator<Object> i$ = indicesCurrentlyCreatingNotBackfilling.iterator();
                    if (i$.hasNext()) {
                        indexName = (String)i$.next();
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_IN_USE_EXCEPTION, String.format(LocalDBClientExceptionMessage.CANT_UPDATE_TABLE_WHEN_INDEX_IS_CREATING_BACKFILLING_FALSE.getMessage(), tableName, indexName));
                    }
                    i$ = indicesCurrentlyDeleting.iterator();
                    if (i$.hasNext()) {
                        indexName = (String)i$.next();
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_IN_USE_EXCEPTION, String.format(LocalDBClientExceptionMessage.CANT_UPDATE_TABLE_WHEN_INDEX_IS_DELETING.getMessage(), tableName, indexName));
                    }
                }
                List updatedAllAttributesList = info.getAttributeDefinitions();
                ArrayList<Object> arrayList = updatedGSIDescList = info.hasGSIs() ? new ArrayList<GlobalSecondaryIndexDescription>(info.getGSIDescriptions()) : new ArrayList();
                if (doesRequestHaveOnlineGSIRequests) {
                    boolean doesRequestHaveDeleteGSI;
                    int numberOfCreateGSIRequests = 0;
                    int numberOfUpdateGSIRequests = 0;
                    int numberOfDeleteGSIRequests = 0;
                    for (GlobalSecondaryIndexUpdate update : gsiUpdates) {
                        if (update == null) continue;
                        if (update.getCreate() != null) {
                            ++numberOfCreateGSIRequests;
                        }
                        if (update.getUpdate() != null) {
                            ++numberOfUpdateGSIRequests;
                        }
                        if (update.getDelete() == null) continue;
                        ++numberOfDeleteGSIRequests;
                    }
                    if (LocalDBClient.this.dbAccess.numberOfSubscriberWideInflightOnlineCreateIndexesOperations() + numberOfCreateGSIRequests > 5) {
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.LIMIT_EXCEEDED_EXCEPTION, LocalDBClientExceptionMessage.SUBSCRIBER_WIDE_MAX_INFLIGHT_CREATE_ONLINE_GSI_LIMIT_REACHED.getMessage());
                    }
                    if (LocalDBClient.this.areThereMoreThanOneUpdateToSameIndex(gsiUpdates)) {
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.ONLY_ONE_GSI_UPDATE_PER_REQUEST_FOR_AN_INDEX.getMessage());
                    }
                    LocalDBClient.this.throwResourceInUseIfIndexIsInFlight(gsiUpdates, indicesCurrentlyCreatingNotBackfilling, indicesCurrentlyCreatingBackfilling, indicesCurrentlyUpdating, indicesCurrentlyDeleting, info);
                    LocalDBClient.this.throwLimitExceededExceptionIfThereAreTooManyIndexUpdates(numberOfCreateGSIRequests, numberOfDeleteGSIRequests, indicesCurrentlyCreatingNotBackfilling, indicesCurrentlyCreatingBackfilling, indicesCurrentlyDeleting);
                    ArrayList<String> indicesToDelete = new ArrayList<String>();
                    for (GlobalSecondaryIndexUpdate gsiUpdate : gsiUpdates) {
                        GlobalSecondaryIndexDescription gsi;
                        if (gsiUpdate == null) {
                            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NULL_GSI_UPDATE.getMessage());
                        }
                        CreateGlobalSecondaryIndexAction createAction = gsiUpdate.getCreate();
                        UpdateGlobalSecondaryIndexAction updateAction = gsiUpdate.getUpdate();
                        DeleteGlobalSecondaryIndexAction deleteAction = gsiUpdate.getDelete();
                        if (updateAction == null && createAction == null && deleteAction == null) {
                            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NULL_GSI_UPDATE_ACTION.getMessage());
                        }
                        if (createAction != null) {
                            LocalDBClient.this.validateCreateGSI(info, createAction);
                            updatedGSIDescList.add(new GlobalSecondaryIndexDescription().withIndexName(createAction.getIndexName()).withIndexStatus(IndexStatus.CREATING).withBackfilling(Boolean.valueOf(false)).withKeySchema((Collection)createAction.getKeySchema()).withProjection(createAction.getProjection()).withProvisionedThroughput(new ProvisionedThroughputDescription().withReadCapacityUnits(createAction.getProvisionedThroughput().getReadCapacityUnits()).withWriteCapacityUnits(createAction.getProvisionedThroughput().getWriteCapacityUnits())));
                        }
                        if (updateAction != null) {
                            LocalDBClient.this.validateUpdateGSI(info, updateAction);
                            gsi = info.getGSIDescWithName(updateAction.getIndexName());
                            gsi.setProvisionedThroughput(new ProvisionedThroughputDescription().withReadCapacityUnits(updateAction.getProvisionedThroughput().getReadCapacityUnits()).withWriteCapacityUnits(updateAction.getProvisionedThroughput().getWriteCapacityUnits()).withLastIncreaseDateTime(gsi.getProvisionedThroughput().getLastIncreaseDateTime()).withLastDecreaseDateTime(gsi.getProvisionedThroughput().getLastDecreaseDateTime()).withNumberOfDecreasesToday(gsi.getProvisionedThroughput().getNumberOfDecreasesToday()));
                        }
                        if (deleteAction == null) continue;
                        LocalDBClient.this.validateDeleteGSI(info, deleteAction);
                        indicesToDelete.add(deleteAction.getIndexName());
                        gsi = info.getGSIDescWithName(deleteAction.getIndexName());
                        gsi.setIndexStatus(IndexStatus.DELETING);
                        gsi.setBackfilling(null);
                    }
                    List attrDefnsFromNewGSIs = updateTableRequest.getAttributeDefinitions();
                    if (attrDefnsFromNewGSIs != null && !attrDefnsFromNewGSIs.isEmpty()) {
                        LocalDBClient.this.validateNewAttributes(attrDefnsFromNewGSIs, info);
                    }
                    boolean doesRequestHaveCreateGSI = numberOfCreateGSIRequests > 0;
                    boolean doesRequestHaveUpdateGSI = numberOfUpdateGSIRequests > 0;
                    boolean bl2 = doesRequestHaveDeleteGSI = numberOfDeleteGSIRequests > 0;
                    if (doesRequestHaveCreateGSI && (attrDefnsFromNewGSIs == null || attrDefnsFromNewGSIs.isEmpty())) {
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_ATTRIBUTE_SCHEMA.getMessage());
                    }
                    updatedAllAttributesList = LocalDBClient.this.updateAttributesList(info, attrDefnsFromNewGSIs, indicesToDelete);
                    LocalDBClient.this.validateAttributeDefinitions(updatedAllAttributesList);
                    if (doesRequestHaveCreateGSI || doesRequestHaveUpdateGSI || doesRequestHaveDeleteGSI) {
                        if (updatedGSIDescList.size() > 5) {
                            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.LIMIT_EXCEEDED_EXCEPTION, LocalDBClientExceptionMessage.TOO_MANY_GSI_LIMIT_EXCEEDED_EXCEPTION.getMessage());
                        }
                        LocalDBClient.this.validateGSISchemas(updatedGSIDescList, LocalDBUtils.getBaseTableHashKeyDefinition(info), LocalDBUtils.getBaseTableRangeKeyDefinition(info), updatedAllAttributesList, info.getLSINames(), info.getNumberOfLSIProjectedAttributes());
                    }
                }
                ProvisionedThroughput curThroughput = info.getThroughput();
                ProvisionedThroughput provisionedThroughput = updatedThroughput = doesRequestUpdateBaseTableIOPS ? newThroughput : curThroughput;
                if (doesRequestUpdateBaseTableIOPS) {
                    LocalDBClient.this.validateProvisionedThroughputIncrease(newThroughput, curThroughput);
                }
                LocalDBClient.this.validateProvisionedThroughputWithGSIs(tableName, updatedThroughput, updatedGSIDescList);
                LocalDBClient.this.dbAccess.updateTable(tableName, updatedThroughput, updatedAllAttributesList, updatedGSIDescList);
            }
        }.execute();
        TableDescription description = this.getTableDescriptionHelper(tableName);
        description = this.fillDescriptionHelper(description);
        return new UpdateTableResult().withTableDescription(description);
    }

    private List<AttributeDefinition> updateAttributesList(TableInfo tableInfo, List<AttributeDefinition> attrDefnsFromNewGSIs, List<String> indicesToBeDeleted) {
        AttributeDefinition rangeKeyDef;
        AttributeDefinition hashKeyDef;
        HashMap<String, AttributeDefinition> newAttrNameToDefnMap = new HashMap<String, AttributeDefinition>();
        newAttrNameToDefnMap.put(tableInfo.getHashKey().getAttributeName(), tableInfo.getHashKey());
        if (tableInfo.getRangeKey() != null) {
            newAttrNameToDefnMap.put(tableInfo.getRangeKey().getAttributeName(), tableInfo.getRangeKey());
        }
        if (tableInfo.getLSIIndexes() != null) {
            for (LocalSecondaryIndex lsi : tableInfo.getLSIIndexes()) {
                hashKeyDef = LocalDBUtils.getLSIHashKeyDefinition(lsi, tableInfo);
                newAttrNameToDefnMap.put(hashKeyDef.getAttributeName(), tableInfo.getHashKey());
                rangeKeyDef = LocalDBUtils.getLSIRangeKeyDefinition(lsi, tableInfo);
                if (rangeKeyDef == null) continue;
                newAttrNameToDefnMap.put(rangeKeyDef.getAttributeName(), rangeKeyDef);
            }
        }
        if (tableInfo.hasGSIs()) {
            for (GlobalSecondaryIndexDescription gsi : tableInfo.getGSIDescriptions()) {
                if (this.isThisIndexGoingToBeDeletedOrIsBeingDeleted(indicesToBeDeleted, gsi)) continue;
                hashKeyDef = LocalDBUtils.getGSIHashKeyDefinition(gsi, tableInfo);
                newAttrNameToDefnMap.put(hashKeyDef.getAttributeName(), hashKeyDef);
                rangeKeyDef = LocalDBUtils.getGSIRangeKeyDefinition(gsi, tableInfo);
                if (rangeKeyDef == null) continue;
                newAttrNameToDefnMap.put(rangeKeyDef.getAttributeName(), rangeKeyDef);
            }
        }
        if (attrDefnsFromNewGSIs != null) {
            for (AttributeDefinition newAttrDef : attrDefnsFromNewGSIs) {
                newAttrNameToDefnMap.put(newAttrDef.getAttributeName(), newAttrDef);
            }
        }
        return new ArrayList<AttributeDefinition>(newAttrNameToDefnMap.values());
    }

    private boolean isThisIndexGoingToBeDeletedOrIsBeingDeleted(List<String> indicesToBeDeleted, GlobalSecondaryIndexDescription gsi) {
        if (indicesToBeDeleted.contains(gsi.getIndexName())) {
            return true;
        }
        return IndexStatus.DELETING.toString().equals(gsi.getIndexStatus());
    }

    private void throwResourceInUseIfIndexIsInFlight(List<GlobalSecondaryIndexUpdate> gsiUpdates, List<String> indicesCurrentlyCreatingNotBackfilling, List<String> indicesCurrentlyCreatingBackfilling, List<String> indicesCurrentlyUpdating, List<String> indicesCurrentlyDeleting, TableInfo info) {
        for (GlobalSecondaryIndexUpdate update : gsiUpdates) {
            if (update.getCreate() != null) {
                this.checkForResourceInUse(update.getCreate().getIndexName(), "Create", indicesCurrentlyCreatingNotBackfilling, indicesCurrentlyCreatingBackfilling, indicesCurrentlyUpdating, indicesCurrentlyDeleting, info);
            }
            if (update.getUpdate() != null) {
                this.checkForResourceInUse(update.getUpdate().getIndexName(), "Update", indicesCurrentlyCreatingNotBackfilling, indicesCurrentlyCreatingBackfilling, indicesCurrentlyUpdating, indicesCurrentlyDeleting, info);
            }
            if (update.getDelete() == null) continue;
            this.checkForResourceInUse(update.getDelete().getIndexName(), "Delete", indicesCurrentlyCreatingNotBackfilling, indicesCurrentlyCreatingBackfilling, indicesCurrentlyUpdating, indicesCurrentlyDeleting, info);
        }
    }

    private void throwLimitExceededExceptionIfThereAreTooManyIndexUpdates(int numberOfCreateGSIRequests, int numberOfDeleteGSIRequests, List<String> indicesCurrentlyCreatingNotBackfilling, List<String> indicesCurrentlyCreatingBackfilling, List<String> indicesCurrentlyDeleting) {
        if (numberOfCreateGSIRequests + numberOfDeleteGSIRequests + indicesCurrentlyCreatingNotBackfilling.size() + indicesCurrentlyCreatingBackfilling.size() + indicesCurrentlyDeleting.size() > 1) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.LIMIT_EXCEEDED_EXCEPTION, LocalDBClientExceptionMessage.INFLIGHT_INDEX_LIMIT_EXCEEDED_EXCEPTION.getMessage());
        }
    }

    private void checkForResourceInUse(String indexName, String updateType, List<String> indicesCurrentlyCreatingNotBackfilling, List<String> indicesCurrentlyCreatingBackfilling, List<String> indicesCurrentlyUpdating, List<String> indicesCurrentlyDeleting, TableInfo tableInfo) {
        if (indicesCurrentlyDeleting.contains(indexName)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_IN_USE_EXCEPTION, LocalDBClientExceptionMessage.INDEX_IS_BEING_DELETED.getMessage());
        }
        if (indicesCurrentlyUpdating.contains(indexName)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_IN_USE_EXCEPTION, LocalDBClientExceptionMessage.INDEX_IS_BEING_UPDATED.getMessage());
        }
        if (indicesCurrentlyCreatingNotBackfilling.contains(indexName) || indicesCurrentlyCreatingBackfilling.contains(indexName)) {
            if (updateType.equals("Create")) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_IN_USE_EXCEPTION, LocalDBClientExceptionMessage.INDEX_IS_BEING_CREATED.getMessage());
            }
            if (updateType.equals("Update")) {
                GlobalSecondaryIndexDescription desc = tableInfo.getGSIDescWithName(indexName);
                if (desc.getBackfilling() == null || !desc.getBackfilling().booleanValue()) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_IN_USE_EXCEPTION, LocalDBClientExceptionMessage.INDEX_IS_BEING_CREATED_BUT_NOT_BACKFILLING.getMessage());
                }
            } else if (updateType.equals("Delete")) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_IN_USE_EXCEPTION, LocalDBClientExceptionMessage.INDEX_IS_BEING_CREATED.getMessage());
            }
        }
    }

    private void validateCreateGSI(TableInfo info, CreateGlobalSecondaryIndexAction createAction) {
        String indexName = createAction.getIndexName();
        if (StringUtils.isEmpty((CharSequence)indexName)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_GSI_NAME.getMessage());
        }
        if (info.isLSIIndex(indexName)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.CANNOT_CREATE_GSI_WITH_SAME_NAME_AS_ANOTHER_INDEX.getMessage());
        }
        if (info.isGSIIndex(indexName)) {
            GlobalSecondaryIndexDescription anotherGSIWithSameName = info.getGSIDescWithName(createAction.getIndexName());
            switch (IndexStatus.fromValue((String)anotherGSIWithSameName.getIndexStatus())) {
                case ACTIVE: {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.CANNOT_CREATE_GSI_WITH_SAME_NAME_AS_ANOTHER_INDEX.getMessage());
                }
                case CREATING: 
                case UPDATING: 
                case DELETING: {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.ONLY_ONE_GSI_UPDATE_PER_REQUEST_FOR_AN_INDEX.getMessage());
                }
            }
        }
    }

    private void validateUpdateGSI(TableInfo info, UpdateGlobalSecondaryIndexAction updateAction) {
        String indexName = updateAction.getIndexName();
        if (StringUtils.isEmpty((CharSequence)indexName)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_GSI_NAME.getMessage());
        }
        if (!info.isGSIIndex(indexName)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_GSI_NAME.getMessage());
        }
        GlobalSecondaryIndexDescription oldGSIDesc = info.getGSIDescWithName(updateAction.getIndexName());
        switch (IndexStatus.fromValue((String)oldGSIDesc.getIndexStatus())) {
            case ACTIVE: {
                break;
            }
            case CREATING: {
                if (oldGSIDesc.getBackfilling().booleanValue()) break;
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_IN_USE_EXCEPTION, LocalDBClientExceptionMessage.ONLY_ONE_GSI_UPDATE_PER_REQUEST_FOR_AN_INDEX.getMessage());
            }
            case UPDATING: {
                break;
            }
            case DELETING: {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INDEX_IS_BEING_DELETED.getMessage());
            }
        }
        ProvisionedThroughput newIndexThroughput = updateAction.getProvisionedThroughput();
        ProvisionedThroughput currentIndexThroughput = LocalDBUtils.getPTfromPTDescription(info.getGSIDescWithName(indexName).getProvisionedThroughput());
        this.validateGSIProvisionedThroughput(newIndexThroughput);
        this.validateProvisionedThroughputIncrease(newIndexThroughput, currentIndexThroughput);
    }

    private void validateDeleteGSI(TableInfo info, DeleteGlobalSecondaryIndexAction deleteAction) {
        String indexName = deleteAction.getIndexName();
        if (StringUtils.isEmpty((CharSequence)indexName)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_GSI_NAME.getMessage());
        }
        if (info.isLSIIndex(indexName)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.CANNOT_DELETE_LSI_VIA_DELETE_GSI_API.getMessage());
        }
        if (info.isGSIIndex(indexName)) {
            GlobalSecondaryIndexDescription oldGSIDesc = info.getGSIDescWithName(indexName);
            switch (IndexStatus.fromValue((String)oldGSIDesc.getIndexStatus())) {
                case CREATING: {
                    if (oldGSIDesc.getBackfilling().booleanValue()) break;
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_IN_USE_EXCEPTION, LocalDBClientExceptionMessage.ONLY_ONE_GSI_UPDATE_PER_REQUEST_FOR_AN_INDEX.getMessage());
                }
                case UPDATING: {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_IN_USE_EXCEPTION, LocalDBClientExceptionMessage.ONLY_ONE_GSI_UPDATE_PER_REQUEST_FOR_AN_INDEX.getMessage());
                }
                case DELETING: {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_IN_USE_EXCEPTION, LocalDBClientExceptionMessage.INDEX_IS_BEING_DELETED.getMessage());
                }
            }
        } else {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_NOT_FOUND_EXCEPTION, LocalDBClientExceptionMessage.REQUESTED_RESOURCE_NOT_FOUND.getMessage());
        }
    }

    private boolean areThereMoreThanOneUpdateToSameIndex(List<GlobalSecondaryIndexUpdate> gsiUpdates) {
        HashSet<String> indexNamesFromUpdate = new HashSet<String>();
        for (GlobalSecondaryIndexUpdate update : gsiUpdates) {
            String indexName = null;
            if (update.getCreate() != null) {
                indexName = update.getCreate().getIndexName();
            } else if (update.getUpdate() != null) {
                indexName = update.getUpdate().getIndexName();
            } else if (update.getDelete() != null) {
                indexName = update.getDelete().getIndexName();
            }
            if (indexName == null) continue;
            if (indexNamesFromUpdate.contains(indexName)) {
                return true;
            }
            indexNamesFromUpdate.add(indexName);
        }
        return false;
    }

    private TableInfo validateTableExists(String tableName) {
        TableInfo tableInfo = this.dbAccess.getTableInfo(tableName);
        if (tableInfo == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_NOT_FOUND_EXCEPTION, LocalDBClientExceptionMessage.TABLE_DOES_NOT_EXIST.getMessage());
        }
        return tableInfo;
    }

    private void validateTableName(String tableName) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.BAD_TABLE_NAME.getMessage());
        }
        if (tableName.length() < 3 || tableName.length() > 255) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.BAD_TABLE_NAME.getMessage());
        }
        if (!tableName.matches("[-a-zA-Z0-9._]*")) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.BAD_TABLE_NAME.getMessage());
        }
    }

    private void validateProvisionedThroughputIncrease(ProvisionedThroughput throughputAfterUpdate, ProvisionedThroughput throughputBeforeUpdate) {
        if (throughputAfterUpdate == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_THROUGHPUT_NULL.getMessage());
        }
        Long readCapacity = throughputAfterUpdate.getReadCapacityUnits();
        Long writeCapacity = throughputAfterUpdate.getWriteCapacityUnits();
        if (readCapacity == null || writeCapacity == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_THROUGHPUT_VALUES.getMessage());
        }
        if (readCapacity < 1L || writeCapacity < 1L) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_THROUGHPUT_VALUES.getMessage());
        }
        if (throughputBeforeUpdate != null && throughputAfterUpdate.getReadCapacityUnits() == throughputBeforeUpdate.getReadCapacityUnits() && throughputAfterUpdate.getWriteCapacityUnits() == throughputBeforeUpdate.getWriteCapacityUnits()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.SAME_THROUGHPUT.getMessage());
        }
    }

    private void validateGSIProvisionedThroughput(ProvisionedThroughput throughput) {
        if (throughput == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_THROUGHPUT_GSI_NULL.getMessage());
        }
        Long readCapacity = throughput.getReadCapacityUnits();
        Long writeCapacity = throughput.getWriteCapacityUnits();
        if (readCapacity == null || writeCapacity == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_THROUGHPUT_VALUES_GSI.getMessage());
        }
        if (readCapacity < 1L || writeCapacity < 1L) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_THROUGHPUT_VALUES_GSI.getMessage());
        }
        if (throughput.getReadCapacityUnits() > 40000L || throughput.getWriteCapacityUnits() > 40000L) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MUCH_THROUGHPUT_GSI.getMessage());
        }
    }

    private void validateProvisionedThroughputWithGSIs(String tableName, ProvisionedThroughput throughput, List<GlobalSecondaryIndexDescription> updatedGSIList) {
        if (throughput.getReadCapacityUnits() > 40000L || throughput.getWriteCapacityUnits() > 40000L) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MUCH_THROUGHPUT_TABLE.getMessage());
        }
        long totalReadThroughput = 0L;
        long totalWriteThroughput = 0L;
        List<String> allTableNames = this.dbAccess.listTables(null, -1L).getTableNames();
        for (String table : allTableNames) {
            if (table.equals(tableName)) continue;
            TableInfo tableInfo = this.dbAccess.getTableInfo(table);
            ProvisionedThroughput existingThroughput = tableInfo.getThroughput();
            totalReadThroughput += existingThroughput.getReadCapacityUnits().longValue();
            totalWriteThroughput += existingThroughput.getWriteCapacityUnits().longValue();
            if (!tableInfo.hasGSIs()) continue;
            for (GlobalSecondaryIndexDescription gsi : tableInfo.getGSIDescriptions()) {
                totalReadThroughput += gsi.getProvisionedThroughput().getReadCapacityUnits().longValue();
                totalWriteThroughput += gsi.getProvisionedThroughput().getWriteCapacityUnits().longValue();
            }
        }
        totalReadThroughput += throughput.getReadCapacityUnits().longValue();
        totalWriteThroughput += throughput.getWriteCapacityUnits().longValue();
        if (updatedGSIList != null) {
            for (GlobalSecondaryIndexDescription gsi : updatedGSIList) {
                totalReadThroughput += gsi.getProvisionedThroughput().getReadCapacityUnits().longValue();
                totalWriteThroughput += gsi.getProvisionedThroughput().getWriteCapacityUnits().longValue();
            }
        }
        if (totalReadThroughput > 80000L || totalWriteThroughput > 80000L) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MUCH_THROUGHPUT_ACCOUNT.getMessage());
        }
    }

    private void validateKeySchema(List<KeySchemaElement> keySchema) {
        if (keySchema == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_KEY_SCHEMA.getMessage());
        }
        int size = keySchema.size();
        if (size > 2) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.KEY_SCHEMA_TOO_BIG.getMessage());
        }
        int numHashKeys = 0;
        for (int i = 0; i < size; ++i) {
            if (keySchema.get(i) == null) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_KEY_SCHEMA_ELEMENT.getMessage());
            }
            if (keySchema.get(i).getKeyType() == null) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.UNSPECIFIED_KEY_TYPE.getMessage());
            }
            if (keySchema.get(i).getAttributeName() == null) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_ATTRIBUTE_NAME.getMessage());
            }
            if (!keySchema.get(i).getKeyType().equals(KeyType.HASH.toString())) continue;
            ++numHashKeys;
        }
        if (numHashKeys == 0) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_HASH_KEY.getMessage());
        }
        if (numHashKeys == 2) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MANY_HASH_KEYS.getMessage());
        }
        if (size == 2 && keySchema.get(1).getKeyType().equals(KeyType.HASH.toString())) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INCORRECT_KEY_SCHEMA_ORDER.getMessage());
        }
        if (size == 2 && keySchema.get(0).getAttributeName().equals(keySchema.get(1).getAttributeName())) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.IDENTICALLY_NAMED_KEYS.getMessage());
        }
    }

    private int validateLSISchema(List<LocalSecondaryIndex> lsiList, String hashKeyName, List<AttributeDefinition> allAttributes, AttributeDefinition rangeKeyDef, Set<String> lsiNames, List<String> projAttributes) {
        if (lsiList == null) {
            return 0;
        }
        if (lsiList.isEmpty()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.EMPTY_LSI_LIST.getMessage());
        }
        if (lsiList.size() > 5) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MANY_LSI.getMessage());
        }
        HashSet<AttributeDefinition> lsiRangeKeys = new HashSet<AttributeDefinition>();
        int totalProjectedAttrs = 0;
        for (LocalSecondaryIndex lsi : lsiList) {
            String lsiName = lsi.getIndexName();
            this.validateTableName(lsiName);
            if (lsiNames.contains(lsiName)) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.SAME_NAME_LSI.getMessage());
            }
            if ((long)(totalProjectedAttrs += this.validateProjection(lsi.getProjection(), projAttributes)) > 20L) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MANY_PROJECTED.getMessage());
            }
            lsiNames.add(lsiName);
            List lsiSchema = lsi.getKeySchema();
            this.validateKeySchema(lsiSchema);
            if (lsiSchema.size() < 2) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_LSI_NO_RANGE.getMessage());
            }
            KeySchemaElement lsiHashKey = (KeySchemaElement)lsiSchema.get(0);
            if (lsiHashKey == null || !lsiHashKey.getAttributeName().equals(hashKeyName) || !lsiHashKey.getKeyType().equals(KeyType.HASH.toString())) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_LSI.getMessage());
            }
            KeySchemaElement lsiRangeKey = (KeySchemaElement)lsiSchema.get(1);
            if (lsiRangeKey == null || !lsiRangeKey.getKeyType().equals(KeyType.RANGE.toString())) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_LSI_NO_RANGE.getMessage());
            }
            AttributeDefinition lsiRangeKeyDef = LocalDBUtils.findAttributeDefinition(lsiRangeKey, allAttributes);
            if (lsiRangeKeyDef == null) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NON_SPECIFIED_LSI_RANGE_KEY.getMessage());
            }
            if (lsiRangeKeyDef.equals((Object)rangeKeyDef)) continue;
            lsiRangeKeys.add(lsiRangeKeyDef);
        }
        return lsiRangeKeys.size();
    }

    private int validateProjection(Projection curProjection, List<String> projAttributes) {
        if (curProjection == null || curProjection.getProjectionType() == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_INDEX_NO_PROJECTION.getMessage());
        }
        int projectedAttrs = 0;
        try {
            ProjectionType curProjectionType = ProjectionType.fromValue((String)curProjection.getProjectionType());
            if (curProjectionType == ProjectionType.INCLUDE) {
                List nonKeyAttrs = curProjection.getNonKeyAttributes();
                if (nonKeyAttrs == null || nonKeyAttrs.size() == 0) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_PROJECTED_ATTRS.getMessage());
                }
                HashSet<String> nonKeyNamesSet = new HashSet<String>();
                for (String attrName : nonKeyAttrs) {
                    this.validateAttributeName(attrName);
                    if (nonKeyNamesSet.contains(attrName)) {
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.IDENTICAL_ATTRIBUTE_NAMES.getMessage());
                    }
                    if (projAttributes != null) {
                        projAttributes.add(attrName);
                    }
                    ++projectedAttrs;
                    nonKeyNamesSet.add(attrName);
                }
            } else if (curProjection.getNonKeyAttributes() != null) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_PROJECTED_ATTRS.getMessage());
            }
        }
        catch (IllegalArgumentException invalidException) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_PROJECTION_TYPE.getMessage());
        }
        return projectedAttrs;
    }

    private int validateGSISchemas(List<GlobalSecondaryIndexDescription> gsiDescList, AttributeDefinition hashKeyDef, AttributeDefinition rangeKeyDef, List<AttributeDefinition> allAttributes, List<String> lsiNames, int numberOfProjectedAttrsInLSI) {
        HashSet<String> gsiNames = new HashSet<String>();
        HashSet<AttributeDefinition> gsiKeys = new HashSet<AttributeDefinition>();
        int totalProjectedAttrs = numberOfProjectedAttrsInLSI;
        for (GlobalSecondaryIndexDescription gsi : gsiDescList) {
            String gsiName = gsi.getIndexName();
            switch (IndexStatus.fromValue((String)gsi.getIndexStatus())) {
                case CREATING: 
                case UPDATING: 
                case ACTIVE: {
                    AttributeDefinition gsiHashKeyDef;
                    this.validateGSIProvisionedThroughput(LocalDBUtils.getPTfromPTDescription(gsi.getProvisionedThroughput()));
                    this.validateTableName(gsiName);
                    if (gsiNames.contains(gsiName)) {
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.SAME_NAME_GSI.getMessage());
                    }
                    if (lsiNames.contains(gsiName)) {
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.SAME_NAME_LSI_GSI.getMessage());
                    }
                    if ((long)(totalProjectedAttrs += this.validateProjection(gsi.getProjection(), null)) > 20L) {
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MANY_PROJECTED.getMessage());
                    }
                    gsiNames.add(gsiName);
                    List gsiSchema = gsi.getKeySchema();
                    this.validateKeySchema(gsiSchema);
                    KeySchemaElement gsiHashKey = (KeySchemaElement)gsiSchema.get(0);
                    KeySchemaElement gsiRangeKey = null;
                    if (gsiSchema.size() > 1) {
                        gsiRangeKey = (KeySchemaElement)gsiSchema.get(1);
                    }
                    if ((gsiHashKeyDef = LocalDBUtils.findAttributeDefinition(gsiHashKey, allAttributes)) == null) {
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NON_SPECIFIED_GSI_HASH_KEY.getMessage());
                    }
                    if (gsiRangeKey != null) {
                        AttributeDefinition gsiRangeKeyDef = LocalDBUtils.findAttributeDefinition(gsiRangeKey, allAttributes);
                        if (gsiRangeKeyDef == null) {
                            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NON_SPECIFIED_GSI_RANGE_KEY.getMessage());
                        }
                        if (!gsiRangeKeyDef.equals((Object)rangeKeyDef)) {
                            gsiKeys.add(gsiRangeKeyDef);
                        }
                    }
                    if (gsiHashKeyDef.equals((Object)hashKeyDef)) break;
                    gsiKeys.add(gsiHashKeyDef);
                    break;
                }
                case DELETING: {
                    this.validateTableName(gsiName);
                }
            }
        }
        return gsiKeys.size();
    }

    private void validateAttributeDefinitions(List<AttributeDefinition> attrDefs) {
        if (attrDefs == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_ATTRIBUTE_SCHEMA.getMessage());
        }
        HashSet<String> validatedAttrNames = new HashSet<String>();
        for (AttributeDefinition curAttr : attrDefs) {
            String curName = curAttr.getAttributeName();
            this.validateAttributeName(curName);
            if (validatedAttrNames.contains(curName)) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.IDENTICAL_ATTRIBUTE_NAMES.getMessage());
            }
            validatedAttrNames.add(curName);
            LocalDBUtils.getDataTypeOfAttributeDefinition(curAttr);
        }
        LocalDBUtils.getDataTypesOfAttributeDefinitions(attrDefs, false);
    }

    private void validateNewAttributes(List<AttributeDefinition> newAttributes, TableInfo info) {
        HashMap<String, AttributeDefinition> existingDataTypes = new HashMap<String, AttributeDefinition>();
        List<AttributeDefinition> curAttributes = info.getAttributeDefinitions();
        if (curAttributes != null) {
            for (AttributeDefinition curAttr : curAttributes) {
                existingDataTypes.put(curAttr.getAttributeName(), curAttr);
            }
        }
        for (AttributeDefinition newAttr : newAttributes) {
            if (!existingDataTypes.containsKey(newAttr.getAttributeName())) continue;
            AttributeDefinition matchingAttrDef = (AttributeDefinition)existingDataTypes.get(newAttr.getAttributeName());
            if (!newAttr.getAttributeType().equals(matchingAttrDef.getAttributeType())) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_ATTRIBUTE_REDEFINITION.getMessage());
            }
            LocalDBUtils.getDataTypeOfAttributeDefinition(newAttr);
        }
    }

    private void validateAttributeName(String attrName) {
        if (attrName == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_ATTRIBUTE_NAME.getMessage());
        }
        int length = attrName.getBytes(LocalDBUtils.UTF8).length;
        if (length < 1 || length > 255) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.ATTRIBUTE_NAME_TOO_LONG.getMessage());
        }
    }

    private Map<String, AttributeValue> validatePutItem(Map<String, AttributeValue> item, TableInfo tableInfo) {
        long baseItemSize;
        HashMap<String, AttributeValue> nonKeyAttrs = new HashMap<String, AttributeValue>(item);
        HashMap<String, AttributeValue> keyAttrs = new HashMap<String, AttributeValue>();
        this.validateKeyValue(item, tableInfo.getHashKey(), true, 2048L);
        String hashKeyName = tableInfo.getHashKey().getAttributeName();
        nonKeyAttrs.remove(hashKeyName);
        keyAttrs.put(hashKeyName, item.get(hashKeyName));
        if (tableInfo.hasRangeKey()) {
            this.validateKeyValue(item, tableInfo.getRangeKey(), true, 1024L);
            String rangeKeyName = tableInfo.getRangeKey().getAttributeName();
            nonKeyAttrs.remove(rangeKeyName);
            keyAttrs.put(rangeKeyName, item.get(rangeKeyName));
            for (String curIndex : tableInfo.getLSINames()) {
                this.validateKeyValue(item, tableInfo.getLSIRangeKey(curIndex), false, 1024L);
                nonKeyAttrs.remove(tableInfo.getLSIRangeKey(curIndex).getAttributeName());
            }
        }
        if (tableInfo.hasGSIs()) {
            for (String curIndex : tableInfo.getGSINames()) {
                this.validateKeyValue(item, tableInfo.getGSIHashKey(curIndex), false, 2048L);
                nonKeyAttrs.remove(tableInfo.getGSIHashKey(curIndex).getAttributeName());
                if (tableInfo.getGSIRangeKey(curIndex) == null) continue;
                this.validateKeyValue(item, tableInfo.getGSIRangeKey(curIndex), false, 1024L);
                nonKeyAttrs.remove(tableInfo.getGSIRangeKey(curIndex).getAttributeName());
            }
        }
        for (String nonKeyAttrName : nonKeyAttrs.keySet()) {
            AttributeValue nonKeyAttr = (AttributeValue)nonKeyAttrs.get(nonKeyAttrName);
            DDBType type = LocalDBUtils.getDataTypeOfAttributeValue(nonKeyAttr);
            if (type == DDBType.N) {
                item.put(nonKeyAttrName, new AttributeValue().withN(LocalDBUtils.validateNumericValue(nonKeyAttr.getN()).toPlainString()));
                continue;
            }
            if (type != DDBType.NS) continue;
            item.put(nonKeyAttrName, new AttributeValue().withNS(LocalDBUtils.validateNumberSet(nonKeyAttr.getNS())));
        }
        long accumulatedSize = baseItemSize = LocalDBUtils.getItemSizeBytes(item);
        List<LocalSecondaryIndex> lsiIndexes = tableInfo.getLSIIndexes();
        if (lsiIndexes != null) {
            for (LocalSecondaryIndex lsi : lsiIndexes) {
                List keySchema = lsi.getKeySchema();
                boolean containsKey = true;
                int lsiSize = 0;
                for (KeySchemaElement keySchemaElement : keySchema) {
                    String attrName = keySchemaElement.getAttributeName();
                    if (!item.containsKey(attrName)) {
                        containsKey = false;
                        break;
                    }
                    lsiSize += attrName.getBytes(UTF8).length;
                    lsiSize = (int)((long)lsiSize + LocalDBUtils.getAttributeValueSizeBytes(item.get(attrName)));
                }
                if (!containsKey) continue;
                if (lsi.getProjection() == null) {
                    accumulatedSize += (long)lsiSize;
                    continue;
                }
                String projectionType = lsi.getProjection().getProjectionType();
                if (ProjectionType.ALL.toString().equals(projectionType)) {
                    accumulatedSize += baseItemSize;
                    continue;
                }
                if (ProjectionType.KEYS_ONLY.toString().equals(projectionType)) {
                    accumulatedSize += (long)lsiSize;
                    continue;
                }
                if (lsi.getProjection().getNonKeyAttributes() == null) continue;
                for (String nonKeyLsi : lsi.getProjection().getNonKeyAttributes()) {
                    if (!item.containsKey(nonKeyLsi)) continue;
                    lsiSize += nonKeyLsi.getBytes(UTF8).length;
                    lsiSize = (int)((long)lsiSize + LocalDBUtils.getAttributeValueSizeBytes(item.get(nonKeyLsi)));
                }
                accumulatedSize += (long)lsiSize;
            }
        }
        if (accumulatedSize > 409600L) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.ITEM_TOO_BIG.getMessage());
        }
        return keyAttrs;
    }

    protected void validateKeyValue(Map<String, AttributeValue> item, AttributeDefinition keyDef, boolean essential, Long maxSize) {
        String keyName = keyDef.getAttributeName();
        AttributeValue val = item.get(keyName);
        DDBType expectedType = LocalDBUtils.getDataTypesOfAttributeDefinitions(Collections.singletonList(keyDef), true).get(0);
        if (val == null) {
            if (essential) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_SPECIFED_KEY_VALUE.getMessage());
            }
            return;
        }
        DDBType valueType = LocalDBUtils.getDataTypeOfScalarAttributeValue(val);
        if (valueType != expectedType) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INCONSISTENT_TYPES.getMessage());
        }
        if (valueType == DDBType.N) {
            item.put(keyName, new AttributeValue().withN(LocalDBUtils.validateNumericValue(val.getN()).toPlainString()));
        } else if (valueType == DDBType.NS) {
            item.put(keyName, new AttributeValue().withNS(LocalDBUtils.validateNumberSet(val.getNS())));
        }
        if (maxSize != null && LocalDBUtils.getAttributeValueSizeBytes(val) > maxSize) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.KEY_VALUE_TOO_BIG.getMessage());
        }
    }

    protected void validateGetKey(Map<String, AttributeValue> conditions, TableInfo tableInfo) {
        if (conditions == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.MISSING_KEY.getMessage());
        }
        int conditionsSize = conditions.size();
        if (conditionsSize > 2 || conditionsSize == 0 || conditionsSize == 2 && !tableInfo.hasRangeKey() || conditionsSize == 1 && tableInfo.hasRangeKey()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INCONSISTENT_GET_CONDITION_SIZE.getMessage());
        }
        this.validateKeyValue(conditions, tableInfo.getHashKey(), true, 2048L);
        if (tableInfo.hasRangeKey()) {
            this.validateKeyValue(conditions, tableInfo.getRangeKey(), true, 1024L);
        }
    }

    private long validateLimitValue(Integer limit) {
        if (limit == null) {
            return -1L;
        }
        if (limit < 1) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_LIMIT_VALUE.getMessage());
        }
        return limit.intValue();
    }

    private long validateLimitValueListTables(Integer limitInit) {
        long limit = this.validateLimitValue(limitInit);
        if (limit > 100L) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_LIMIT_TOO_BIG.getMessage());
        }
        return limit == -1L ? 100L : limit;
    }

    private ComparisonOperator validateConditionType(com.amazonaws.services.dynamodbv2.local.shared.model.Condition requestCondition) {
        try {
            return ComparisonOperator.fromValue((String)requestCondition.getComparisonOperator());
        }
        catch (IllegalArgumentException ie) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_COMPARISON.getMessage());
        }
    }

    protected void validateHashKeyCondition(AttributeDefinition hashKeyDef, Map<String, com.amazonaws.services.dynamodbv2.local.shared.model.Condition> keyConditions) {
        AttributeValue expectedVal;
        List<AttributeValue> expectedVals;
        this.localDBEnv.dbAssert(keyConditions != null, "validateHashKeyCondition", "keyConditions should not be null", new Object[0]);
        this.localDBEnv.dbAssert(hashKeyDef != null, "validateHashKeyCondition", "table hash key schema should not be null", new Object[0]);
        com.amazonaws.services.dynamodbv2.local.shared.model.Condition requestHashCondition = keyConditions.get(hashKeyDef.getAttributeName());
        if (requestHashCondition == null || requestHashCondition.getComparisonOperator() == null) {
            this.awsExceptionFactory.KEY_CONDITIONS_MISSING_KEY.throwAsException();
        }
        if ((expectedVals = requestHashCondition.getAttributeValueList()) == null || expectedVals.isEmpty()) {
            this.awsExceptionFactory.INVALID_HASH_KEY_VALUE.throwAsException();
        }
        if ((expectedVal = requestHashCondition.getAttributeValueList().get(0)) == null) {
            this.awsExceptionFactory.INVALID_HASH_KEY_VALUE.throwAsException();
        }
        LocalDBUtils.validateConsistentTypes(hashKeyDef, expectedVal, LocalDBClientExceptionMessage.INCONSISTENT_CONDITION_PARAMETER);
        if (!requestHashCondition.getComparisonOperator().equals(ComparisonOperator.EQ.toString())) {
            this.awsExceptionFactory.UNSUPPORTED_QUERY_KEY_CONDITION_SEQUENCE.throwAsException();
        }
        if (requestHashCondition.getAttributeValueList().size() > 1) {
            this.awsExceptionFactory.INVALID_FILTER_ARGUMENT_COUNT.throwAsException();
        }
        if (!DDBType.SortableScalarTypeSet.contains((Object)expectedVal.getType())) {
            this.awsExceptionFactory.INVALID_HASH_KEY_VALUE.throwAsException();
        }
    }

    private void validateRangeKeyCondition(AttributeDefinition rangeKeyDef, Map<String, com.amazonaws.services.dynamodbv2.local.shared.model.Condition> keyConditions) {
        com.amazonaws.services.dynamodbv2.local.shared.model.Condition requestRangeCondition = keyConditions.get(rangeKeyDef.getAttributeName());
        if (requestRangeCondition == null) {
            if (keyConditions.size() > 1) {
                this.awsExceptionFactory.KEY_CONDITIONS_MISSING_KEY.throwAsException();
            }
        } else {
            int expectedComparisonArguments;
            List<AttributeValue> expectedVals = requestRangeCondition.getAttributeValueList();
            if (expectedVals == null || expectedVals.isEmpty()) {
                this.awsExceptionFactory.INVALID_RANGE_KEY_VALUE.throwAsException();
            }
            for (AttributeValue expectedVal : requestRangeCondition.getAttributeValueList()) {
                LocalDBUtils.validateConsistentTypes(rangeKeyDef, expectedVal, LocalDBClientExceptionMessage.INCONSISTENT_CONDITION_PARAMETER);
            }
            ComparisonOperator comparisonOperator = this.validateConditionType(requestRangeCondition);
            LocalDBComparisonOperator localOp = LocalDBComparisonOperator.fromValue(comparisonOperator);
            if (!localOp.isValidForQuery()) {
                this.awsExceptionFactory.NON_INDEXABLE_CONDITION.throwAsException();
            }
            int n = expectedComparisonArguments = comparisonOperator == ComparisonOperator.BETWEEN ? 2 : 1;
            if (requestRangeCondition.getAttributeValueList().size() != expectedComparisonArguments) {
                this.awsExceptionFactory.INVALID_FILTER_ARGUMENT_COUNT.throwAsException();
            }
        }
    }

    private void validateExclusiveStartKeyQuery(Map<String, AttributeValue> exclusiveStartKey, List<AttributeDefinition> keyDefs, Map<String, com.amazonaws.services.dynamodbv2.local.shared.model.Condition> queryConditions, boolean asc, AttributeDefinition rangeKey) {
        this.validateExclusiveStartKey(exclusiveStartKey, keyDefs);
        if (exclusiveStartKey == null) {
            return;
        }
        if (!this.exclusiveStartFitsConditions(exclusiveStartKey, queryConditions, asc, rangeKey)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_START_KEY_RANGE.getMessage());
        }
    }

    private boolean exclusiveStartFitsConditions(Map<String, AttributeValue> exclusiveStartKey, Map<String, com.amazonaws.services.dynamodbv2.local.shared.model.Condition> queryConditions, boolean asc, AttributeDefinition rangeKey) {
        for (Map.Entry<String, AttributeValue> entry : exclusiveStartKey.entrySet()) {
            com.amazonaws.services.dynamodbv2.local.shared.model.Condition keyCondition = queryConditions.get(entry.getKey());
            AttributeValue val = entry.getValue();
            if (keyCondition == null || !(rangeKey != null && entry.getKey().equals(rangeKey.getAttributeName()) ? !LocalDBComparisonOperator.fromValue(keyCondition.getComparisonOperator()).evaluateExclusive(keyCondition.getAttributeValueList(), val, asc) : !LocalDBComparisonOperator.fromValue(keyCondition.getComparisonOperator()).evaluate(keyCondition.getAttributeValueList(), val))) continue;
            return false;
        }
        return true;
    }

    private void validateExclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey, List<AttributeDefinition> keyDefs) {
        if (exclusiveStartKey == null) {
            return;
        }
        if (exclusiveStartKey.size() != keyDefs.size()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_EXCLUSIVE_START_SIZE.getMessage());
        }
        for (int i = 0; i < keyDefs.size(); ++i) {
            AttributeDefinition keyDef = keyDefs.get(i);
            String keyName = keyDef.getAttributeName();
            AttributeValue keyVal = exclusiveStartKey.get(keyName);
            if (keyVal == null) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_EXCLUSIVE_START.getMessage());
            }
            DDBType keyType = LocalDBUtils.validateConsistentTypes(keyDef, keyVal, LocalDBClientExceptionMessage.INCONSISTENT_TYPES);
            if (keyType != DDBType.N) continue;
            exclusiveStartKey.put(keyName, new AttributeValue().withN(LocalDBUtils.validateNumericValue(keyVal.getN()).toPlainString()));
        }
    }

    private ReturnValue validateReturnType(String returnValsString, boolean update) {
        ReturnValue returnType;
        if (returnValsString == null) {
            return ReturnValue.NONE;
        }
        try {
            returnType = ReturnValue.fromValue((String)returnValsString);
        }
        catch (IllegalArgumentException illegalArgs) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_RETURN_VALUES_TYPE.getMessage());
        }
        if (!(update || returnType != ReturnValue.ALL_NEW && returnType != ReturnValue.UPDATED_NEW && returnType != ReturnValue.UPDATED_OLD)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_RETURN_VALUES_TYPE.getMessage());
        }
        return returnType;
    }

    private TableDescription getTableDescriptionHelper(String tableName) {
        TableInfo tableInfo = this.validateTableExists(tableName);
        TableDescription tableDescription = new TableDescription().withTableName(tableName).withAttributeDefinitions(tableInfo.getAttributeDefinitions()).withKeySchema(tableInfo.getKeySchema()).withTableStatus(TableStatus.ACTIVE).withCreationDateTime(new Date(tableInfo.getCreationDateTime())).withProvisionedThroughput(tableInfo.getThroughputDescription()).withLocalSecondaryIndexes(tableInfo.getLSIDescriptions()).withGlobalSecondaryIndexes(tableInfo.getGSIDescriptions());
        return tableDescription;
    }

    private void validateExpecations(Map<String, ExpectedAttributeValue> expected, String conditionalOperatorAsString) {
        if (expected.isEmpty() && conditionalOperatorAsString != null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.COND_OP_WITHOUT_FILTER_OR_EXPECTED.getMessage());
        }
        for (Map.Entry<String, ExpectedAttributeValue> entry : expected.entrySet()) {
            this.validateExpectedAttribute(entry.getKey(), entry.getValue());
        }
    }

    private void validateExpectedAttribute(String attributeName, ExpectedAttributeValue expectedAttributeValue) {
        if (expectedAttributeValue == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.format(LocalDBClientExceptionMessage.INVALID_PARAMETER_VALUE.getMessage(), "ExpectedAttributeValue must not be null for Attribute: " + attributeName));
        }
        if (expectedAttributeValue.isExists() != null && expectedAttributeValue.getComparisonOperator() != null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.format(LocalDBClientExceptionMessage.INVALID_PARAMETER_VALUE.getMessage(), "Exists and ComparisonOperator cannot be used together for Attribute: " + attributeName));
        }
        if (expectedAttributeValue.getValue() != null && expectedAttributeValue.getAttributeValueList() != null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.format(LocalDBClientExceptionMessage.INVALID_PARAMETER_VALUE.getMessage(), "Value and AttributeValueList cannot be used together for Attribute: " + attributeName));
        }
        if (expectedAttributeValue.getComparisonOperator() == null && expectedAttributeValue.getAttributeValueList() != null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.format(LocalDBClientExceptionMessage.INVALID_PARAMETER_VALUE.getMessage(), "AttributeValueList can only be used with a ComparisonOperator for Attribute: " + attributeName));
        }
        if (expectedAttributeValue.isExists() != null && !expectedAttributeValue.isExists().booleanValue() && expectedAttributeValue.getValue() != null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.format(LocalDBClientExceptionMessage.INVALID_PARAMETER_VALUE.getMessage(), "Value cannot be used when Exists is false for Attribute: " + attributeName));
        }
        if (expectedAttributeValue.getValue() == null && expectedAttributeValue.getAttributeValueList() == null) {
            if (expectedAttributeValue.getComparisonOperator() != null) {
                if (!expectedAttributeValue.getComparisonOperator().equals("NOT_NULL") && !expectedAttributeValue.getComparisonOperator().equals("NULL")) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.format(LocalDBClientExceptionMessage.INVALID_PARAMETER_VALUE.getMessage(), "Value or AttributeValueList must be used with ComparisonOperator: " + expectedAttributeValue.getComparisonOperator() + " for Attribute: " + attributeName));
                }
            } else {
                if (expectedAttributeValue.isExists() == null) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.format(LocalDBClientExceptionMessage.INVALID_PARAMETER_VALUE.getMessage(), "Value must be provided when Exists is null for Attribute: " + attributeName));
                }
                if (expectedAttributeValue.isExists().booleanValue()) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.format(LocalDBClientExceptionMessage.INVALID_PARAMETER_VALUE.getMessage(), "Value must be provided when Exists is true for Attribute: " + attributeName));
                }
            }
        }
    }

    private boolean checkANDConditions(Map<String, AttributeValue> item, Map<String, com.amazonaws.services.dynamodbv2.local.shared.model.Condition> conditions) {
        for (Map.Entry<String, com.amazonaws.services.dynamodbv2.local.shared.model.Condition> entry : conditions.entrySet()) {
            if (this.doesItemMatchCondition(item, entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean checkORConditions(Map<String, AttributeValue> item, Map<String, com.amazonaws.services.dynamodbv2.local.shared.model.Condition> conditions) {
        for (Map.Entry<String, com.amazonaws.services.dynamodbv2.local.shared.model.Condition> entry : conditions.entrySet()) {
            if (!this.doesItemMatchCondition(item, entry.getKey(), entry.getValue())) continue;
            return true;
        }
        return false;
    }

    private List<AttributeValue> getExpectedAttributeValueList(ExpectedAttributeValue expected) {
        return expected.getValue() != null ? Collections.singletonList(expected.getValue()) : expected.getAttributeValueList();
    }

    private ComparisonOperator getExpectedComparisonOperator(ExpectedAttributeValue expected) {
        if (expected.getComparisonOperator() != null) {
            return ComparisonOperator.fromValue((String)expected.getComparisonOperator());
        }
        Boolean exists = expected.getExists();
        if (!Boolean.FALSE.equals(exists)) {
            return ComparisonOperator.EQ;
        }
        return ComparisonOperator.NULL;
    }

    private Map<String, com.amazonaws.services.dynamodbv2.local.shared.model.Condition> convertToConditions(Map<String, ExpectedAttributeValue> expected) {
        HashMap<String, com.amazonaws.services.dynamodbv2.local.shared.model.Condition> conditions = new HashMap<String, com.amazonaws.services.dynamodbv2.local.shared.model.Condition>();
        for (Map.Entry<String, ExpectedAttributeValue> entry : expected.entrySet()) {
            String attrName = entry.getKey();
            ExpectedAttributeValue expectedAttributeValue = entry.getValue();
            com.amazonaws.services.dynamodbv2.local.shared.model.Condition condition = new com.amazonaws.services.dynamodbv2.local.shared.model.Condition().withAttributeValueList(this.getExpectedAttributeValueList(expectedAttributeValue)).withComparisonOperator(this.getExpectedComparisonOperator(expectedAttributeValue));
            conditions.put(attrName, condition);
        }
        return conditions;
    }

    private void validateAttributesToGet(List<String> attributesToGet) {
        this.validateAttributesToGetAndProjExpr(attributesToGet, null, null, null);
    }

    private void validateAttributesToGetAndProjExpr(List<String> attributesToGet, ProjectionExpression projectionExpression, String indexName, TableInfo tableInfo) {
        if (attributesToGet != null && attributesToGet.size() == 0) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.ATTRIBUTES_EMPTY.getMessage());
        }
        Set<Object> attrsToFetch = new HashSet();
        if (projectionExpression != null) {
            attrsToFetch = ExpressionUtils.getProjectionExpressionTopLevelAttributes(projectionExpression, this.localDBEnv);
        } else {
            if (attributesToGet == null) {
                return;
            }
            for (String attr : attributesToGet) {
                if (StringUtils.isEmpty((CharSequence)attr)) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_ATTRIBUTE_NAME.getMessage());
                }
                if (attrsToFetch.contains(attr)) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.IDENTICAL_ATTRIBUTE_NAMES.getMessage());
                }
                attrsToFetch.add(attr);
            }
        }
        if (indexName != null && tableInfo.isGSIIndex(indexName) && !tableInfo.getProjection(indexName).getProjectionType().equals(ProjectionType.ALL.name())) {
            Projection gsiProj = tableInfo.getProjection(indexName);
            List nonKeyAttributes = gsiProj.getNonKeyAttributes();
            ArrayList<String> keyAndNonKeyAttrs = new ArrayList<String>();
            keyAndNonKeyAttrs.addAll(this.getAttributeNames(this.getKeyAttributes(tableInfo, indexName)));
            if (nonKeyAttributes != null) {
                keyAndNonKeyAttrs.addAll(nonKeyAttributes);
            }
            if (!keyAndNonKeyAttrs.containsAll(attrsToFetch)) {
                attrsToFetch.removeAll(keyAndNonKeyAttrs);
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.format(LocalDBClientExceptionMessage.INVALID_PARAMETER_VALUE.getMessage(), "Global secondary index " + indexName + " does not project " + attrsToFetch));
            }
        }
    }

    private TableDescription fillDescriptionHelper(TableDescription description) {
        String indexName;
        String tableName = description.getTableName();
        long tableItemCount = this.dbAccess.getTableItemCount(tableName);
        description.setItemCount(Long.valueOf(tableItemCount));
        description.setTableSizeBytes(Long.valueOf(this.dbAccess.getTableByteSize(tableName)));
        if (description.getLocalSecondaryIndexes() != null) {
            for (LocalSecondaryIndexDescription lsiDesc : description.getLocalSecondaryIndexes()) {
                indexName = lsiDesc.getIndexName();
                long indexItemCount = this.dbAccess.getLSIItemCount(tableName, indexName);
                lsiDesc.setItemCount(Long.valueOf(indexItemCount));
                lsiDesc.setIndexSizeBytes(Long.valueOf(this.dbAccess.getLSIByteSize(tableName, indexName)));
            }
        }
        if (description.getGlobalSecondaryIndexes() != null) {
            for (GlobalSecondaryIndexDescription gsiDesc : description.getGlobalSecondaryIndexes()) {
                if (!this.isGSIInAStateToCountItems(gsiDesc)) continue;
                indexName = gsiDesc.getIndexName();
                gsiDesc.setItemCount(Long.valueOf(this.dbAccess.getGSIItemCount(tableName, indexName)));
                gsiDesc.setIndexSizeBytes(Long.valueOf(this.dbAccess.getGSIByteSize(tableName, indexName)));
            }
        }
        return description;
    }

    private boolean isGSIInAStateToCountItems(GlobalSecondaryIndexDescription description) {
        return IndexStatus.ACTIVE.toString().equals(description.getIndexStatus()) || IndexStatus.CREATING.toString().equals(description.getIndexStatus()) && Boolean.TRUE.equals(description.getBackfilling()) || IndexStatus.UPDATING.toString().equals(description.getIndexStatus()) && Boolean.TRUE.equals(description.getBackfilling());
    }

    public Select validateSelect(String selectStr, List<String> attrsToGet, ProjectionExpression projectionExpression, String indexName, TableInfo tableInfo) {
        Select newSelect = null;
        if (StringUtils.isEmpty((CharSequence)selectStr)) {
            newSelect = attrsToGet != null || projectionExpression != null ? Select.SPECIFIC_ATTRIBUTES : (indexName != null ? Select.ALL_PROJECTED_ATTRIBUTES : Select.ALL_ATTRIBUTES);
        } else {
            try {
                newSelect = Select.fromValue((String)selectStr);
            }
            catch (IllegalArgumentException ie) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_SELECT.getMessage());
            }
            String addErrorInfo = null;
            if (attrsToGet != null || projectionExpression != null) {
                addErrorInfo = attrsToGet != null ? "AttributesToGet" : "ProjectionExpression";
            }
            switch (newSelect) {
                case ALL_ATTRIBUTES: {
                    if (attrsToGet == null && projectionExpression == null) break;
                    String errorMessage = "Cannot specify the " + addErrorInfo + " when choosing to get " + Select.ALL_ATTRIBUTES;
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, errorMessage);
                }
                case ALL_PROJECTED_ATTRIBUTES: {
                    if (attrsToGet != null || projectionExpression != null) {
                        String errorMessage = "Cannot specify the " + addErrorInfo + " when choosing to get " + Select.ALL_PROJECTED_ATTRIBUTES;
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, errorMessage);
                    }
                    if (!StringUtils.isEmpty((CharSequence)indexName)) break;
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, Select.ALL_PROJECTED_ATTRIBUTES + " can be used only when Querying using an IndexName");
                }
                case COUNT: {
                    if (attrsToGet != null) {
                        this.awsExceptionFactory.OBTAINING_COUNT_AND_ATTRIBUTES.throwAsException();
                        break;
                    }
                    if (projectionExpression == null) break;
                    this.awsExceptionFactory.OBTAINING_COUNT_AND_PROJECTIONEXPRESSION.throwAsException();
                    break;
                }
                case SPECIFIC_ATTRIBUTES: {
                    if (attrsToGet == null && projectionExpression == null) {
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, "Must specify the AttributesToGet or ProjectionExpression when choosing to get " + Select.SPECIFIC_ATTRIBUTES);
                    }
                    this.validateAttributesToGetAndProjExpr(attrsToGet, projectionExpression, indexName, tableInfo);
                    break;
                }
                default: {
                    this.awsExceptionFactory.INTERNAL_FAILURE.throwAsException();
                }
            }
        }
        return newSelect;
    }

    private void validateAttributeUpdate(AttributeAction action, AttributeValue curAttr) {
        if (curAttr == null && !this.inputConverter.isDelete(action)) {
            this.awsExceptionFactory.INVALID_PARAMETER_VALUE.throwAsException("Only DELETE action is allowed when no attribute value is specified");
        } else {
            DocumentNodeType type;
            DocumentNodeType documentNodeType = type = curAttr != null ? this.inputConverter.getType(curAttr) : null;
            if (this.inputConverter.isDelete(action) && curAttr != null && !this.inputConverter.TypesSupportingAttributeDeleteWithValueUpdate.contains((Object)type)) {
                this.awsExceptionFactory.INVALID_PARAMETER_VALUE.throwAsException("DELETE action with value is not supported for the type " + (Object)((Object)type));
            } else if (this.inputConverter.isAdd(action) && !this.inputConverter.TypesSupportingAttributeAddUpdate.contains((Object)type)) {
                this.awsExceptionFactory.INVALID_PARAMETER_VALUE.throwAsException("ADD action is not supported for the type " + (Object)((Object)type));
            }
        }
    }

    private void validateAttributeUpdates(Map<String, AttributeValueUpdate> updates, TableInfo tableInfo, Map<String, AttributeValue> oldItem) {
        if (updates == null) {
            return;
        }
        for (Map.Entry<String, AttributeValueUpdate> entry : updates.entrySet()) {
            AttributeAction curAction;
            String attributeName = this.inputConverter.newAttributeName(entry.getKey());
            if (attributeName.equals(tableInfo.getHashKey().getAttributeName()) || tableInfo.hasRangeKey() && attributeName.equals(tableInfo.getRangeKey().getAttributeName())) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.format(LocalDBClientExceptionMessage.INVALID_PARAMETER_VALUE.getMessage(), "Cannot update attribute " + attributeName + ". This attribute is part of the key"));
            }
            AttributeValueUpdate curUpdate = entry.getValue();
            try {
                if (curUpdate.getAction() == null) {
                    curUpdate.setAction(AttributeAction.PUT);
                }
                curAction = AttributeAction.fromValue((String)curUpdate.getAction());
            }
            catch (IllegalArgumentException illegalArgs) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_ACTION_TYPE.getMessage());
            }
            AttributeValue curAttr = (AttributeValue)this.inputConverter.externalToInternalAttributeValue(curUpdate.getValue(), true);
            this.validateAttributeUpdate(curAction, curAttr);
            AttributeValue curAttrOld = null;
            if (oldItem != null && oldItem.containsKey(attributeName)) {
                curAttrOld = oldItem.get(attributeName);
            }
            switch (curAction) {
                case DELETE: {
                    this.validateAttributeDelete(curAttr, curAttrOld);
                    break;
                }
                case PUT: {
                    this.validateAttributePut(curAttr);
                    break;
                }
                case ADD: {
                    this.validateAttributeAdd(curAttr, curAttrOld);
                }
            }
            AttributeDefinition lsiKeyDef = tableInfo.getLSIRangeKeyWithAttributeName(attributeName);
            if (lsiKeyDef != null && curAttr != null) {
                try {
                    LocalDBUtils.validateConsistentTypes(lsiKeyDef, curAttr, LocalDBClientExceptionMessage.INCONSISTENT_TYPES);
                }
                catch (AmazonServiceException serviceException) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_UPDATE_INDEX_KEY.getMessage());
                }
            }
            if (curAttr == null) continue;
            DDBType type = LocalDBUtils.getDataTypeOfAttributeValue(curAttr);
            if (type == DDBType.N) {
                curUpdate.setValue(new com.amazonaws.services.dynamodbv2.model.AttributeValue().withN(LocalDBUtils.validateNumericValue(curAttr.getN()).toPlainString()));
                continue;
            }
            if (!type.isSet()) continue;
            if (type == DDBType.NS) {
                curUpdate.setValue(new com.amazonaws.services.dynamodbv2.model.AttributeValue().withNS(LocalDBUtils.validateNumberSet(curAttr.getNS())));
                continue;
            }
            LocalDBUtils.validateItemSet(curAttr.getBS());
            LocalDBUtils.validateItemSet(curAttr.getSS());
        }
    }

    private void validateAttributeDelete(AttributeValue curAttr, AttributeValue oldAttr) {
        boolean isSet;
        try {
            isSet = LocalDBUtils.getDataTypeOfAttributeValue(curAttr).isSet();
        }
        catch (NullPointerException npe) {
            isSet = false;
        }
        if (curAttr != null && !isSet) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_ACTION_DELETE.getMessage());
        }
        if (isSet && oldAttr != null) {
            LocalDBUtils.validateConsistentTypes(curAttr, oldAttr);
        }
    }

    private void validateAttributePutAdd(AttributeValue curAttr) {
        if (curAttr == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_ACTION_NO_VALUE.getMessage());
        }
    }

    private void validateAttributePut(AttributeValue curAttr) {
        this.validateAttributePutAdd(curAttr);
        LocalDBUtils.getDataTypeOfAttributeValue(curAttr);
    }

    private void validateAttributeAdd(AttributeValue curAttr, AttributeValue oldAttr) {
        this.validateAttributePutAdd(curAttr);
        DDBType type = LocalDBUtils.getDataTypeOfAttributeValue(curAttr);
        if (type != DDBType.N && !type.isSet() && type != DDBType.L) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_ACTION_ADD.getMessage());
        }
        if (oldAttr != null) {
            LocalDBUtils.validateConsistentTypes(curAttr, oldAttr);
        }
    }

    private Map<String, AttributeValue> doUpdates(Map<String, AttributeValueUpdate> updatesToMake, Map<String, AttributeValue> item) {
        if (updatesToMake == null) {
            return item;
        }
        for (Map.Entry<String, AttributeValueUpdate> entry : updatesToMake.entrySet()) {
            String attr = entry.getKey();
            AttributeValueUpdate curUpdate = entry.getValue();
            AttributeAction curAction = AttributeAction.valueOf((String)curUpdate.getAction());
            switch (curAction) {
                case ADD: {
                    this.doAdd(attr, curUpdate, item);
                    break;
                }
                case DELETE: {
                    this.doDelete(attr, curUpdate, item);
                    break;
                }
                case PUT: {
                    this.doPut(attr, curUpdate, item);
                }
            }
        }
        return item;
    }

    private void doUpdates(UpdateExpression updateExpression, Map<String, AttributeValue> oldItem, Map<String, AttributeValue> itemChanges, ReturnValue returnValue) {
        if (updateExpression == null) {
            return;
        }
        try {
            AttributeValue existingDocument = new AttributeValue().withM(new LinkedHashMap<String, AttributeValue>(oldItem));
            ExpressionExecutor exprExecutor = new ExpressionExecutor(existingDocument, null, this.localDBEnv, this.documentFactory);
            AttributeValue modifiedDocument = (AttributeValue)exprExecutor.getUserDocNew(updateExpression.getTreeRoot());
            oldItem.clear();
            oldItem.putAll(modifiedDocument.getM());
            AttributeValue updates = null;
            if (returnValue != null && ReturnValue.UPDATED_NEW.equals((Object)returnValue)) {
                updates = (AttributeValue)exprExecutor.getUpdatedNewDocument(updateExpression.getTreeRoot(), modifiedDocument);
            } else if (returnValue != null && ReturnValue.UPDATED_OLD.equals((Object)returnValue)) {
                ExpressionExecutor exprExecutorOld = new ExpressionExecutor(existingDocument, null, this.localDBEnv, this.documentFactory);
                updates = (AttributeValue)exprExecutorOld.getUpdatedOldDocument(updateExpression.getTreeRoot());
            }
            if (updates != null) {
                itemChanges.putAll(updates.getM());
            }
        }
        catch (ExpressionExecutionException eee) {
            ExceptionHandler.processExecutionExceptions(ExceptionHandler.ExpressionExecutionContext.UPDATE_EXPRESSION, eee, this.awsExceptionFactory);
        }
    }

    private void doDelete(String attrName, AttributeValueUpdate attrUpdate, Map<String, AttributeValue> item) {
        AttributeValue updateVal = (AttributeValue)this.inputConverter.externalToInternalAttributeValue(attrUpdate.getValue(), true);
        if (updateVal == null) {
            item.remove(attrName);
        } else {
            AttributeValue curAttr = item.get(attrName);
            if (curAttr == null) {
                return;
            }
            DDBType type = LocalDBUtils.getDataTypeOfAttributeValue(curAttr);
            switch (type) {
                case BS: {
                    ArrayList<ByteBuffer> curValBlobSet = new ArrayList<ByteBuffer>();
                    curValBlobSet.addAll(curAttr.getBS());
                    curValBlobSet.removeAll(updateVal.getBS());
                    if (curValBlobSet.isEmpty()) {
                        item.remove(attrName);
                        break;
                    }
                    item.put(attrName, new AttributeValue().withBS(curValBlobSet));
                    break;
                }
                case NS: {
                    ArrayList<String> curValNumSet = new ArrayList<String>();
                    curValNumSet.addAll(curAttr.getNS());
                    curValNumSet.removeAll(updateVal.getNS());
                    if (curValNumSet.isEmpty()) {
                        item.remove(attrName);
                        break;
                    }
                    item.put(attrName, new AttributeValue().withNS(curValNumSet));
                    break;
                }
                case SS: {
                    ArrayList<String> curValStrSet = new ArrayList<String>();
                    curValStrSet.addAll(curAttr.getSS());
                    curValStrSet.removeAll(updateVal.getSS());
                    if (curValStrSet.isEmpty()) {
                        item.remove(attrName);
                        break;
                    }
                    item.put(attrName, new AttributeValue().withSS(curValStrSet));
                    break;
                }
                default: {
                    LocalDBUtils.ldClientFail(LocalDBClientExceptionType.UNREACHABLE_CODE);
                }
            }
        }
    }

    private void doPut(String attrName, AttributeValueUpdate attrUpdate, Map<String, AttributeValue> item) {
        AttributeValue updateVal = (AttributeValue)this.inputConverter.externalToInternalAttributeValue(attrUpdate.getValue(), false);
        item.put(attrName, updateVal);
    }

    private void doAdd(String attrName, AttributeValueUpdate attrUpdate, Map<String, AttributeValue> item) {
        AttributeValue updateVal = (AttributeValue)this.inputConverter.externalToInternalAttributeValue(attrUpdate.getValue(), false);
        AttributeValue curAttr = item.get(attrName);
        DDBType type = LocalDBUtils.getDataTypeOfAttributeValue(updateVal);
        if (type == DDBType.N) {
            if (curAttr == null) {
                item.put(attrName, updateVal);
            } else {
                BigDecimal curValNum = new BigDecimal(curAttr.getN());
                BigDecimal updateValNum = new BigDecimal(updateVal.getN());
                BigDecimal newValNum = curValNum.add(updateValNum);
                item.put(attrName, new AttributeValue().withN(newValNum.toPlainString()));
            }
        } else if (type.isSet()) {
            if (curAttr == null) {
                item.put(attrName, updateVal);
            } else {
                switch (LocalDBUtils.getDataTypeOfAttributeValue(curAttr)) {
                    case BS: {
                        ArrayList<ByteBuffer> curValBlobSet = new ArrayList<ByteBuffer>();
                        curValBlobSet.addAll(curAttr.getBS());
                        for (ByteBuffer curBuf : updateVal.getBS()) {
                            if (curValBlobSet.contains(curBuf)) continue;
                            curValBlobSet.add(curBuf);
                        }
                        item.put(attrName, new AttributeValue().withBS(curValBlobSet));
                        break;
                    }
                    case NS: {
                        ArrayList<String> curValNumSet = new ArrayList<String>();
                        curValNumSet.addAll(curAttr.getNS());
                        for (String curNum : updateVal.getNS()) {
                            if (curValNumSet.contains(curNum)) continue;
                            curValNumSet.add(curNum);
                        }
                        item.put(attrName, new AttributeValue().withNS(curValNumSet));
                        break;
                    }
                    case SS: {
                        ArrayList<String> curValStrSet = new ArrayList<String>();
                        curValStrSet.addAll(curAttr.getSS());
                        for (String curStr : updateVal.getSS()) {
                            if (curValStrSet.contains(curStr)) continue;
                            curValStrSet.add(curStr);
                        }
                        item.put(attrName, new AttributeValue().withSS(curValStrSet));
                        break;
                    }
                }
            }
        } else if (type == DDBType.L) {
            if (curAttr == null) {
                item.put(attrName, updateVal);
            } else if (updateVal.getL() != null && updateVal.getL().size() > 0) {
                AttributeValue resultListAttrVal;
                block22: {
                    ArrayList<AttributeValue> resultList = new ArrayList<AttributeValue>();
                    resultList.addAll(curAttr.getL());
                    resultList.addAll(updateVal.getL());
                    resultListAttrVal = new AttributeValue().withL(resultList);
                    try {
                        LocalDBUtils.setDocumentLevel(1, resultListAttrVal);
                    }
                    catch (Exception ex) {
                        if (!ex.getMessage().equalsIgnoreCase(this.awsExceptionFactory.ITEM_NESTING_LEVELS_LIMIT_EXCEEDED.getMessage())) break block22;
                        this.awsExceptionFactory.ITEM_NESTING_LEVELS_LIMIT_EXCEEDED.throwAsException();
                    }
                }
                item.put(attrName, resultListAttrVal);
            }
        }
    }

    private Map<String, AttributeValue> getReturnedValsFromUpdate(ReturnValue returnVals, Map<String, ?> updatesToMake, Map<String, AttributeValue> oldItem, Map<String, AttributeValue> updatedItem) {
        HashMap<String, AttributeValue> returnedVals = new HashMap<String, AttributeValue>();
        switch (returnVals) {
            case ALL_OLD: {
                if (oldItem == null) {
                    return null;
                }
                returnedVals.putAll(oldItem);
                break;
            }
            case ALL_NEW: {
                returnedVals.putAll(updatedItem);
                break;
            }
            case UPDATED_OLD: {
                if (oldItem == null) {
                    return null;
                }
                for (Map.Entry<String, ?> entry : updatesToMake.entrySet()) {
                    String attr = entry.getKey();
                    if (!oldItem.containsKey(attr)) continue;
                    returnedVals.put(attr, oldItem.get(attr));
                }
                break;
            }
            case UPDATED_NEW: {
                for (Map.Entry<String, ?> entry : updatesToMake.entrySet()) {
                    String attr = entry.getKey();
                    if (!updatedItem.containsKey(attr)) continue;
                    returnedVals.put(attr, updatedItem.get(attr));
                }
                break;
            }
            case NONE: {
                returnedVals = null;
            }
        }
        if (returnedVals != null && returnedVals.isEmpty()) {
            returnedVals = null;
        }
        return returnedVals;
    }

    private int validateBatchGetEntry(String tableName, com.amazonaws.services.dynamodbv2.local.shared.model.KeysAndAttributes requests, int count) {
        this.validateTableName(tableName);
        TableInfo info = this.validateTableExists(tableName);
        if (requests == null) {
            this.awsExceptionFactory.BATCH_GET_NULL_OR_EMPTY_KAS.throwAsException(tableName + " has empty list");
        }
        this.validateAttributesToGet(requests.getAttributesToGet());
        List<Map<String, AttributeValue>> keys = requests.getKeys();
        if (keys == null || keys.isEmpty()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_KEYS.getMessage());
        }
        HashSet<Map<String, AttributeValue>> keysSet = new HashSet<Map<String, AttributeValue>>(keys);
        if (keysSet.size() < keys.size()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.DUPLICATE_ITEM_KEY.getMessage());
        }
        if ((count += keys.size()) > 100) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MANY_REQUESTED_ITEMS.getMessage());
        }
        for (Map<String, AttributeValue> primaryKey : keys) {
            if (primaryKey == null) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.BAD_GET_CONDITION.getMessage());
            }
            this.validateGetKey(primaryKey, info);
        }
        return count;
    }

    public long doBatchGet(String tableName, com.amazonaws.services.dynamodbv2.local.shared.model.KeysAndAttributes requests, Map<String, List<Map<String, AttributeValue>>> responses, Map<String, com.amazonaws.services.dynamodbv2.local.shared.model.KeysAndAttributes> unprocessedKeys, long totalSize) {
        ArrayList<Map<String, AttributeValue>> fetchedItems = new ArrayList<Map<String, AttributeValue>>();
        responses.put(tableName, fetchedItems);
        List<String> attributesToGet = requests.getAttributesToGet();
        String projectionExpressionString = requests.getProjectionExpression();
        ProjectionExpressionWrapper projectionExpressionWrapper = this.inputConverter.externalToInternalProjectionExpression(projectionExpressionString, requests.getExpressionAttributeNames());
        ProjectionExpression projectionExpression = projectionExpressionWrapper == null ? null : projectionExpressionWrapper.getProjection();
        LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(this.dbAccess.getTableInfo(tableName), projectionExpressionWrapper, this.awsExceptionFactory);
        HashMap<String, com.amazonaws.services.dynamodbv2.local.shared.model.KeysAndAttributes> batchInputMap = new HashMap<String, com.amazonaws.services.dynamodbv2.local.shared.model.KeysAndAttributes>();
        batchInputMap.put(tableName, requests);
        ArrayList<Map<String, AttributeValue>> keys = new ArrayList<Map<String, AttributeValue>>(requests.getKeys());
        while (!keys.isEmpty()) {
            Map primaryKey = (Map)keys.remove(0);
            Map<String, AttributeValue> item = this.dbAccess.getRecord(tableName, primaryKey);
            if (item == null) continue;
            if ((totalSize += LocalDBUtils.getItemSizeBytes(item)) > 0x1000000L) {
                keys.add(0, primaryKey);
                break;
            }
            if (projectionExpression != null) {
                fetchedItems.add(LocalDBUtils.projectAttributes(item, projectionExpression));
                continue;
            }
            fetchedItems.add(LocalDBUtils.projectAttributes(item, attributesToGet));
        }
        if (!fetchedItems.isEmpty()) {
            responses.put(tableName, fetchedItems);
        }
        if (!keys.isEmpty()) {
            com.amazonaws.services.dynamodbv2.local.shared.model.KeysAndAttributes tableUnprocessedKeys = new com.amazonaws.services.dynamodbv2.local.shared.model.KeysAndAttributes().withAttributesToGet(attributesToGet).withProjectionExpression(projectionExpressionString);
            tableUnprocessedKeys.setExpressionAttributeNames(requests.getExpressionAttributeNames());
            tableUnprocessedKeys.setKeys(keys);
            tableUnprocessedKeys.setConsistentRead(requests.getConsistentRead());
            unprocessedKeys.put(tableName, tableUnprocessedKeys);
        }
        return totalSize;
    }

    private void validateTableNotExists(String tableName) {
        if (this.dbAccess.getTableInfo(tableName) != null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_IN_USE_EXCEPTION, LocalDBClientExceptionMessage.TABLE_ALREADY_EXISTS.getMessage());
        }
    }

    private void validateConditions(Map<String, com.amazonaws.services.dynamodbv2.local.shared.model.Condition> conditions, String conditionalOperatorAsString) {
        if (conditionalOperatorAsString != null && this.isValidConditionalOperator(conditionalOperatorAsString)) {
            if (conditions.isEmpty()) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.COND_OP_WITHOUT_FILTER_OR_EXPECTED.getMessage());
            }
            if (conditions.size() == 1) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.COND_OP_WITH_ONE_ELEMENT.getMessage());
            }
        }
        if (conditions == null) {
            return;
        }
        for (Map.Entry<String, com.amazonaws.services.dynamodbv2.local.shared.model.Condition> entry : conditions.entrySet()) {
            com.amazonaws.services.dynamodbv2.local.shared.model.Condition requestCondition = entry.getValue();
            ComparisonOperator comparisonOperator = this.validateConditionType(requestCondition);
            List<AttributeValue> expectedVals = requestCondition.getAttributeValueList();
            LocalDBComparisonOperator localOp = LocalDBComparisonOperator.fromValue(comparisonOperator);
            localOp.isValidAttributeList(expectedVals);
        }
    }

    private boolean isValidConditionalOperator(String conditionalOperatorAsString) {
        try {
            ConditionalOperator.fromValue((String)conditionalOperatorAsString);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public boolean doesItemMatchConditionalOperator(Map<String, AttributeValue> item, Map<String, com.amazonaws.services.dynamodbv2.local.shared.model.Condition> conditions, ConditionalOperator conditionalOperator) {
        if (conditions != null && conditions.size() > 0) {
            switch (conditionalOperator) {
                case AND: {
                    return this.checkANDConditions(item, conditions);
                }
                case OR: {
                    return this.checkORConditions(item, conditions);
                }
            }
            LocalDBUtils.ldClientFail(LocalDBClientExceptionType.UNREACHABLE_CODE);
            return false;
        }
        return true;
    }

    private boolean doesItemMatchCondition(Map<String, AttributeValue> item, String attributeName, com.amazonaws.services.dynamodbv2.local.shared.model.Condition condition) {
        AttributeValue actualValue = item == null ? null : item.get(attributeName);
        return LocalDBComparisonOperator.fromValue(condition.getComparisonOperator()).evaluate(condition.getAttributeValueList(), actualValue);
    }

    private boolean isAttributeOfSetType(AttributeValue expected) {
        DDBType type = LocalDBUtils.getDataTypeOfAttributeValue(expected);
        if (type == null) {
            return false;
        }
        return type.isSet();
    }

    private Map<String, AttributeValue> validateBatchWriteDelete(WriteRequest writeRequest, List<Map<String, AttributeValue>> deletesList, TableInfo tableInfo) {
        if (writeRequest.getPutRequest() != null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.BATCH_WRITE_TWO_IN_ONE.getMessage());
        }
        DeleteRequest deleteRequest = writeRequest.getDeleteRequest();
        if (deleteRequest.getKey() == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.MISSING_KEY.getMessage());
        }
        Map<String, AttributeValue> primaryKey = deleteRequest.getKey();
        this.validateGetKey(primaryKey, tableInfo);
        deletesList.add(primaryKey);
        return primaryKey;
    }

    private Map<String, AttributeValue> validateBatchWritePut(WriteRequest writeRequest, List<Map<String, AttributeValue>> putsList, TableInfo tableInfo) {
        if (writeRequest.getPutRequest() == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.BATCH_WRITE_NO_REQUEST_TYPE.getMessage());
        }
        PutRequest putRequest = writeRequest.getPutRequest();
        if (putRequest.getItem() == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_PUT_NULL.getMessage());
        }
        Map<String, AttributeValue> record = putRequest.getItem();
        Map<String, AttributeValue> primaryKey = this.validatePutItem(record, tableInfo);
        putsList.add(record);
        return primaryKey;
    }

    private Long validateBatchWriteWriteRequest(WriteRequest writeRequest, TableInfo tableInfo, List<Map<String, AttributeValue>> putsList, List<Map<String, AttributeValue>> deletesList, Set<Map<String, AttributeValue>> keySet, Long totalRequestSize) {
        boolean isDelete;
        if (writeRequest == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.BATCH_WRITE_NULL_INDIVIDUAL_REQUEST.getMessage());
        }
        Map<String, AttributeValue> primaryKey = null;
        boolean bl = isDelete = writeRequest.getDeleteRequest() != null;
        if (isDelete) {
            primaryKey = this.validateBatchWriteDelete(writeRequest, deletesList, tableInfo);
        } else {
            primaryKey = this.validateBatchWritePut(writeRequest, putsList, tableInfo);
            totalRequestSize = totalRequestSize + Long.valueOf(LocalDBUtils.getItemSizeBytes(putsList.get(putsList.size() - 1)));
        }
        if (keySet.contains(primaryKey)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.DUPLICATE_ITEM_KEY.getMessage());
        }
        keySet.add(primaryKey);
        return totalRequestSize;
    }

    private static byte[] getSegmentBeginningHashKey(int totalSegments, int segment) {
        BigInteger delta = LocalDBUtils.MAX_HASH_KEY.divide(BigInteger.valueOf(totalSegments));
        delta = delta.multiply(BigInteger.valueOf(segment));
        return LocalDBUtils.bigIntegerToSHA1Bytes(delta);
    }

    private static byte[] getSegmentEndHashKey(int totalSegments, int segment) {
        if (segment + 1 == totalSegments) {
            return LocalDBUtils.bigIntegerToSHA1Bytes(LocalDBUtils.MAX_HASH_KEY);
        }
        BigInteger delta = LocalDBUtils.MAX_HASH_KEY.divide(BigInteger.valueOf(totalSegments));
        delta = delta.multiply(BigInteger.valueOf(segment + 1));
        return LocalDBUtils.bigIntegerToSHA1Bytes(delta.subtract(BigInteger.valueOf(1L)));
    }

    public void setRegion(Region region) throws IllegalArgumentException {
        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.INVALID_ACTION, "Regions are not supported in LocalDynamoDB");
    }

    public BatchGetItemResult batchGetItem(Map<String, KeysAndAttributes> arg0) throws AmazonServiceException, AmazonClientException {
        BatchGetItemRequest request = new BatchGetItemRequest(arg0);
        return this.batchGetItem(request);
    }

    public BatchGetItemResult batchGetItem(Map<String, KeysAndAttributes> arg0, String arg1) throws AmazonServiceException, AmazonClientException {
        BatchGetItemRequest request = new BatchGetItemRequest(arg0, arg1);
        return this.batchGetItem(request);
    }

    public BatchWriteItemResult batchWriteItem(Map<String, List<com.amazonaws.services.dynamodbv2.model.WriteRequest>> arg0) throws AmazonServiceException, AmazonClientException {
        BatchWriteItemRequest request = new BatchWriteItemRequest(arg0);
        return this.batchWriteItem(request);
    }

    public CreateTableResult createTable(List<AttributeDefinition> arg0, String arg1, List<KeySchemaElement> arg2, ProvisionedThroughput arg3) throws AmazonServiceException, AmazonClientException {
        CreateTableRequest request = new CreateTableRequest(arg0, arg1, arg2, arg3);
        return this.createTable(request);
    }

    public DeleteItemResult deleteItem(String arg0, Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> arg1) throws AmazonServiceException, AmazonClientException {
        DeleteItemRequest request = new DeleteItemRequest(arg0, arg1);
        return this.deleteItem(request);
    }

    public DeleteItemResult deleteItem(String arg0, Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> arg1, String arg2) throws AmazonServiceException, AmazonClientException {
        DeleteItemRequest request = new DeleteItemRequest(arg0, arg1, arg2);
        return this.deleteItem(request);
    }

    public DeleteTableResult deleteTable(String arg0) throws AmazonServiceException, AmazonClientException {
        DeleteTableRequest request = new DeleteTableRequest(arg0);
        return this.deleteTable(request);
    }

    public DescribeTableResult describeTable(String arg0) throws AmazonServiceException, AmazonClientException {
        DescribeTableRequest request = new DescribeTableRequest(arg0);
        return this.describeTable(request);
    }

    public GetItemResult getItem(String arg0, Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> arg1) throws AmazonServiceException, AmazonClientException {
        GetItemRequest request = new GetItemRequest(arg0, arg1);
        return this.getItem(request);
    }

    public GetItemResult getItem(String arg0, Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> arg1, Boolean arg2) throws AmazonServiceException, AmazonClientException {
        GetItemRequest request = new GetItemRequest(arg0, arg1, arg2);
        return this.getItem(request);
    }

    public ListTablesResult listTables(String arg0) throws AmazonServiceException, AmazonClientException {
        ListTablesRequest request = new ListTablesRequest(arg0);
        return this.listTables(request);
    }

    public ListTablesResult listTables(Integer arg0) throws AmazonServiceException, AmazonClientException {
        ListTablesRequest request = new ListTablesRequest().withLimit(arg0);
        return this.listTables(request);
    }

    public ListTablesResult listTables(String arg0, Integer arg1) throws AmazonServiceException, AmazonClientException {
        ListTablesRequest request = new ListTablesRequest(arg0, arg1);
        return this.listTables(request);
    }

    public PutItemResult putItem(String arg0, Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> arg1) throws AmazonServiceException, AmazonClientException {
        PutItemRequest request = new PutItemRequest(arg0, arg1);
        return this.putItem(request);
    }

    public PutItemResult putItem(String arg0, Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> arg1, String arg2) throws AmazonServiceException, AmazonClientException {
        PutItemRequest request = new PutItemRequest(arg0, arg1, arg2);
        return this.putItem(request);
    }

    public ScanResult scan(String arg0, List<String> arg1) throws AmazonServiceException, AmazonClientException {
        ScanRequest request = new ScanRequest(arg0).withAttributesToGet(arg1);
        return this.scan(request);
    }

    public ScanResult scan(String arg0, Map<String, Condition> arg1) throws AmazonServiceException, AmazonClientException {
        ScanRequest request = new ScanRequest(arg0).withScanFilter(arg1);
        return this.scan(request);
    }

    public ScanResult scan(String arg0, List<String> arg1, Map<String, Condition> arg2) throws AmazonServiceException, AmazonClientException {
        ScanRequest request = new ScanRequest(arg0).withAttributesToGet(arg1).withScanFilter(arg2);
        return this.scan(request);
    }

    public UpdateItemResult updateItem(String arg0, Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> arg1, Map<String, AttributeValueUpdate> arg2) throws AmazonServiceException, AmazonClientException {
        UpdateItemRequest request = new UpdateItemRequest(arg0, arg1, arg2);
        return this.updateItem(request);
    }

    public UpdateItemResult updateItem(String arg0, Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> arg1, Map<String, AttributeValueUpdate> arg2, String arg3) throws AmazonServiceException, AmazonClientException {
        UpdateItemRequest request = new UpdateItemRequest(arg0, arg1, arg2, arg3);
        return this.updateItem(request);
    }

    public UpdateTableResult updateTable(String arg0, ProvisionedThroughput arg1) throws AmazonServiceException, AmazonClientException {
        UpdateTableRequest request = new UpdateTableRequest(arg0, arg1);
        return this.updateTable(request);
    }
}

