/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.dataMembers;

import com.amazonaws.services.dynamodbv2.exceptions.AWSExceptionFactory;
import com.amazonaws.services.dynamodbv2.exceptions.AmazonServiceExceptionType;
import com.amazonaws.services.dynamodbv2.exceptions.DynamoDBLocalServiceException;
import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDBUtils;
import java.util.Collection;
import javax.servlet.http.HttpServletResponse;

public class ResponseData {
    private byte[] responseBody = null;
    private final HttpServletResponse httpServletResponse;

    public ResponseData(HttpServletResponse httpServletResponse) throws DynamoDBLocalServiceException {
        if (httpServletResponse == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.INTERNAL_SERVER_ERROR, "Received null response object");
        }
        this.httpServletResponse = httpServletResponse;
    }

    public byte[] getResponseBody() {
        return this.responseBody;
    }

    public void setResponseBody(byte[] responseBody) throws DynamoDBLocalServiceException {
        if (this.responseBody != null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.INTERNAL_SERVER_ERROR, "Response body has already been set");
        }
        this.responseBody = responseBody;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.httpServletResponse;
    }

    public String toString() {
        StringBuilder output = new StringBuilder("[Response] ");
        Collection collection = this.httpServletResponse.getHeaderNames();
        for (String headName : collection) {
            output.append(String.format("header name: %s : value: %s\n", headName, this.httpServletResponse.getHeader(headName)));
        }
        output.append("status: ").append(this.httpServletResponse.getStatus()).append("\n");
        if (this.responseBody.length > 4096) {
            output.append("<< response body not shown (length > 4KB) >>");
        } else {
            output.append("response body: ").append(new String(this.responseBody, LocalDBUtils.UTF8)).append("\n");
        }
        return output.toString();
    }
}

