/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backup.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.backup.model.ReportDestination;
import java.util.List;

@SdkInternalApi
public class ReportDestinationMarshaller {
    private static final MarshallingInfo<String> S3BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3BucketName").build();
    private static final MarshallingInfo<List> S3KEYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Keys").build();
    private static final ReportDestinationMarshaller instance = new ReportDestinationMarshaller();

    public static ReportDestinationMarshaller getInstance() {
        return instance;
    }

    public void marshall(ReportDestination reportDestination, ProtocolMarshaller protocolMarshaller) {
        if (reportDestination == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)reportDestination.getS3BucketName(), S3BUCKETNAME_BINDING);
            protocolMarshaller.marshall(reportDestination.getS3Keys(), S3KEYS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

