/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backupgateway.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.backupgateway.model.Hypervisor;

@SdkInternalApi
public class HypervisorMarshaller {
    private static final MarshallingInfo<String> HOST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Host").build();
    private static final MarshallingInfo<String> HYPERVISORARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HypervisorArn").build();
    private static final MarshallingInfo<String> KMSKEYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyArn").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final HypervisorMarshaller instance = new HypervisorMarshaller();

    public static HypervisorMarshaller getInstance() {
        return instance;
    }

    public void marshall(Hypervisor hypervisor, ProtocolMarshaller protocolMarshaller) {
        if (hypervisor == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)hypervisor.getHost(), HOST_BINDING);
            protocolMarshaller.marshall((Object)hypervisor.getHypervisorArn(), HYPERVISORARN_BINDING);
            protocolMarshaller.marshall((Object)hypervisor.getKmsKeyArn(), KMSKEYARN_BINDING);
            protocolMarshaller.marshall((Object)hypervisor.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)hypervisor.getState(), STATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

