/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.elastictranscoder.model.Playlist;
import java.util.List;

@SdkInternalApi
public class PlaylistMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> FORMAT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Format").build();
    private static final MarshallingInfo<List> OUTPUTKEYS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputKeys").build();
    private static final MarshallingInfo<StructuredPojo> HLSCONTENTPROTECTION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HlsContentProtection").build();
    private static final MarshallingInfo<StructuredPojo> PLAYREADYDRM_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlayReadyDrm").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> STATUSDETAIL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusDetail").build();
    private static final PlaylistMarshaller instance = new PlaylistMarshaller();

    public static PlaylistMarshaller getInstance() {
        return instance;
    }

    public void marshall(Playlist playlist, ProtocolMarshaller protocolMarshaller) {
        if (playlist == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(playlist.getName(), NAME_BINDING);
            protocolMarshaller.marshall(playlist.getFormat(), FORMAT_BINDING);
            protocolMarshaller.marshall(playlist.getOutputKeys(), OUTPUTKEYS_BINDING);
            protocolMarshaller.marshall(playlist.getHlsContentProtection(), HLSCONTENTPROTECTION_BINDING);
            protocolMarshaller.marshall(playlist.getPlayReadyDrm(), PLAYREADYDRM_BINDING);
            protocolMarshaller.marshall(playlist.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(playlist.getStatusDetail(), STATUSDETAIL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

