/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.identitymanagement.model.PolicyEvaluationDecisionType;
import com.amazonaws.services.identitymanagement.model.Statement;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ResourceSpecificResult
implements Serializable,
Cloneable {
    private String evalResourceName;
    private String evalResourceDecision;
    private SdkInternalList<Statement> matchedStatements;
    private SdkInternalList<String> missingContextValues;
    private SdkInternalMap<String, String> evalDecisionDetails;

    public void setEvalResourceName(String evalResourceName) {
        this.evalResourceName = evalResourceName;
    }

    public String getEvalResourceName() {
        return this.evalResourceName;
    }

    public ResourceSpecificResult withEvalResourceName(String evalResourceName) {
        this.setEvalResourceName(evalResourceName);
        return this;
    }

    public void setEvalResourceDecision(String evalResourceDecision) {
        this.evalResourceDecision = evalResourceDecision;
    }

    public String getEvalResourceDecision() {
        return this.evalResourceDecision;
    }

    public ResourceSpecificResult withEvalResourceDecision(String evalResourceDecision) {
        this.setEvalResourceDecision(evalResourceDecision);
        return this;
    }

    public void setEvalResourceDecision(PolicyEvaluationDecisionType evalResourceDecision) {
        this.evalResourceDecision = evalResourceDecision.toString();
    }

    public ResourceSpecificResult withEvalResourceDecision(PolicyEvaluationDecisionType evalResourceDecision) {
        this.setEvalResourceDecision(evalResourceDecision);
        return this;
    }

    public List<Statement> getMatchedStatements() {
        if (this.matchedStatements == null) {
            this.matchedStatements = new SdkInternalList();
        }
        return this.matchedStatements;
    }

    public void setMatchedStatements(Collection<Statement> matchedStatements) {
        if (matchedStatements == null) {
            this.matchedStatements = null;
            return;
        }
        this.matchedStatements = new SdkInternalList<Statement>(matchedStatements);
    }

    public ResourceSpecificResult withMatchedStatements(Statement ... matchedStatements) {
        if (this.matchedStatements == null) {
            this.setMatchedStatements(new SdkInternalList<Statement>(matchedStatements.length));
        }
        for (Statement ele : matchedStatements) {
            this.matchedStatements.add(ele);
        }
        return this;
    }

    public ResourceSpecificResult withMatchedStatements(Collection<Statement> matchedStatements) {
        this.setMatchedStatements(matchedStatements);
        return this;
    }

    public List<String> getMissingContextValues() {
        if (this.missingContextValues == null) {
            this.missingContextValues = new SdkInternalList();
        }
        return this.missingContextValues;
    }

    public void setMissingContextValues(Collection<String> missingContextValues) {
        if (missingContextValues == null) {
            this.missingContextValues = null;
            return;
        }
        this.missingContextValues = new SdkInternalList<String>(missingContextValues);
    }

    public ResourceSpecificResult withMissingContextValues(String ... missingContextValues) {
        if (this.missingContextValues == null) {
            this.setMissingContextValues(new SdkInternalList<String>(missingContextValues.length));
        }
        for (String ele : missingContextValues) {
            this.missingContextValues.add(ele);
        }
        return this;
    }

    public ResourceSpecificResult withMissingContextValues(Collection<String> missingContextValues) {
        this.setMissingContextValues(missingContextValues);
        return this;
    }

    public Map<String, String> getEvalDecisionDetails() {
        if (this.evalDecisionDetails == null) {
            this.evalDecisionDetails = new SdkInternalMap();
        }
        return this.evalDecisionDetails;
    }

    public void setEvalDecisionDetails(Map<String, String> evalDecisionDetails) {
        this.evalDecisionDetails = evalDecisionDetails == null ? null : new SdkInternalMap<String, String>(evalDecisionDetails);
    }

    public ResourceSpecificResult withEvalDecisionDetails(Map<String, String> evalDecisionDetails) {
        this.setEvalDecisionDetails(evalDecisionDetails);
        return this;
    }

    public ResourceSpecificResult addEvalDecisionDetailsEntry(String key, String value) {
        if (null == this.evalDecisionDetails) {
            this.evalDecisionDetails = new SdkInternalMap();
        }
        if (this.evalDecisionDetails.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.evalDecisionDetails.put(key, value);
        return this;
    }

    public ResourceSpecificResult clearEvalDecisionDetailsEntries() {
        this.evalDecisionDetails = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEvalResourceName() != null) {
            sb.append("EvalResourceName: ").append(this.getEvalResourceName()).append(",");
        }
        if (this.getEvalResourceDecision() != null) {
            sb.append("EvalResourceDecision: ").append(this.getEvalResourceDecision()).append(",");
        }
        if (this.getMatchedStatements() != null) {
            sb.append("MatchedStatements: ").append(this.getMatchedStatements()).append(",");
        }
        if (this.getMissingContextValues() != null) {
            sb.append("MissingContextValues: ").append(this.getMissingContextValues()).append(",");
        }
        if (this.getEvalDecisionDetails() != null) {
            sb.append("EvalDecisionDetails: ").append(this.getEvalDecisionDetails());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSpecificResult)) {
            return false;
        }
        ResourceSpecificResult other = (ResourceSpecificResult)obj;
        if (other.getEvalResourceName() == null ^ this.getEvalResourceName() == null) {
            return false;
        }
        if (other.getEvalResourceName() != null && !other.getEvalResourceName().equals(this.getEvalResourceName())) {
            return false;
        }
        if (other.getEvalResourceDecision() == null ^ this.getEvalResourceDecision() == null) {
            return false;
        }
        if (other.getEvalResourceDecision() != null && !other.getEvalResourceDecision().equals(this.getEvalResourceDecision())) {
            return false;
        }
        if (other.getMatchedStatements() == null ^ this.getMatchedStatements() == null) {
            return false;
        }
        if (other.getMatchedStatements() != null && !other.getMatchedStatements().equals(this.getMatchedStatements())) {
            return false;
        }
        if (other.getMissingContextValues() == null ^ this.getMissingContextValues() == null) {
            return false;
        }
        if (other.getMissingContextValues() != null && !other.getMissingContextValues().equals(this.getMissingContextValues())) {
            return false;
        }
        if (other.getEvalDecisionDetails() == null ^ this.getEvalDecisionDetails() == null) {
            return false;
        }
        return other.getEvalDecisionDetails() == null || other.getEvalDecisionDetails().equals(this.getEvalDecisionDetails());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEvalResourceName() == null ? 0 : this.getEvalResourceName().hashCode());
        hashCode = 31 * hashCode + (this.getEvalResourceDecision() == null ? 0 : this.getEvalResourceDecision().hashCode());
        hashCode = 31 * hashCode + (this.getMatchedStatements() == null ? 0 : this.getMatchedStatements().hashCode());
        hashCode = 31 * hashCode + (this.getMissingContextValues() == null ? 0 : this.getMissingContextValues().hashCode());
        hashCode = 31 * hashCode + (this.getEvalDecisionDetails() == null ? 0 : this.getEvalDecisionDetails().hashCode());
        return hashCode;
    }

    public ResourceSpecificResult clone() {
        try {
            return (ResourceSpecificResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

