/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.codedeploy.AmazonCodeDeploy;
import com.amazonaws.services.codedeploy.model.GetDeploymentRequest;
import com.amazonaws.services.codedeploy.waiters.DeploymentSuccessful;
import com.amazonaws.services.codedeploy.waiters.GetDeploymentFunction;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonCodeDeployWaiters {
    private final AmazonCodeDeploy client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonCodeDeployWaiters(AmazonCodeDeploy client) {
        this.client = client;
    }

    public Waiter<GetDeploymentRequest> deploymentSuccessful() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetDeploymentFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new DeploymentSuccessful.IsSucceededMatcher(), new DeploymentSuccessful.IsFailedMatcher(), new DeploymentSuccessful.IsStoppedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }
}

