/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.service.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.service.codepipeline.model.ActionConfigurationProperty;
import com.amazonaws.service.codepipeline.model.CreateCustomActionTypeRequest;
import com.amazonaws.service.codepipeline.model.transform.ActionConfigurationPropertyJsonMarshaller;
import com.amazonaws.service.codepipeline.model.transform.ActionTypeSettingsJsonMarshaller;
import com.amazonaws.service.codepipeline.model.transform.ArtifactDetailsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class CreateCustomActionTypeRequestMarshaller
implements Marshaller<Request<CreateCustomActionTypeRequest>, CreateCustomActionTypeRequest> {
    public Request<CreateCustomActionTypeRequest> marshall(CreateCustomActionTypeRequest createCustomActionTypeRequest) {
        if (createCustomActionTypeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createCustomActionTypeRequest, "AWSCodePipeline");
        request.addHeader("X-Amz-Target", "CodePipeline_20150709.CreateCustomActionType");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<ActionConfigurationProperty> configurationPropertiesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createCustomActionTypeRequest.getCategory() != null) {
                jsonWriter.key("category").value((Object)createCustomActionTypeRequest.getCategory());
            }
            if (createCustomActionTypeRequest.getProvider() != null) {
                jsonWriter.key("provider").value((Object)createCustomActionTypeRequest.getProvider());
            }
            if (createCustomActionTypeRequest.getVersion() != null) {
                jsonWriter.key("version").value((Object)createCustomActionTypeRequest.getVersion());
            }
            if (createCustomActionTypeRequest.getSettings() != null) {
                jsonWriter.key("settings");
                ActionTypeSettingsJsonMarshaller.getInstance().marshall(createCustomActionTypeRequest.getSettings(), jsonWriter);
            }
            if ((configurationPropertiesList = createCustomActionTypeRequest.getConfigurationProperties()) != null) {
                jsonWriter.key("configurationProperties");
                jsonWriter.array();
                for (ActionConfigurationProperty configurationPropertiesListValue : configurationPropertiesList) {
                    if (configurationPropertiesListValue == null) continue;
                    ActionConfigurationPropertyJsonMarshaller.getInstance().marshall(configurationPropertiesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (createCustomActionTypeRequest.getInputArtifactDetails() != null) {
                jsonWriter.key("inputArtifactDetails");
                ArtifactDetailsJsonMarshaller.getInstance().marshall(createCustomActionTypeRequest.getInputArtifactDetails(), jsonWriter);
            }
            if (createCustomActionTypeRequest.getOutputArtifactDetails() != null) {
                jsonWriter.key("outputArtifactDetails");
                ArtifactDetailsJsonMarshaller.getInstance().marshall(createCustomActionTypeRequest.getOutputArtifactDetails(), jsonWriter);
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

