/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.service.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.service.codepipeline.model.PollForJobsRequest;
import com.amazonaws.service.codepipeline.model.transform.ActionTypeIdJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class PollForJobsRequestMarshaller
implements Marshaller<Request<PollForJobsRequest>, PollForJobsRequest> {
    public Request<PollForJobsRequest> marshall(PollForJobsRequest pollForJobsRequest) {
        if (pollForJobsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)pollForJobsRequest, "AWSCodePipeline");
        request.addHeader("X-Amz-Target", "CodePipeline_20150709.PollForJobs");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Map<String, String> queryParamMap;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (pollForJobsRequest.getActionTypeId() != null) {
                jsonWriter.key("actionTypeId");
                ActionTypeIdJsonMarshaller.getInstance().marshall(pollForJobsRequest.getActionTypeId(), jsonWriter);
            }
            if (pollForJobsRequest.getMaxBatchSize() != null) {
                jsonWriter.key("maxBatchSize").value((Object)pollForJobsRequest.getMaxBatchSize());
            }
            if ((queryParamMap = pollForJobsRequest.getQueryParam()) != null) {
                jsonWriter.key("queryParam");
                jsonWriter.object();
                for (Map.Entry<String, String> queryParamMapValue : queryParamMap.entrySet()) {
                    if (queryParamMapValue.getValue() == null) continue;
                    jsonWriter.key(queryParamMapValue.getKey());
                    jsonWriter.value((Object)queryParamMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

