/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeSharedDirectoriesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String ownerDirectoryId;
    private SdkInternalList<String> sharedDirectoryIds;
    private String nextToken;
    private Integer limit;

    public void setOwnerDirectoryId(String ownerDirectoryId) {
        this.ownerDirectoryId = ownerDirectoryId;
    }

    public String getOwnerDirectoryId() {
        return this.ownerDirectoryId;
    }

    public DescribeSharedDirectoriesRequest withOwnerDirectoryId(String ownerDirectoryId) {
        this.setOwnerDirectoryId(ownerDirectoryId);
        return this;
    }

    public List<String> getSharedDirectoryIds() {
        if (this.sharedDirectoryIds == null) {
            this.sharedDirectoryIds = new SdkInternalList();
        }
        return this.sharedDirectoryIds;
    }

    public void setSharedDirectoryIds(Collection<String> sharedDirectoryIds) {
        if (sharedDirectoryIds == null) {
            this.sharedDirectoryIds = null;
            return;
        }
        this.sharedDirectoryIds = new SdkInternalList(sharedDirectoryIds);
    }

    public DescribeSharedDirectoriesRequest withSharedDirectoryIds(String ... sharedDirectoryIds) {
        if (this.sharedDirectoryIds == null) {
            this.setSharedDirectoryIds((Collection<String>)new SdkInternalList(sharedDirectoryIds.length));
        }
        for (String ele : sharedDirectoryIds) {
            this.sharedDirectoryIds.add((Object)ele);
        }
        return this;
    }

    public DescribeSharedDirectoriesRequest withSharedDirectoryIds(Collection<String> sharedDirectoryIds) {
        this.setSharedDirectoryIds(sharedDirectoryIds);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeSharedDirectoriesRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public DescribeSharedDirectoriesRequest withLimit(Integer limit) {
        this.setLimit(limit);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOwnerDirectoryId() != null) {
            sb.append("OwnerDirectoryId: ").append(this.getOwnerDirectoryId()).append(",");
        }
        if (this.getSharedDirectoryIds() != null) {
            sb.append("SharedDirectoryIds: ").append(this.getSharedDirectoryIds()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getLimit() != null) {
            sb.append("Limit: ").append(this.getLimit());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSharedDirectoriesRequest)) {
            return false;
        }
        DescribeSharedDirectoriesRequest other = (DescribeSharedDirectoriesRequest)obj;
        if (other.getOwnerDirectoryId() == null ^ this.getOwnerDirectoryId() == null) {
            return false;
        }
        if (other.getOwnerDirectoryId() != null && !other.getOwnerDirectoryId().equals(this.getOwnerDirectoryId())) {
            return false;
        }
        if (other.getSharedDirectoryIds() == null ^ this.getSharedDirectoryIds() == null) {
            return false;
        }
        if (other.getSharedDirectoryIds() != null && !other.getSharedDirectoryIds().equals(this.getSharedDirectoryIds())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getLimit() == null ^ this.getLimit() == null) {
            return false;
        }
        return other.getLimit() == null || other.getLimit().equals(this.getLimit());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOwnerDirectoryId() == null ? 0 : this.getOwnerDirectoryId().hashCode());
        hashCode = 31 * hashCode + (this.getSharedDirectoryIds() == null ? 0 : this.getSharedDirectoryIds().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getLimit() == null ? 0 : this.getLimit().hashCode());
        return hashCode;
    }

    public DescribeSharedDirectoriesRequest clone() {
        return (DescribeSharedDirectoriesRequest)super.clone();
    }
}

