/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ConnectionTrackingSpecificationRequest;
import com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest;
import com.amazonaws.services.ec2.model.InstanceIpv6Address;
import com.amazonaws.services.ec2.model.Ipv4PrefixSpecificationRequest;
import com.amazonaws.services.ec2.model.Ipv6PrefixSpecificationRequest;
import com.amazonaws.services.ec2.model.PrivateIpAddressSpecification;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class CreateNetworkInterfaceRequestMarshaller
implements Marshaller<Request<CreateNetworkInterfaceRequest>, CreateNetworkInterfaceRequest> {
    public Request<CreateNetworkInterfaceRequest> marshall(CreateNetworkInterfaceRequest createNetworkInterfaceRequest) {
        ConnectionTrackingSpecificationRequest connectionTrackingSpecification;
        SdkInternalList createNetworkInterfaceRequestTagSpecificationsList;
        SdkInternalList createNetworkInterfaceRequestIpv6PrefixesList;
        SdkInternalList createNetworkInterfaceRequestIpv4PrefixesList;
        SdkInternalList createNetworkInterfaceRequestPrivateIpAddressesList;
        SdkInternalList createNetworkInterfaceRequestIpv6AddressesList;
        SdkInternalList createNetworkInterfaceRequestGroupsList;
        if (createNetworkInterfaceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createNetworkInterfaceRequest, "AmazonEC2");
        request.addParameter("Action", "CreateNetworkInterface");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createNetworkInterfaceRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createNetworkInterfaceRequest.getDescription()));
        }
        if (!(createNetworkInterfaceRequestGroupsList = (SdkInternalList)createNetworkInterfaceRequest.getGroups()).isEmpty() || !createNetworkInterfaceRequestGroupsList.isAutoConstruct()) {
            int groupsListIndex = 1;
            for (Object createNetworkInterfaceRequestGroupsListValue : createNetworkInterfaceRequestGroupsList) {
                if (createNetworkInterfaceRequestGroupsListValue != null) {
                    request.addParameter("SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)createNetworkInterfaceRequestGroupsListValue));
                }
                ++groupsListIndex;
            }
        }
        if (createNetworkInterfaceRequest.getIpv6AddressCount() != null) {
            request.addParameter("Ipv6AddressCount", StringUtils.fromInteger((Integer)createNetworkInterfaceRequest.getIpv6AddressCount()));
        }
        if (!(createNetworkInterfaceRequestIpv6AddressesList = (SdkInternalList)createNetworkInterfaceRequest.getIpv6Addresses()).isEmpty() || !createNetworkInterfaceRequestIpv6AddressesList.isAutoConstruct()) {
            int ipv6AddressesListIndex = 1;
            for (Object createNetworkInterfaceRequestIpv6AddressesListValue : createNetworkInterfaceRequestIpv6AddressesList) {
                if (((InstanceIpv6Address)createNetworkInterfaceRequestIpv6AddressesListValue).getIpv6Address() != null) {
                    request.addParameter("Ipv6Addresses." + ipv6AddressesListIndex + ".Ipv6Address", StringUtils.fromString((String)((InstanceIpv6Address)createNetworkInterfaceRequestIpv6AddressesListValue).getIpv6Address()));
                }
                if (((InstanceIpv6Address)createNetworkInterfaceRequestIpv6AddressesListValue).getIsPrimaryIpv6() != null) {
                    request.addParameter("Ipv6Addresses." + ipv6AddressesListIndex + ".IsPrimaryIpv6", StringUtils.fromBoolean((Boolean)((InstanceIpv6Address)createNetworkInterfaceRequestIpv6AddressesListValue).getIsPrimaryIpv6()));
                }
                ++ipv6AddressesListIndex;
            }
        }
        if (createNetworkInterfaceRequest.getPrivateIpAddress() != null) {
            request.addParameter("PrivateIpAddress", StringUtils.fromString((String)createNetworkInterfaceRequest.getPrivateIpAddress()));
        }
        if (!(createNetworkInterfaceRequestPrivateIpAddressesList = (SdkInternalList)createNetworkInterfaceRequest.getPrivateIpAddresses()).isEmpty() || !createNetworkInterfaceRequestPrivateIpAddressesList.isAutoConstruct()) {
            int privateIpAddressesListIndex = 1;
            for (Object createNetworkInterfaceRequestPrivateIpAddressesListValue : createNetworkInterfaceRequestPrivateIpAddressesList) {
                if (((PrivateIpAddressSpecification)createNetworkInterfaceRequestPrivateIpAddressesListValue).getPrimary() != null) {
                    request.addParameter("PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringUtils.fromBoolean((Boolean)((PrivateIpAddressSpecification)createNetworkInterfaceRequestPrivateIpAddressesListValue).getPrimary()));
                }
                if (((PrivateIpAddressSpecification)createNetworkInterfaceRequestPrivateIpAddressesListValue).getPrivateIpAddress() != null) {
                    request.addParameter("PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)((PrivateIpAddressSpecification)createNetworkInterfaceRequestPrivateIpAddressesListValue).getPrivateIpAddress()));
                }
                ++privateIpAddressesListIndex;
            }
        }
        if (createNetworkInterfaceRequest.getSecondaryPrivateIpAddressCount() != null) {
            request.addParameter("SecondaryPrivateIpAddressCount", StringUtils.fromInteger((Integer)createNetworkInterfaceRequest.getSecondaryPrivateIpAddressCount()));
        }
        if (!(createNetworkInterfaceRequestIpv4PrefixesList = (SdkInternalList)createNetworkInterfaceRequest.getIpv4Prefixes()).isEmpty() || !createNetworkInterfaceRequestIpv4PrefixesList.isAutoConstruct()) {
            int ipv4PrefixesListIndex = 1;
            for (Object createNetworkInterfaceRequestIpv4PrefixesListValue : createNetworkInterfaceRequestIpv4PrefixesList) {
                if (((Ipv4PrefixSpecificationRequest)createNetworkInterfaceRequestIpv4PrefixesListValue).getIpv4Prefix() != null) {
                    request.addParameter("Ipv4Prefix." + ipv4PrefixesListIndex + ".Ipv4Prefix", StringUtils.fromString((String)((Ipv4PrefixSpecificationRequest)createNetworkInterfaceRequestIpv4PrefixesListValue).getIpv4Prefix()));
                }
                ++ipv4PrefixesListIndex;
            }
        }
        if (createNetworkInterfaceRequest.getIpv4PrefixCount() != null) {
            request.addParameter("Ipv4PrefixCount", StringUtils.fromInteger((Integer)createNetworkInterfaceRequest.getIpv4PrefixCount()));
        }
        if (!(createNetworkInterfaceRequestIpv6PrefixesList = (SdkInternalList)createNetworkInterfaceRequest.getIpv6Prefixes()).isEmpty() || !createNetworkInterfaceRequestIpv6PrefixesList.isAutoConstruct()) {
            int ipv6PrefixesListIndex = 1;
            for (Ipv6PrefixSpecificationRequest createNetworkInterfaceRequestIpv6PrefixesListValue : createNetworkInterfaceRequestIpv6PrefixesList) {
                if (createNetworkInterfaceRequestIpv6PrefixesListValue.getIpv6Prefix() != null) {
                    request.addParameter("Ipv6Prefix." + ipv6PrefixesListIndex + ".Ipv6Prefix", StringUtils.fromString((String)createNetworkInterfaceRequestIpv6PrefixesListValue.getIpv6Prefix()));
                }
                ++ipv6PrefixesListIndex;
            }
        }
        if (createNetworkInterfaceRequest.getIpv6PrefixCount() != null) {
            request.addParameter("Ipv6PrefixCount", StringUtils.fromInteger((Integer)createNetworkInterfaceRequest.getIpv6PrefixCount()));
        }
        if (createNetworkInterfaceRequest.getInterfaceType() != null) {
            request.addParameter("InterfaceType", StringUtils.fromString((String)createNetworkInterfaceRequest.getInterfaceType()));
        }
        if (createNetworkInterfaceRequest.getSubnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString((String)createNetworkInterfaceRequest.getSubnetId()));
        }
        if (!(createNetworkInterfaceRequestTagSpecificationsList = (SdkInternalList)createNetworkInterfaceRequest.getTagSpecifications()).isEmpty() || !createNetworkInterfaceRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createNetworkInterfaceRequestTagSpecificationsListValue : createNetworkInterfaceRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createNetworkInterfaceRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createNetworkInterfaceRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createNetworkInterfaceRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)createNetworkInterfaceRequest.getClientToken()));
        if (createNetworkInterfaceRequest.getEnablePrimaryIpv6() != null) {
            request.addParameter("EnablePrimaryIpv6", StringUtils.fromBoolean((Boolean)createNetworkInterfaceRequest.getEnablePrimaryIpv6()));
        }
        if ((connectionTrackingSpecification = createNetworkInterfaceRequest.getConnectionTrackingSpecification()) != null) {
            if (connectionTrackingSpecification.getTcpEstablishedTimeout() != null) {
                request.addParameter("ConnectionTrackingSpecification.TcpEstablishedTimeout", StringUtils.fromInteger((Integer)connectionTrackingSpecification.getTcpEstablishedTimeout()));
            }
            if (connectionTrackingSpecification.getUdpStreamTimeout() != null) {
                request.addParameter("ConnectionTrackingSpecification.UdpStreamTimeout", StringUtils.fromInteger((Integer)connectionTrackingSpecification.getUdpStreamTimeout()));
            }
            if (connectionTrackingSpecification.getUdpTimeout() != null) {
                request.addParameter("ConnectionTrackingSpecification.UdpTimeout", StringUtils.fromInteger((Integer)connectionTrackingSpecification.getUdpTimeout()));
            }
        }
        return request;
    }
}

